package Pista::Object::Buffer;

use strict;
use warnings;
use vars qw(@ISA);
@ISA = qw(Pista::Object);
use Pista::Util qw(min max dup);
use Pista::Object;

use Dumpvalue;
my $dumper = new Dumpvalue('arrayDepth' => 16);

sub new {
	my $pkg = shift;
	my $self = { };
	bless $self, $pkg;
}

sub read {
#print "Pista::Object::Buffer::read(@_)\n";
	my $self = shift;
	my %arg = (@_);
#	my $noblank = $arg{noblank};
	my $range = $arg{range};
	undef %arg;
	my $new = dup($self);

	return $new unless $range;

	for (qw(prog cal userid devid conf eeprom)) {
		next unless exists $new->{$_};
		if (exists $range->{$_}) {
			$new->{$_}->intersect($range->{$_}->{start},
						$range->{$_}->{end});
		}
		else {
			delete $new->{$_};
		}
	}
	return $new;
}

sub write {
#print "Pista::Object::Buffer::write(@_)\n";
	my ($self, $src) = @_;
	for my $sect (qw(prog cal userid devid eeprom conf)) {
		next unless exists $src->{$sect};
		if (exists $self->{$sect}) {
			$self->{$sect}->merge($src->{$sect});
		}
		else {
			$self->{$sect} = $src->{$sect};
		}
	}
	return $self;
}

sub erase {
	my $self = shift;
	my %arg = (@_);
	my $range = $arg{range};
	undef %arg;

	if (!$range) {
		for (qw(prog cal userid devid conf eeprom)) {
			delete $self->{$_};
		}
	}
	else {
		for (qw(prog cal userid devid conf eeprom)) {
			next unless exists $range->{$_};
			next unless exists $self->{$_};
			$self->{$_}->erase($range->{$_}->{start},
					   $range->{$_}->{end})
				or delete $self->{$_};
		}
	}
	return $self;
}

#sub checksum {
#	my $self = shift;
#	my $chksum = 0;
#	foreach (@{$self->{buffer}}) {
#		$chksum += defined $_ ?  $_ : ((1<<(2*$self->{width}))-1);
#	}
#	return $chksum & 0xffff;
#}

1;
