# Nomad UI

The official Nomad UI.

## Prerequisites

This is an [ember.js](https://emberjs.com/) project, and you will need the following tools installed on your computer.

- [Node.js v10](https://nodejs.org/)
- [Yarn](https://yarnpkg.com)
- [Ember CLI](https://ember-cli.com/)

## Installation

The Nomad UI gets cloned along with the rest of Nomad. To install dependencies, do the following from the root of the Nomad project:

```
$ cd ui
$ yarn
```

## Running / Development

UI in development mode defaults to using fake generated data, but you can configure it to proxy a live running nomad process by setting `USE_MIRAGE` environment variable to `false`. First, make sure nomad is running. The UI, in development mode, runs independently from Nomad, so this could be an official release or a dev branch. Likewise, Nomad can be running in server mode or dev mode. As long as the API is accessible, the UI will work as expected.

- `USE_MIRAGE=false ember serve`
- Visit your app at [http://localhost:4200](http://localhost:4200).

You may need to reference the direct path to `ember`, typically in `./node_modules/.bin/ember`.

The fake data in development is generated from a stable seed of 1. To generate different data, you can include a query parameter of `?faker-seed=2` or any other number in the URL. To turn off the seed and get different data with every load, use `?faker=seed=0`.

When running with Mirage, the default scenario is set in `config/environment.js` but can be overridden with a query parameter to any of the scenarios named in `mirage/scenarios/default.js` with something like `?mirage-scenario=emptyCluster`.

## Running / Development with Vagrant

All necessary tools for UI development are installed as part of the Vagrantfile. This is primarily to make it easy to build the UI from source while working on Nomad. Due to the filesystem requirements of [Broccoli](http://broccolijs.com/) (which powers Ember CLI), it is strongly discouraged to use Vagrant for developing changes to the UI.

That said, development with Vagrant is still possible, but the `ember serve` command requires two modifications:

- `--watch polling`: This allows the vm to notice file changes made in the host environment.
- `--port 4201`: The default port 4200 is not forwarded, since local development is recommended.

This makes the full command for running the UI in development mode in Vagrant:

```
$ ember serve --watch polling --port 4201
```

### Running Tests

Nomad UI tests can be run independently of Nomad golang tests.

- `ember test` (single run, headless browser)
- `ember test --server` (watches for changes, runs in a full browser)

You can use `--filter <test name>` to run a targetted set of tests, e.g. `ember test --filter 'allocation detail'`.

In the test environment, the fake data is generated with a random seed. If you want stable data, you can set a seed while running the test server by appending `&faker-seed=1` (or any other non-zero number) to the URL.

### Linting

- `yarn lint`
- `yarn lint:fix`

### Building

Typically `make release` or `make dev-ui` will be the desired build workflow, but in the event that build artifacts need to be inspected, `ember build` will output compiled files in `ui/dist`.

- `ember build` (development)
- `ember build --environment production` (production)

### Releasing

Nomad UI releases are in lockstep with Nomad releases and are integrated into the `make release` toolchain.

### Conventions

- UI branches should be prefix with `f-ui-` for feature work and `b-ui-` for bug fixes. This instructs CI to skip running nomad backend tests.

### Storybook UI Library

The Storybook project provides a browser to see what components and patterns are present in the application and how to use them. You can run it locally with `yarn storybook` after you have `ember serve` running. The latest version from the `main` branch is at [`nomad-storybook-and-ui.vercel.app/storybook/`](https://nomad-storybook-and-ui.vercel.app/storybook/).

To generate a new story for a component, run `ember generate story component-name`. You can use the existing stories as a guide.

### Troubleshooting

#### The UI is running, but none of the API requests are working

By default (according to the `.ember-cli` file), a proxy address of `http://localhost:4646` is used. If you are running Nomad at a different address, you will need to override this setting when running ember serve: `ember serve --proxy http://newlocation:1111`.

Also, ensure that `USE_MIRAGE` environment variable is set to false, so the UI proxy requests to Nomad process instead of using autogenerated test data.

#### Nomad is running in Vagrant, but I can't access the API from my host machine

Nomad binds to `127.0.0.1:4646` by default, which is the loopback address. Try running nomad bound to `0.0.0.0`: `bin/nomad -bind 0.0.0.0`.

Ports also need to be forwarded in the Vagrantfile. 4646 is already forwarded, but if a port other than the default is being used, that port needs to be added to the Vagrantfile and `vagrant reload` needs to be run.
