; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -basicaa -debugify -loop-idiom -pass-remarks=loop-idiom -pass-remarks-analysis=loop-idiom -verify -verify-each -verify-dom-info -verify-loop-info  < %s -S 2>&1 | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; Check that everything still works when debuginfo is present, and that it is reasonably propagated.

; void my_basic_memset(char* begin, char* end, char value) {
;   for( ; begin != end; ++begin)
;     *begin = value;
; }

; CHECK: remark: <stdin>:4:1: Transformed loop-strided store into a call to llvm.memset.p0i8.i64() function

define void @_Z15my_basic_memsetPcS_c(i8* %ptr, i8* %end, i8 %value) {
; CHECK-LABEL: @_Z15my_basic_memsetPcS_c(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR1:%.*]] = ptrtoint i8* [[PTR:%.*]] to i64
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8* [[PTR]], [[END:%.*]], !dbg !15
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i1 [[CMP3]], metadata !9, metadata !DIExpression()), !dbg !15
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_END:%.*]], label [[FOR_BODY_PREHEADER:%.*]], !dbg !16
; CHECK:       for.body.preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = sub i64 0, [[PTR1]], !dbg !17
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, i8* [[END]], i64 [[TMP0]], !dbg !17
; CHECK-NEXT:    [[SCEVGEP2:%.*]] = ptrtoint i8* [[SCEVGEP]] to i64
; CHECK-NEXT:    call void @llvm.memset.p0i8.i64(i8* align 1 [[PTR]], i8 [[VALUE:%.*]], i64 [[SCEVGEP2]], i1 false), !dbg !17
; CHECK-NEXT:    br label [[FOR_BODY:%.*]], !dbg !17
; CHECK:       for.body:
; CHECK-NEXT:    [[PTR_ADDR_04:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_BODY]] ], [ [[PTR]], [[FOR_BODY_PREHEADER]] ], !dbg !18
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i8* [[PTR_ADDR_04]], metadata !11, metadata !DIExpression()), !dbg !18
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR_ADDR_04]], i64 1, !dbg !19
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i8* [[INCDEC_PTR]], metadata !13, metadata !DIExpression()), !dbg !19
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8* [[INCDEC_PTR]], [[END]], !dbg !20
; CHECK-NEXT:    call void @llvm.dbg.value(metadata i1 [[CMP]], metadata !14, metadata !DIExpression()), !dbg !20
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY]], !dbg !21
; CHECK:       for.end.loopexit:
; CHECK-NEXT:    br label [[FOR_END]], !dbg !22
; CHECK:       for.end:
; CHECK-NEXT:    ret void, !dbg !22
;
entry:
  %cmp3 = icmp eq i8* %ptr, %end
  br i1 %cmp3, label %for.end, label %for.body

for.body:                                         ; preds = %entry, %for.body
  %ptr.addr.04 = phi i8* [ %incdec.ptr, %for.body ], [ %ptr, %entry ]
  store i8 %value, i8* %ptr.addr.04, align 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr.addr.04, i64 1
  %cmp = icmp eq i8* %incdec.ptr, %end
  br i1 %cmp, label %for.end, label %for.body

for.end:                                          ; preds = %for.body, %entry
  ret void
}
