; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s

; PR42190

define double @pow_sitofp_const_base_fast(i32 %x) {
; CHECK-LABEL: @pow_sitofp_const_base_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[POWI:%.*]] = tail call fast float @llvm.pow.f32(float 7.000000e+00, float [[SUBFP]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[POWI]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call fast float @llvm.pow.f32(float 7.000000e+00, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_const_base_power_of_2_fast(i32 %x) {
; CHECK-LABEL: @pow_sitofp_const_base_power_of_2_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast float [[SUBFP]], 4.000000e+00
; CHECK-NEXT:    [[EXP2:%.*]] = call fast float @llvm.exp2.f32(float [[MUL]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[EXP2]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call fast float @llvm.pow.f32(float 16.000000e+00, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_float_base_fast(float %base, i32 %x) {
; CHECK-LABEL: @pow_sitofp_float_base_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[POWI:%.*]] = tail call fast float @llvm.pow.f32(float [[BASE:%.*]], float [[SUBFP]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[POWI]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call fast float @llvm.pow.f32(float %base, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_double_base_fast(double %base, i32 %x) {
; CHECK-LABEL: @pow_sitofp_double_base_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to double
; CHECK-NEXT:    [[RES:%.*]] = tail call fast double @llvm.pow.f64(double [[BASE:%.*]], double [[SUBFP]])
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to double
  %res = tail call fast double @llvm.pow.f64(double %base, double %subfp)
  ret double %res
}

define double @powf_exp_const_int_fast(double %base) {
; CHECK-LABEL: @powf_exp_const_int_fast(
; CHECK-NEXT:    [[RES:%.*]] = tail call fast double @llvm.pow.f64(double [[BASE:%.*]], double 4.000000e+01)
; CHECK-NEXT:    ret double [[RES]]
;
  %res = tail call fast double @llvm.pow.f64(double %base, double 4.000000e+01)
  ret double %res
}

define double @pow_sitofp_const_base_no_fast(i32 %x) {
; CHECK-LABEL: @pow_sitofp_const_base_no_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[POWI:%.*]] = tail call float @llvm.pow.f32(float 7.000000e+00, float [[SUBFP]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[POWI]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call float @llvm.pow.f32(float 7.000000e+00, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_const_base_power_of_2_no_fast(i32 %x) {
; CHECK-LABEL: @pow_sitofp_const_base_power_of_2_no_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[MUL:%.*]] = fmul float [[SUBFP]], 4.000000e+00
; CHECK-NEXT:    [[EXP2:%.*]] = call float @llvm.exp2.f32(float [[MUL]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[EXP2]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call float @llvm.pow.f32(float 16.000000e+00, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_float_base_no_fast(float %base, i32 %x) {
; CHECK-LABEL: @pow_sitofp_float_base_no_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to float
; CHECK-NEXT:    [[POWI:%.*]] = tail call float @llvm.pow.f32(float [[BASE:%.*]], float [[SUBFP]])
; CHECK-NEXT:    [[RES:%.*]] = fpext float [[POWI]] to double
; CHECK-NEXT:    ret double [[RES]]
;
  %subfp = sitofp i32 %x to float
  %powi = tail call float @llvm.pow.f32(float %base, float %subfp)
  %res = fpext float %powi to double
  ret double %res
}

define double @pow_sitofp_double_base_no_fast(double %base, i32 %x) {
; CHECK-LABEL: @pow_sitofp_double_base_no_fast(
; CHECK-NEXT:    [[SUBFP:%.*]] = sitofp i32 [[X:%.*]] to double
; CHECK-NEXT:    [[POWI:%.*]] = tail call double @llvm.pow.f64(double [[BASE:%.*]], double [[SUBFP]])
; CHECK-NEXT:    ret double [[POWI]]
;
  %subfp = sitofp i32 %x to double
  %powi = tail call double @llvm.pow.f64(double %base, double %subfp)
  ret double %powi
}

define double @powf_exp_const_int_no_fast(double %base) {
; CHECK-LABEL: @powf_exp_const_int_no_fast(
; CHECK-NEXT:    [[RES:%.*]] = tail call double @llvm.pow.f64(double [[BASE:%.*]], double 4.000000e+01)
; CHECK-NEXT:    ret double [[RES]]
;
  %res = tail call double @llvm.pow.f64(double %base, double 4.000000e+01)
  ret double %res
}

define double @powf_exp_const_not_int_fast(double %base) {
; CHECK-LABEL: @powf_exp_const_not_int_fast(
; CHECK-NEXT:    [[RES:%.*]] = tail call fast double @llvm.pow.f64(double [[BASE:%.*]], double 3.750000e+01)
; CHECK-NEXT:    ret double [[RES]]
;
  %res = tail call fast double @llvm.pow.f64(double %base, double 3.750000e+01)
  ret double %res
}

define double @powf_exp_const_not_int_no_fast(double %base) {
; CHECK-LABEL: @powf_exp_const_not_int_no_fast(
; CHECK-NEXT:    [[RES:%.*]] = tail call double @llvm.pow.f64(double [[BASE:%.*]], double 3.750000e+01)
; CHECK-NEXT:    ret double [[RES]]
;
  %res = tail call double @llvm.pow.f64(double %base, double 3.750000e+01)
  ret double %res
}

declare float @llvm.pow.f32(float, float)
declare double @llvm.pow.f64(double, double)
