; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=sse2    | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=sse4.2  | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx     | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx2    | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512dq,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLDQ
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512bw,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLBW

;
; vXf64
;

define void @store_v1f64_v1i64(<1 x i64> %trigger, <1 x double>* %addr, <1 x double> %val) {
; SSE-LABEL: store_v1f64_v1i64:
; SSE:       ## %bb.0:
; SSE-NEXT:    testq %rdi, %rdi
; SSE-NEXT:    jns LBB0_2
; SSE-NEXT:  ## %bb.1: ## %cond.store
; SSE-NEXT:    movsd %xmm0, (%rsi)
; SSE-NEXT:  LBB0_2: ## %else
; SSE-NEXT:    retq
;
; AVX-LABEL: store_v1f64_v1i64:
; AVX:       ## %bb.0:
; AVX-NEXT:    testq %rdi, %rdi
; AVX-NEXT:    jns LBB0_2
; AVX-NEXT:  ## %bb.1: ## %cond.store
; AVX-NEXT:    vmovsd %xmm0, (%rsi)
; AVX-NEXT:  LBB0_2: ## %else
; AVX-NEXT:    retq
  %mask = icmp slt <1 x i64> %trigger, zeroinitializer
  call void @llvm.masked.store.v1f64.p0v1f64(<1 x double> %val, <1 x double>* %addr, i32 4, <1 x i1> %mask)
  ret void
}

define void @store_v2f64_v2i64(<2 x i64> %trigger, <2 x double>* %addr, <2 x double> %val) {
; SSE2-LABEL: store_v2f64_v2i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movlpd %xmm1, (%rdi)
; SSE2-NEXT:  LBB1_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movhpd %xmm1, 8(%rdi)
; SSE2-NEXT:  LBB1_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v2f64_v2i64:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpgtq %xmm0, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB1_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movlpd %xmm1, (%rdi)
; SSE4-NEXT:  LBB1_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB1_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    movhpd %xmm1, 8(%rdi)
; SSE4-NEXT:  LBB1_4: ## %else2
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v2f64_v2i64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v2f64_v2i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm2, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovupd %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v2f64_v2i64:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovq2m %xmm0, %k1
; AVX512VLDQ-NEXT:    vmovupd %xmm1, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v2f64_v2i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpcmpgtq %xmm0, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovupd %xmm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp slt <2 x i64> %trigger, zeroinitializer
  call void @llvm.masked.store.v2f64.p0v2f64(<2 x double> %val, <2 x double>* %addr, i32 4, <2 x i1> %mask)
  ret void
}

define void @store_v4f64_v4i64(<4 x i64> %trigger, <4 x double>* %addr, <4 x double> %val) {
; SSE2-LABEL: store_v4f64_v4i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movlpd %xmm2, (%rdi)
; SSE2-NEXT:  LBB2_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movhpd %xmm2, 8(%rdi)
; SSE2-NEXT:  LBB2_4: ## %else2
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movlpd %xmm3, 16(%rdi)
; SSE2-NEXT:  LBB2_6: ## %else4
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    movhpd %xmm3, 24(%rdi)
; SSE2-NEXT:  LBB2_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v4f64_v4i64:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpgtq %xmm0, %xmm4
; SSE4-NEXT:    pextrb $0, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB2_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movlpd %xmm2, (%rdi)
; SSE4-NEXT:  LBB2_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB2_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    movhpd %xmm2, 8(%rdi)
; SSE4-NEXT:  LBB2_4: ## %else2
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB2_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    movlpd %xmm3, 16(%rdi)
; SSE4-NEXT:  LBB2_6: ## %else4
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB2_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    movhpd %xmm3, 24(%rdi)
; SSE4-NEXT:  LBB2_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v4f64_v4i64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi)
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v4f64_v4i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm2, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovupd %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v4f64_v4i64:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovq2m %ymm0, %k1
; AVX512VLDQ-NEXT:    vmovupd %ymm1, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v4f64_v4i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpcmpgtq %ymm0, %ymm2, %k1
; AVX512VLBW-NEXT:    vmovupd %ymm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %mask = icmp slt <4 x i64> %trigger, zeroinitializer
  call void @llvm.masked.store.v4f64.p0v4f64(<4 x double> %val, <4 x double>* %addr, i32 4, <4 x i1> %mask)
  ret void
}

;
; vXf32
;

define void @store_v2f32_v2i32(<2 x i32> %trigger, <2 x float>* %addr, <2 x float> %val) {
; SSE2-LABEL: store_v2f32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:  LBB3_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSE2-NEXT:    movss %xmm1, 4(%rdi)
; SSE2-NEXT:  LBB3_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v2f32_v2i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE4-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB3_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm1, (%rdi)
; SSE4-NEXT:  LBB3_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB3_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm1, 4(%rdi)
; SSE4-NEXT:  LBB3_4: ## %else2
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v2f32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v2f32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX2-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v2f32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovups %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_v2f32_v2i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512VL-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vmovups %xmm1, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v2f32.p0v2f32(<2 x float> %val, <2 x float>* %addr, i32 4, <2 x i1> %mask)
  ret void
}

define void @store_v4f32_v4i32(<4 x float> %x, <4 x float>* %ptr, <4 x float> %y, <4 x i32> %mask) {
; SSE2-LABEL: store_v4f32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:  LBB4_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm1, 4(%rdi)
; SSE2-NEXT:  LBB4_4: ## %else2
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE2-NEXT:    movss %xmm2, 8(%rdi)
; SSE2-NEXT:  LBB4_6: ## %else4
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB4_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v4f32_v4i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE4-NEXT:    pextrb $0, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB4_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm0, (%rdi)
; SSE4-NEXT:  LBB4_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB4_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm0, 4(%rdi)
; SSE4-NEXT:  LBB4_4: ## %else2
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE4-NEXT:    pextrb $8, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB4_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    extractps $2, %xmm0, 8(%rdi)
; SSE4-NEXT:  LBB4_6: ## %else4
; SSE4-NEXT:    pextrb $12, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB4_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    extractps $3, %xmm0, 12(%rdi)
; SSE4-NEXT:  LBB4_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v4f32_v4i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovps %xmm0, %xmm2, (%rdi)
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v4f32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpgtd %zmm2, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v4f32_v4i32:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovd2m %xmm2, %k1
; AVX512VLDQ-NEXT:    vmovups %xmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v4f32_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpcmpgtd %xmm2, %xmm1, %k1
; AVX512VLBW-NEXT:    vmovups %xmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  %bool_mask = icmp slt <4 x i32> %mask, zeroinitializer
  call void @llvm.masked.store.v4f32.p0v4f32(<4 x float> %x, <4 x float>* %ptr, i32 1, <4 x i1> %bool_mask)
  ret void
}

define void @store_v8f32_v8i32(<8 x float> %x, <8 x float>* %ptr, <8 x float> %y, <8 x i32> %mask) {
; SSE2-LABEL: store_v8f32_v8i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    packssdw %xmm0, %xmm3
; SSE2-NEXT:    movd %xmm3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:  LBB5_2: ## %else
; SSE2-NEXT:    psrlq $16, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm2, 4(%rdi)
; SSE2-NEXT:  LBB5_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; SSE2-NEXT:    movd %xmm3, 8(%rdi)
; SSE2-NEXT:  LBB5_6: ## %else4
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB5_8: ## %else6
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    movss %xmm1, 16(%rdi)
; SSE2-NEXT:  LBB5_10: ## %else8
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE2-NEXT:    movss %xmm0, 20(%rdi)
; SSE2-NEXT:  LBB5_12: ## %else10
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    movaps %xmm1, %xmm2
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE2-NEXT:    movss %xmm2, 24(%rdi)
; SSE2-NEXT:  LBB5_14: ## %else12
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movss %xmm1, 28(%rdi)
; SSE2-NEXT:  LBB5_16: ## %else14
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v8f32_v8i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movd %xmm0, (%rdi)
; SSE4-NEXT:  LBB5_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrd $1, %xmm0, 4(%rdi)
; SSE4-NEXT:  LBB5_4: ## %else2
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE4-NEXT:  LBB5_6: ## %else4
; SSE4-NEXT:    pextrb $12, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrd $3, %xmm0, 12(%rdi)
; SSE4-NEXT:  LBB5_8: ## %else6
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    movss %xmm1, 16(%rdi)
; SSE4-NEXT:  LBB5_10: ## %else8
; SSE4-NEXT:    pextrb $4, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    extractps $1, %xmm1, 20(%rdi)
; SSE4-NEXT:  LBB5_12: ## %else10
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    extractps $2, %xmm1, 24(%rdi)
; SSE4-NEXT:  LBB5_14: ## %else12
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB5_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    extractps $3, %xmm1, 28(%rdi)
; SSE4-NEXT:  LBB5_16: ## %else14
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v8f32_v8i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovps %ymm0, %ymm2, (%rdi)
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v8f32_v8i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpgtd %zmm2, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v8f32_v8i32:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k1
; AVX512VLDQ-NEXT:    vmovups %ymm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v8f32_v8i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpcmpgtd %ymm2, %ymm1, %k1
; AVX512VLBW-NEXT:    vmovups %ymm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %bool_mask = icmp slt <8 x i32> %mask, zeroinitializer
  call void @llvm.masked.store.v8f32.p0v8f32(<8 x float> %x, <8 x float>* %ptr, i32 1, <8 x i1> %bool_mask)
  ret void
}

define void @store_v16f32_v16i32(<16 x float> %x, <16 x float>* %ptr, <16 x float> %y, <16 x i32> %mask) {
; SSE2-LABEL: store_v16f32_v16i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE2-NEXT:    movd %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:  LBB6_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm5
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm5, 4(%rdi)
; SSE2-NEXT:  LBB6_4: ## %else2
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE2-NEXT:    pextrw $4, %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm0[1]
; SSE2-NEXT:    movss %xmm4, 8(%rdi)
; SSE2-NEXT:  LBB6_6: ## %else4
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; SSE2-NEXT:    pextrw $6, %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB6_8: ## %else6
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    movss %xmm1, 16(%rdi)
; SSE2-NEXT:  LBB6_10: ## %else8
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE2-NEXT:    movss %xmm0, 20(%rdi)
; SSE2-NEXT:  LBB6_12: ## %else10
; SSE2-NEXT:    pxor %xmm5, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE2-NEXT:    pextrw $4, %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE2-NEXT:    movss %xmm0, 24(%rdi)
; SSE2-NEXT:  LBB6_14: ## %else12
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $6, %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movss %xmm1, 28(%rdi)
; SSE2-NEXT:  LBB6_16: ## %else14
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store15
; SSE2-NEXT:    movss %xmm2, 32(%rdi)
; SSE2-NEXT:  LBB6_18: ## %else16
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store17
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[2,3]
; SSE2-NEXT:    movss %xmm1, 36(%rdi)
; SSE2-NEXT:  LBB6_20: ## %else18
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store19
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; SSE2-NEXT:    movss %xmm0, 40(%rdi)
; SSE2-NEXT:  LBB6_22: ## %else20
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store21
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; SSE2-NEXT:    movss %xmm2, 44(%rdi)
; SSE2-NEXT:  LBB6_24: ## %else22
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store23
; SSE2-NEXT:    movss %xmm3, 48(%rdi)
; SSE2-NEXT:  LBB6_26: ## %else24
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store25
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[2,3]
; SSE2-NEXT:    movss %xmm1, 52(%rdi)
; SSE2-NEXT:  LBB6_28: ## %else26
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store27
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE2-NEXT:    movss %xmm0, 56(%rdi)
; SSE2-NEXT:  LBB6_30: ## %else28
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store29
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE2-NEXT:    movss %xmm3, 60(%rdi)
; SSE2-NEXT:  LBB6_32: ## %else30
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v16f32_v16i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; SSE4-NEXT:    pxor %xmm5, %xmm5
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE4-NEXT:    pextrb $0, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movd %xmm0, (%rdi)
; SSE4-NEXT:  LBB6_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrd $1, %xmm0, 4(%rdi)
; SSE4-NEXT:  LBB6_4: ## %else2
; SSE4-NEXT:    pxor %xmm5, %xmm5
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE4-NEXT:    pextrb $8, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrd $2, %xmm0, 8(%rdi)
; SSE4-NEXT:  LBB6_6: ## %else4
; SSE4-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; SSE4-NEXT:    pextrb $12, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrd $3, %xmm0, 12(%rdi)
; SSE4-NEXT:  LBB6_8: ## %else6
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    movd %xmm1, 16(%rdi)
; SSE4-NEXT:  LBB6_10: ## %else8
; SSE4-NEXT:    pextrb $4, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    pextrd $1, %xmm1, 20(%rdi)
; SSE4-NEXT:  LBB6_12: ## %else10
; SSE4-NEXT:    pxor %xmm5, %xmm5
; SSE4-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE4-NEXT:    pextrb $8, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    pextrd $2, %xmm1, 24(%rdi)
; SSE4-NEXT:  LBB6_14: ## %else12
; SSE4-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE4-NEXT:    pextrb $12, %xmm5, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    pextrd $3, %xmm1, 28(%rdi)
; SSE4-NEXT:  LBB6_16: ## %else14
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE4-NEXT:    pextrb $0, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_18
; SSE4-NEXT:  ## %bb.17: ## %cond.store15
; SSE4-NEXT:    movss %xmm2, 32(%rdi)
; SSE4-NEXT:  LBB6_18: ## %else16
; SSE4-NEXT:    pextrb $4, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_20
; SSE4-NEXT:  ## %bb.19: ## %cond.store17
; SSE4-NEXT:    extractps $1, %xmm2, 36(%rdi)
; SSE4-NEXT:  LBB6_20: ## %else18
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE4-NEXT:    pextrb $8, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_22
; SSE4-NEXT:  ## %bb.21: ## %cond.store19
; SSE4-NEXT:    extractps $2, %xmm2, 40(%rdi)
; SSE4-NEXT:  LBB6_22: ## %else20
; SSE4-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE4-NEXT:    pextrb $12, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_24
; SSE4-NEXT:  ## %bb.23: ## %cond.store21
; SSE4-NEXT:    extractps $3, %xmm2, 44(%rdi)
; SSE4-NEXT:  LBB6_24: ## %else22
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE4-NEXT:    pextrb $0, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_26
; SSE4-NEXT:  ## %bb.25: ## %cond.store23
; SSE4-NEXT:    movss %xmm3, 48(%rdi)
; SSE4-NEXT:  LBB6_26: ## %else24
; SSE4-NEXT:    pextrb $4, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_28
; SSE4-NEXT:  ## %bb.27: ## %cond.store25
; SSE4-NEXT:    extractps $1, %xmm3, 52(%rdi)
; SSE4-NEXT:  LBB6_28: ## %else26
; SSE4-NEXT:    pxor %xmm1, %xmm1
; SSE4-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE4-NEXT:    pextrb $8, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_30
; SSE4-NEXT:  ## %bb.29: ## %cond.store27
; SSE4-NEXT:    extractps $2, %xmm3, 56(%rdi)
; SSE4-NEXT:  LBB6_30: ## %else28
; SSE4-NEXT:    pextrb $12, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB6_32
; SSE4-NEXT:  ## %bb.31: ## %cond.store29
; SSE4-NEXT:    extractps $3, %xmm3, 60(%rdi)
; SSE4-NEXT:  LBB6_32: ## %else30
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v16f32_v16i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovps %ymm1, %ymm5, 32(%rdi)
; AVX1OR2-NEXT:    vmaskmovps %ymm0, %ymm4, (%rdi)
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v16f32_v16i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpgtd %zmm2, %zmm1, %k1
; AVX512F-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v16f32_v16i32:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k1
; AVX512VLDQ-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v16f32_v16i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpcmpgtd %zmm2, %zmm1, %k1
; AVX512VLBW-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %bool_mask = icmp slt <16 x i32> %mask, zeroinitializer
  call void @llvm.masked.store.v16f32.p0v16f32(<16 x float> %x, <16 x float>* %ptr, i32 1, <16 x i1> %bool_mask)
  ret void
}

;
; vXi64
;

define void @store_v2i64_v2i64(<2 x i64> %trigger, <2 x i64>* %addr, <2 x i64> %val) {
; SSE2-LABEL: store_v2i64_v2i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movq %xmm1, (%rdi)
; SSE2-NEXT:  LBB7_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, 8(%rdi)
; SSE2-NEXT:  LBB7_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v2i64_v2i64:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpgtq %xmm0, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB7_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movq %xmm1, (%rdi)
; SSE4-NEXT:  LBB7_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB7_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrq $1, %xmm1, 8(%rdi)
; SSE4-NEXT:  LBB7_4: ## %else2
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v2i64_v2i64:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vmaskmovpd %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v2i64_v2i64:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpmaskmovq %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v2i64_v2i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm2, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovdqu64 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v2i64_v2i64:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovq2m %xmm0, %k1
; AVX512VLDQ-NEXT:    vmovdqu64 %xmm1, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v2i64_v2i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpcmpgtq %xmm0, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu64 %xmm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp slt <2 x i64> %trigger, zeroinitializer
  call void @llvm.masked.store.v2i64.p0v2i64(<2 x i64> %val, <2 x i64>* %addr, i32 4, <2 x i1> %mask)
  ret void
}

define void @store_v4i64_v4i64(<4 x i64> %trigger, <4 x i64>* %addr, <4 x i64> %val) {
; SSE2-LABEL: store_v4i64_v4i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:  LBB8_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, 8(%rdi)
; SSE2-NEXT:  LBB8_4: ## %else2
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm4, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movq %xmm3, 16(%rdi)
; SSE2-NEXT:  LBB8_6: ## %else4
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, 24(%rdi)
; SSE2-NEXT:  LBB8_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v4i64_v4i64:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpgtq %xmm0, %xmm4
; SSE4-NEXT:    pextrb $0, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB8_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movq %xmm2, (%rdi)
; SSE4-NEXT:  LBB8_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB8_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrq $1, %xmm2, 8(%rdi)
; SSE4-NEXT:  LBB8_4: ## %else2
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB8_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    movq %xmm3, 16(%rdi)
; SSE4-NEXT:  LBB8_6: ## %else4
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB8_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrq $1, %xmm3, 24(%rdi)
; SSE4-NEXT:  LBB8_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v4i64_v4i64:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vmaskmovpd %ymm1, %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v4i64_v4i64:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpmaskmovq %ymm1, %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v4i64_v4i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm2, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovdqu64 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v4i64_v4i64:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovq2m %ymm0, %k1
; AVX512VLDQ-NEXT:    vmovdqu64 %ymm1, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v4i64_v4i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpcmpgtq %ymm0, %ymm2, %k1
; AVX512VLBW-NEXT:    vmovdqu64 %ymm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %mask = icmp slt <4 x i64> %trigger, zeroinitializer
  call void @llvm.masked.store.v4i64.p0v4i64(<4 x i64> %val, <4 x i64>* %addr, i32 4, <4 x i1> %mask)
  ret void
}

;
; vXi32
;

define void @store_v1i32_v1i32(<1 x i32> %trigger, <1 x i32>* %addr, <1 x i32> %val) {
; SSE-LABEL: store_v1i32_v1i32:
; SSE:       ## %bb.0:
; SSE-NEXT:    testl %edi, %edi
; SSE-NEXT:    jne LBB9_2
; SSE-NEXT:  ## %bb.1: ## %cond.store
; SSE-NEXT:    movl %edx, (%rsi)
; SSE-NEXT:  LBB9_2: ## %else
; SSE-NEXT:    retq
;
; AVX-LABEL: store_v1i32_v1i32:
; AVX:       ## %bb.0:
; AVX-NEXT:    testl %edi, %edi
; AVX-NEXT:    jne LBB9_2
; AVX-NEXT:  ## %bb.1: ## %cond.store
; AVX-NEXT:    movl %edx, (%rsi)
; AVX-NEXT:  LBB9_2: ## %else
; AVX-NEXT:    retq
  %mask = icmp eq <1 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v1i32.p0v1i32(<1 x i32> %val, <1 x i32>* %addr, i32 4, <1 x i1> %mask)
  ret void
}

define void @store_v2i32_v2i32(<2 x i32> %trigger, <2 x i32>* %addr, <2 x i32> %val) {
; SSE2-LABEL: store_v2i32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm1, (%rdi)
; SSE2-NEXT:  LBB10_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 4(%rdi)
; SSE2-NEXT:  LBB10_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v2i32_v2i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE4-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB10_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm1, (%rdi)
; SSE4-NEXT:  LBB10_2: ## %else
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB10_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $2, %xmm1, 4(%rdi)
; SSE4-NEXT:  LBB10_4: ## %else2
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v2i32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v2i32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v2i32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_v2i32_v2i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512VL-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpmovqd %xmm1, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v2i32.p0v2i32(<2 x i32> %val, <2 x i32>* %addr, i32 4, <2 x i1> %mask)
  ret void
}

define void @store_v4i32_v4i32(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %val) {
; SSE2-LABEL: store_v4i32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm1, (%rdi)
; SSE2-NEXT:  LBB11_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, 4(%rdi)
; SSE2-NEXT:  LBB11_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, 8(%rdi)
; SSE2-NEXT:  LBB11_6: ## %else4
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB11_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v4i32_v4i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB11_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm1, (%rdi)
; SSE4-NEXT:  LBB11_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB11_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm1, 4(%rdi)
; SSE4-NEXT:  LBB11_4: ## %else2
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB11_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    extractps $2, %xmm1, 8(%rdi)
; SSE4-NEXT:  LBB11_6: ## %else4
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB11_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    extractps $3, %xmm1, 12(%rdi)
; SSE4-NEXT:  LBB11_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v4i32_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v4i32_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v4i32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_v4i32_v4i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vmovdqu32 %xmm1, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v4i32.p0v4i32(<4 x i32> %val, <4 x i32>* %addr, i32 4, <4 x i1> %mask)
  ret void
}

define void @store_v8i32_v8i32(<8 x i32> %trigger, <8 x i32>* %addr, <8 x i32> %val) {
; SSE2-LABEL: store_v8i32_v8i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    packssdw %xmm0, %xmm5
; SSE2-NEXT:    movd %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm2, (%rdi)
; SSE2-NEXT:  LBB12_2: ## %else
; SSE2-NEXT:    psrlq $16, %xmm4
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,2,3]
; SSE2-NEXT:    movd %xmm4, 4(%rdi)
; SSE2-NEXT:  LBB12_4: ## %else2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm4, 8(%rdi)
; SSE2-NEXT:  LBB12_6: ## %else4
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB12_8: ## %else6
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    movd %xmm3, 16(%rdi)
; SSE2-NEXT:  LBB12_10: ## %else8
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, 20(%rdi)
; SSE2-NEXT:  LBB12_12: ## %else10
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 24(%rdi)
; SSE2-NEXT:  LBB12_14: ## %else12
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 28(%rdi)
; SSE2-NEXT:  LBB12_16: ## %else14
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v8i32_v8i32:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE4-NEXT:    pextrb $0, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm2, (%rdi)
; SSE4-NEXT:  LBB12_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm2, 4(%rdi)
; SSE4-NEXT:  LBB12_4: ## %else2
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    extractps $2, %xmm2, 8(%rdi)
; SSE4-NEXT:  LBB12_6: ## %else4
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    extractps $3, %xmm2, 12(%rdi)
; SSE4-NEXT:  LBB12_8: ## %else6
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    movss %xmm3, 16(%rdi)
; SSE4-NEXT:  LBB12_10: ## %else8
; SSE4-NEXT:    pextrb $4, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    extractps $1, %xmm3, 20(%rdi)
; SSE4-NEXT:  LBB12_12: ## %else10
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE4-NEXT:    pextrb $8, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    extractps $2, %xmm3, 24(%rdi)
; SSE4-NEXT:  LBB12_14: ## %else12
; SSE4-NEXT:    pextrb $12, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB12_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    extractps $3, %xmm3, 28(%rdi)
; SSE4-NEXT:  LBB12_16: ## %else14
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v8i32_v8i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vmaskmovps %ymm1, %ymm0, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v8i32_v8i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd %ymm1, %ymm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v8i32_v8i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_v8i32_v8i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqu32 %ymm1, (%rdi) {%k1}
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %mask = icmp eq <8 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v8i32.p0v8i32(<8 x i32> %val, <8 x i32>* %addr, i32 4, <8 x i1> %mask)
  ret void
}

;
; vXi16
;

define void @store_v8i16_v8i16(<8 x i16> %trigger, <8 x i16>* %addr, <8 x i16> %val) {
; SSE2-LABEL: store_v8i16_v8i16:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm1, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:  LBB13_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 2(%rdi)
; SSE2-NEXT:  LBB13_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 4(%rdi)
; SSE2-NEXT:  LBB13_6: ## %else4
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 6(%rdi)
; SSE2-NEXT:  LBB13_8: ## %else6
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 8(%rdi)
; SSE2-NEXT:  LBB13_10: ## %else8
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    pextrw $5, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 10(%rdi)
; SSE2-NEXT:  LBB13_12: ## %else10
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 12(%rdi)
; SSE2-NEXT:  LBB13_14: ## %else12
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB13_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    movw %ax, 14(%rdi)
; SSE2-NEXT:  LBB13_16: ## %else14
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v8i16_v8i16:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    pextrw $0, %xmm1, (%rdi)
; SSE4-NEXT:  LBB13_2: ## %else
; SSE4-NEXT:    pextrb $2, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm1, 2(%rdi)
; SSE4-NEXT:  LBB13_4: ## %else2
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm1, 4(%rdi)
; SSE4-NEXT:  LBB13_6: ## %else4
; SSE4-NEXT:    pextrb $6, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm1, 6(%rdi)
; SSE4-NEXT:  LBB13_8: ## %else6
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm2
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    pextrw $4, %xmm1, 8(%rdi)
; SSE4-NEXT:  LBB13_10: ## %else8
; SSE4-NEXT:    pextrb $10, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    pextrw $5, %xmm1, 10(%rdi)
; SSE4-NEXT:  LBB13_12: ## %else10
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    pextrw $6, %xmm1, 12(%rdi)
; SSE4-NEXT:  LBB13_14: ## %else12
; SSE4-NEXT:    pextrb $14, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB13_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    pextrw $7, %xmm1, 14(%rdi)
; SSE4-NEXT:  LBB13_16: ## %else14
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v8i16_v8i16:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX1OR2-NEXT:  LBB13_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX1OR2-NEXT:  LBB13_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store3
; AVX1OR2-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX1OR2-NEXT:  LBB13_6: ## %else4
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store5
; AVX1OR2-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX1OR2-NEXT:  LBB13_8: ## %else6
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store7
; AVX1OR2-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX1OR2-NEXT:  LBB13_10: ## %else8
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store9
; AVX1OR2-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX1OR2-NEXT:  LBB13_12: ## %else10
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpextrb $12, %xmm0, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store11
; AVX1OR2-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX1OR2-NEXT:  LBB13_14: ## %else12
; AVX1OR2-NEXT:    vpextrb $14, %xmm0, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB13_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store13
; AVX1OR2-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX1OR2-NEXT:  LBB13_16: ## %else14
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v8i16_v8i16:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX512F-NEXT:  LBB13_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX512F-NEXT:  LBB13_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX512F-NEXT:  LBB13_6: ## %else4
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX512F-NEXT:  LBB13_8: ## %else6
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store7
; AVX512F-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX512F-NEXT:  LBB13_10: ## %else8
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store9
; AVX512F-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX512F-NEXT:  LBB13_12: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store11
; AVX512F-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX512F-NEXT:  LBB13_14: ## %else12
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB13_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store13
; AVX512F-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX512F-NEXT:  LBB13_16: ## %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v8i16_v8i16:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX512VLDQ-NEXT:  LBB13_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrb $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX512VLDQ-NEXT:  LBB13_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store3
; AVX512VLDQ-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX512VLDQ-NEXT:  LBB13_6: ## %else4
; AVX512VLDQ-NEXT:    kshiftrb $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store5
; AVX512VLDQ-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX512VLDQ-NEXT:  LBB13_8: ## %else6
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX512VLDQ-NEXT:  LBB13_10: ## %else8
; AVX512VLDQ-NEXT:    kshiftrb $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store9
; AVX512VLDQ-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX512VLDQ-NEXT:  LBB13_12: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VLDQ-NEXT:    vpmovd2m %ymm0, %k0
; AVX512VLDQ-NEXT:    kshiftrb $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store11
; AVX512VLDQ-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX512VLDQ-NEXT:  LBB13_14: ## %else12
; AVX512VLDQ-NEXT:    kshiftrb $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB13_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX512VLDQ-NEXT:  LBB13_16: ## %else14
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v8i16_v8i16:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmw %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %xmm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <8 x i16> %trigger, zeroinitializer
  call void @llvm.masked.store.v8i16.p0v8i16(<8 x i16> %val, <8 x i16>* %addr, i32 4, <8 x i1> %mask)
  ret void
}

define void @store_v16i16_v16i16(<16 x i16> %trigger, <16 x i16>* %addr, <16 x i16> %val) {
; SSE2-LABEL: store_v16i16_v16i16:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:  LBB14_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 2(%rdi)
; SSE2-NEXT:  LBB14_4: ## %else2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE2-NEXT:    pextrw $2, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 4(%rdi)
; SSE2-NEXT:  LBB14_6: ## %else4
; SSE2-NEXT:    pextrw $3, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 6(%rdi)
; SSE2-NEXT:  LBB14_8: ## %else6
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE2-NEXT:    pextrw $4, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 8(%rdi)
; SSE2-NEXT:  LBB14_10: ## %else8
; SSE2-NEXT:    pextrw $5, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 10(%rdi)
; SSE2-NEXT:  LBB14_12: ## %else10
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 12(%rdi)
; SSE2-NEXT:  LBB14_14: ## %else12
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 14(%rdi)
; SSE2-NEXT:  LBB14_16: ## %else14
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store15
; SSE2-NEXT:    movd %xmm3, %ecx
; SSE2-NEXT:    movw %cx, 16(%rdi)
; SSE2-NEXT:  LBB14_18: ## %else16
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store17
; SSE2-NEXT:    pextrw $1, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 18(%rdi)
; SSE2-NEXT:  LBB14_20: ## %else18
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store19
; SSE2-NEXT:    pextrw $2, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 20(%rdi)
; SSE2-NEXT:  LBB14_22: ## %else20
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store21
; SSE2-NEXT:    pextrw $3, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 22(%rdi)
; SSE2-NEXT:  LBB14_24: ## %else22
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store23
; SSE2-NEXT:    pextrw $4, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 24(%rdi)
; SSE2-NEXT:  LBB14_26: ## %else24
; SSE2-NEXT:    pextrw $5, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store25
; SSE2-NEXT:    pextrw $5, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 26(%rdi)
; SSE2-NEXT:  LBB14_28: ## %else26
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm1
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store27
; SSE2-NEXT:    pextrw $6, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 28(%rdi)
; SSE2-NEXT:  LBB14_30: ## %else28
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB14_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store29
; SSE2-NEXT:    pextrw $7, %xmm3, %eax
; SSE2-NEXT:    movw %ax, 30(%rdi)
; SSE2-NEXT:  LBB14_32: ## %else30
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v16i16_v16i16:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE4-NEXT:    pextrb $0, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    pextrw $0, %xmm2, (%rdi)
; SSE4-NEXT:  LBB14_2: ## %else
; SSE4-NEXT:    pextrb $2, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm2, 2(%rdi)
; SSE4-NEXT:  LBB14_4: ## %else2
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE4-NEXT:    pextrb $4, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm2, 4(%rdi)
; SSE4-NEXT:  LBB14_6: ## %else4
; SSE4-NEXT:    pextrb $6, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm2, 6(%rdi)
; SSE4-NEXT:  LBB14_8: ## %else6
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm4
; SSE4-NEXT:    pextrb $8, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    pextrw $4, %xmm2, 8(%rdi)
; SSE4-NEXT:  LBB14_10: ## %else8
; SSE4-NEXT:    pextrb $10, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    pextrw $5, %xmm2, 10(%rdi)
; SSE4-NEXT:  LBB14_12: ## %else10
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    pextrw $6, %xmm2, 12(%rdi)
; SSE4-NEXT:  LBB14_14: ## %else12
; SSE4-NEXT:    pextrb $14, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    pextrw $7, %xmm2, 14(%rdi)
; SSE4-NEXT:  LBB14_16: ## %else14
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_18
; SSE4-NEXT:  ## %bb.17: ## %cond.store15
; SSE4-NEXT:    pextrw $0, %xmm3, 16(%rdi)
; SSE4-NEXT:  LBB14_18: ## %else16
; SSE4-NEXT:    pextrb $2, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_20
; SSE4-NEXT:  ## %bb.19: ## %cond.store17
; SSE4-NEXT:    pextrw $1, %xmm3, 18(%rdi)
; SSE4-NEXT:  LBB14_20: ## %else18
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE4-NEXT:    pextrb $4, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_22
; SSE4-NEXT:  ## %bb.21: ## %cond.store19
; SSE4-NEXT:    pextrw $2, %xmm3, 20(%rdi)
; SSE4-NEXT:  LBB14_22: ## %else20
; SSE4-NEXT:    pextrb $6, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_24
; SSE4-NEXT:  ## %bb.23: ## %cond.store21
; SSE4-NEXT:    pextrw $3, %xmm3, 22(%rdi)
; SSE4-NEXT:  LBB14_24: ## %else22
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_26
; SSE4-NEXT:  ## %bb.25: ## %cond.store23
; SSE4-NEXT:    pextrw $4, %xmm3, 24(%rdi)
; SSE4-NEXT:  LBB14_26: ## %else24
; SSE4-NEXT:    pextrb $10, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_28
; SSE4-NEXT:  ## %bb.27: ## %cond.store25
; SSE4-NEXT:    pextrw $5, %xmm3, 26(%rdi)
; SSE4-NEXT:  LBB14_28: ## %else26
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqw %xmm0, %xmm1
; SSE4-NEXT:    pextrb $12, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_30
; SSE4-NEXT:  ## %bb.29: ## %cond.store27
; SSE4-NEXT:    pextrw $6, %xmm3, 28(%rdi)
; SSE4-NEXT:  LBB14_30: ## %else28
; SSE4-NEXT:    pextrb $14, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB14_32
; SSE4-NEXT:  ## %bb.31: ## %cond.store29
; SSE4-NEXT:    pextrw $7, %xmm3, 30(%rdi)
; SSE4-NEXT:  LBB14_32: ## %else30
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v16i16_v16i16:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX1-NEXT:  LBB14_2: ## %else
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX1-NEXT:  LBB14_4: ## %else2
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $4, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_6
; AVX1-NEXT:  ## %bb.5: ## %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX1-NEXT:  LBB14_6: ## %else4
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_8
; AVX1-NEXT:  ## %bb.7: ## %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX1-NEXT:  LBB14_8: ## %else6
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $8, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_10
; AVX1-NEXT:  ## %bb.9: ## %cond.store7
; AVX1-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX1-NEXT:  LBB14_10: ## %else8
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_12
; AVX1-NEXT:  ## %bb.11: ## %cond.store9
; AVX1-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX1-NEXT:  LBB14_12: ## %else10
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $12, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_14
; AVX1-NEXT:  ## %bb.13: ## %cond.store11
; AVX1-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX1-NEXT:  LBB14_14: ## %else12
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $14, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_16
; AVX1-NEXT:  ## %bb.15: ## %cond.store13
; AVX1-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX1-NEXT:  LBB14_16: ## %else14
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    je LBB14_18
; AVX1-NEXT:  ## %bb.17: ## %cond.store15
; AVX1-NEXT:    vpextrw $0, %xmm0, 16(%rdi)
; AVX1-NEXT:  LBB14_18: ## %else16
; AVX1-NEXT:    vpextrb $2, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_20
; AVX1-NEXT:  ## %bb.19: ## %cond.store17
; AVX1-NEXT:    vpextrw $1, %xmm0, 18(%rdi)
; AVX1-NEXT:  LBB14_20: ## %else18
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $4, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_22
; AVX1-NEXT:  ## %bb.21: ## %cond.store19
; AVX1-NEXT:    vpextrw $2, %xmm0, 20(%rdi)
; AVX1-NEXT:  LBB14_22: ## %else20
; AVX1-NEXT:    vpextrb $6, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_24
; AVX1-NEXT:  ## %bb.23: ## %cond.store21
; AVX1-NEXT:    vpextrw $3, %xmm0, 22(%rdi)
; AVX1-NEXT:  LBB14_24: ## %else22
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_26
; AVX1-NEXT:  ## %bb.25: ## %cond.store23
; AVX1-NEXT:    vpextrw $4, %xmm0, 24(%rdi)
; AVX1-NEXT:  LBB14_26: ## %else24
; AVX1-NEXT:    vpextrb $10, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_28
; AVX1-NEXT:  ## %bb.27: ## %cond.store25
; AVX1-NEXT:    vpextrw $5, %xmm0, 26(%rdi)
; AVX1-NEXT:  LBB14_28: ## %else26
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_30
; AVX1-NEXT:  ## %bb.29: ## %cond.store27
; AVX1-NEXT:    vpextrw $6, %xmm0, 28(%rdi)
; AVX1-NEXT:  LBB14_30: ## %else28
; AVX1-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB14_32
; AVX1-NEXT:  ## %bb.31: ## %cond.store29
; AVX1-NEXT:    vpextrw $7, %xmm0, 30(%rdi)
; AVX1-NEXT:  LBB14_32: ## %else30
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v16i16_v16i16:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX2-NEXT:  LBB14_2: ## %else
; AVX2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX2-NEXT:  LBB14_4: ## %else2
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_6
; AVX2-NEXT:  ## %bb.5: ## %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX2-NEXT:  LBB14_6: ## %else4
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_8
; AVX2-NEXT:  ## %bb.7: ## %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX2-NEXT:  LBB14_8: ## %else6
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_10
; AVX2-NEXT:  ## %bb.9: ## %cond.store7
; AVX2-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX2-NEXT:  LBB14_10: ## %else8
; AVX2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_12
; AVX2-NEXT:  ## %bb.11: ## %cond.store9
; AVX2-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX2-NEXT:  LBB14_12: ## %else10
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_14
; AVX2-NEXT:  ## %bb.13: ## %cond.store11
; AVX2-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX2-NEXT:  LBB14_14: ## %else12
; AVX2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_16
; AVX2-NEXT:  ## %bb.15: ## %cond.store13
; AVX2-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX2-NEXT:  LBB14_16: ## %else14
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    je LBB14_18
; AVX2-NEXT:  ## %bb.17: ## %cond.store15
; AVX2-NEXT:    vpextrw $0, %xmm1, 16(%rdi)
; AVX2-NEXT:  LBB14_18: ## %else16
; AVX2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_20
; AVX2-NEXT:  ## %bb.19: ## %cond.store17
; AVX2-NEXT:    vpextrw $1, %xmm1, 18(%rdi)
; AVX2-NEXT:  LBB14_20: ## %else18
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_22
; AVX2-NEXT:  ## %bb.21: ## %cond.store19
; AVX2-NEXT:    vpextrw $2, %xmm1, 20(%rdi)
; AVX2-NEXT:  LBB14_22: ## %else20
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_24
; AVX2-NEXT:  ## %bb.23: ## %cond.store21
; AVX2-NEXT:    vpextrw $3, %xmm1, 22(%rdi)
; AVX2-NEXT:  LBB14_24: ## %else22
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_26
; AVX2-NEXT:  ## %bb.25: ## %cond.store23
; AVX2-NEXT:    vpextrw $4, %xmm1, 24(%rdi)
; AVX2-NEXT:  LBB14_26: ## %else24
; AVX2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_28
; AVX2-NEXT:  ## %bb.27: ## %cond.store25
; AVX2-NEXT:    vpextrw $5, %xmm1, 26(%rdi)
; AVX2-NEXT:  LBB14_28: ## %else26
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpextrb $12, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_30
; AVX2-NEXT:  ## %bb.29: ## %cond.store27
; AVX2-NEXT:    vpextrw $6, %xmm1, 28(%rdi)
; AVX2-NEXT:  LBB14_30: ## %else28
; AVX2-NEXT:    vpextrb $14, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB14_32
; AVX2-NEXT:  ## %bb.31: ## %cond.store29
; AVX2-NEXT:    vpextrw $7, %xmm1, 30(%rdi)
; AVX2-NEXT:  LBB14_32: ## %else30
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v16i16_v16i16:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX512F-NEXT:  LBB14_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX512F-NEXT:  LBB14_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX512F-NEXT:  LBB14_6: ## %else4
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX512F-NEXT:  LBB14_8: ## %else6
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store7
; AVX512F-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX512F-NEXT:  LBB14_10: ## %else8
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store9
; AVX512F-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX512F-NEXT:  LBB14_12: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store11
; AVX512F-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX512F-NEXT:  LBB14_14: ## %else12
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store13
; AVX512F-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX512F-NEXT:  LBB14_16: ## %else14
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    je LBB14_18
; AVX512F-NEXT:  ## %bb.17: ## %cond.store15
; AVX512F-NEXT:    vpextrw $0, %xmm1, 16(%rdi)
; AVX512F-NEXT:  LBB14_18: ## %else16
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_20
; AVX512F-NEXT:  ## %bb.19: ## %cond.store17
; AVX512F-NEXT:    vpextrw $1, %xmm1, 18(%rdi)
; AVX512F-NEXT:  LBB14_20: ## %else18
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_22
; AVX512F-NEXT:  ## %bb.21: ## %cond.store19
; AVX512F-NEXT:    vpextrw $2, %xmm1, 20(%rdi)
; AVX512F-NEXT:  LBB14_22: ## %else20
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_24
; AVX512F-NEXT:  ## %bb.23: ## %cond.store21
; AVX512F-NEXT:    vpextrw $3, %xmm1, 22(%rdi)
; AVX512F-NEXT:  LBB14_24: ## %else22
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_26
; AVX512F-NEXT:  ## %bb.25: ## %cond.store23
; AVX512F-NEXT:    vpextrw $4, %xmm1, 24(%rdi)
; AVX512F-NEXT:  LBB14_26: ## %else24
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_28
; AVX512F-NEXT:  ## %bb.27: ## %cond.store25
; AVX512F-NEXT:    vpextrw $5, %xmm1, 26(%rdi)
; AVX512F-NEXT:  LBB14_28: ## %else26
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_30
; AVX512F-NEXT:  ## %bb.29: ## %cond.store27
; AVX512F-NEXT:    vpextrw $6, %xmm1, 28(%rdi)
; AVX512F-NEXT:  LBB14_30: ## %else28
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB14_32
; AVX512F-NEXT:  ## %bb.31: ## %cond.store29
; AVX512F-NEXT:    vpextrw $7, %xmm1, 30(%rdi)
; AVX512F-NEXT:  LBB14_32: ## %else30
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v16i16_v16i16:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrw $0, %xmm1, (%rdi)
; AVX512VLDQ-NEXT:  LBB14_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrw $1, %xmm1, 2(%rdi)
; AVX512VLDQ-NEXT:  LBB14_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store3
; AVX512VLDQ-NEXT:    vpextrw $2, %xmm1, 4(%rdi)
; AVX512VLDQ-NEXT:  LBB14_6: ## %else4
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store5
; AVX512VLDQ-NEXT:    vpextrw $3, %xmm1, 6(%rdi)
; AVX512VLDQ-NEXT:  LBB14_8: ## %else6
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrw $4, %xmm1, 8(%rdi)
; AVX512VLDQ-NEXT:  LBB14_10: ## %else8
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store9
; AVX512VLDQ-NEXT:    vpextrw $5, %xmm1, 10(%rdi)
; AVX512VLDQ-NEXT:  LBB14_12: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store11
; AVX512VLDQ-NEXT:    vpextrw $6, %xmm1, 12(%rdi)
; AVX512VLDQ-NEXT:  LBB14_14: ## %else12
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrw $7, %xmm1, 14(%rdi)
; AVX512VLDQ-NEXT:  LBB14_16: ## %else14
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512VLDQ-NEXT:    je LBB14_18
; AVX512VLDQ-NEXT:  ## %bb.17: ## %cond.store15
; AVX512VLDQ-NEXT:    vpextrw $0, %xmm1, 16(%rdi)
; AVX512VLDQ-NEXT:  LBB14_18: ## %else16
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_20
; AVX512VLDQ-NEXT:  ## %bb.19: ## %cond.store17
; AVX512VLDQ-NEXT:    vpextrw $1, %xmm1, 18(%rdi)
; AVX512VLDQ-NEXT:  LBB14_20: ## %else18
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_22
; AVX512VLDQ-NEXT:  ## %bb.21: ## %cond.store19
; AVX512VLDQ-NEXT:    vpextrw $2, %xmm1, 20(%rdi)
; AVX512VLDQ-NEXT:  LBB14_22: ## %else20
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_24
; AVX512VLDQ-NEXT:  ## %bb.23: ## %cond.store21
; AVX512VLDQ-NEXT:    vpextrw $3, %xmm1, 22(%rdi)
; AVX512VLDQ-NEXT:  LBB14_24: ## %else22
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_26
; AVX512VLDQ-NEXT:  ## %bb.25: ## %cond.store23
; AVX512VLDQ-NEXT:    vpextrw $4, %xmm1, 24(%rdi)
; AVX512VLDQ-NEXT:  LBB14_26: ## %else24
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_28
; AVX512VLDQ-NEXT:  ## %bb.27: ## %cond.store25
; AVX512VLDQ-NEXT:    vpextrw $5, %xmm1, 26(%rdi)
; AVX512VLDQ-NEXT:  LBB14_28: ## %else26
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX512VLDQ-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_30
; AVX512VLDQ-NEXT:  ## %bb.29: ## %cond.store27
; AVX512VLDQ-NEXT:    vpextrw $6, %xmm1, 28(%rdi)
; AVX512VLDQ-NEXT:  LBB14_30: ## %else28
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB14_32
; AVX512VLDQ-NEXT:  ## %bb.31: ## %cond.store29
; AVX512VLDQ-NEXT:    vpextrw $7, %xmm1, 30(%rdi)
; AVX512VLDQ-NEXT:  LBB14_32: ## %else30
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v16i16_v16i16:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmw %ymm0, %ymm0, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %ymm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <16 x i16> %trigger, zeroinitializer
  call void @llvm.masked.store.v16i16.p0v16i16(<16 x i16> %val, <16 x i16>* %addr, i32 4, <16 x i1> %mask)
  ret void
}

;
; vXi8
;

define void @store_v16i8_v16i8(<16 x i8> %trigger, <16 x i8>* %addr, <16 x i8> %val) {
; SSE2-LABEL: store_v16i8_v16i8:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    je LBB15_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:  LBB15_2: ## %else
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movb %ah, 1(%rdi)
; SSE2-NEXT:  LBB15_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    je LBB15_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:  LBB15_6: ## %else4
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, 3(%rdi)
; SSE2-NEXT:  LBB15_8: ## %else6
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    je LBB15_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    movb %al, 4(%rdi)
; SSE2-NEXT:  LBB15_10: ## %else8
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    movb %ah, 5(%rdi)
; SSE2-NEXT:  LBB15_12: ## %else10
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    pextrw $3, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $3, %xmm1, %eax
; SSE2-NEXT:    je LBB15_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    movb %al, 6(%rdi)
; SSE2-NEXT:  LBB15_14: ## %else12
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    movb %ah, 7(%rdi)
; SSE2-NEXT:  LBB15_16: ## %else14
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    je LBB15_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store15
; SSE2-NEXT:    movb %al, 8(%rdi)
; SSE2-NEXT:  LBB15_18: ## %else16
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store17
; SSE2-NEXT:    movb %ah, 9(%rdi)
; SSE2-NEXT:  LBB15_20: ## %else18
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    pextrw $5, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $5, %xmm1, %eax
; SSE2-NEXT:    je LBB15_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store19
; SSE2-NEXT:    movb %al, 10(%rdi)
; SSE2-NEXT:  LBB15_22: ## %else20
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store21
; SSE2-NEXT:    movb %ah, 11(%rdi)
; SSE2-NEXT:  LBB15_24: ## %else22
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE2-NEXT:    pextrw $6, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    je LBB15_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store23
; SSE2-NEXT:    movb %al, 12(%rdi)
; SSE2-NEXT:  LBB15_26: ## %else24
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store25
; SSE2-NEXT:    movb %ah, 13(%rdi)
; SSE2-NEXT:  LBB15_28: ## %else26
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE2-NEXT:    pextrw $7, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    je LBB15_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store27
; SSE2-NEXT:    movb %al, 14(%rdi)
; SSE2-NEXT:  LBB15_30: ## %else28
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB15_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store29
; SSE2-NEXT:    movb %ah, 15(%rdi)
; SSE2-NEXT:  LBB15_32: ## %else30
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v16i8_v16i8:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    pextrb $0, %xmm1, (%rdi)
; SSE4-NEXT:  LBB15_2: ## %else
; SSE4-NEXT:    pextrb $1, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm1, 1(%rdi)
; SSE4-NEXT:  LBB15_4: ## %else2
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $2, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm1, 2(%rdi)
; SSE4-NEXT:  LBB15_6: ## %else4
; SSE4-NEXT:    pextrb $3, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm1, 3(%rdi)
; SSE4-NEXT:  LBB15_8: ## %else6
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm1, 4(%rdi)
; SSE4-NEXT:  LBB15_10: ## %else8
; SSE4-NEXT:    pextrb $5, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm1, 5(%rdi)
; SSE4-NEXT:  LBB15_12: ## %else10
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $6, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm1, 6(%rdi)
; SSE4-NEXT:  LBB15_14: ## %else12
; SSE4-NEXT:    pextrb $7, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm1, 7(%rdi)
; SSE4-NEXT:  LBB15_16: ## %else14
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_18
; SSE4-NEXT:  ## %bb.17: ## %cond.store15
; SSE4-NEXT:    pextrb $8, %xmm1, 8(%rdi)
; SSE4-NEXT:  LBB15_18: ## %else16
; SSE4-NEXT:    pextrb $9, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_20
; SSE4-NEXT:  ## %bb.19: ## %cond.store17
; SSE4-NEXT:    pextrb $9, %xmm1, 9(%rdi)
; SSE4-NEXT:  LBB15_20: ## %else18
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $10, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_22
; SSE4-NEXT:  ## %bb.21: ## %cond.store19
; SSE4-NEXT:    pextrb $10, %xmm1, 10(%rdi)
; SSE4-NEXT:  LBB15_22: ## %else20
; SSE4-NEXT:    pextrb $11, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_24
; SSE4-NEXT:  ## %bb.23: ## %cond.store21
; SSE4-NEXT:    pextrb $11, %xmm1, 11(%rdi)
; SSE4-NEXT:  LBB15_24: ## %else22
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE4-NEXT:    pextrb $12, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_26
; SSE4-NEXT:  ## %bb.25: ## %cond.store23
; SSE4-NEXT:    pextrb $12, %xmm1, 12(%rdi)
; SSE4-NEXT:  LBB15_26: ## %else24
; SSE4-NEXT:    pextrb $13, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_28
; SSE4-NEXT:  ## %bb.27: ## %cond.store25
; SSE4-NEXT:    pextrb $13, %xmm1, 13(%rdi)
; SSE4-NEXT:  LBB15_28: ## %else26
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE4-NEXT:    pextrb $14, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_30
; SSE4-NEXT:  ## %bb.29: ## %cond.store27
; SSE4-NEXT:    pextrb $14, %xmm1, 14(%rdi)
; SSE4-NEXT:  LBB15_30: ## %else28
; SSE4-NEXT:    pextrb $15, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB15_32
; SSE4-NEXT:  ## %bb.31: ## %cond.store29
; SSE4-NEXT:    pextrb $15, %xmm1, 15(%rdi)
; SSE4-NEXT:  LBB15_32: ## %else30
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: store_v16i8_v16i8:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX1OR2-NEXT:  LBB15_2: ## %else
; AVX1OR2-NEXT:    vpextrb $1, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX1OR2-NEXT:  LBB15_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store3
; AVX1OR2-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX1OR2-NEXT:  LBB15_6: ## %else4
; AVX1OR2-NEXT:    vpextrb $3, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store5
; AVX1OR2-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX1OR2-NEXT:  LBB15_8: ## %else6
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store7
; AVX1OR2-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX1OR2-NEXT:  LBB15_10: ## %else8
; AVX1OR2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store9
; AVX1OR2-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX1OR2-NEXT:  LBB15_12: ## %else10
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store11
; AVX1OR2-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX1OR2-NEXT:  LBB15_14: ## %else12
; AVX1OR2-NEXT:    vpextrb $7, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store13
; AVX1OR2-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX1OR2-NEXT:  LBB15_16: ## %else14
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_18
; AVX1OR2-NEXT:  ## %bb.17: ## %cond.store15
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX1OR2-NEXT:  LBB15_18: ## %else16
; AVX1OR2-NEXT:    vpextrb $9, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_20
; AVX1OR2-NEXT:  ## %bb.19: ## %cond.store17
; AVX1OR2-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX1OR2-NEXT:  LBB15_20: ## %else18
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_22
; AVX1OR2-NEXT:  ## %bb.21: ## %cond.store19
; AVX1OR2-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX1OR2-NEXT:  LBB15_22: ## %else20
; AVX1OR2-NEXT:    vpextrb $11, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_24
; AVX1OR2-NEXT:  ## %bb.23: ## %cond.store21
; AVX1OR2-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX1OR2-NEXT:  LBB15_24: ## %else22
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1OR2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_26
; AVX1OR2-NEXT:  ## %bb.25: ## %cond.store23
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX1OR2-NEXT:  LBB15_26: ## %else24
; AVX1OR2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_28
; AVX1OR2-NEXT:  ## %bb.27: ## %cond.store25
; AVX1OR2-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX1OR2-NEXT:  LBB15_28: ## %else26
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpextrb $14, %xmm0, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_30
; AVX1OR2-NEXT:  ## %bb.29: ## %cond.store27
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX1OR2-NEXT:  LBB15_30: ## %else28
; AVX1OR2-NEXT:    vpextrb $15, %xmm0, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB15_32
; AVX1OR2-NEXT:  ## %bb.31: ## %cond.store29
; AVX1OR2-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX1OR2-NEXT:  LBB15_32: ## %else30
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: store_v16i8_v16i8:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX512F-NEXT:  LBB15_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX512F-NEXT:  LBB15_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX512F-NEXT:  LBB15_6: ## %else4
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX512F-NEXT:  LBB15_8: ## %else6
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX512F-NEXT:  LBB15_10: ## %else8
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX512F-NEXT:  LBB15_12: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX512F-NEXT:  LBB15_14: ## %else12
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX512F-NEXT:  LBB15_16: ## %else14
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_18
; AVX512F-NEXT:  ## %bb.17: ## %cond.store15
; AVX512F-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX512F-NEXT:  LBB15_18: ## %else16
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_20
; AVX512F-NEXT:  ## %bb.19: ## %cond.store17
; AVX512F-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX512F-NEXT:  LBB15_20: ## %else18
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_22
; AVX512F-NEXT:  ## %bb.21: ## %cond.store19
; AVX512F-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX512F-NEXT:  LBB15_22: ## %else20
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_24
; AVX512F-NEXT:  ## %bb.23: ## %cond.store21
; AVX512F-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX512F-NEXT:  LBB15_24: ## %else22
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_26
; AVX512F-NEXT:  ## %bb.25: ## %cond.store23
; AVX512F-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX512F-NEXT:  LBB15_26: ## %else24
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_28
; AVX512F-NEXT:  ## %bb.27: ## %cond.store25
; AVX512F-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX512F-NEXT:  LBB15_28: ## %else26
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_30
; AVX512F-NEXT:  ## %bb.29: ## %cond.store27
; AVX512F-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX512F-NEXT:  LBB15_30: ## %else28
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB15_32
; AVX512F-NEXT:  ## %bb.31: ## %cond.store29
; AVX512F-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX512F-NEXT:  LBB15_32: ## %else30
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v16i8_v16i8:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX512VLDQ-NEXT:  LBB15_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX512VLDQ-NEXT:  LBB15_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store3
; AVX512VLDQ-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX512VLDQ-NEXT:  LBB15_6: ## %else4
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store5
; AVX512VLDQ-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX512VLDQ-NEXT:  LBB15_8: ## %else6
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX512VLDQ-NEXT:  LBB15_10: ## %else8
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store9
; AVX512VLDQ-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX512VLDQ-NEXT:  LBB15_12: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store11
; AVX512VLDQ-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX512VLDQ-NEXT:  LBB15_14: ## %else12
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX512VLDQ-NEXT:  LBB15_16: ## %else14
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_18
; AVX512VLDQ-NEXT:  ## %bb.17: ## %cond.store15
; AVX512VLDQ-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX512VLDQ-NEXT:  LBB15_18: ## %else16
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_20
; AVX512VLDQ-NEXT:  ## %bb.19: ## %cond.store17
; AVX512VLDQ-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX512VLDQ-NEXT:  LBB15_20: ## %else18
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_22
; AVX512VLDQ-NEXT:  ## %bb.21: ## %cond.store19
; AVX512VLDQ-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX512VLDQ-NEXT:  LBB15_22: ## %else20
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_24
; AVX512VLDQ-NEXT:  ## %bb.23: ## %cond.store21
; AVX512VLDQ-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX512VLDQ-NEXT:  LBB15_24: ## %else22
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_26
; AVX512VLDQ-NEXT:  ## %bb.25: ## %cond.store23
; AVX512VLDQ-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX512VLDQ-NEXT:  LBB15_26: ## %else24
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_28
; AVX512VLDQ-NEXT:  ## %bb.27: ## %cond.store25
; AVX512VLDQ-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX512VLDQ-NEXT:  LBB15_28: ## %else26
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_30
; AVX512VLDQ-NEXT:  ## %bb.29: ## %cond.store27
; AVX512VLDQ-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX512VLDQ-NEXT:  LBB15_30: ## %else28
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB15_32
; AVX512VLDQ-NEXT:  ## %bb.31: ## %cond.store29
; AVX512VLDQ-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX512VLDQ-NEXT:  LBB15_32: ## %else30
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v16i8_v16i8:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmb %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %xmm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <16 x i8> %trigger, zeroinitializer
  call void @llvm.masked.store.v16i8.p0v16i8(<16 x i8> %val, <16 x i8>* %addr, i32 4, <16 x i1> %mask)
  ret void
}

define void @store_v32i8_v32i8(<32 x i8> %trigger, <32 x i8>* %addr, <32 x i8> %val) {
; SSE2-LABEL: store_v32i8_v32i8:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    movd %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    je LBB16_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:  LBB16_2: ## %else
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movb %ah, 1(%rdi)
; SSE2-NEXT:  LBB16_4: ## %else2
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    movd %xmm4, %ecx
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    je LBB16_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:  LBB16_6: ## %else4
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, 3(%rdi)
; SSE2-NEXT:  LBB16_8: ## %else6
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    pextrw $2, %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    je LBB16_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store7
; SSE2-NEXT:    movb %al, 4(%rdi)
; SSE2-NEXT:  LBB16_10: ## %else8
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store9
; SSE2-NEXT:    movb %ah, 5(%rdi)
; SSE2-NEXT:  LBB16_12: ## %else10
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    pextrw $3, %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    je LBB16_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store11
; SSE2-NEXT:    movb %al, 6(%rdi)
; SSE2-NEXT:  LBB16_14: ## %else12
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store13
; SSE2-NEXT:    movb %ah, 7(%rdi)
; SSE2-NEXT:  LBB16_16: ## %else14
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    pextrw $4, %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    je LBB16_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store15
; SSE2-NEXT:    movb %al, 8(%rdi)
; SSE2-NEXT:  LBB16_18: ## %else16
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store17
; SSE2-NEXT:    movb %ah, 9(%rdi)
; SSE2-NEXT:  LBB16_20: ## %else18
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    pextrw $5, %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    je LBB16_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store19
; SSE2-NEXT:    movb %al, 10(%rdi)
; SSE2-NEXT:  LBB16_22: ## %else20
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store21
; SSE2-NEXT:    movb %ah, 11(%rdi)
; SSE2-NEXT:  LBB16_24: ## %else22
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE2-NEXT:    pextrw $6, %xmm4, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    je LBB16_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store23
; SSE2-NEXT:    movb %al, 12(%rdi)
; SSE2-NEXT:  LBB16_26: ## %else24
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store25
; SSE2-NEXT:    movb %ah, 13(%rdi)
; SSE2-NEXT:  LBB16_28: ## %else26
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqb %xmm4, %xmm0
; SSE2-NEXT:    pextrw $7, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    je LBB16_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store27
; SSE2-NEXT:    movb %al, 14(%rdi)
; SSE2-NEXT:  LBB16_30: ## %else28
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store29
; SSE2-NEXT:    movb %ah, 15(%rdi)
; SSE2-NEXT:  LBB16_32: ## %else30
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm3, %eax
; SSE2-NEXT:    je LBB16_34
; SSE2-NEXT:  ## %bb.33: ## %cond.store31
; SSE2-NEXT:    movb %al, 16(%rdi)
; SSE2-NEXT:  LBB16_34: ## %else32
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_36
; SSE2-NEXT:  ## %bb.35: ## %cond.store33
; SSE2-NEXT:    movb %ah, 17(%rdi)
; SSE2-NEXT:  LBB16_36: ## %else34
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    je LBB16_38
; SSE2-NEXT:  ## %bb.37: ## %cond.store35
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 18(%rdi)
; SSE2-NEXT:  LBB16_38: ## %else36
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_40
; SSE2-NEXT:  ## %bb.39: ## %cond.store37
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, 19(%rdi)
; SSE2-NEXT:  LBB16_40: ## %else38
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $2, %xmm3, %eax
; SSE2-NEXT:    je LBB16_42
; SSE2-NEXT:  ## %bb.41: ## %cond.store39
; SSE2-NEXT:    movb %al, 20(%rdi)
; SSE2-NEXT:  LBB16_42: ## %else40
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_44
; SSE2-NEXT:  ## %bb.43: ## %cond.store41
; SSE2-NEXT:    movb %ah, 21(%rdi)
; SSE2-NEXT:  LBB16_44: ## %else42
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pextrw $3, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $3, %xmm3, %eax
; SSE2-NEXT:    je LBB16_46
; SSE2-NEXT:  ## %bb.45: ## %cond.store43
; SSE2-NEXT:    movb %al, 22(%rdi)
; SSE2-NEXT:  LBB16_46: ## %else44
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_48
; SSE2-NEXT:  ## %bb.47: ## %cond.store45
; SSE2-NEXT:    movb %ah, 23(%rdi)
; SSE2-NEXT:  LBB16_48: ## %else46
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $4, %xmm3, %eax
; SSE2-NEXT:    je LBB16_50
; SSE2-NEXT:  ## %bb.49: ## %cond.store47
; SSE2-NEXT:    movb %al, 24(%rdi)
; SSE2-NEXT:  LBB16_50: ## %else48
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_52
; SSE2-NEXT:  ## %bb.51: ## %cond.store49
; SSE2-NEXT:    movb %ah, 25(%rdi)
; SSE2-NEXT:  LBB16_52: ## %else50
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pextrw $5, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $5, %xmm3, %eax
; SSE2-NEXT:    je LBB16_54
; SSE2-NEXT:  ## %bb.53: ## %cond.store51
; SSE2-NEXT:    movb %al, 26(%rdi)
; SSE2-NEXT:  LBB16_54: ## %else52
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_56
; SSE2-NEXT:  ## %bb.55: ## %cond.store53
; SSE2-NEXT:    movb %ah, 27(%rdi)
; SSE2-NEXT:  LBB16_56: ## %else54
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pextrw $6, %xmm0, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $6, %xmm3, %eax
; SSE2-NEXT:    je LBB16_58
; SSE2-NEXT:  ## %bb.57: ## %cond.store55
; SSE2-NEXT:    movb %al, 28(%rdi)
; SSE2-NEXT:  LBB16_58: ## %else56
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_60
; SSE2-NEXT:  ## %bb.59: ## %cond.store57
; SSE2-NEXT:    movb %ah, 29(%rdi)
; SSE2-NEXT:  LBB16_60: ## %else58
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pextrw $7, %xmm1, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $7, %xmm3, %eax
; SSE2-NEXT:    je LBB16_62
; SSE2-NEXT:  ## %bb.61: ## %cond.store59
; SSE2-NEXT:    movb %al, 30(%rdi)
; SSE2-NEXT:  LBB16_62: ## %else60
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB16_64
; SSE2-NEXT:  ## %bb.63: ## %cond.store61
; SSE2-NEXT:    movb %ah, 31(%rdi)
; SSE2-NEXT:  LBB16_64: ## %else62
; SSE2-NEXT:    retq
;
; SSE4-LABEL: store_v32i8_v32i8:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $0, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    pextrb $0, %xmm2, (%rdi)
; SSE4-NEXT:  LBB16_2: ## %else
; SSE4-NEXT:    pextrb $1, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm2, 1(%rdi)
; SSE4-NEXT:  LBB16_4: ## %else2
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $2, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm2, 2(%rdi)
; SSE4-NEXT:  LBB16_6: ## %else4
; SSE4-NEXT:    pextrb $3, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm2, 3(%rdi)
; SSE4-NEXT:  LBB16_8: ## %else6
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $4, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_10
; SSE4-NEXT:  ## %bb.9: ## %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm2, 4(%rdi)
; SSE4-NEXT:  LBB16_10: ## %else8
; SSE4-NEXT:    pextrb $5, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_12
; SSE4-NEXT:  ## %bb.11: ## %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm2, 5(%rdi)
; SSE4-NEXT:  LBB16_12: ## %else10
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $6, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_14
; SSE4-NEXT:  ## %bb.13: ## %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm2, 6(%rdi)
; SSE4-NEXT:  LBB16_14: ## %else12
; SSE4-NEXT:    pextrb $7, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_16
; SSE4-NEXT:  ## %bb.15: ## %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm2, 7(%rdi)
; SSE4-NEXT:  LBB16_16: ## %else14
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $8, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_18
; SSE4-NEXT:  ## %bb.17: ## %cond.store15
; SSE4-NEXT:    pextrb $8, %xmm2, 8(%rdi)
; SSE4-NEXT:  LBB16_18: ## %else16
; SSE4-NEXT:    pextrb $9, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_20
; SSE4-NEXT:  ## %bb.19: ## %cond.store17
; SSE4-NEXT:    pextrb $9, %xmm2, 9(%rdi)
; SSE4-NEXT:  LBB16_20: ## %else18
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $10, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_22
; SSE4-NEXT:  ## %bb.21: ## %cond.store19
; SSE4-NEXT:    pextrb $10, %xmm2, 10(%rdi)
; SSE4-NEXT:  LBB16_22: ## %else20
; SSE4-NEXT:    pextrb $11, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_24
; SSE4-NEXT:  ## %bb.23: ## %cond.store21
; SSE4-NEXT:    pextrb $11, %xmm2, 11(%rdi)
; SSE4-NEXT:  LBB16_24: ## %else22
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm4
; SSE4-NEXT:    pextrb $12, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_26
; SSE4-NEXT:  ## %bb.25: ## %cond.store23
; SSE4-NEXT:    pextrb $12, %xmm2, 12(%rdi)
; SSE4-NEXT:  LBB16_26: ## %else24
; SSE4-NEXT:    pextrb $13, %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_28
; SSE4-NEXT:  ## %bb.27: ## %cond.store25
; SSE4-NEXT:    pextrb $13, %xmm2, 13(%rdi)
; SSE4-NEXT:  LBB16_28: ## %else26
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    pcmpeqb %xmm4, %xmm0
; SSE4-NEXT:    pextrb $14, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_30
; SSE4-NEXT:  ## %bb.29: ## %cond.store27
; SSE4-NEXT:    pextrb $14, %xmm2, 14(%rdi)
; SSE4-NEXT:  LBB16_30: ## %else28
; SSE4-NEXT:    pextrb $15, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_32
; SSE4-NEXT:  ## %bb.31: ## %cond.store29
; SSE4-NEXT:    pextrb $15, %xmm2, 15(%rdi)
; SSE4-NEXT:  LBB16_32: ## %else30
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $0, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_34
; SSE4-NEXT:  ## %bb.33: ## %cond.store31
; SSE4-NEXT:    pextrb $0, %xmm3, 16(%rdi)
; SSE4-NEXT:  LBB16_34: ## %else32
; SSE4-NEXT:    pextrb $1, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_36
; SSE4-NEXT:  ## %bb.35: ## %cond.store33
; SSE4-NEXT:    pextrb $1, %xmm3, 17(%rdi)
; SSE4-NEXT:  LBB16_36: ## %else34
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $2, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_38
; SSE4-NEXT:  ## %bb.37: ## %cond.store35
; SSE4-NEXT:    pextrb $2, %xmm3, 18(%rdi)
; SSE4-NEXT:  LBB16_38: ## %else36
; SSE4-NEXT:    pextrb $3, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_40
; SSE4-NEXT:  ## %bb.39: ## %cond.store37
; SSE4-NEXT:    pextrb $3, %xmm3, 19(%rdi)
; SSE4-NEXT:  LBB16_40: ## %else38
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $4, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_42
; SSE4-NEXT:  ## %bb.41: ## %cond.store39
; SSE4-NEXT:    pextrb $4, %xmm3, 20(%rdi)
; SSE4-NEXT:  LBB16_42: ## %else40
; SSE4-NEXT:    pextrb $5, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_44
; SSE4-NEXT:  ## %bb.43: ## %cond.store41
; SSE4-NEXT:    pextrb $5, %xmm3, 21(%rdi)
; SSE4-NEXT:  LBB16_44: ## %else42
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $6, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_46
; SSE4-NEXT:  ## %bb.45: ## %cond.store43
; SSE4-NEXT:    pextrb $6, %xmm3, 22(%rdi)
; SSE4-NEXT:  LBB16_46: ## %else44
; SSE4-NEXT:    pextrb $7, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_48
; SSE4-NEXT:  ## %bb.47: ## %cond.store45
; SSE4-NEXT:    pextrb $7, %xmm3, 23(%rdi)
; SSE4-NEXT:  LBB16_48: ## %else46
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $8, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_50
; SSE4-NEXT:  ## %bb.49: ## %cond.store47
; SSE4-NEXT:    pextrb $8, %xmm3, 24(%rdi)
; SSE4-NEXT:  LBB16_50: ## %else48
; SSE4-NEXT:    pextrb $9, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_52
; SSE4-NEXT:  ## %bb.51: ## %cond.store49
; SSE4-NEXT:    pextrb $9, %xmm3, 25(%rdi)
; SSE4-NEXT:  LBB16_52: ## %else50
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $10, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_54
; SSE4-NEXT:  ## %bb.53: ## %cond.store51
; SSE4-NEXT:    pextrb $10, %xmm3, 26(%rdi)
; SSE4-NEXT:  LBB16_54: ## %else52
; SSE4-NEXT:    pextrb $11, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_56
; SSE4-NEXT:  ## %bb.55: ## %cond.store53
; SSE4-NEXT:    pextrb $11, %xmm3, 27(%rdi)
; SSE4-NEXT:  LBB16_56: ## %else54
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE4-NEXT:    pextrb $12, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_58
; SSE4-NEXT:  ## %bb.57: ## %cond.store55
; SSE4-NEXT:    pextrb $12, %xmm3, 28(%rdi)
; SSE4-NEXT:  LBB16_58: ## %else56
; SSE4-NEXT:    pextrb $13, %xmm0, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_60
; SSE4-NEXT:  ## %bb.59: ## %cond.store57
; SSE4-NEXT:    pextrb $13, %xmm3, 29(%rdi)
; SSE4-NEXT:  LBB16_60: ## %else58
; SSE4-NEXT:    pxor %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE4-NEXT:    pextrb $14, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_62
; SSE4-NEXT:  ## %bb.61: ## %cond.store59
; SSE4-NEXT:    pextrb $14, %xmm3, 30(%rdi)
; SSE4-NEXT:  LBB16_62: ## %else60
; SSE4-NEXT:    pextrb $15, %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB16_64
; SSE4-NEXT:  ## %bb.63: ## %cond.store61
; SSE4-NEXT:    pextrb $15, %xmm3, 31(%rdi)
; SSE4-NEXT:  LBB16_64: ## %else62
; SSE4-NEXT:    retq
;
; AVX1-LABEL: store_v32i8_v32i8:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX1-NEXT:  LBB16_2: ## %else
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $1, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX1-NEXT:  LBB16_4: ## %else2
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $2, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_6
; AVX1-NEXT:  ## %bb.5: ## %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX1-NEXT:  LBB16_6: ## %else4
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $3, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_8
; AVX1-NEXT:  ## %bb.7: ## %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX1-NEXT:  LBB16_8: ## %else6
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $4, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_10
; AVX1-NEXT:  ## %bb.9: ## %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX1-NEXT:  LBB16_10: ## %else8
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $5, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_12
; AVX1-NEXT:  ## %bb.11: ## %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX1-NEXT:  LBB16_12: ## %else10
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $6, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_14
; AVX1-NEXT:  ## %bb.13: ## %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX1-NEXT:  LBB16_14: ## %else12
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $7, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_16
; AVX1-NEXT:  ## %bb.15: ## %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX1-NEXT:  LBB16_16: ## %else14
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $8, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_18
; AVX1-NEXT:  ## %bb.17: ## %cond.store15
; AVX1-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX1-NEXT:  LBB16_18: ## %else16
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $9, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_20
; AVX1-NEXT:  ## %bb.19: ## %cond.store17
; AVX1-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX1-NEXT:  LBB16_20: ## %else18
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $10, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_22
; AVX1-NEXT:  ## %bb.21: ## %cond.store19
; AVX1-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX1-NEXT:  LBB16_22: ## %else20
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $11, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_24
; AVX1-NEXT:  ## %bb.23: ## %cond.store21
; AVX1-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX1-NEXT:  LBB16_24: ## %else22
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $12, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_26
; AVX1-NEXT:  ## %bb.25: ## %cond.store23
; AVX1-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX1-NEXT:  LBB16_26: ## %else24
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $13, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_28
; AVX1-NEXT:  ## %bb.27: ## %cond.store25
; AVX1-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX1-NEXT:  LBB16_28: ## %else26
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpextrb $14, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_30
; AVX1-NEXT:  ## %bb.29: ## %cond.store27
; AVX1-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX1-NEXT:  LBB16_30: ## %else28
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $15, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_32
; AVX1-NEXT:  ## %bb.31: ## %cond.store29
; AVX1-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX1-NEXT:  LBB16_32: ## %else30
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm0, %xmm2, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    je LBB16_34
; AVX1-NEXT:  ## %bb.33: ## %cond.store31
; AVX1-NEXT:    vpextrb $0, %xmm0, 16(%rdi)
; AVX1-NEXT:  LBB16_34: ## %else32
; AVX1-NEXT:    vpextrb $1, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_36
; AVX1-NEXT:  ## %bb.35: ## %cond.store33
; AVX1-NEXT:    vpextrb $1, %xmm0, 17(%rdi)
; AVX1-NEXT:  LBB16_36: ## %else34
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $2, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_38
; AVX1-NEXT:  ## %bb.37: ## %cond.store35
; AVX1-NEXT:    vpextrb $2, %xmm0, 18(%rdi)
; AVX1-NEXT:  LBB16_38: ## %else36
; AVX1-NEXT:    vpextrb $3, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_40
; AVX1-NEXT:  ## %bb.39: ## %cond.store37
; AVX1-NEXT:    vpextrb $3, %xmm0, 19(%rdi)
; AVX1-NEXT:  LBB16_40: ## %else38
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $4, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_42
; AVX1-NEXT:  ## %bb.41: ## %cond.store39
; AVX1-NEXT:    vpextrb $4, %xmm0, 20(%rdi)
; AVX1-NEXT:  LBB16_42: ## %else40
; AVX1-NEXT:    vpextrb $5, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_44
; AVX1-NEXT:  ## %bb.43: ## %cond.store41
; AVX1-NEXT:    vpextrb $5, %xmm0, 21(%rdi)
; AVX1-NEXT:  LBB16_44: ## %else42
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $6, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_46
; AVX1-NEXT:  ## %bb.45: ## %cond.store43
; AVX1-NEXT:    vpextrb $6, %xmm0, 22(%rdi)
; AVX1-NEXT:  LBB16_46: ## %else44
; AVX1-NEXT:    vpextrb $7, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_48
; AVX1-NEXT:  ## %bb.47: ## %cond.store45
; AVX1-NEXT:    vpextrb $7, %xmm0, 23(%rdi)
; AVX1-NEXT:  LBB16_48: ## %else46
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_50
; AVX1-NEXT:  ## %bb.49: ## %cond.store47
; AVX1-NEXT:    vpextrb $8, %xmm0, 24(%rdi)
; AVX1-NEXT:  LBB16_50: ## %else48
; AVX1-NEXT:    vpextrb $9, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_52
; AVX1-NEXT:  ## %bb.51: ## %cond.store49
; AVX1-NEXT:    vpextrb $9, %xmm0, 25(%rdi)
; AVX1-NEXT:  LBB16_52: ## %else50
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $10, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_54
; AVX1-NEXT:  ## %bb.53: ## %cond.store51
; AVX1-NEXT:    vpextrb $10, %xmm0, 26(%rdi)
; AVX1-NEXT:  LBB16_54: ## %else52
; AVX1-NEXT:    vpextrb $11, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_56
; AVX1-NEXT:  ## %bb.55: ## %cond.store53
; AVX1-NEXT:    vpextrb $11, %xmm0, 27(%rdi)
; AVX1-NEXT:  LBB16_56: ## %else54
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_58
; AVX1-NEXT:  ## %bb.57: ## %cond.store55
; AVX1-NEXT:    vpextrb $12, %xmm0, 28(%rdi)
; AVX1-NEXT:  LBB16_58: ## %else56
; AVX1-NEXT:    vpextrb $13, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_60
; AVX1-NEXT:  ## %bb.59: ## %cond.store57
; AVX1-NEXT:    vpextrb $13, %xmm0, 29(%rdi)
; AVX1-NEXT:  LBB16_60: ## %else58
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_62
; AVX1-NEXT:  ## %bb.61: ## %cond.store59
; AVX1-NEXT:    vpextrb $14, %xmm0, 30(%rdi)
; AVX1-NEXT:  LBB16_62: ## %else60
; AVX1-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB16_64
; AVX1-NEXT:  ## %bb.63: ## %cond.store61
; AVX1-NEXT:    vpextrb $15, %xmm0, 31(%rdi)
; AVX1-NEXT:  LBB16_64: ## %else62
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_v32i8_v32i8:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX2-NEXT:  LBB16_2: ## %else
; AVX2-NEXT:    vpextrb $1, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX2-NEXT:  LBB16_4: ## %else2
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_6
; AVX2-NEXT:  ## %bb.5: ## %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX2-NEXT:  LBB16_6: ## %else4
; AVX2-NEXT:    vpextrb $3, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_8
; AVX2-NEXT:  ## %bb.7: ## %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX2-NEXT:  LBB16_8: ## %else6
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_10
; AVX2-NEXT:  ## %bb.9: ## %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX2-NEXT:  LBB16_10: ## %else8
; AVX2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_12
; AVX2-NEXT:  ## %bb.11: ## %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX2-NEXT:  LBB16_12: ## %else10
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_14
; AVX2-NEXT:  ## %bb.13: ## %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX2-NEXT:  LBB16_14: ## %else12
; AVX2-NEXT:    vpextrb $7, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_16
; AVX2-NEXT:  ## %bb.15: ## %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX2-NEXT:  LBB16_16: ## %else14
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_18
; AVX2-NEXT:  ## %bb.17: ## %cond.store15
; AVX2-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX2-NEXT:  LBB16_18: ## %else16
; AVX2-NEXT:    vpextrb $9, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_20
; AVX2-NEXT:  ## %bb.19: ## %cond.store17
; AVX2-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX2-NEXT:  LBB16_20: ## %else18
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_22
; AVX2-NEXT:  ## %bb.21: ## %cond.store19
; AVX2-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX2-NEXT:  LBB16_22: ## %else20
; AVX2-NEXT:    vpextrb $11, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_24
; AVX2-NEXT:  ## %bb.23: ## %cond.store21
; AVX2-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX2-NEXT:  LBB16_24: ## %else22
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_26
; AVX2-NEXT:  ## %bb.25: ## %cond.store23
; AVX2-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX2-NEXT:  LBB16_26: ## %else24
; AVX2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_28
; AVX2-NEXT:  ## %bb.27: ## %cond.store25
; AVX2-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX2-NEXT:  LBB16_28: ## %else26
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_30
; AVX2-NEXT:  ## %bb.29: ## %cond.store27
; AVX2-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX2-NEXT:  LBB16_30: ## %else28
; AVX2-NEXT:    vpextrb $15, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_32
; AVX2-NEXT:  ## %bb.31: ## %cond.store29
; AVX2-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX2-NEXT:  LBB16_32: ## %else30
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    je LBB16_34
; AVX2-NEXT:  ## %bb.33: ## %cond.store31
; AVX2-NEXT:    vpextrb $0, %xmm1, 16(%rdi)
; AVX2-NEXT:  LBB16_34: ## %else32
; AVX2-NEXT:    vpextrb $1, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_36
; AVX2-NEXT:  ## %bb.35: ## %cond.store33
; AVX2-NEXT:    vpextrb $1, %xmm1, 17(%rdi)
; AVX2-NEXT:  LBB16_36: ## %else34
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_38
; AVX2-NEXT:  ## %bb.37: ## %cond.store35
; AVX2-NEXT:    vpextrb $2, %xmm1, 18(%rdi)
; AVX2-NEXT:  LBB16_38: ## %else36
; AVX2-NEXT:    vpextrb $3, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_40
; AVX2-NEXT:  ## %bb.39: ## %cond.store37
; AVX2-NEXT:    vpextrb $3, %xmm1, 19(%rdi)
; AVX2-NEXT:  LBB16_40: ## %else38
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_42
; AVX2-NEXT:  ## %bb.41: ## %cond.store39
; AVX2-NEXT:    vpextrb $4, %xmm1, 20(%rdi)
; AVX2-NEXT:  LBB16_42: ## %else40
; AVX2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_44
; AVX2-NEXT:  ## %bb.43: ## %cond.store41
; AVX2-NEXT:    vpextrb $5, %xmm1, 21(%rdi)
; AVX2-NEXT:  LBB16_44: ## %else42
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_46
; AVX2-NEXT:  ## %bb.45: ## %cond.store43
; AVX2-NEXT:    vpextrb $6, %xmm1, 22(%rdi)
; AVX2-NEXT:  LBB16_46: ## %else44
; AVX2-NEXT:    vpextrb $7, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_48
; AVX2-NEXT:  ## %bb.47: ## %cond.store45
; AVX2-NEXT:    vpextrb $7, %xmm1, 23(%rdi)
; AVX2-NEXT:  LBB16_48: ## %else46
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_50
; AVX2-NEXT:  ## %bb.49: ## %cond.store47
; AVX2-NEXT:    vpextrb $8, %xmm1, 24(%rdi)
; AVX2-NEXT:  LBB16_50: ## %else48
; AVX2-NEXT:    vpextrb $9, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_52
; AVX2-NEXT:  ## %bb.51: ## %cond.store49
; AVX2-NEXT:    vpextrb $9, %xmm1, 25(%rdi)
; AVX2-NEXT:  LBB16_52: ## %else50
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_54
; AVX2-NEXT:  ## %bb.53: ## %cond.store51
; AVX2-NEXT:    vpextrb $10, %xmm1, 26(%rdi)
; AVX2-NEXT:  LBB16_54: ## %else52
; AVX2-NEXT:    vpextrb $11, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_56
; AVX2-NEXT:  ## %bb.55: ## %cond.store53
; AVX2-NEXT:    vpextrb $11, %xmm1, 27(%rdi)
; AVX2-NEXT:  LBB16_56: ## %else54
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_58
; AVX2-NEXT:  ## %bb.57: ## %cond.store55
; AVX2-NEXT:    vpextrb $12, %xmm1, 28(%rdi)
; AVX2-NEXT:  LBB16_58: ## %else56
; AVX2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_60
; AVX2-NEXT:  ## %bb.59: ## %cond.store57
; AVX2-NEXT:    vpextrb $13, %xmm1, 29(%rdi)
; AVX2-NEXT:  LBB16_60: ## %else58
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpextrb $14, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_62
; AVX2-NEXT:  ## %bb.61: ## %cond.store59
; AVX2-NEXT:    vpextrb $14, %xmm1, 30(%rdi)
; AVX2-NEXT:  LBB16_62: ## %else60
; AVX2-NEXT:    vpextrb $15, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB16_64
; AVX2-NEXT:  ## %bb.63: ## %cond.store61
; AVX2-NEXT:    vpextrb $15, %xmm1, 31(%rdi)
; AVX2-NEXT:  LBB16_64: ## %else62
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_v32i8_v32i8:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX512F-NEXT:  LBB16_2: ## %else
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX512F-NEXT:  LBB16_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX512F-NEXT:  LBB16_6: ## %else4
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX512F-NEXT:  LBB16_8: ## %else6
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX512F-NEXT:  LBB16_10: ## %else8
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX512F-NEXT:  LBB16_12: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX512F-NEXT:  LBB16_14: ## %else12
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX512F-NEXT:  LBB16_16: ## %else14
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_18
; AVX512F-NEXT:  ## %bb.17: ## %cond.store15
; AVX512F-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX512F-NEXT:  LBB16_18: ## %else16
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_20
; AVX512F-NEXT:  ## %bb.19: ## %cond.store17
; AVX512F-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX512F-NEXT:  LBB16_20: ## %else18
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_22
; AVX512F-NEXT:  ## %bb.21: ## %cond.store19
; AVX512F-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX512F-NEXT:  LBB16_22: ## %else20
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_24
; AVX512F-NEXT:  ## %bb.23: ## %cond.store21
; AVX512F-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX512F-NEXT:  LBB16_24: ## %else22
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_26
; AVX512F-NEXT:  ## %bb.25: ## %cond.store23
; AVX512F-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX512F-NEXT:  LBB16_26: ## %else24
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_28
; AVX512F-NEXT:  ## %bb.27: ## %cond.store25
; AVX512F-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX512F-NEXT:  LBB16_28: ## %else26
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512F-NEXT:    vptestmd %zmm3, %zmm3, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_30
; AVX512F-NEXT:  ## %bb.29: ## %cond.store27
; AVX512F-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX512F-NEXT:  LBB16_30: ## %else28
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_32
; AVX512F-NEXT:  ## %bb.31: ## %cond.store29
; AVX512F-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX512F-NEXT:  LBB16_32: ## %else30
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    je LBB16_34
; AVX512F-NEXT:  ## %bb.33: ## %cond.store31
; AVX512F-NEXT:    vpextrb $0, %xmm1, 16(%rdi)
; AVX512F-NEXT:  LBB16_34: ## %else32
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_36
; AVX512F-NEXT:  ## %bb.35: ## %cond.store33
; AVX512F-NEXT:    vpextrb $1, %xmm1, 17(%rdi)
; AVX512F-NEXT:  LBB16_36: ## %else34
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_38
; AVX512F-NEXT:  ## %bb.37: ## %cond.store35
; AVX512F-NEXT:    vpextrb $2, %xmm1, 18(%rdi)
; AVX512F-NEXT:  LBB16_38: ## %else36
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_40
; AVX512F-NEXT:  ## %bb.39: ## %cond.store37
; AVX512F-NEXT:    vpextrb $3, %xmm1, 19(%rdi)
; AVX512F-NEXT:  LBB16_40: ## %else38
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_42
; AVX512F-NEXT:  ## %bb.41: ## %cond.store39
; AVX512F-NEXT:    vpextrb $4, %xmm1, 20(%rdi)
; AVX512F-NEXT:  LBB16_42: ## %else40
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_44
; AVX512F-NEXT:  ## %bb.43: ## %cond.store41
; AVX512F-NEXT:    vpextrb $5, %xmm1, 21(%rdi)
; AVX512F-NEXT:  LBB16_44: ## %else42
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_46
; AVX512F-NEXT:  ## %bb.45: ## %cond.store43
; AVX512F-NEXT:    vpextrb $6, %xmm1, 22(%rdi)
; AVX512F-NEXT:  LBB16_46: ## %else44
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_48
; AVX512F-NEXT:  ## %bb.47: ## %cond.store45
; AVX512F-NEXT:    vpextrb $7, %xmm1, 23(%rdi)
; AVX512F-NEXT:  LBB16_48: ## %else46
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_50
; AVX512F-NEXT:  ## %bb.49: ## %cond.store47
; AVX512F-NEXT:    vpextrb $8, %xmm1, 24(%rdi)
; AVX512F-NEXT:  LBB16_50: ## %else48
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_52
; AVX512F-NEXT:  ## %bb.51: ## %cond.store49
; AVX512F-NEXT:    vpextrb $9, %xmm1, 25(%rdi)
; AVX512F-NEXT:  LBB16_52: ## %else50
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_54
; AVX512F-NEXT:  ## %bb.53: ## %cond.store51
; AVX512F-NEXT:    vpextrb $10, %xmm1, 26(%rdi)
; AVX512F-NEXT:  LBB16_54: ## %else52
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_56
; AVX512F-NEXT:  ## %bb.55: ## %cond.store53
; AVX512F-NEXT:    vpextrb $11, %xmm1, 27(%rdi)
; AVX512F-NEXT:  LBB16_56: ## %else54
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_58
; AVX512F-NEXT:  ## %bb.57: ## %cond.store55
; AVX512F-NEXT:    vpextrb $12, %xmm1, 28(%rdi)
; AVX512F-NEXT:  LBB16_58: ## %else56
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_60
; AVX512F-NEXT:  ## %bb.59: ## %cond.store57
; AVX512F-NEXT:    vpextrb $13, %xmm1, 29(%rdi)
; AVX512F-NEXT:  LBB16_60: ## %else58
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_62
; AVX512F-NEXT:  ## %bb.61: ## %cond.store59
; AVX512F-NEXT:    vpextrb $14, %xmm1, 30(%rdi)
; AVX512F-NEXT:  LBB16_62: ## %else60
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB16_64
; AVX512F-NEXT:  ## %bb.63: ## %cond.store61
; AVX512F-NEXT:    vpextrb $15, %xmm1, 31(%rdi)
; AVX512F-NEXT:  LBB16_64: ## %else62
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: store_v32i8_v32i8:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrb $0, %xmm1, (%rdi)
; AVX512VLDQ-NEXT:  LBB16_2: ## %else
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrb $1, %xmm1, 1(%rdi)
; AVX512VLDQ-NEXT:  LBB16_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store3
; AVX512VLDQ-NEXT:    vpextrb $2, %xmm1, 2(%rdi)
; AVX512VLDQ-NEXT:  LBB16_6: ## %else4
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store5
; AVX512VLDQ-NEXT:    vpextrb $3, %xmm1, 3(%rdi)
; AVX512VLDQ-NEXT:  LBB16_8: ## %else6
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrb $4, %xmm1, 4(%rdi)
; AVX512VLDQ-NEXT:  LBB16_10: ## %else8
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store9
; AVX512VLDQ-NEXT:    vpextrb $5, %xmm1, 5(%rdi)
; AVX512VLDQ-NEXT:  LBB16_12: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store11
; AVX512VLDQ-NEXT:    vpextrb $6, %xmm1, 6(%rdi)
; AVX512VLDQ-NEXT:  LBB16_14: ## %else12
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrb $7, %xmm1, 7(%rdi)
; AVX512VLDQ-NEXT:  LBB16_16: ## %else14
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_18
; AVX512VLDQ-NEXT:  ## %bb.17: ## %cond.store15
; AVX512VLDQ-NEXT:    vpextrb $8, %xmm1, 8(%rdi)
; AVX512VLDQ-NEXT:  LBB16_18: ## %else16
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_20
; AVX512VLDQ-NEXT:  ## %bb.19: ## %cond.store17
; AVX512VLDQ-NEXT:    vpextrb $9, %xmm1, 9(%rdi)
; AVX512VLDQ-NEXT:  LBB16_20: ## %else18
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_22
; AVX512VLDQ-NEXT:  ## %bb.21: ## %cond.store19
; AVX512VLDQ-NEXT:    vpextrb $10, %xmm1, 10(%rdi)
; AVX512VLDQ-NEXT:  LBB16_22: ## %else20
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_24
; AVX512VLDQ-NEXT:  ## %bb.23: ## %cond.store21
; AVX512VLDQ-NEXT:    vpextrb $11, %xmm1, 11(%rdi)
; AVX512VLDQ-NEXT:  LBB16_24: ## %else22
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_26
; AVX512VLDQ-NEXT:  ## %bb.25: ## %cond.store23
; AVX512VLDQ-NEXT:    vpextrb $12, %xmm1, 12(%rdi)
; AVX512VLDQ-NEXT:  LBB16_26: ## %else24
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_28
; AVX512VLDQ-NEXT:  ## %bb.27: ## %cond.store25
; AVX512VLDQ-NEXT:    vpextrb $13, %xmm1, 13(%rdi)
; AVX512VLDQ-NEXT:  LBB16_28: ## %else26
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm3
; AVX512VLDQ-NEXT:    vpmovd2m %zmm3, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_30
; AVX512VLDQ-NEXT:  ## %bb.29: ## %cond.store27
; AVX512VLDQ-NEXT:    vpextrb $14, %xmm1, 14(%rdi)
; AVX512VLDQ-NEXT:  LBB16_30: ## %else28
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_32
; AVX512VLDQ-NEXT:  ## %bb.31: ## %cond.store29
; AVX512VLDQ-NEXT:    vpextrb $15, %xmm1, 15(%rdi)
; AVX512VLDQ-NEXT:  LBB16_32: ## %else30
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512VLDQ-NEXT:    je LBB16_34
; AVX512VLDQ-NEXT:  ## %bb.33: ## %cond.store31
; AVX512VLDQ-NEXT:    vpextrb $0, %xmm1, 16(%rdi)
; AVX512VLDQ-NEXT:  LBB16_34: ## %else32
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_36
; AVX512VLDQ-NEXT:  ## %bb.35: ## %cond.store33
; AVX512VLDQ-NEXT:    vpextrb $1, %xmm1, 17(%rdi)
; AVX512VLDQ-NEXT:  LBB16_36: ## %else34
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_38
; AVX512VLDQ-NEXT:  ## %bb.37: ## %cond.store35
; AVX512VLDQ-NEXT:    vpextrb $2, %xmm1, 18(%rdi)
; AVX512VLDQ-NEXT:  LBB16_38: ## %else36
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_40
; AVX512VLDQ-NEXT:  ## %bb.39: ## %cond.store37
; AVX512VLDQ-NEXT:    vpextrb $3, %xmm1, 19(%rdi)
; AVX512VLDQ-NEXT:  LBB16_40: ## %else38
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_42
; AVX512VLDQ-NEXT:  ## %bb.41: ## %cond.store39
; AVX512VLDQ-NEXT:    vpextrb $4, %xmm1, 20(%rdi)
; AVX512VLDQ-NEXT:  LBB16_42: ## %else40
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_44
; AVX512VLDQ-NEXT:  ## %bb.43: ## %cond.store41
; AVX512VLDQ-NEXT:    vpextrb $5, %xmm1, 21(%rdi)
; AVX512VLDQ-NEXT:  LBB16_44: ## %else42
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_46
; AVX512VLDQ-NEXT:  ## %bb.45: ## %cond.store43
; AVX512VLDQ-NEXT:    vpextrb $6, %xmm1, 22(%rdi)
; AVX512VLDQ-NEXT:  LBB16_46: ## %else44
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_48
; AVX512VLDQ-NEXT:  ## %bb.47: ## %cond.store45
; AVX512VLDQ-NEXT:    vpextrb $7, %xmm1, 23(%rdi)
; AVX512VLDQ-NEXT:  LBB16_48: ## %else46
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_50
; AVX512VLDQ-NEXT:  ## %bb.49: ## %cond.store47
; AVX512VLDQ-NEXT:    vpextrb $8, %xmm1, 24(%rdi)
; AVX512VLDQ-NEXT:  LBB16_50: ## %else48
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_52
; AVX512VLDQ-NEXT:  ## %bb.51: ## %cond.store49
; AVX512VLDQ-NEXT:    vpextrb $9, %xmm1, 25(%rdi)
; AVX512VLDQ-NEXT:  LBB16_52: ## %else50
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_54
; AVX512VLDQ-NEXT:  ## %bb.53: ## %cond.store51
; AVX512VLDQ-NEXT:    vpextrb $10, %xmm1, 26(%rdi)
; AVX512VLDQ-NEXT:  LBB16_54: ## %else52
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_56
; AVX512VLDQ-NEXT:  ## %bb.55: ## %cond.store53
; AVX512VLDQ-NEXT:    vpextrb $11, %xmm1, 27(%rdi)
; AVX512VLDQ-NEXT:  LBB16_56: ## %else54
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_58
; AVX512VLDQ-NEXT:  ## %bb.57: ## %cond.store55
; AVX512VLDQ-NEXT:    vpextrb $12, %xmm1, 28(%rdi)
; AVX512VLDQ-NEXT:  LBB16_58: ## %else56
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_60
; AVX512VLDQ-NEXT:  ## %bb.59: ## %cond.store57
; AVX512VLDQ-NEXT:    vpextrb $13, %xmm1, 29(%rdi)
; AVX512VLDQ-NEXT:  LBB16_60: ## %else58
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX512VLDQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_62
; AVX512VLDQ-NEXT:  ## %bb.61: ## %cond.store59
; AVX512VLDQ-NEXT:    vpextrb $14, %xmm1, 30(%rdi)
; AVX512VLDQ-NEXT:  LBB16_62: ## %else60
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB16_64
; AVX512VLDQ-NEXT:  ## %bb.63: ## %cond.store61
; AVX512VLDQ-NEXT:    vpextrb $15, %xmm1, 31(%rdi)
; AVX512VLDQ-NEXT:  LBB16_64: ## %else62
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: store_v32i8_v32i8:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmb %ymm0, %ymm0, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %ymm1, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <32 x i8> %trigger, zeroinitializer
  call void @llvm.masked.store.v32i8.p0v32i8(<32 x i8> %val, <32 x i8>* %addr, i32 4, <32 x i1> %mask)
  ret void
}

;;; Stores with Constant Masks

define void @mstore_constmask_v4i32_v4i32(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %val) {
; SSE-LABEL: mstore_constmask_v4i32_v4i32:
; SSE:       ## %bb.0:
; SSE-NEXT:    movups %xmm1, (%rdi)
; SSE-NEXT:    retq
;
; AVX1-LABEL: mstore_constmask_v4i32_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps %xmm1, %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mstore_constmask_v4i32_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd %xmm1, %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mstore_constmask_v4i32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    movw $15, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm1, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mstore_constmask_v4i32_v4i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    kxnorw %k0, %k0, %k1
; AVX512VL-NEXT:    vmovdqu32 %xmm1, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  call void @llvm.masked.store.v4i32.p0v4i32(<4 x i32> %val, <4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 true, i1 true, i1 true>)
  ret void
}

;  When only one element of the mask is set, reduce to a scalar store.

define void @one_mask_bit_set1(<4 x i32>* %addr, <4 x i32> %val) {
; SSE-LABEL: one_mask_bit_set1:
; SSE:       ## %bb.0:
; SSE-NEXT:    movss %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: one_mask_bit_set1:
; AVX:       ## %bb.0:
; AVX-NEXT:    vmovss %xmm0, (%rdi)
; AVX-NEXT:    retq
  call void @llvm.masked.store.v4i32.p0v4i32(<4 x i32> %val, <4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 false, i1 false, i1 false>)
  ret void
}

; Choose a different element to show that the correct address offset is produced.

define void @one_mask_bit_set2(<4 x float>* %addr, <4 x float> %val) {
; SSE2-LABEL: one_mask_bit_set2:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; SSE2-NEXT:    movss %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: one_mask_bit_set2:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    extractps $2, %xmm0, 8(%rdi)
; SSE4-NEXT:    retq
;
; AVX-LABEL: one_mask_bit_set2:
; AVX:       ## %bb.0:
; AVX-NEXT:    vextractps $2, %xmm0, 8(%rdi)
; AVX-NEXT:    retq
  call void @llvm.masked.store.v4f32.p0v4f32(<4 x float> %val, <4 x float>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>)
  ret void
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define void @one_mask_bit_set3(<4 x i64>* %addr, <4 x i64> %val) {
; SSE-LABEL: one_mask_bit_set3:
; SSE:       ## %bb.0:
; SSE-NEXT:    movlps %xmm1, 16(%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: one_mask_bit_set3:
; AVX:       ## %bb.0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vmovlps %xmm0, 16(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  call void @llvm.masked.store.v4i64.p0v4i64(<4 x i64> %val, <4 x i64>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>)
  ret void
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define void @one_mask_bit_set4(<4 x double>* %addr, <4 x double> %val) {
; SSE-LABEL: one_mask_bit_set4:
; SSE:       ## %bb.0:
; SSE-NEXT:    movhpd %xmm1, 24(%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: one_mask_bit_set4:
; AVX:       ## %bb.0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX-NEXT:    vmovhpd %xmm0, 24(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  call void @llvm.masked.store.v4f64.p0v4f64(<4 x double> %val, <4 x double>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 false, i1 true>)
  ret void
}

; Try a 512-bit vector to make sure AVX doesn't die and AVX512 works as expected.

define void @one_mask_bit_set5(<8 x double>* %addr, <8 x double> %val) {
; SSE-LABEL: one_mask_bit_set5:
; SSE:       ## %bb.0:
; SSE-NEXT:    movlps %xmm3, 48(%rdi)
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: one_mask_bit_set5:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1OR2-NEXT:    vmovlps %xmm0, 48(%rdi)
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: one_mask_bit_set5:
; AVX512:       ## %bb.0:
; AVX512-NEXT:    vextractf32x4 $3, %zmm0, %xmm0
; AVX512-NEXT:    vmovlps %xmm0, 48(%rdi)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  call void @llvm.masked.store.v8f64.p0v8f64(<8 x double> %val, <8 x double>* %addr, i32 4, <8 x i1><i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true, i1 false>)
  ret void
}

; SimplifyDemandedBits eliminates an ashr here.

define void @masked_store_bool_mask_demand_trunc_sext(<4 x double> %x, <4 x double>* %p, <4 x i32> %masksrc) {
; SSE2-LABEL: masked_store_bool_mask_demand_trunc_sext:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB23_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movlpd %xmm0, (%rdi)
; SSE2-NEXT:  LBB23_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB23_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movhpd %xmm0, 8(%rdi)
; SSE2-NEXT:  LBB23_4: ## %else2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB23_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movlpd %xmm1, 16(%rdi)
; SSE2-NEXT:  LBB23_6: ## %else4
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB23_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    movhpd %xmm1, 24(%rdi)
; SSE2-NEXT:  LBB23_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: masked_store_bool_mask_demand_trunc_sext:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB23_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movlpd %xmm0, (%rdi)
; SSE4-NEXT:  LBB23_2: ## %else
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB23_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    movhpd %xmm0, 8(%rdi)
; SSE4-NEXT:  LBB23_4: ## %else2
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB23_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    movlpd %xmm1, 16(%rdi)
; SSE4-NEXT:  LBB23_6: ## %else4
; SSE4-NEXT:    pextrb $12, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB23_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    movhpd %xmm1, 24(%rdi)
; SSE4-NEXT:  LBB23_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1-LABEL: masked_store_bool_mask_demand_trunc_sext:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmaskmovpd %ymm0, %ymm1, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: masked_store_bool_mask_demand_trunc_sext:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vmaskmovpd %ymm0, %ymm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: masked_store_bool_mask_demand_trunc_sext:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovupd %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: masked_store_bool_mask_demand_trunc_sext:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovd2m %xmm1, %k1
; AVX512VLDQ-NEXT:    vmovupd %ymm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: masked_store_bool_mask_demand_trunc_sext:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vmovupd %ymm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  %sext = sext <4 x i32> %masksrc to <4 x i64>
  %boolmask = trunc <4 x i64> %sext to <4 x i1>
  call void @llvm.masked.store.v4f64.p0v4f64(<4 x double> %x, <4 x double>* %p, i32 4, <4 x i1> %boolmask)
  ret void
}

; PR26697

define void @one_mask_bit_set1_variable(<4 x float>* %addr, <4 x float> %val, <4 x i32> %mask) {
; SSE2-LABEL: one_mask_bit_set1_variable:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB24_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:  LBB24_2: ## %else
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB24_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm3, 4(%rdi)
; SSE2-NEXT:  LBB24_4: ## %else2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB24_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store3
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE2-NEXT:    movss %xmm2, 8(%rdi)
; SSE2-NEXT:  LBB24_6: ## %else4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB24_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store5
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 12(%rdi)
; SSE2-NEXT:  LBB24_8: ## %else6
; SSE2-NEXT:    retq
;
; SSE4-LABEL: one_mask_bit_set1_variable:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; SSE4-NEXT:    pand %xmm2, %xmm1
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE4-NEXT:    pextrb $0, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB24_2
; SSE4-NEXT:  ## %bb.1: ## %cond.store
; SSE4-NEXT:    movss %xmm0, (%rdi)
; SSE4-NEXT:  LBB24_2: ## %else
; SSE4-NEXT:    pxor %xmm3, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE4-NEXT:    pxor %xmm3, %xmm2
; SSE4-NEXT:    pextrb $4, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB24_4
; SSE4-NEXT:  ## %bb.3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm0, 4(%rdi)
; SSE4-NEXT:  LBB24_4: ## %else2
; SSE4-NEXT:    pextrb $8, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB24_6
; SSE4-NEXT:  ## %bb.5: ## %cond.store3
; SSE4-NEXT:    extractps $2, %xmm0, 8(%rdi)
; SSE4-NEXT:  LBB24_6: ## %else4
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE4-NEXT:    pxor %xmm1, %xmm2
; SSE4-NEXT:    pextrb $12, %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    je LBB24_8
; SSE4-NEXT:  ## %bb.7: ## %cond.store5
; SSE4-NEXT:    extractps $3, %xmm0, 12(%rdi)
; SSE4-NEXT:  LBB24_8: ## %else6
; SSE4-NEXT:    retq
;
; AVX1OR2-LABEL: one_mask_bit_set1_variable:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmaskmovps %xmm0, %xmm1, (%rdi)
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: one_mask_bit_set1_variable:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmd {{.*}}(%rip){1to16}, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovups %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: one_mask_bit_set1_variable:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestmd {{.*}}(%rip){1to4}, %xmm1, %k1
; AVX512VL-NEXT:    vmovups %xmm0, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask_signbit = and <4 x i32> %mask, <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147483648>
  %mask_bool = icmp ne <4 x i32> %mask_signbit, zeroinitializer
  call void @llvm.masked.store.v4f32.p0v4f32(<4 x float> %val, <4 x float>* %addr, i32 1, <4 x i1> %mask_bool)
  ret void
}

; This needs to be widened to v4i32.
; This used to assert in type legalization. PR38436
; FIXME: The codegen for AVX512 should use KSHIFT to zero the upper bits of the mask.
define void @widen_masked_store(<3 x i32> %v, <3 x i32>* %p, <3 x i1> %mask) {
; SSE2-LABEL: widen_masked_store:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    testb $1, %sil
; SSE2-NEXT:    jne LBB25_1
; SSE2-NEXT:  ## %bb.2: ## %else
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    jne LBB25_3
; SSE2-NEXT:  LBB25_4: ## %else2
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    jne LBB25_5
; SSE2-NEXT:  LBB25_6: ## %else4
; SSE2-NEXT:    retq
; SSE2-NEXT:  LBB25_1: ## %cond.store
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    je LBB25_4
; SSE2-NEXT:  LBB25_3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm1, 4(%rdi)
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB25_6
; SSE2-NEXT:  LBB25_5: ## %cond.store3
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: widen_masked_store:
; SSE4:       ## %bb.0:
; SSE4-NEXT:    testb $1, %sil
; SSE4-NEXT:    jne LBB25_1
; SSE4-NEXT:  ## %bb.2: ## %else
; SSE4-NEXT:    testb $1, %dl
; SSE4-NEXT:    jne LBB25_3
; SSE4-NEXT:  LBB25_4: ## %else2
; SSE4-NEXT:    testb $1, %cl
; SSE4-NEXT:    jne LBB25_5
; SSE4-NEXT:  LBB25_6: ## %else4
; SSE4-NEXT:    retq
; SSE4-NEXT:  LBB25_1: ## %cond.store
; SSE4-NEXT:    movss %xmm0, (%rdi)
; SSE4-NEXT:    testb $1, %dl
; SSE4-NEXT:    je LBB25_4
; SSE4-NEXT:  LBB25_3: ## %cond.store1
; SSE4-NEXT:    extractps $1, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $1, %cl
; SSE4-NEXT:    je LBB25_6
; SSE4-NEXT:  LBB25_5: ## %cond.store3
; SSE4-NEXT:    extractps $2, %xmm0, 8(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: widen_masked_store:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vmovd %edx, %xmm1
; AVX1-NEXT:    vmovd %esi, %xmm2
; AVX1-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX1-NEXT:    vmovd %ecx, %xmm2
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vmaskmovps %xmm0, %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: widen_masked_store:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vmovd %edx, %xmm1
; AVX2-NEXT:    vmovd %esi, %xmm2
; AVX2-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-NEXT:    vmovd %ecx, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX2-NEXT:    vpmaskmovd %xmm0, %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: widen_masked_store:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3]
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: widen_masked_store:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovd2m %xmm1, %k0
; AVX512VLDQ-NEXT:    vpmovm2d %k0, %xmm1
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3]
; AVX512VLDQ-NEXT:    vpmovd2m %xmm1, %k1
; AVX512VLDQ-NEXT:    vmovdqa32 %xmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: widen_masked_store:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vmovdqa32 %xmm1, %xmm1 {%k1} {z}
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3]
; AVX512VLBW-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %xmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.store.v3i32.p0v3i32(<3 x i32> %v, <3 x i32>* %p, i32 16, <3 x i1> %mask)
  ret void
}

define void @zero_mask(<2 x double>* %addr, <2 x double> %val) {
; SSE-LABEL: zero_mask:
; SSE:       ## %bb.0:
; SSE-NEXT:    retq
;
; AVX-LABEL: zero_mask:
; AVX:       ## %bb.0:
; AVX-NEXT:    retq
  call void @llvm.masked.store.v2f64.p0v2f64(<2 x double> %val, <2 x double>* %addr, i32 4, <2 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.store.v8f64.p0v8f64(<8 x double>, <8 x double>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4f64.p0v4f64(<4 x double>, <4 x double>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2f64.p0v2f64(<2 x double>, <2 x double>*, i32, <2 x i1>)
declare void @llvm.masked.store.v1f64.p0v1f64(<1 x double>, <1 x double>*, i32, <1 x i1>)

declare void @llvm.masked.store.v16f32.p0v16f32(<16 x float>, <16 x float>*, i32, <16 x i1>)
declare void @llvm.masked.store.v8f32.p0v8f32(<8 x float>, <8 x float>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4f32.p0v4f32(<4 x float>, <4 x float>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2f32.p0v2f32(<2 x float>, <2 x float>*, i32, <2 x i1>)

declare void @llvm.masked.store.v8i64.p0v8i64(<8 x i64>, <8 x i64>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4i64.p0v4i64(<4 x i64>, <4 x i64>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2i64.p0v2i64(<2 x i64>, <2 x i64>*, i32, <2 x i1>)
declare void @llvm.masked.store.v1i64.p0v1i64(<1 x i64>, <1 x i64>*, i32, <1 x i1>)

declare void @llvm.masked.store.v16i32.p0v16i32(<16 x i32>, <16 x i32>*, i32, <16 x i1>)
declare void @llvm.masked.store.v8i32.p0v8i32(<8 x i32>, <8 x i32>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4i32.p0v4i32(<4 x i32>, <4 x i32>*, i32, <4 x i1>)
declare void @llvm.masked.store.v3i32.p0v3i32(<3 x i32>, <3 x i32>*, i32, <3 x i1>)
declare void @llvm.masked.store.v2i32.p0v2i32(<2 x i32>, <2 x i32>*, i32, <2 x i1>)
declare void @llvm.masked.store.v1i32.p0v1i32(<1 x i32>, <1 x i32>*, i32, <1 x i1>)

declare void @llvm.masked.store.v32i16.p0v32i16(<32 x i16>, <32 x i16>*, i32, <32 x i1>)
declare void @llvm.masked.store.v16i16.p0v16i16(<16 x i16>, <16 x i16>*, i32, <16 x i1>)
declare void @llvm.masked.store.v8i16.p0v8i16(<8 x i16>, <8 x i16>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4i16.p0v4i16(<4 x i16>, <4 x i16>*, i32, <4 x i1>)

declare void @llvm.masked.store.v64i8.p0v64i8(<64 x i8>, <64 x i8>*, i32, <64 x i1>)
declare void @llvm.masked.store.v32i8.p0v32i8(<32 x i8>, <32 x i8>*, i32, <32 x i1>)
declare void @llvm.masked.store.v16i8.p0v16i8(<16 x i8>, <16 x i8>*, i32, <16 x i1>)
declare void @llvm.masked.store.v8i8.p0v8i8(<8 x i8>, <8 x i8>*, i32, <8 x i1>)
