// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.23 $
#ifndef KNODAMAINWINDOWBASE_H
#define KNODAMAINWINDOWBASE_H

#include <qvariant.h>
#include <qmainwindow.h>
#include <qpopupmenu.h>
#include <hk_classes.h>
#include <qwidget.h>
#include <qlistbox.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QLabel;
class hk_listbox;
class QListBoxItem;
class QPushButton;
class QRadioButton;
class KAction;
class KActionMenu;
class QPopupMenu;
class QProgressDialog;
class hk_kdeschemadialog;
class KMainWindow;
class KPopupMenu;
class hk_kdeform;
class hk_kdereport;
class hk_kdetable;
class hk_kdequery;

class knodamainwindowbase : public QWidget ,public hk_dsvisible
{
    Q_OBJECT

        public:
        knodamainwindowbase( KMainWindow* parent = 0,const char* name = 0, WFlags fl = 0,const QString& database="",const QString& form="" );
        virtual    ~knodamainwindowbase();
        void set_connection(hk_connection* c);
        hk_connection* connection(void) {return p_connection;}
        hk_listbox* itemslist;
        QLabel* TextLabel1;
        QLabel* TextLabel1_2;
        QLabel* databasename;
        QButtonGroup* ButtonGroup2;
        QRadioButton* querybutton;
        QRadioButton* reportbutton;
        QRadioButton* tablebutton;
        QRadioButton* viewbutton;
        QRadioButton* formbutton;
        QRadioButton* databasebutton;
        QButtonGroup* ButtonGroup3;
        QPushButton* newbutton;
        QPushButton* startbutton;
        QPushButton* alterbutton;
        QPushButton* deletebutton;
        QPopupMenu* popupmenu(void);

    public slots:
        virtual void alter_clicked();
        virtual void delete_clicked();
        virtual void function_select(int);
        virtual void function_select(void);
        virtual void itemslist_doubleclicked();
        virtual void new_clicked();
        virtual void start_clicked();
	virtual void rename_clicked();
        virtual void importcsv_clicked();
        virtual void exportcsv_clicked();
        virtual void exportxml_clicked();
        virtual void itemslist_clicked(QListBoxItem*);
        virtual void newpassworddialog_selected(void);
        virtual void copy_clicked(void);
        virtual void paste_clicked(void);
        virtual void clipboarddata_has_changed(void);
        virtual void databasesettings_clicked(void);
        virtual void objecthandler_clicked(void);
	virtual void slot_open_localdatabase(void);
	hk_database* database(){return p_database;}
virtual void show_exportdbdrivers();
virtual void show_importdbdrivers();
void exportdbdriver_selected(int);
void importdbdriver_selected(int);
void slot_store_connection();
    protected:
        QHBoxLayout* knodamainwindowbaseLayout;
        QGridLayout* Layout8;
        QVBoxLayout* Layout3;
        QVBoxLayout* ButtonGroup3Layout;
        QVBoxLayout* ButtonGroup2Layout;
        hk_connection* p_connection;
        hk_database* p_database;
        virtual void        list_changes(listtype type);
	bool eventFilter(QObject*,QEvent*);
    private:
 enum enum_function{f_exportdb,f_importdb};
 void show_drivers(KPopupMenu* menu, enum_function);
        void open_autoform();
        void set_buttons();
        void set_databasebuttons();
        void set_tablebuttons();
        void set_querybuttons();
        void set_formbuttons();
        void set_reportbuttons();
        void set_minimalbuttons();
        void set_normalbuttons();
	hk_kdeform* new_form(void);
	hk_kdereport* new_report(void);
	hk_kdetable* new_table(void);
	hk_kdequery* new_query(void);
	hk_kdequery* new_view(void);
        QString p_databasestring;
        QString p_sdatabasestring;
        QString p_tablestring;
        QString p_sviewstring;
	QString p_viewstring;
        QString p_querystring;
        QString p_formstring;
        QString p_reportstring;
        QString p_stablestring;
        QString p_squerystring;
        QString p_sformstring;
        QString p_sreportstring;
//    KAction* p_changepasswordaction;
        KAction* p_newaction;
        KAction* p_alteraction;
        KAction* p_startaction;
        KAction* p_deleteaction;
        KAction* p_copyaction;
        KAction* p_pasteaction;
	KAction* p_renameaction;
        KActionMenu* p_exportaction;
        KAction* p_exportcsvaction;
        KAction* p_exportxmlaction;
        KActionMenu* p_importaction;
        KAction* p_importcsvaction;
	KAction* p_databasesettingaction;
        KAction* p_objecthandleraction;
        KAction* p_passwordaction;
	KAction* p_openlocaldbaction;
KActionMenu* p_importdatabaseaction;
KActionMenu* p_exportdatabaseaction;
KAction* p_storeconnection;
        QPopupMenu* p_popup;
        QString p_selecteddb;
        QString p_selectedform;

        KMainWindow* p_parent;
};


class hk_listbox : public QListBox,public hk_class
{
    Q_OBJECT
        friend class knodamainwindowbase;
    public:
        hk_listbox(knodamainwindowbase* w);
        ~hk_listbox();
        bool cancel(void){return p_cancelcopying;}
        static  bool set_progress(long int,long int,const hk_string&);
    public slots:
        void copying_cancelled();
    protected:
        virtual void contextMenuEvent(QContextMenuEvent* );
        virtual void mouseReleaseEvent(QMouseEvent*);
        virtual void mouseMoveEvent(QMouseEvent*);
	//virtual void focusInEvent(QFocusEvent*);
        void dragEnterEvent(QDragEnterEvent*);
        void dropEvent(QDropEvent*);
        hk_string create_draginfo(void);
        bool decode_action(QMimeSource* event);
        bool execute_action(void);
        bool copy_presentationfile(void);
        bool copy_table(void);
        bool copy_view(void);
        bool copy_database(void);
        hk_connection* find_connection(void);
        hk_kdeschemadialog* p_schemadialog;
        QPopupMenu* p_popup;
        knodamainwindowbase* p_window;
        bool p_dragging;
        QPoint p_dragstartposition;
                                                  //decoded drag&dropvalues
        hk_string xname,xtype,xdirectory,xserver,xhost,xtcp,xuser,xdbname;
        objecttype ftype;
        objecttype actiontype;
        static QProgressDialog* p_progressdialog;
        static bool p_cancelcopying;

} ;

class hk_kdeschemadialog : public QDialog
{
    Q_OBJECT

        public:
        hk_kdeschemadialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~hk_kdeschemadialog();

        QButtonGroup* ButtonGroup1;
        QRadioButton* schemaonlyfield;
        QRadioButton* datafield;
        QPushButton* buttonOk;
        QPushButton* buttonCancel;

    protected:
        QHBoxLayout* hk_kdeschemadialogLayout;
        QVBoxLayout* ButtonGroup1Layout;
        QVBoxLayout* Layout2;
};
#endif                                            // knodamainwindowbase_H
