// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.15 $

#include "hk_kdereportpartwidget.h"
#include "hk_kdetoolbar.h"
#include "hk_kdesimplereport.h"
#include "hk_kdereportsectiondialog.h"
#include "../hk_kdereportpart/hk_kdereportpart.h"
#include "hk_kdeformfocus.h"

#include <hk_database.h>
#include <hk_connection.h>
#include <hk_datasource.h>

#include <qscrollview.h>
#include <qbuttongroup.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwidgetstack.h>
#include <qclipboard.h>
#include <qapplication.h>
#include <qwidget.h>

#include <klibloader.h>
#include <kmenubar.h>
#include <kaction.h>
#include <kactioncollection.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <kmdichildview.h>


class hk_kdepreviewwindow: public QWidget
{
public:
hk_kdepreviewwindow(QWidget * parent , const char * name = 0, WFlags f = WDestructiveClose )
:QWidget(parent,name,f)

     {
       QVBoxLayout* l=new QVBoxLayout(this);
        p_toolbar=new KToolBar(this,"gvtoolbar",true);
	p_toolbar->setBarPos(KToolBar::Top);
	p_toolbar->setMovingEnabled(false);
	l->addWidget(p_toolbar, AlignTop);
        KLibFactory*    p_factory=KLibLoader::self()->factory("libkghostview");
        if (!p_factory) p_factory=KLibLoader::self()->factory("libkghostviewpart");
	p_previewpart=NULL;
       p_previewpart=(KParts::ReadOnlyPart*) p_factory->create(this,"kgvpart","KParts::ReadOnlyPart");
       if (p_previewpart) l->addWidget(p_previewpart->widget());
       add_actions();
     }
virtual ~hk_kdepreviewwindow()
        {
	  delete p_previewpart;
	}
void add_actions(void)
  {
   if(!p_previewpart) return;
   QDomNodeList l= p_previewpart->domDocument().elementsByTagName("ToolBar");
   if (l.length()==0) return;
   QDomNodeList a=l.item(0).toElement().elementsByTagName("Action");
   for (uint i=0;i<a.length();++i)
   {
     QDomElement n=a.item(i).toElement();
     KAction* newact=p_previewpart->action(n);
     if (newact)
       {
         newact->plug(p_toolbar);
       }
   }
   //KAction* printact=new KAction(p_previewpart->widget(),SLOT(print()),NULL)   ;
  }
KParts::ReadOnlyPart* p_previewpart;
KToolBar* p_toolbar;

};




















class hk_kdereportpartwidgetscrollview :public QScrollView
{
    public:
        hk_kdereportpartwidgetscrollview ( QWidget * parent=0, const char * name=0, WFlags f=0 )
            :QScrollView(parent,name,f)
        {
            p_report =NULL;
        }
	~hk_kdereportpartwidgetscrollview()
	{

	}
        void set_report(hk_kdesimplereport* r){p_report=r;}
    protected:

        virtual void viewportMousePressEvent ( QMouseEvent * )
        {
            if (p_report!=NULL) p_report->set_focus2property();
        }
        hk_kdesimplereport* p_report;
};

hk_kdereportpartwidget::hk_kdereportpartwidget (hk_kdereportpart* reportpart,QWidget* parent,  const char* name, WFlags fl )
: KParts::DockMainWindow( parent, name, fl ) ,hk_class()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::hk_kdereportpartwidget");
#endif
     setFocusPolicy(StrongFocus);
   p_reportpart=reportpart;
    p_previewwindow=NULL;
    resize( 800, 600 );
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    //setXMLFile(locate("data","hk_kdeclasses/hk_kdereport.rc"));
    p_whilepreview=false;
    p_closewindow=false;
    if (runtime_only())
    {
      p_designaction=NULL;
      p_viewaction=NULL;
    }
    else
    {
    p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(set_designmode()),p_reportpart->actionCollection(),"designmode");
    p_designaction->setEnabled(!runtime_only());
    p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(set_viewmode()),p_reportpart->actionCollection(),"viewmode");
    p_designaction->setExclusiveGroup("mode");
    p_viewaction->setExclusiveGroup("mode");
    p_designaction->setChecked(true);
    }
    p_printaction=new KAction(i18n("&Print"),"fileprint",0,this,SLOT(print_report()),p_reportpart->actionCollection(),"printreport");
    p_printaction->setEnabled(false);
    p_sectionaction=new KAction(i18n("Sectionselect"),loader->loadIcon("reportsection",KIcon::User),0,this,SLOT(select_section()),p_reportpart->actionCollection(),"sectionselect");
    p_sectionaction->setToolTip(i18n("sections"));
    p_saveaction=new KAction(i18n("&Save"),"filesave",0,this,SLOT(save_report()),p_reportpart->actionCollection(),"savereport");
    p_saveaction->setEnabled(!runtime_only());
    p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,this,SLOT(saveas_report()),p_reportpart->actionCollection(),"saveas");
    p_saveasaction->setEnabled(!runtime_only());

    p_pointeraction=new KRadioAction("Pointer",loader->loadIcon("pfeil",KIcon::User),0,this,SLOT(pointerbutton_clicked()),p_reportpart->actionCollection(),"pointer");
    p_fieldaction=new KRadioAction("Field",loader->loadIcon("edit",KIcon::User),0,this,SLOT(fieldbutton_clicked()),p_reportpart->actionCollection(),"fieldbutton");
    p_pointeraction->setToolTip(i18n("select"));
    p_pointeraction->setExclusiveGroup("design");
    p_fieldaction->setExclusiveGroup("design");
    p_fieldaction->setToolTip(i18n("new field"));
    p_pointeraction->setChecked(true);
    p_bulkaction=new KActionMenu(i18n("Set to all"),0,p_reportpart->actionCollection(),"bulk");
    p_bulkfontaction=new KAction(i18n("Font"),0,0,this,SLOT(bulkfont_clicked()),p_reportpart->actionCollection(),"bulkfont");
    p_bulkforegroundcolouraction=new KAction(i18n("Foregroundcolour"),0,0,this,SLOT(bulkforegroundcolour_clicked()),p_reportpart->actionCollection(),"bulkforeground");
    p_bulkbackgroundcolouraction=new KAction(i18n("Backgroundcolour"),0,0,this,SLOT(bulkbackgroundcolour_clicked()),p_reportpart->actionCollection(),"bulkbackground");
    p_bulkaction->insert(p_bulkfontaction);
    p_bulkaction->insert(p_bulkforegroundcolouraction);
    p_bulkaction->insert(p_bulkbackgroundcolouraction);






    QPixmap p;
    KDockWidget* maindock=createDockWidget("",p,0,"");
    maindock->setEnableDocking(KDockWidget::DockNone);
    maindock->setDockSite(KDockWidget::DockCorner);
    setView(maindock);
    setMainDockWidget(maindock);
    p_stack= new QWidgetStack(maindock);
    maindock->setWidget(p_stack);


    p_scrollview = new hk_kdereportpartwidgetscrollview(p_stack);
    p_stack->addWidget(p_scrollview,0);
    p_report = new hk_kdesimplereport( p_scrollview->viewport() );
    p_report->set_reportpartwidget(this);
    p_scrollview->set_report(p_report);
    set_caption();
    p_reportpropertyaction=new KAction(i18n("&Propertyeditor"),loader->loadIcon("propertyeditor",KIcon::User),0,p_report,SLOT(show_property()),p_reportpart->actionCollection(),"viewproperty");



    p_deleteaction=new KAction(i18n("&Delete"),Key_Delete,p_report,SLOT(delete_widgets()),p_reportpart->actionCollection(),"delete");
    p_copyaction= new KAction(i18n("&Copy"),CTRL+Key_C,p_report,SLOT(copy_widgets()),p_reportpart->actionCollection(),"copy");
    p_pasteaction=new KAction(i18n("&Paste"),CTRL+Key_V,p_report,SLOT(paste_widgets()),p_reportpart->actionCollection(),"paste");
    p_cutaction=new KAction(i18n("Cu&t"),CTRL+Key_X,p_report,SLOT(cut_widgets()),p_reportpart->actionCollection(),"cut");
    p_resizeaction=new KActionMenu(i18n("Adjust &size"),0,p_reportpart->actionCollection(),"size");
    p_minwidthaction=new KAction(i18n("Minimum width"),0,0,p_report,SLOT(adjust_minw()),p_reportpart->actionCollection(),"minwidth");
    p_maxwidthaction=new KAction(i18n("Maximum width"),0,0,p_report,SLOT(adjust_maxw()),p_reportpart->actionCollection(),"maxwidth");
    p_minheightaction=new KAction(i18n("Minimum height"),0,0,p_report,SLOT(adjust_minh()),p_reportpart->actionCollection(),"minheight");
    p_maxheightaction=new KAction(i18n("Maximum height"),0,0,p_report,SLOT(adjust_maxh()),p_reportpart->actionCollection(),"maxheight");
    p_minsizeaction=new KAction(i18n("Minimum size"),0,0,p_report,SLOT(adjust_mins()),p_reportpart->actionCollection(),"minsize");
    p_maxsizeaction=new KAction(i18n("Maximum size"),0,0,p_report,SLOT(adjust_maxs()),p_reportpart->actionCollection(),"maxsize");
    p_resizeaction->insert(p_minwidthaction);
    p_resizeaction->insert(p_maxwidthaction);
    p_resizeaction->insert(p_minheightaction);
    p_resizeaction->insert(p_maxheightaction);
    p_resizeaction->insert(p_minsizeaction);
    p_resizeaction->insert(p_maxsizeaction);

    p_alignaction=new KActionMenu(i18n("&Align"),0,p_reportpart->actionCollection(),"align");
    p_alignleftaction=new KAction(i18n("&Left"),0,0,p_report,SLOT(align_left()),p_reportpart->actionCollection(),"alignleft");
    p_alignrightaction=new KAction(i18n("&Right"),0,0,p_report,SLOT(align_right()),p_reportpart->actionCollection(),"alignright");
    p_aligntopaction=new KAction(i18n("&Top"),0,0,p_report,SLOT(align_top()),p_reportpart->actionCollection(),"aligntop");
    p_alignbottomaction=new KAction(i18n("&Bottom"),0,0,p_report,SLOT(align_bottom()),p_reportpart->actionCollection(),"alignbottom");
    p_alignaction->insert(p_alignleftaction);
    p_alignaction->insert(p_alignrightaction);
    p_alignaction->insert(p_aligntopaction);
    p_alignaction->insert(p_alignbottomaction);


     connect(p_report,SIGNAL(signal_has_changed()),this,SLOT(slot_has_changed()));

   connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboard_changed()));
    connect( p_report, SIGNAL( signal_focuswidget_changed() ), this, SLOT( slot_focuswidget_changed() ) );





    //setCentralWidget(p_scrollview);
    set_reporttoolbar();
    p_scrollview->addChild(p_report);
    set_nodesignmode(runtime_only());
    p_report->set_reporttype("Postscript",false);
    //createGUI(0L);
    //toolBar("designtoolbar")->setBarPos(KToolBar::Left);
}


hk_kdereportpartwidget::~hk_kdereportpartwidget(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::~hk_kdereportpartwidget");
#endif

}


void hk_kdereportpartwidget::viewbutton_clicked(void)
{
    set_mode(hk_presentation::viewmode);
}


void hk_kdereportpartwidget::designbutton_clicked(void)
{
    if (p_nodesignmode)  set_mode(hk_presentation::viewmode);
    else set_mode(hk_presentation::designmode);

}


void hk_kdereportpartwidget::set_reporttoolbar(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::set_reporttoolbar");
#endif

    connect( p_report, SIGNAL( signalfield_created() ), this, SLOT( field_created() ) );

}


bool    hk_kdereportpartwidget::set_presentationdatasource(long n, bool r)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::set_presentationdatasource(n)");
#endif
    bool res=true;
    if (r) res= p_report->set_presentationdatasource(n,false);
    return res;
}


long    hk_kdereportpartwidget::presentationdatasource(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::presentationdatasource(n)");
#endif
    return p_report->presentationdatasource();
}


void hk_kdereportpartwidget::set_database(hk_database* db)
{
    if (!p_report) return;
    p_report->set_database(db);
    set_caption();
}


hk_database* hk_kdereportpartwidget::database(void)
{
    if (!p_report) return NULL;
    return p_report->database();
}

bool hk_kdereportpartwidget::while_executing(void) const
{
  return p_report->while_executing();
}

void hk_kdereportpartwidget::stop_execution(void)
{
  p_report->stop_execution();
}


void hk_kdereportpartwidget::closeEvent ( QCloseEvent* e)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::closeEvent");
#endif

    if (p_report->while_executing())
    {
      e->ignore();
      return;
    }
    if (p_report->has_changed())
    {
        p_report->save_report();
    }

    if(!p_whilepreview)
    {
        //setCentralWidget(NULL);
        if(p_previewwindow!=NULL)
        {
            p_stack->removeWidget(p_previewwindow);
	    delete p_previewwindow;
	    p_previewwindow=NULL;
        }
        QWidget::closeEvent(e);
    } else p_closewindow=true;
   emit signal_closed(this);
}


void hk_kdereportpartwidget::fieldbutton_clicked(void)
{
    p_report->set_field2create(p_fieldaction->isChecked());
}


void hk_kdereportpartwidget::set_nodesignmode(bool d)
{
    p_nodesignmode=d;

}


void    hk_kdereportpartwidget::set_mode(hk_presentation::enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdereportpartwidget::set_mode(s)");
#endif
    //if (s==p_report->mode()&&!runtime_only())return;

    if (s==hk_presentation::viewmode)
    {
        if (!p_report->set_mode(s))
        {
            if (p_designaction)p_designaction->setChecked(true);
            return;
        }
        //toolBar("designtoolbar")->hide();
        p_reportpropertyaction->setEnabled(false);
	p_pointeraction->setEnabled(false);
	    p_fieldaction->setEnabled(false);
	    p_sectionaction->setEnabled(false);

        if (p_viewaction) p_viewaction->setChecked(true);
        KLibFactory*    p_factory=KLibLoader::self()->factory("libkghostview");
        if (!p_factory) p_factory=KLibLoader::self()->factory("libkghostviewpart");
        if (p_factory)
        {
            if (p_previewwindow!=NULL)
	    {
		//createGUI(0L);
		p_stack->removeWidget(p_previewwindow);
	        delete p_previewwindow;
	        p_previewwindow=NULL;
	    }
            p_previewwindow=new hk_kdepreviewwindow(this);
            if (p_previewwindow!=NULL)
            {

                p_whilepreview=true;
                p_stack->addWidget(p_previewwindow,1);
		p_stack->raiseWidget(p_previewwindow);
                //createGUI(p_previewpart);
                if (p_previewwindow->p_previewpart)
		  p_previewwindow->p_previewpart->openURL(QString::fromUtf8(l2u(p_report->outputfile()).c_str()));
                p_previewwindow->show();
                p_whilepreview=false;
                if (p_closewindow) close();
                p_printaction->setEnabled(true);
                set_caption();
            }

        p_reportpart->setXMLFile(locate("data","hk_kdeclasses/hk_kdereportpartview.rc"));
	p_copyaction->setEnabled(false);
        p_cutaction->setEnabled(false);
        p_pasteaction->setEnabled(false);
        p_deleteaction->setEnabled(false);


	}
        else
        {
            show_warningmessage(hk_translate("KGhostview could not be found!\nPlease install the kdegraphics package"));
        }
        p_bulkaction->setEnabled(false);
    }
    else
    {                                             //design mode
//setCaption(QString::fromUtf8(l2u(p_report->hk_presentation::name()).c_str()));

	p_report->set_mode(s);
	p_printaction->setEnabled(false);
        //createGUI(NULL);
        p_reportpart->setXMLFile(locate("data","hk_kdeclasses/hk_kdereportpartdesign.rc"));

        if (p_designaction)p_designaction->setChecked(true);
        p_bulkaction->setEnabled(true);
        if (!p_whilepreview)
        {
            //toolBar("designtoolbar")->show();
            p_reportpropertyaction->setEnabled(true);
	    p_pointeraction->setEnabled(true);
	    p_fieldaction->setEnabled(true);
	    p_sectionaction->setEnabled(true);
            p_stack->raiseWidget(p_scrollview);
            //p_report->set_mode(s);
        }
        else      if (p_viewaction)p_viewaction->setChecked(true);
        p_copyaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
        p_cutaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
        p_deleteaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
        p_pasteaction->setEnabled(QApplication::clipboard()->data()&&QApplication::clipboard()->data()->provides("application/x-hk_kdesimplereportcopy"));

    }
    p_resizeaction->setEnabled(p_report->mode()==hk_presentation::designmode&&p_report->focus_multipleselected());
    p_alignaction->setEnabled(p_report->mode()==hk_presentation::designmode&&p_report->focus_multipleselected());
    p_report->repaint(0,0,p_report->QWidget::width(),p_report->QWidget::height(),true);
}


void hk_kdereportpartwidget::set_designmode(void)
{
    set_mode(hk_presentation::designmode);
}


void hk_kdereportpartwidget::set_viewmode(void)
{
    set_mode(hk_presentation::viewmode);
}


void hk_kdereportpartwidget::field_created(void)
{
    p_pointeraction->setChecked(true);
}


hk_kdesimplereport* hk_kdereportpartwidget::simplereport(void)
{
    return p_report;
}


void    hk_kdereportpartwidget::save_report(void)
{
    p_report->save_report("",false);
    set_caption();
}


void hk_kdereportpartwidget::saveas_report(void)
{
    hk_string oldname=p_report->hk_presentation::name();
    p_report->set_name("");
    if (p_report->save_report("",false))
    {
        set_caption();
    }
    else
    {

        p_report->set_name(oldname);
    }

}


bool hk_kdereportpartwidget::load_report(const hk_string& name)
{
    bool res=p_report->load_report(name);
    set_caption();
    return res;
}


void hk_kdereportpartwidget::close_report(void)
{
    close();
}


void hk_kdereportpartwidget::slot_showtoolbar(void)
{

}


void hk_kdereportpartwidget::pointerbutton_clicked(void)
{

}


void hk_kdereportpartwidget::print_report(void)
{
    hk_string buf=p_report->printcommand();
    p_report->set_printcommand("kprinter -j none");
    p_report->print_report(false);
    p_report->set_printcommand(buf);
}


void hk_kdereportpartwidget::select_section(void)
{
    p_report->clearfocus();
    hk_kdereportsectiondialog* d= new hk_kdereportsectiondialog(p_report,this,0,true);
    d->exec();

    delete d;
}


void hk_kdereportpartwidget::set_caption(void)
{

    QString reportname=i18n( "Report - "  );
    reportname+=QString::fromUtf8 (l2u(p_report->hk_presentation::name()).c_str());

    setCaption( reportname  );
    KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
    if (v) v->setCaption(reportname);

   emit signal_setcaption(reportname);

}


void hk_kdereportpartwidget::bulkfont_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkfont);
}


void hk_kdereportpartwidget::bulkforegroundcolour_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkforeground);

}


void hk_kdereportpartwidget::bulkbackgroundcolour_clicked(void)
{
    p_report->set_for_all(hk_presentation::bulkbackground);

}


void hk_kdereportpartwidget::slot_has_changed()
{
 if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& p_report->has_changed());

}


void hk_kdereportpartwidget::clipboard_changed()
{
if (p_pasteaction)
p_pasteaction->setEnabled(QApplication::clipboard()->data()&&QApplication::clipboard()->data()->provides("application/x-hk_kdesimplereportcopy"));
}


void hk_kdereportpartwidget::slot_focuswidget_changed(void)
{
        p_copyaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
        p_cutaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
        p_deleteaction->setEnabled(p_report->formfocus()&&p_report->formfocus()->widget());
    if (p_resizeaction) p_resizeaction->setEnabled(p_report->mode()==hk_presentation::designmode&&p_report->focus_multipleselected());
    if (p_alignaction) p_alignaction->setEnabled(p_report->mode()==hk_presentation::designmode&&p_report->focus_multipleselected());

}

void hk_kdereportpartwidget::show_widget(void)
{
  show();
}

void hk_kdereportpartwidget::hide_widget(void)
{
  hide();
}

void hk_kdereportpartwidget::close_widget(void)
{
  close();
}

