// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
 //$Revision: 1.6 $
#include "hk_kdeobjecthandler.h"
#include "hk_kdedblistview.h"
#include <hk_database.h>

#include <qpushbutton.h>
#include <qpixmap.h>
#include <qiconset.h>
#include <qwhatsthis.h>
#include <qlabel.h>
#include <qheader.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <kconfig.h>

#include <klocale.h>


hk_kdeobjecthandler::hk_kdeobjecthandler( hk_database* db,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kdeobjecthandlerbase( parent, name, modal, fl )
{
p_database=db;
centrallistview->set_database(db);
centrallistview->set_showmode(hk_kdedblistview::sm_central);
locallistview->set_database(db);
locallistview->set_showmode(hk_kdedblistview::sm_local);
KIconLoader* loader=KGlobal::iconLoader();
loader->addAppDir("hk_kdeclasses");
slot_selection_changed();
uploadbutton->setIconSet( loader->loadIcon("2rightarrow",KIcon::Small));
downloadbutton->setIconSet( loader->loadIcon("2leftarrow",KIcon::Small));
centrallistview->header()->setLabel(0,i18n("Central"));
locallistview->header()->setLabel(0,i18n("Local"));
setCaption(i18n("Database object handler"));
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Objecthandler");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);

}


hk_kdeobjecthandler::~hk_kdeobjecthandler()
{
}



void hk_kdeobjecthandler::download_clicked()
{
  filetype f=ft_report;
  if (centrallistview->is_queryitem()) f=ft_query;
  else
  if (centrallistview->is_formitem()) f=ft_form;
  
  hk_string data=p_database->load_central(u2l(centrallistview->currentItem()->text(0).utf8().data()),f);
  p_database->save_local(data,u2l(centrallistview->currentItem()->text(0).utf8().data()),f,true,true); 
}



void hk_kdeobjecthandler::upload_clicked()
{
  filetype f=ft_report;
  if (locallistview->is_queryitem()) f=ft_query;
  else
  if (locallistview->is_formitem()) f=ft_form;
  
  hk_string data=p_database->load_local(u2l(locallistview->currentItem()->text(0).utf8().data()),f);
  p_database->save_central(data,u2l(locallistview->currentItem()->text(0).utf8().data()),f,true,true); 

}


void hk_kdeobjecthandler::slot_selection_changed()
{
 downloadbutton->setEnabled(!centrallistview->is_headeritem());
 uploadbutton->setEnabled(!locallistview->is_headeritem());
}


void hk_kdeobjecthandler::accept(void)
{
KConfig* c=kapp->config();
  c->setGroup("Objecthandler");
  c->writeEntry("Geometry",geometry());
QDialog::accept();
}
