// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.19 $

#include "hk_kdecsvimportdialog.h"
#include "hk_kdecsvimportdialog.moc"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <qapplication.h>
#include <qprogressdialog.h>
#include <kapplication.h>
#include <kconfig.h>

/*
 *  Constructs a hk_kdecsvimportdialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdecsvimportdialog::hk_kdecsvimportdialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdecsvimportdialogbase( parent, name, modal, fl ),hk_importcsv()
{
    if ( !name )
        setName( "hk_kdecsvimportdialog" );
    setCaption( i18n( "CSV Import Dialog"  ) );
    TextLabel1->setText( i18n( "Filename:"  ) );
    TextLabel3->setText( i18n( "Text delimiter"  ) );
    TextLabel1_3->setText( i18n( "Field names in first row"  ));
    textdelimiterfield->setText( "\""   );
    TextLabel1_2->setText( i18n("Tablename:"  ) );
    TextLabel2->setText( i18n("Column Separator"  ));
    p_tab=i18n("Tab");
    columnseparatorfield->insertItem(  ","  );
    columnseparatorfield->insertItem(  ";"  );
    columnseparatorfield->insertItem( p_tab);
    buttonOk->setText( i18n( "&OK"  ) );
    buttonCancel->setText( i18n( "&Cancel"  ) );
    buttonHelp->setText( i18n( "&Help"  ));
    p_cancelprinting=false;
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("CSVImport");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}


hk_kdecsvimportdialog::~hk_kdecsvimportdialog()
{
// no need to delete child widgets, Qt does it all for us
//    delete p_import;
}


void hk_kdecsvimportdialog::ok_clicked(void)
{
//  wanna_debug(true);
    set_filename(u2l(filefield->text().utf8().data()));
    datasource()->set_name(u2l(tablename->text().utf8().data()));
    set_firstrow_contains_fieldnames(firstrow->isChecked());
    QString sep=columnseparatorfield->currentText();
    if (sep==p_tab) sep="\t";
    set_filedefinition(u2l(textdelimiterfield->text().utf8().data()),u2l(sep.utf8().data()));
    set_append_rows(appendrows->isChecked());
    before_execute();
    bool r=execute();
    after_execute();
    if (r ) accept();
    KConfig* c=kapp->config();
  c->setGroup("CSVImport");
  c->writeEntry("Geometry",geometry());

}


void hk_kdecsvimportdialog::filebutton_clicked()
{

    p_file = KFileDialog::getOpenFileName( ":csv", QString::null, this,i18n("Select a CSV file"));
    filefield->setText(p_file);
}


void hk_kdecsvimportdialog::buttons_enabled()
{
    if (    !filefield->text().isEmpty()
        &&!columnseparatorfield->currentText().isEmpty()
        &&!tablename->text().isEmpty()
        )
        buttonOk->setEnabled(true);
    else buttonOk->setEnabled(false);
}


void    hk_kdecsvimportdialog::before_execute(void)
{
    p_cancelprinting=false;
/*   p_progressdialog= new  QProgressDialog();
   p_progressdialog->setCaption(i18n("Generating report..."));
   p_progressdialog->setTotalSteps(datasource()->max_rows());
   connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(printing_cancelled()));
   p_progressdialog->show();
   qApp->processEvents();*/
}


void    hk_kdecsvimportdialog::after_execute(void)
{
/*  delete p_progressdialog;
  p_progressdialog=NULL;*/
}


void hk_kdecsvimportdialog::printing_cancelled(void)
{
    cout <<"cancelclicked"<<endl;
    p_cancelprinting=true;

}


bool hk_kdecsvimportdialog::widget_specific_after_new_row(void)
{
/*  if (p_progressdialog!=NULL)
  {
     p_progressdialog->setProgress(datasource()->row_position());
  }
  qApp->processEvents();*/

    return !p_cancelprinting;
}
