#ifndef __MAINWCLASS
#define __MAINWCLASS

#include <kmainwindow.h>
class KApplication;
class KToolBar;
class KMenuBar;

class QObject;
class QMouseEvent;
class QPaintEvent;
class QPopupMenu;
class QSlider;
class QComboBox;
class QString;
//#include <qstring.h>

class NetWidget;
class Circuit;
class XDevice;
class ClientW;
class ScrollableSimw;
class SimW;
class DevLibrary;

#include <klogicList.h>

//************ constants ***************
// 500..599 reserved for netdev!!
// 1000..1999 reserved for device!! (see class Device, device.h)
// 2000..3999 reserved for library devices!! (see class Device, device.h)

// file operations
#define ID_OPEN		4001
#define ID_SAVE		4002
#define ID_SAVE_AS	4003
#define ID_NEW		4004
#define ID_PRINT	4005
#define ID_LIBRARY_MAIN	4008
#define ID_EXIT		4009

// edit operations
#define ID_COPY		4100
#define ID_PASTE	4101
#define ID_CUT		4102

// logic
#define ID_DRAW		4200
#define ID_UP		4201
#define ID_SEL		4202
#define ID_LIB_CHOOSER	4204
#define ID_LIBDEV_CHOOSER 4205

// simulation
#define ID_SIM_SHOW	4300
#define ID_SIM_EQU	4301

// options
#define ID_GLOBAL	4400
#define ID_TOOL_VISIBLE	4402

#define ID_MAINTENANCE	4500

// main modes

//************ class *************
class MainWidget : public KMainWindow
{	Q_OBJECT
public:
	MainWidget(KApplication *, const char *file = (char *)NULL);
	~MainWidget();
	void closeClient(ClientW *);	// close client widget

	void setMode(int);		// operation mode (draw/select/drop)
	static int getMode();

	void setToolbarPixmap();

	static QString PATH;
	static QString TBPATH;

	static const int MAIN_MODE_DRAW = 1;	// draw wires
	static const int MAIN_MODE_SELECT = 2;	// select frames to copy/paste
	static const int MAIN_MODE_DROP = 3;	// drop library devices

	static DevLibrary *activeLib;		// active library, or 0

public slots:
	void menuCallback(int);
	void netChange(int);
	void netDelete(Circuit *);
	void newClient(Circuit *);
	void repaintClients();
	void circuitUnchanged();
	void simWidgetHidden();
	void simTimeSliderChanged(int);
	void libraryChanged(int);
	void libraryDeviceChanged(int);
	void modeDraw();
	void modeSelect();
	void addToLib(XDevice *);

signals:
	void idChange(int, int);

protected:
	void saveProperties(KConfig *config);	// virtual??
	void readProperties(KConfig *config);

private:
	static void setPATH(KApplication *);
	static const int MAXCLIENTS = 100;

	void paintEvent(QPaintEvent *);
	bool queryClose();
	void closeAllClients();
	void setWidgets();
	void initToolbar();
	void setToolbar();
	void initMenubar();
	void turnAllCheckButton(int);
	void dialogSim();
	void dialogGlobal();
	void dialogLibrary(XDevice *new_dev = (XDevice *)NULL);
	void devChange(int);
	void simMode(int);
	NetWidget * getActive();

	KToolBar *gate_toolbar;
	KToolBar *lib_toolbar;
	KToolBar *sim_toolbar;

	KMenuBar *menubar;

	QPopupMenu *pm_file;
	QPopupMenu *pm_edit;
	QPopupMenu *pm_logic;
	QPopupMenu *pm_sim;
	QPopupMenu *pm_options;
	KPopupMenu *pm_help;
	QSlider *speed_slider;

	KlogicList<ClientW> client_widgets;
	NetWidget *main_netwidget;

	KlogicList<DevLibrary> libList;
	QComboBox *cbLibrary;
	QComboBox *cbLibDev;

	ScrollableSimw *scrollSimW;
	SimW *simW;
	int simw;
	int tool_visible;

	KApplication *app;

	static int mode;		// the current drawing mode

	bool circuit_changed;		// current change status
};
#endif
