#include "encoding_korean.h"

#include "core/image.h"

#include <stdlib.h>
#include <string.h>

typedef struct {
    uint16_t cp949;
    uint8_t utf8[3];
} korean_entry;

static const korean_entry codepage_to_utf8[IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS] = {
    {0xb0a1, {0xea, 0xb0, 0x80}},
    {0xb0a2, {0xea, 0xb0, 0x81}},
    {0xb0a3, {0xea, 0xb0, 0x84}},
    {0xb0a4, {0xea, 0xb0, 0x87}},
    {0xb0a5, {0xea, 0xb0, 0x88}},
    {0xb0a6, {0xea, 0xb0, 0x89}},
    {0xb0a7, {0xea, 0xb0, 0x8a}},
    {0xb0a8, {0xea, 0xb0, 0x90}},
    {0xb0a9, {0xea, 0xb0, 0x91}},
    {0xb0aa, {0xea, 0xb0, 0x92}},
    {0xb0ab, {0xea, 0xb0, 0x93}},
    {0xb0ac, {0xea, 0xb0, 0x94}},
    {0xb0ad, {0xea, 0xb0, 0x95}},
    {0xb0ae, {0xea, 0xb0, 0x96}},
    {0xb0af, {0xea, 0xb0, 0x97}},
    {0xb0b0, {0xea, 0xb0, 0x99}},
    {0xb0b1, {0xea, 0xb0, 0x9a}},
    {0xb0b2, {0xea, 0xb0, 0x9b}},
    {0xb0b3, {0xea, 0xb0, 0x9c}},
    {0xb0b4, {0xea, 0xb0, 0x9d}},
    {0xb0b5, {0xea, 0xb0, 0xa0}},
    {0xb0b6, {0xea, 0xb0, 0xa4}},
    {0xb0b7, {0xea, 0xb0, 0xac}},
    {0xb0b8, {0xea, 0xb0, 0xad}},
    {0xb0b9, {0xea, 0xb0, 0xaf}},
    {0xb0ba, {0xea, 0xb0, 0xb0}},
    {0xb0bb, {0xea, 0xb0, 0xb1}},
    {0xb0bc, {0xea, 0xb0, 0xb8}},
    {0xb0bd, {0xea, 0xb0, 0xb9}},
    {0xb0be, {0xea, 0xb0, 0xbc}},
    {0xb0bf, {0xea, 0xb1, 0x80}},
    {0xb0c0, {0xea, 0xb1, 0x8b}},
    {0xb0c1, {0xea, 0xb1, 0x8d}},
    {0xb0c2, {0xea, 0xb1, 0x94}},
    {0xb0c3, {0xea, 0xb1, 0x98}},
    {0xb0c4, {0xea, 0xb1, 0x9c}},
    {0xb0c5, {0xea, 0xb1, 0xb0}},
    {0xb0c6, {0xea, 0xb1, 0xb1}},
    {0xb0c7, {0xea, 0xb1, 0xb4}},
    {0xb0c8, {0xea, 0xb1, 0xb7}},
    {0xb0c9, {0xea, 0xb1, 0xb8}},
    {0xb0ca, {0xea, 0xb1, 0xba}},
    {0xb0cb, {0xea, 0xb2, 0x80}},
    {0xb0cc, {0xea, 0xb2, 0x81}},
    {0xb0cd, {0xea, 0xb2, 0x83}},
    {0xb0ce, {0xea, 0xb2, 0x84}},
    {0xb0cf, {0xea, 0xb2, 0x85}},
    {0xb0d0, {0xea, 0xb2, 0x86}},
    {0xb0d1, {0xea, 0xb2, 0x89}},
    {0xb0d2, {0xea, 0xb2, 0x8a}},
    {0xb0d3, {0xea, 0xb2, 0x8b}},
    {0xb0d4, {0xea, 0xb2, 0x8c}},
    {0xb0d5, {0xea, 0xb2, 0x90}},
    {0xb0d6, {0xea, 0xb2, 0x94}},
    {0xb0d7, {0xea, 0xb2, 0x9c}},
    {0xb0d8, {0xea, 0xb2, 0x9d}},
    {0xb0d9, {0xea, 0xb2, 0x9f}},
    {0xb0da, {0xea, 0xb2, 0xa0}},
    {0xb0db, {0xea, 0xb2, 0xa1}},
    {0xb0dc, {0xea, 0xb2, 0xa8}},
    {0xb0dd, {0xea, 0xb2, 0xa9}},
    {0xb0de, {0xea, 0xb2, 0xaa}},
    {0xb0df, {0xea, 0xb2, 0xac}},
    {0xb0e0, {0xea, 0xb2, 0xaf}},
    {0xb0e1, {0xea, 0xb2, 0xb0}},
    {0xb0e2, {0xea, 0xb2, 0xb8}},
    {0xb0e3, {0xea, 0xb2, 0xb9}},
    {0xb0e4, {0xea, 0xb2, 0xbb}},
    {0xb0e5, {0xea, 0xb2, 0xbc}},
    {0xb0e6, {0xea, 0xb2, 0xbd}},
    {0xb0e7, {0xea, 0xb3, 0x81}},
    {0xb0e8, {0xea, 0xb3, 0x84}},
    {0xb0e9, {0xea, 0xb3, 0x88}},
    {0xb0ea, {0xea, 0xb3, 0x8c}},
    {0xb0eb, {0xea, 0xb3, 0x95}},
    {0xb0ec, {0xea, 0xb3, 0x97}},
    {0xb0ed, {0xea, 0xb3, 0xa0}},
    {0xb0ee, {0xea, 0xb3, 0xa1}},
    {0xb0ef, {0xea, 0xb3, 0xa4}},
    {0xb0f0, {0xea, 0xb3, 0xa7}},
    {0xb0f1, {0xea, 0xb3, 0xa8}},
    {0xb0f2, {0xea, 0xb3, 0xaa}},
    {0xb0f3, {0xea, 0xb3, 0xac}},
    {0xb0f4, {0xea, 0xb3, 0xaf}},
    {0xb0f5, {0xea, 0xb3, 0xb0}},
    {0xb0f6, {0xea, 0xb3, 0xb1}},
    {0xb0f7, {0xea, 0xb3, 0xb3}},
    {0xb0f8, {0xea, 0xb3, 0xb5}},
    {0xb0f9, {0xea, 0xb3, 0xb6}},
    {0xb0fa, {0xea, 0xb3, 0xbc}},
    {0xb0fb, {0xea, 0xb3, 0xbd}},
    {0xb0fc, {0xea, 0xb4, 0x80}},
    {0xb0fd, {0xea, 0xb4, 0x84}},
    {0xb0fe, {0xea, 0xb4, 0x86}},
    {0xb1a1, {0xea, 0xb4, 0x8c}},
    {0xb1a2, {0xea, 0xb4, 0x8d}},
    {0xb1a3, {0xea, 0xb4, 0x8f}},
    {0xb1a4, {0xea, 0xb4, 0x91}},
    {0xb1a5, {0xea, 0xb4, 0x98}},
    {0xb1a6, {0xea, 0xb4, 0x9c}},
    {0xb1a7, {0xea, 0xb4, 0xa0}},
    {0xb1a8, {0xea, 0xb4, 0xa9}},
    {0xb1a9, {0xea, 0xb4, 0xac}},
    {0xb1aa, {0xea, 0xb4, 0xad}},
    {0xb1ab, {0xea, 0xb4, 0xb4}},
    {0xb1ac, {0xea, 0xb4, 0xb5}},
    {0xb1ad, {0xea, 0xb4, 0xb8}},
    {0xb1ae, {0xea, 0xb4, 0xbc}},
    {0xb1af, {0xea, 0xb5, 0x84}},
    {0xb1b0, {0xea, 0xb5, 0x85}},
    {0xb1b1, {0xea, 0xb5, 0x87}},
    {0xb1b2, {0xea, 0xb5, 0x89}},
    {0xb1b3, {0xea, 0xb5, 0x90}},
    {0xb1b4, {0xea, 0xb5, 0x94}},
    {0xb1b5, {0xea, 0xb5, 0x98}},
    {0xb1b6, {0xea, 0xb5, 0xa1}},
    {0xb1b7, {0xea, 0xb5, 0xa3}},
    {0xb1b8, {0xea, 0xb5, 0xac}},
    {0xb1b9, {0xea, 0xb5, 0xad}},
    {0xb1ba, {0xea, 0xb5, 0xb0}},
    {0xb1bb, {0xea, 0xb5, 0xb3}},
    {0xb1bc, {0xea, 0xb5, 0xb4}},
    {0xb1bd, {0xea, 0xb5, 0xb5}},
    {0xb1be, {0xea, 0xb5, 0xb6}},
    {0xb1bf, {0xea, 0xb5, 0xbb}},
    {0xb1c0, {0xea, 0xb5, 0xbc}},
    {0xb1c1, {0xea, 0xb5, 0xbd}},
    {0xb1c2, {0xea, 0xb5, 0xbf}},
    {0xb1c3, {0xea, 0xb6, 0x81}},
    {0xb1c4, {0xea, 0xb6, 0x82}},
    {0xb1c5, {0xea, 0xb6, 0x88}},
    {0xb1c6, {0xea, 0xb6, 0x89}},
    {0xb1c7, {0xea, 0xb6, 0x8c}},
    {0xb1c8, {0xea, 0xb6, 0x90}},
    {0xb1c9, {0xea, 0xb6, 0x9c}},
    {0xb1ca, {0xea, 0xb6, 0x9d}},
    {0xb1cb, {0xea, 0xb6, 0xa4}},
    {0xb1cc, {0xea, 0xb6, 0xb7}},
    {0xb1cd, {0xea, 0xb7, 0x80}},
    {0xb1ce, {0xea, 0xb7, 0x81}},
    {0xb1cf, {0xea, 0xb7, 0x84}},
    {0xb1d0, {0xea, 0xb7, 0x88}},
    {0xb1d1, {0xea, 0xb7, 0x90}},
    {0xb1d2, {0xea, 0xb7, 0x91}},
    {0xb1d3, {0xea, 0xb7, 0x93}},
    {0xb1d4, {0xea, 0xb7, 0x9c}},
    {0xb1d5, {0xea, 0xb7, 0xa0}},
    {0xb1d6, {0xea, 0xb7, 0xa4}},
    {0xb1d7, {0xea, 0xb7, 0xb8}},
    {0xb1d8, {0xea, 0xb7, 0xb9}},
    {0xb1d9, {0xea, 0xb7, 0xbc}},
    {0xb1da, {0xea, 0xb7, 0xbf}},
    {0xb1db, {0xea, 0xb8, 0x80}},
    {0xb1dc, {0xea, 0xb8, 0x81}},
    {0xb1dd, {0xea, 0xb8, 0x88}},
    {0xb1de, {0xea, 0xb8, 0x89}},
    {0xb1df, {0xea, 0xb8, 0x8b}},
    {0xb1e0, {0xea, 0xb8, 0x8d}},
    {0xb1e1, {0xea, 0xb8, 0x94}},
    {0xb1e2, {0xea, 0xb8, 0xb0}},
    {0xb1e3, {0xea, 0xb8, 0xb1}},
    {0xb1e4, {0xea, 0xb8, 0xb4}},
    {0xb1e5, {0xea, 0xb8, 0xb7}},
    {0xb1e6, {0xea, 0xb8, 0xb8}},
    {0xb1e7, {0xea, 0xb8, 0xba}},
    {0xb1e8, {0xea, 0xb9, 0x80}},
    {0xb1e9, {0xea, 0xb9, 0x81}},
    {0xb1ea, {0xea, 0xb9, 0x83}},
    {0xb1eb, {0xea, 0xb9, 0x85}},
    {0xb1ec, {0xea, 0xb9, 0x86}},
    {0xb1ed, {0xea, 0xb9, 0x8a}},
    {0xb1ee, {0xea, 0xb9, 0x8c}},
    {0xb1ef, {0xea, 0xb9, 0x8d}},
    {0xb1f0, {0xea, 0xb9, 0x8e}},
    {0xb1f1, {0xea, 0xb9, 0x90}},
    {0xb1f2, {0xea, 0xb9, 0x94}},
    {0xb1f3, {0xea, 0xb9, 0x96}},
    {0xb1f4, {0xea, 0xb9, 0x9c}},
    {0xb1f5, {0xea, 0xb9, 0x9d}},
    {0xb1f6, {0xea, 0xb9, 0x9f}},
    {0xb1f7, {0xea, 0xb9, 0xa0}},
    {0xb1f8, {0xea, 0xb9, 0xa1}},
    {0xb1f9, {0xea, 0xb9, 0xa5}},
    {0xb1fa, {0xea, 0xb9, 0xa8}},
    {0xb1fb, {0xea, 0xb9, 0xa9}},
    {0xb1fc, {0xea, 0xb9, 0xac}},
    {0xb1fd, {0xea, 0xb9, 0xb0}},
    {0xb1fe, {0xea, 0xb9, 0xb8}},
    {0xb2a1, {0xea, 0xb9, 0xb9}},
    {0xb2a2, {0xea, 0xb9, 0xbb}},
    {0xb2a3, {0xea, 0xb9, 0xbc}},
    {0xb2a4, {0xea, 0xb9, 0xbd}},
    {0xb2a5, {0xea, 0xba, 0x84}},
    {0xb2a6, {0xea, 0xba, 0x85}},
    {0xb2a7, {0xea, 0xba, 0x8c}},
    {0xb2a8, {0xea, 0xba, 0xbc}},
    {0xb2a9, {0xea, 0xba, 0xbd}},
    {0xb2aa, {0xea, 0xba, 0xbe}},
    {0xb2ab, {0xea, 0xbb, 0x80}},
    {0xb2ac, {0xea, 0xbb, 0x84}},
    {0xb2ad, {0xea, 0xbb, 0x8c}},
    {0xb2ae, {0xea, 0xbb, 0x8d}},
    {0xb2af, {0xea, 0xbb, 0x8f}},
    {0xb2b0, {0xea, 0xbb, 0x90}},
    {0xb2b1, {0xea, 0xbb, 0x91}},
    {0xb2b2, {0xea, 0xbb, 0x98}},
    {0xb2b3, {0xea, 0xbb, 0x99}},
    {0xb2b4, {0xea, 0xbb, 0x9c}},
    {0xb2b5, {0xea, 0xbb, 0xa8}},
    {0xb2b6, {0xea, 0xbb, 0xab}},
    {0xb2b7, {0xea, 0xbb, 0xad}},
    {0xb2b8, {0xea, 0xbb, 0xb4}},
    {0xb2b9, {0xea, 0xbb, 0xb8}},
    {0xb2ba, {0xea, 0xbb, 0xbc}},
    {0xb2bb, {0xea, 0xbc, 0x87}},
    {0xb2bc, {0xea, 0xbc, 0x88}},
    {0xb2bd, {0xea, 0xbc, 0x8d}},
    {0xb2be, {0xea, 0xbc, 0x90}},
    {0xb2bf, {0xea, 0xbc, 0xac}},
    {0xb2c0, {0xea, 0xbc, 0xad}},
    {0xb2c1, {0xea, 0xbc, 0xb0}},
    {0xb2c2, {0xea, 0xbc, 0xb2}},
    {0xb2c3, {0xea, 0xbc, 0xb4}},
    {0xb2c4, {0xea, 0xbc, 0xbc}},
    {0xb2c5, {0xea, 0xbc, 0xbd}},
    {0xb2c6, {0xea, 0xbc, 0xbf}},
    {0xb2c7, {0xea, 0xbd, 0x81}},
    {0xb2c8, {0xea, 0xbd, 0x82}},
    {0xb2c9, {0xea, 0xbd, 0x83}},
    {0xb2ca, {0xea, 0xbd, 0x88}},
    {0xb2cb, {0xea, 0xbd, 0x89}},
    {0xb2cc, {0xea, 0xbd, 0x90}},
    {0xb2cd, {0xea, 0xbd, 0x9c}},
    {0xb2ce, {0xea, 0xbd, 0x9d}},
    {0xb2cf, {0xea, 0xbd, 0xa4}},
    {0xb2d0, {0xea, 0xbd, 0xa5}},
    {0xb2d1, {0xea, 0xbd, 0xb9}},
    {0xb2d2, {0xea, 0xbe, 0x80}},
    {0xb2d3, {0xea, 0xbe, 0x84}},
    {0xb2d4, {0xea, 0xbe, 0x88}},
    {0xb2d5, {0xea, 0xbe, 0x90}},
    {0xb2d6, {0xea, 0xbe, 0x91}},
    {0xb2d7, {0xea, 0xbe, 0x95}},
    {0xb2d8, {0xea, 0xbe, 0x9c}},
    {0xb2d9, {0xea, 0xbe, 0xb8}},
    {0xb2da, {0xea, 0xbe, 0xb9}},
    {0xb2db, {0xea, 0xbe, 0xbc}},
    {0xb2dc, {0xea, 0xbf, 0x80}},
    {0xb2dd, {0xea, 0xbf, 0x87}},
    {0xb2de, {0xea, 0xbf, 0x88}},
    {0xb2df, {0xea, 0xbf, 0x89}},
    {0xb2e0, {0xea, 0xbf, 0x8b}},
    {0xb2e1, {0xea, 0xbf, 0x8d}},
    {0xb2e2, {0xea, 0xbf, 0x8e}},
    {0xb2e3, {0xea, 0xbf, 0x94}},
    {0xb2e4, {0xea, 0xbf, 0x9c}},
    {0xb2e5, {0xea, 0xbf, 0xa8}},
    {0xb2e6, {0xea, 0xbf, 0xa9}},
    {0xb2e7, {0xea, 0xbf, 0xb0}},
    {0xb2e8, {0xea, 0xbf, 0xb1}},
    {0xb2e9, {0xea, 0xbf, 0xb4}},
    {0xb2ea, {0xea, 0xbf, 0xb8}},
    {0xb2eb, {0xeb, 0x80, 0x80}},
    {0xb2ec, {0xeb, 0x80, 0x81}},
    {0xb2ed, {0xeb, 0x80, 0x84}},
    {0xb2ee, {0xeb, 0x80, 0x8c}},
    {0xb2ef, {0xeb, 0x80, 0x90}},
    {0xb2f0, {0xeb, 0x80, 0x94}},
    {0xb2f1, {0xeb, 0x80, 0x9c}},
    {0xb2f2, {0xeb, 0x80, 0x9d}},
    {0xb2f3, {0xeb, 0x80, 0xa8}},
    {0xb2f4, {0xeb, 0x81, 0x84}},
    {0xb2f5, {0xeb, 0x81, 0x85}},
    {0xb2f6, {0xeb, 0x81, 0x88}},
    {0xb2f7, {0xeb, 0x81, 0x8a}},
    {0xb2f8, {0xeb, 0x81, 0x8c}},
    {0xb2f9, {0xeb, 0x81, 0x8e}},
    {0xb2fa, {0xeb, 0x81, 0x93}},
    {0xb2fb, {0xeb, 0x81, 0x94}},
    {0xb2fc, {0xeb, 0x81, 0x95}},
    {0xb2fd, {0xeb, 0x81, 0x97}},
    {0xb2fe, {0xeb, 0x81, 0x99}},
    {0xb3a1, {0xeb, 0x81, 0x9d}},
    {0xb3a2, {0xeb, 0x81, 0xbc}},
    {0xb3a3, {0xeb, 0x81, 0xbd}},
    {0xb3a4, {0xeb, 0x82, 0x80}},
    {0xb3a5, {0xeb, 0x82, 0x84}},
    {0xb3a6, {0xeb, 0x82, 0x8c}},
    {0xb3a7, {0xeb, 0x82, 0x8d}},
    {0xb3a8, {0xeb, 0x82, 0x8f}},
    {0xb3a9, {0xeb, 0x82, 0x91}},
    {0xb3aa, {0xeb, 0x82, 0x98}},
    {0xb3ab, {0xeb, 0x82, 0x99}},
    {0xb3ac, {0xeb, 0x82, 0x9a}},
    {0xb3ad, {0xeb, 0x82, 0x9c}},
    {0xb3ae, {0xeb, 0x82, 0x9f}},
    {0xb3af, {0xeb, 0x82, 0xa0}},
    {0xb3b0, {0xeb, 0x82, 0xa1}},
    {0xb3b1, {0xeb, 0x82, 0xa2}},
    {0xb3b2, {0xeb, 0x82, 0xa8}},
    {0xb3b3, {0xeb, 0x82, 0xa9}},
    {0xb3b4, {0xeb, 0x82, 0xab}},
    {0xb3b5, {0xeb, 0x82, 0xac}},
    {0xb3b6, {0xeb, 0x82, 0xad}},
    {0xb3b7, {0xeb, 0x82, 0xae}},
    {0xb3b8, {0xeb, 0x82, 0xaf}},
    {0xb3b9, {0xeb, 0x82, 0xb1}},
    {0xb3ba, {0xeb, 0x82, 0xb3}},
    {0xb3bb, {0xeb, 0x82, 0xb4}},
    {0xb3bc, {0xeb, 0x82, 0xb5}},
    {0xb3bd, {0xeb, 0x82, 0xb8}},
    {0xb3be, {0xeb, 0x82, 0xbc}},
    {0xb3bf, {0xeb, 0x83, 0x84}},
    {0xb3c0, {0xeb, 0x83, 0x85}},
    {0xb3c1, {0xeb, 0x83, 0x87}},
    {0xb3c2, {0xeb, 0x83, 0x88}},
    {0xb3c3, {0xeb, 0x83, 0x89}},
    {0xb3c4, {0xeb, 0x83, 0x90}},
    {0xb3c5, {0xeb, 0x83, 0x91}},
    {0xb3c6, {0xeb, 0x83, 0x94}},
    {0xb3c7, {0xeb, 0x83, 0x98}},
    {0xb3c8, {0xeb, 0x83, 0xa0}},
    {0xb3c9, {0xeb, 0x83, 0xa5}},
    {0xb3ca, {0xeb, 0x84, 0x88}},
    {0xb3cb, {0xeb, 0x84, 0x89}},
    {0xb3cc, {0xeb, 0x84, 0x8b}},
    {0xb3cd, {0xeb, 0x84, 0x8c}},
    {0xb3ce, {0xeb, 0x84, 0x90}},
    {0xb3cf, {0xeb, 0x84, 0x92}},
    {0xb3d0, {0xeb, 0x84, 0x93}},
    {0xb3d1, {0xeb, 0x84, 0x98}},
    {0xb3d2, {0xeb, 0x84, 0x99}},
    {0xb3d3, {0xeb, 0x84, 0x9b}},
    {0xb3d4, {0xeb, 0x84, 0x9c}},
    {0xb3d5, {0xeb, 0x84, 0x9d}},
    {0xb3d6, {0xeb, 0x84, 0xa3}},
    {0xb3d7, {0xeb, 0x84, 0xa4}},
    {0xb3d8, {0xeb, 0x84, 0xa5}},
    {0xb3d9, {0xeb, 0x84, 0xa8}},
    {0xb3da, {0xeb, 0x84, 0xac}},
    {0xb3db, {0xeb, 0x84, 0xb4}},
    {0xb3dc, {0xeb, 0x84, 0xb5}},
    {0xb3dd, {0xeb, 0x84, 0xb7}},
    {0xb3de, {0xeb, 0x84, 0xb8}},
    {0xb3df, {0xeb, 0x84, 0xb9}},
    {0xb3e0, {0xeb, 0x85, 0x80}},
    {0xb3e1, {0xeb, 0x85, 0x81}},
    {0xb3e2, {0xeb, 0x85, 0x84}},
    {0xb3e3, {0xeb, 0x85, 0x88}},
    {0xb3e4, {0xeb, 0x85, 0x90}},
    {0xb3e5, {0xeb, 0x85, 0x91}},
    {0xb3e6, {0xeb, 0x85, 0x94}},
    {0xb3e7, {0xeb, 0x85, 0x95}},
    {0xb3e8, {0xeb, 0x85, 0x98}},
    {0xb3e9, {0xeb, 0x85, 0x9c}},
    {0xb3ea, {0xeb, 0x85, 0xa0}},
    {0xb3eb, {0xeb, 0x85, 0xb8}},
    {0xb3ec, {0xeb, 0x85, 0xb9}},
    {0xb3ed, {0xeb, 0x85, 0xbc}},
    {0xb3ee, {0xeb, 0x86, 0x80}},
    {0xb3ef, {0xeb, 0x86, 0x82}},
    {0xb3f0, {0xeb, 0x86, 0x88}},
    {0xb3f1, {0xeb, 0x86, 0x89}},
    {0xb3f2, {0xeb, 0x86, 0x8b}},
    {0xb3f3, {0xeb, 0x86, 0x8d}},
    {0xb3f4, {0xeb, 0x86, 0x92}},
    {0xb3f5, {0xeb, 0x86, 0x93}},
    {0xb3f6, {0xeb, 0x86, 0x94}},
    {0xb3f7, {0xeb, 0x86, 0x98}},
    {0xb3f8, {0xeb, 0x86, 0x9c}},
    {0xb3f9, {0xeb, 0x86, 0xa8}},
    {0xb3fa, {0xeb, 0x87, 0x8c}},
    {0xb3fb, {0xeb, 0x87, 0x90}},
    {0xb3fc, {0xeb, 0x87, 0x94}},
    {0xb3fd, {0xeb, 0x87, 0x9c}},
    {0xb3fe, {0xeb, 0x87, 0x9d}},
    {0xb4a1, {0xeb, 0x87, 0x9f}},
    {0xb4a2, {0xeb, 0x87, 0xa8}},
    {0xb4a3, {0xeb, 0x87, 0xa9}},
    {0xb4a4, {0xeb, 0x87, 0xac}},
    {0xb4a5, {0xeb, 0x87, 0xb0}},
    {0xb4a6, {0xeb, 0x87, 0xb9}},
    {0xb4a7, {0xeb, 0x87, 0xbb}},
    {0xb4a8, {0xeb, 0x87, 0xbd}},
    {0xb4a9, {0xeb, 0x88, 0x84}},
    {0xb4aa, {0xeb, 0x88, 0x85}},
    {0xb4ab, {0xeb, 0x88, 0x88}},
    {0xb4ac, {0xeb, 0x88, 0x8b}},
    {0xb4ad, {0xeb, 0x88, 0x8c}},
    {0xb4ae, {0xeb, 0x88, 0x94}},
    {0xb4af, {0xeb, 0x88, 0x95}},
    {0xb4b0, {0xeb, 0x88, 0x97}},
    {0xb4b1, {0xeb, 0x88, 0x99}},
    {0xb4b2, {0xeb, 0x88, 0xa0}},
    {0xb4b3, {0xeb, 0x88, 0xb4}},
    {0xb4b4, {0xeb, 0x88, 0xbc}},
    {0xb4b5, {0xeb, 0x89, 0x98}},
    {0xb4b6, {0xeb, 0x89, 0x9c}},
    {0xb4b7, {0xeb, 0x89, 0xa0}},
    {0xb4b8, {0xeb, 0x89, 0xa8}},
    {0xb4b9, {0xeb, 0x89, 0xa9}},
    {0xb4ba, {0xeb, 0x89, 0xb4}},
    {0xb4bb, {0xeb, 0x89, 0xb5}},
    {0xb4bc, {0xeb, 0x89, 0xbc}},
    {0xb4bd, {0xeb, 0x8a, 0x84}},
    {0xb4be, {0xeb, 0x8a, 0x85}},
    {0xb4bf, {0xeb, 0x8a, 0x89}},
    {0xb4c0, {0xeb, 0x8a, 0x90}},
    {0xb4c1, {0xeb, 0x8a, 0x91}},
    {0xb4c2, {0xeb, 0x8a, 0x94}},
    {0xb4c3, {0xeb, 0x8a, 0x98}},
    {0xb4c4, {0xeb, 0x8a, 0x99}},
    {0xb4c5, {0xeb, 0x8a, 0x9a}},
    {0xb4c6, {0xeb, 0x8a, 0xa0}},
    {0xb4c7, {0xeb, 0x8a, 0xa1}},
    {0xb4c8, {0xeb, 0x8a, 0xa3}},
    {0xb4c9, {0xeb, 0x8a, 0xa5}},
    {0xb4ca, {0xeb, 0x8a, 0xa6}},
    {0xb4cb, {0xeb, 0x8a, 0xaa}},
    {0xb4cc, {0xeb, 0x8a, 0xac}},
    {0xb4cd, {0xeb, 0x8a, 0xb0}},
    {0xb4ce, {0xeb, 0x8a, 0xb4}},
    {0xb4cf, {0xeb, 0x8b, 0x88}},
    {0xb4d0, {0xeb, 0x8b, 0x89}},
    {0xb4d1, {0xeb, 0x8b, 0x8c}},
    {0xb4d2, {0xeb, 0x8b, 0x90}},
    {0xb4d3, {0xeb, 0x8b, 0x92}},
    {0xb4d4, {0xeb, 0x8b, 0x98}},
    {0xb4d5, {0xeb, 0x8b, 0x99}},
    {0xb4d6, {0xeb, 0x8b, 0x9b}},
    {0xb4d7, {0xeb, 0x8b, 0x9d}},
    {0xb4d8, {0xeb, 0x8b, 0xa2}},
    {0xb4d9, {0xeb, 0x8b, 0xa4}},
    {0xb4da, {0xeb, 0x8b, 0xa5}},
    {0xb4db, {0xeb, 0x8b, 0xa6}},
    {0xb4dc, {0xeb, 0x8b, 0xa8}},
    {0xb4dd, {0xeb, 0x8b, 0xab}},
    {0xb4de, {0xeb, 0x8b, 0xac}},
    {0xb4df, {0xeb, 0x8b, 0xad}},
    {0xb4e0, {0xeb, 0x8b, 0xae}},
    {0xb4e1, {0xeb, 0x8b, 0xaf}},
    {0xb4e2, {0xeb, 0x8b, 0xb3}},
    {0xb4e3, {0xeb, 0x8b, 0xb4}},
    {0xb4e4, {0xeb, 0x8b, 0xb5}},
    {0xb4e5, {0xeb, 0x8b, 0xb7}},
    {0xb4e6, {0xeb, 0x8b, 0xb8}},
    {0xb4e7, {0xeb, 0x8b, 0xb9}},
    {0xb4e8, {0xeb, 0x8b, 0xba}},
    {0xb4e9, {0xeb, 0x8b, 0xbb}},
    {0xb4ea, {0xeb, 0x8b, 0xbf}},
    {0xb4eb, {0xeb, 0x8c, 0x80}},
    {0xb4ec, {0xeb, 0x8c, 0x81}},
    {0xb4ed, {0xeb, 0x8c, 0x84}},
    {0xb4ee, {0xeb, 0x8c, 0x88}},
    {0xb4ef, {0xeb, 0x8c, 0x90}},
    {0xb4f0, {0xeb, 0x8c, 0x91}},
    {0xb4f1, {0xeb, 0x8c, 0x93}},
    {0xb4f2, {0xeb, 0x8c, 0x94}},
    {0xb4f3, {0xeb, 0x8c, 0x95}},
    {0xb4f4, {0xeb, 0x8c, 0x9c}},
    {0xb4f5, {0xeb, 0x8d, 0x94}},
    {0xb4f6, {0xeb, 0x8d, 0x95}},
    {0xb4f7, {0xeb, 0x8d, 0x96}},
    {0xb4f8, {0xeb, 0x8d, 0x98}},
    {0xb4f9, {0xeb, 0x8d, 0x9b}},
    {0xb4fa, {0xeb, 0x8d, 0x9c}},
    {0xb4fb, {0xeb, 0x8d, 0x9e}},
    {0xb4fc, {0xeb, 0x8d, 0x9f}},
    {0xb4fd, {0xeb, 0x8d, 0xa4}},
    {0xb4fe, {0xeb, 0x8d, 0xa5}},
    {0xb5a1, {0xeb, 0x8d, 0xa7}},
    {0xb5a2, {0xeb, 0x8d, 0xa9}},
    {0xb5a3, {0xeb, 0x8d, 0xab}},
    {0xb5a4, {0xeb, 0x8d, 0xae}},
    {0xb5a5, {0xeb, 0x8d, 0xb0}},
    {0xb5a6, {0xeb, 0x8d, 0xb1}},
    {0xb5a7, {0xeb, 0x8d, 0xb4}},
    {0xb5a8, {0xeb, 0x8d, 0xb8}},
    {0xb5a9, {0xeb, 0x8e, 0x80}},
    {0xb5aa, {0xeb, 0x8e, 0x81}},
    {0xb5ab, {0xeb, 0x8e, 0x83}},
    {0xb5ac, {0xeb, 0x8e, 0x84}},
    {0xb5ad, {0xeb, 0x8e, 0x85}},
    {0xb5ae, {0xeb, 0x8e, 0x8c}},
    {0xb5af, {0xeb, 0x8e, 0x90}},
    {0xb5b0, {0xeb, 0x8e, 0x94}},
    {0xb5b1, {0xeb, 0x8e, 0xa0}},
    {0xb5b2, {0xeb, 0x8e, 0xa1}},
    {0xb5b3, {0xeb, 0x8e, 0xa8}},
    {0xb5b4, {0xeb, 0x8e, 0xac}},
    {0xb5b5, {0xeb, 0x8f, 0x84}},
    {0xb5b6, {0xeb, 0x8f, 0x85}},
    {0xb5b7, {0xeb, 0x8f, 0x88}},
    {0xb5b8, {0xeb, 0x8f, 0x8b}},
    {0xb5b9, {0xeb, 0x8f, 0x8c}},
    {0xb5ba, {0xeb, 0x8f, 0x8e}},
    {0xb5bb, {0xeb, 0x8f, 0x90}},
    {0xb5bc, {0xeb, 0x8f, 0x94}},
    {0xb5bd, {0xeb, 0x8f, 0x95}},
    {0xb5be, {0xeb, 0x8f, 0x97}},
    {0xb5bf, {0xeb, 0x8f, 0x99}},
    {0xb5c0, {0xeb, 0x8f, 0x9b}},
    {0xb5c1, {0xeb, 0x8f, 0x9d}},
    {0xb5c2, {0xeb, 0x8f, 0xa0}},
    {0xb5c3, {0xeb, 0x8f, 0xa4}},
    {0xb5c4, {0xeb, 0x8f, 0xa8}},
    {0xb5c5, {0xeb, 0x8f, 0xbc}},
    {0xb5c6, {0xeb, 0x90, 0x90}},
    {0xb5c7, {0xeb, 0x90, 0x98}},
    {0xb5c8, {0xeb, 0x90, 0x9c}},
    {0xb5c9, {0xeb, 0x90, 0xa0}},
    {0xb5ca, {0xeb, 0x90, 0xa8}},
    {0xb5cb, {0xeb, 0x90, 0xa9}},
    {0xb5cc, {0xeb, 0x90, 0xab}},
    {0xb5cd, {0xeb, 0x90, 0xb4}},
    {0xb5ce, {0xeb, 0x91, 0x90}},
    {0xb5cf, {0xeb, 0x91, 0x91}},
    {0xb5d0, {0xeb, 0x91, 0x94}},
    {0xb5d1, {0xeb, 0x91, 0x98}},
    {0xb5d2, {0xeb, 0x91, 0xa0}},
    {0xb5d3, {0xeb, 0x91, 0xa1}},
    {0xb5d4, {0xeb, 0x91, 0xa3}},
    {0xb5d5, {0xeb, 0x91, 0xa5}},
    {0xb5d6, {0xeb, 0x91, 0xac}},
    {0xb5d7, {0xeb, 0x92, 0x80}},
    {0xb5d8, {0xeb, 0x92, 0x88}},
    {0xb5d9, {0xeb, 0x92, 0x9d}},
    {0xb5da, {0xeb, 0x92, 0xa4}},
    {0xb5db, {0xeb, 0x92, 0xa8}},
    {0xb5dc, {0xeb, 0x92, 0xac}},
    {0xb5dd, {0xeb, 0x92, 0xb5}},
    {0xb5de, {0xeb, 0x92, 0xb7}},
    {0xb5df, {0xeb, 0x92, 0xb9}},
    {0xb5e0, {0xeb, 0x93, 0x80}},
    {0xb5e1, {0xeb, 0x93, 0x84}},
    {0xb5e2, {0xeb, 0x93, 0x88}},
    {0xb5e3, {0xeb, 0x93, 0x90}},
    {0xb5e4, {0xeb, 0x93, 0x95}},
    {0xb5e5, {0xeb, 0x93, 0x9c}},
    {0xb5e6, {0xeb, 0x93, 0x9d}},
    {0xb5e7, {0xeb, 0x93, 0xa0}},
    {0xb5e8, {0xeb, 0x93, 0xa3}},
    {0xb5e9, {0xeb, 0x93, 0xa4}},
    {0xb5ea, {0xeb, 0x93, 0xa6}},
    {0xb5eb, {0xeb, 0x93, 0xac}},
    {0xb5ec, {0xeb, 0x93, 0xad}},
    {0xb5ed, {0xeb, 0x93, 0xaf}},
    {0xb5ee, {0xeb, 0x93, 0xb1}},
    {0xb5ef, {0xeb, 0x93, 0xb8}},
    {0xb5f0, {0xeb, 0x94, 0x94}},
    {0xb5f1, {0xeb, 0x94, 0x95}},
    {0xb5f2, {0xeb, 0x94, 0x98}},
    {0xb5f3, {0xeb, 0x94, 0x9b}},
    {0xb5f4, {0xeb, 0x94, 0x9c}},
    {0xb5f5, {0xeb, 0x94, 0xa4}},
    {0xb5f6, {0xeb, 0x94, 0xa5}},
    {0xb5f7, {0xeb, 0x94, 0xa7}},
    {0xb5f8, {0xeb, 0x94, 0xa8}},
    {0xb5f9, {0xeb, 0x94, 0xa9}},
    {0xb5fa, {0xeb, 0x94, 0xaa}},
    {0xb5fb, {0xeb, 0x94, 0xb0}},
    {0xb5fc, {0xeb, 0x94, 0xb1}},
    {0xb5fd, {0xeb, 0x94, 0xb4}},
    {0xb5fe, {0xeb, 0x94, 0xb8}},
    {0xb6a1, {0xeb, 0x95, 0x80}},
    {0xb6a2, {0xeb, 0x95, 0x81}},
    {0xb6a3, {0xeb, 0x95, 0x83}},
    {0xb6a4, {0xeb, 0x95, 0x84}},
    {0xb6a5, {0xeb, 0x95, 0x85}},
    {0xb6a6, {0xeb, 0x95, 0x8b}},
    {0xb6a7, {0xeb, 0x95, 0x8c}},
    {0xb6a8, {0xeb, 0x95, 0x8d}},
    {0xb6a9, {0xeb, 0x95, 0x90}},
    {0xb6aa, {0xeb, 0x95, 0x94}},
    {0xb6ab, {0xeb, 0x95, 0x9c}},
    {0xb6ac, {0xeb, 0x95, 0x9d}},
    {0xb6ad, {0xeb, 0x95, 0x9f}},
    {0xb6ae, {0xeb, 0x95, 0xa0}},
    {0xb6af, {0xeb, 0x95, 0xa1}},
    {0xb6b0, {0xeb, 0x96, 0xa0}},
    {0xb6b1, {0xeb, 0x96, 0xa1}},
    {0xb6b2, {0xeb, 0x96, 0xa4}},
    {0xb6b3, {0xeb, 0x96, 0xa8}},
    {0xb6b4, {0xeb, 0x96, 0xaa}},
    {0xb6b5, {0xeb, 0x96, 0xab}},
    {0xb6b6, {0xeb, 0x96, 0xb0}},
    {0xb6b7, {0xeb, 0x96, 0xb1}},
    {0xb6b8, {0xeb, 0x96, 0xb3}},
    {0xb6b9, {0xeb, 0x96, 0xb4}},
    {0xb6ba, {0xeb, 0x96, 0xb5}},
    {0xb6bb, {0xeb, 0x96, 0xbb}},
    {0xb6bc, {0xeb, 0x96, 0xbc}},
    {0xb6bd, {0xeb, 0x96, 0xbd}},
    {0xb6be, {0xeb, 0x97, 0x80}},
    {0xb6bf, {0xeb, 0x97, 0x84}},
    {0xb6c0, {0xeb, 0x97, 0x8c}},
    {0xb6c1, {0xeb, 0x97, 0x8d}},
    {0xb6c2, {0xeb, 0x97, 0x8f}},
    {0xb6c3, {0xeb, 0x97, 0x90}},
    {0xb6c4, {0xeb, 0x97, 0x91}},
    {0xb6c5, {0xeb, 0x97, 0x98}},
    {0xb6c6, {0xeb, 0x97, 0xac}},
    {0xb6c7, {0xeb, 0x98, 0x90}},
    {0xb6c8, {0xeb, 0x98, 0x91}},
    {0xb6c9, {0xeb, 0x98, 0x94}},
    {0xb6ca, {0xeb, 0x98, 0x98}},
    {0xb6cb, {0xeb, 0x98, 0xa5}},
    {0xb6cc, {0xeb, 0x98, 0xac}},
    {0xb6cd, {0xeb, 0x98, 0xb4}},
    {0xb6ce, {0xeb, 0x99, 0x88}},
    {0xb6cf, {0xeb, 0x99, 0xa4}},
    {0xb6d0, {0xeb, 0x99, 0xa8}},
    {0xb6d1, {0xeb, 0x9a, 0x9c}},
    {0xb6d2, {0xeb, 0x9a, 0x9d}},
    {0xb6d3, {0xeb, 0x9a, 0xa0}},
    {0xb6d4, {0xeb, 0x9a, 0xa4}},
    {0xb6d5, {0xeb, 0x9a, 0xab}},
    {0xb6d6, {0xeb, 0x9a, 0xac}},
    {0xb6d7, {0xeb, 0x9a, 0xb1}},
    {0xb6d8, {0xeb, 0x9b, 0x94}},
    {0xb6d9, {0xeb, 0x9b, 0xb0}},
    {0xb6da, {0xeb, 0x9b, 0xb4}},
    {0xb6db, {0xeb, 0x9b, 0xb8}},
    {0xb6dc, {0xeb, 0x9c, 0x80}},
    {0xb6dd, {0xeb, 0x9c, 0x81}},
    {0xb6de, {0xeb, 0x9c, 0x85}},
    {0xb6df, {0xeb, 0x9c, 0xa8}},
    {0xb6e0, {0xeb, 0x9c, 0xa9}},
    {0xb6e1, {0xeb, 0x9c, 0xac}},
    {0xb6e2, {0xeb, 0x9c, 0xaf}},
    {0xb6e3, {0xeb, 0x9c, 0xb0}},
    {0xb6e4, {0xeb, 0x9c, 0xb8}},
    {0xb6e5, {0xeb, 0x9c, 0xb9}},
    {0xb6e6, {0xeb, 0x9c, 0xbb}},
    {0xb6e7, {0xeb, 0x9d, 0x84}},
    {0xb6e8, {0xeb, 0x9d, 0x88}},
    {0xb6e9, {0xeb, 0x9d, 0x8c}},
    {0xb6ea, {0xeb, 0x9d, 0x94}},
    {0xb6eb, {0xeb, 0x9d, 0x95}},
    {0xb6ec, {0xeb, 0x9d, 0xa0}},
    {0xb6ed, {0xeb, 0x9d, 0xa4}},
    {0xb6ee, {0xeb, 0x9d, 0xa8}},
    {0xb6ef, {0xeb, 0x9d, 0xb0}},
    {0xb6f0, {0xeb, 0x9d, 0xb1}},
    {0xb6f1, {0xeb, 0x9d, 0xb3}},
    {0xb6f2, {0xeb, 0x9d, 0xb5}},
    {0xb6f3, {0xeb, 0x9d, 0xbc}},
    {0xb6f4, {0xeb, 0x9d, 0xbd}},
    {0xb6f5, {0xeb, 0x9e, 0x80}},
    {0xb6f6, {0xeb, 0x9e, 0x84}},
    {0xb6f7, {0xeb, 0x9e, 0x8c}},
    {0xb6f8, {0xeb, 0x9e, 0x8d}},
    {0xb6f9, {0xeb, 0x9e, 0x8f}},
    {0xb6fa, {0xeb, 0x9e, 0x90}},
    {0xb6fb, {0xeb, 0x9e, 0x91}},
    {0xb6fc, {0xeb, 0x9e, 0x92}},
    {0xb6fd, {0xeb, 0x9e, 0x96}},
    {0xb6fe, {0xeb, 0x9e, 0x97}},
    {0xb7a1, {0xeb, 0x9e, 0x98}},
    {0xb7a2, {0xeb, 0x9e, 0x99}},
    {0xb7a3, {0xeb, 0x9e, 0x9c}},
    {0xb7a4, {0xeb, 0x9e, 0xa0}},
    {0xb7a5, {0xeb, 0x9e, 0xa8}},
    {0xb7a6, {0xeb, 0x9e, 0xa9}},
    {0xb7a7, {0xeb, 0x9e, 0xab}},
    {0xb7a8, {0xeb, 0x9e, 0xac}},
    {0xb7a9, {0xeb, 0x9e, 0xad}},
    {0xb7aa, {0xeb, 0x9e, 0xb4}},
    {0xb7ab, {0xeb, 0x9e, 0xb5}},
    {0xb7ac, {0xeb, 0x9e, 0xb8}},
    {0xb7ad, {0xeb, 0x9f, 0x87}},
    {0xb7ae, {0xeb, 0x9f, 0x89}},
    {0xb7af, {0xeb, 0x9f, 0xac}},
    {0xb7b0, {0xeb, 0x9f, 0xad}},
    {0xb7b1, {0xeb, 0x9f, 0xb0}},
    {0xb7b2, {0xeb, 0x9f, 0xb4}},
    {0xb7b3, {0xeb, 0x9f, 0xbc}},
    {0xb7b4, {0xeb, 0x9f, 0xbd}},
    {0xb7b5, {0xeb, 0x9f, 0xbf}},
    {0xb7b6, {0xeb, 0xa0, 0x80}},
    {0xb7b7, {0xeb, 0xa0, 0x81}},
    {0xb7b8, {0xeb, 0xa0, 0x87}},
    {0xb7b9, {0xeb, 0xa0, 0x88}},
    {0xb7ba, {0xeb, 0xa0, 0x89}},
    {0xb7bb, {0xeb, 0xa0, 0x8c}},
    {0xb7bc, {0xeb, 0xa0, 0x90}},
    {0xb7bd, {0xeb, 0xa0, 0x98}},
    {0xb7be, {0xeb, 0xa0, 0x99}},
    {0xb7bf, {0xeb, 0xa0, 0x9b}},
    {0xb7c0, {0xeb, 0xa0, 0x9d}},
    {0xb7c1, {0xeb, 0xa0, 0xa4}},
    {0xb7c2, {0xeb, 0xa0, 0xa5}},
    {0xb7c3, {0xeb, 0xa0, 0xa8}},
    {0xb7c4, {0xeb, 0xa0, 0xac}},
    {0xb7c5, {0xeb, 0xa0, 0xb4}},
    {0xb7c6, {0xeb, 0xa0, 0xb5}},
    {0xb7c7, {0xeb, 0xa0, 0xb7}},
    {0xb7c8, {0xeb, 0xa0, 0xb8}},
    {0xb7c9, {0xeb, 0xa0, 0xb9}},
    {0xb7ca, {0xeb, 0xa1, 0x80}},
    {0xb7cb, {0xeb, 0xa1, 0x84}},
    {0xb7cc, {0xeb, 0xa1, 0x91}},
    {0xb7cd, {0xeb, 0xa1, 0x93}},
    {0xb7ce, {0xeb, 0xa1, 0x9c}},
    {0xb7cf, {0xeb, 0xa1, 0x9d}},
    {0xb7d0, {0xeb, 0xa1, 0xa0}},
    {0xb7d1, {0xeb, 0xa1, 0xa4}},
    {0xb7d2, {0xeb, 0xa1, 0xac}},
    {0xb7d3, {0xeb, 0xa1, 0xad}},
    {0xb7d4, {0xeb, 0xa1, 0xaf}},
    {0xb7d5, {0xeb, 0xa1, 0xb1}},
    {0xb7d6, {0xeb, 0xa1, 0xb8}},
    {0xb7d7, {0xeb, 0xa1, 0xbc}},
    {0xb7d8, {0xeb, 0xa2, 0x8d}},
    {0xb7d9, {0xeb, 0xa2, 0xa8}},
    {0xb7da, {0xeb, 0xa2, 0xb0}},
    {0xb7db, {0xeb, 0xa2, 0xb4}},
    {0xb7dc, {0xeb, 0xa2, 0xb8}},
    {0xb7dd, {0xeb, 0xa3, 0x80}},
    {0xb7de, {0xeb, 0xa3, 0x81}},
    {0xb7df, {0xeb, 0xa3, 0x83}},
    {0xb7e0, {0xeb, 0xa3, 0x85}},
    {0xb7e1, {0xeb, 0xa3, 0x8c}},
    {0xb7e2, {0xeb, 0xa3, 0x90}},
    {0xb7e3, {0xeb, 0xa3, 0x94}},
    {0xb7e4, {0xeb, 0xa3, 0x9d}},
    {0xb7e5, {0xeb, 0xa3, 0x9f}},
    {0xb7e6, {0xeb, 0xa3, 0xa1}},
    {0xb7e7, {0xeb, 0xa3, 0xa8}},
    {0xb7e8, {0xeb, 0xa3, 0xa9}},
    {0xb7e9, {0xeb, 0xa3, 0xac}},
    {0xb7ea, {0xeb, 0xa3, 0xb0}},
    {0xb7eb, {0xeb, 0xa3, 0xb8}},
    {0xb7ec, {0xeb, 0xa3, 0xb9}},
    {0xb7ed, {0xeb, 0xa3, 0xbb}},
    {0xb7ee, {0xeb, 0xa3, 0xbd}},
    {0xb7ef, {0xeb, 0xa4, 0x84}},
    {0xb7f0, {0xeb, 0xa4, 0x98}},
    {0xb7f1, {0xeb, 0xa4, 0xa0}},
    {0xb7f2, {0xeb, 0xa4, 0xbc}},
    {0xb7f3, {0xeb, 0xa4, 0xbd}},
    {0xb7f4, {0xeb, 0xa5, 0x80}},
    {0xb7f5, {0xeb, 0xa5, 0x84}},
    {0xb7f6, {0xeb, 0xa5, 0x8c}},
    {0xb7f7, {0xeb, 0xa5, 0x8f}},
    {0xb7f8, {0xeb, 0xa5, 0x91}},
    {0xb7f9, {0xeb, 0xa5, 0x98}},
    {0xb7fa, {0xeb, 0xa5, 0x99}},
    {0xb7fb, {0xeb, 0xa5, 0x9c}},
    {0xb7fc, {0xeb, 0xa5, 0xa0}},
    {0xb7fd, {0xeb, 0xa5, 0xa8}},
    {0xb7fe, {0xeb, 0xa5, 0xa9}},
    {0xb8a1, {0xeb, 0xa5, 0xab}},
    {0xb8a2, {0xeb, 0xa5, 0xad}},
    {0xb8a3, {0xeb, 0xa5, 0xb4}},
    {0xb8a4, {0xeb, 0xa5, 0xb5}},
    {0xb8a5, {0xeb, 0xa5, 0xb8}},
    {0xb8a6, {0xeb, 0xa5, 0xbc}},
    {0xb8a7, {0xeb, 0xa6, 0x84}},
    {0xb8a8, {0xeb, 0xa6, 0x85}},
    {0xb8a9, {0xeb, 0xa6, 0x87}},
    {0xb8aa, {0xeb, 0xa6, 0x89}},
    {0xb8ab, {0xeb, 0xa6, 0x8a}},
    {0xb8ac, {0xeb, 0xa6, 0x8d}},
    {0xb8ad, {0xeb, 0xa6, 0x8e}},
    {0xb8ae, {0xeb, 0xa6, 0xac}},
    {0xb8af, {0xeb, 0xa6, 0xad}},
    {0xb8b0, {0xeb, 0xa6, 0xb0}},
    {0xb8b1, {0xeb, 0xa6, 0xb4}},
    {0xb8b2, {0xeb, 0xa6, 0xbc}},
    {0xb8b3, {0xeb, 0xa6, 0xbd}},
    {0xb8b4, {0xeb, 0xa6, 0xbf}},
    {0xb8b5, {0xeb, 0xa7, 0x81}},
    {0xb8b6, {0xeb, 0xa7, 0x88}},
    {0xb8b7, {0xeb, 0xa7, 0x89}},
    {0xb8b8, {0xeb, 0xa7, 0x8c}},
    {0xb8b9, {0xeb, 0xa7, 0x8e}},
    {0xb8ba, {0xeb, 0xa7, 0x8f}},
    {0xb8bb, {0xeb, 0xa7, 0x90}},
    {0xb8bc, {0xeb, 0xa7, 0x91}},
    {0xb8bd, {0xeb, 0xa7, 0x92}},
    {0xb8be, {0xeb, 0xa7, 0x98}},
    {0xb8bf, {0xeb, 0xa7, 0x99}},
    {0xb8c0, {0xeb, 0xa7, 0x9b}},
    {0xb8c1, {0xeb, 0xa7, 0x9d}},
    {0xb8c2, {0xeb, 0xa7, 0x9e}},
    {0xb8c3, {0xeb, 0xa7, 0xa1}},
    {0xb8c4, {0xeb, 0xa7, 0xa3}},
    {0xb8c5, {0xeb, 0xa7, 0xa4}},
    {0xb8c6, {0xeb, 0xa7, 0xa5}},
    {0xb8c7, {0xeb, 0xa7, 0xa8}},
    {0xb8c8, {0xeb, 0xa7, 0xac}},
    {0xb8c9, {0xeb, 0xa7, 0xb4}},
    {0xb8ca, {0xeb, 0xa7, 0xb5}},
    {0xb8cb, {0xeb, 0xa7, 0xb7}},
    {0xb8cc, {0xeb, 0xa7, 0xb8}},
    {0xb8cd, {0xeb, 0xa7, 0xb9}},
    {0xb8ce, {0xeb, 0xa7, 0xba}},
    {0xb8cf, {0xeb, 0xa8, 0x80}},
    {0xb8d0, {0xeb, 0xa8, 0x81}},
    {0xb8d1, {0xeb, 0xa8, 0x88}},
    {0xb8d2, {0xeb, 0xa8, 0x95}},
    {0xb8d3, {0xeb, 0xa8, 0xb8}},
    {0xb8d4, {0xeb, 0xa8, 0xb9}},
    {0xb8d5, {0xeb, 0xa8, 0xbc}},
    {0xb8d6, {0xeb, 0xa9, 0x80}},
    {0xb8d7, {0xeb, 0xa9, 0x82}},
    {0xb8d8, {0xeb, 0xa9, 0x88}},
    {0xb8d9, {0xeb, 0xa9, 0x89}},
    {0xb8da, {0xeb, 0xa9, 0x8b}},
    {0xb8db, {0xeb, 0xa9, 0x8d}},
    {0xb8dc, {0xeb, 0xa9, 0x8e}},
    {0xb8dd, {0xeb, 0xa9, 0x93}},
    {0xb8de, {0xeb, 0xa9, 0x94}},
    {0xb8df, {0xeb, 0xa9, 0x95}},
    {0xb8e0, {0xeb, 0xa9, 0x98}},
    {0xb8e1, {0xeb, 0xa9, 0x9c}},
    {0xb8e2, {0xeb, 0xa9, 0xa4}},
    {0xb8e3, {0xeb, 0xa9, 0xa5}},
    {0xb8e4, {0xeb, 0xa9, 0xa7}},
    {0xb8e5, {0xeb, 0xa9, 0xa8}},
    {0xb8e6, {0xeb, 0xa9, 0xa9}},
    {0xb8e7, {0xeb, 0xa9, 0xb0}},
    {0xb8e8, {0xeb, 0xa9, 0xb1}},
    {0xb8e9, {0xeb, 0xa9, 0xb4}},
    {0xb8ea, {0xeb, 0xa9, 0xb8}},
    {0xb8eb, {0xeb, 0xaa, 0x83}},
    {0xb8ec, {0xeb, 0xaa, 0x84}},
    {0xb8ed, {0xeb, 0xaa, 0x85}},
    {0xb8ee, {0xeb, 0xaa, 0x87}},
    {0xb8ef, {0xeb, 0xaa, 0x8c}},
    {0xb8f0, {0xeb, 0xaa, 0xa8}},
    {0xb8f1, {0xeb, 0xaa, 0xa9}},
    {0xb8f2, {0xeb, 0xaa, 0xab}},
    {0xb8f3, {0xeb, 0xaa, 0xac}},
    {0xb8f4, {0xeb, 0xaa, 0xb0}},
    {0xb8f5, {0xeb, 0xaa, 0xb2}},
    {0xb8f6, {0xeb, 0xaa, 0xb8}},
    {0xb8f7, {0xeb, 0xaa, 0xb9}},
    {0xb8f8, {0xeb, 0xaa, 0xbb}},
    {0xb8f9, {0xeb, 0xaa, 0xbd}},
    {0xb8fa, {0xeb, 0xab, 0x84}},
    {0xb8fb, {0xeb, 0xab, 0x88}},
    {0xb8fc, {0xeb, 0xab, 0x98}},
    {0xb8fd, {0xeb, 0xab, 0x99}},
    {0xb8fe, {0xeb, 0xab, 0xbc}},
    {0xb9a1, {0xeb, 0xac, 0x80}},
    {0xb9a2, {0xeb, 0xac, 0x84}},
    {0xb9a3, {0xeb, 0xac, 0x8d}},
    {0xb9a4, {0xeb, 0xac, 0x8f}},
    {0xb9a5, {0xeb, 0xac, 0x91}},
    {0xb9a6, {0xeb, 0xac, 0x98}},
    {0xb9a7, {0xeb, 0xac, 0x9c}},
    {0xb9a8, {0xeb, 0xac, 0xa0}},
    {0xb9a9, {0xeb, 0xac, 0xa9}},
    {0xb9aa, {0xeb, 0xac, 0xab}},
    {0xb9ab, {0xeb, 0xac, 0xb4}},
    {0xb9ac, {0xeb, 0xac, 0xb5}},
    {0xb9ad, {0xeb, 0xac, 0xb6}},
    {0xb9ae, {0xeb, 0xac, 0xb8}},
    {0xb9af, {0xeb, 0xac, 0xbb}},
    {0xb9b0, {0xeb, 0xac, 0xbc}},
    {0xb9b1, {0xeb, 0xac, 0xbd}},
    {0xb9b2, {0xeb, 0xac, 0xbe}},
    {0xb9b3, {0xeb, 0xad, 0x84}},
    {0xb9b4, {0xeb, 0xad, 0x85}},
    {0xb9b5, {0xeb, 0xad, 0x87}},
    {0xb9b6, {0xeb, 0xad, 0x89}},
    {0xb9b7, {0xeb, 0xad, 0x8d}},
    {0xb9b8, {0xeb, 0xad, 0x8f}},
    {0xb9b9, {0xeb, 0xad, 0x90}},
    {0xb9ba, {0xeb, 0xad, 0x94}},
    {0xb9bb, {0xeb, 0xad, 0x98}},
    {0xb9bc, {0xeb, 0xad, 0xa1}},
    {0xb9bd, {0xeb, 0xad, 0xa3}},
    {0xb9be, {0xeb, 0xad, 0xac}},
    {0xb9bf, {0xeb, 0xae, 0x88}},
    {0xb9c0, {0xeb, 0xae, 0x8c}},
    {0xb9c1, {0xeb, 0xae, 0x90}},
    {0xb9c2, {0xeb, 0xae, 0xa4}},
    {0xb9c3, {0xeb, 0xae, 0xa8}},
    {0xb9c4, {0xeb, 0xae, 0xac}},
    {0xb9c5, {0xeb, 0xae, 0xb4}},
    {0xb9c6, {0xeb, 0xae, 0xb7}},
    {0xb9c7, {0xeb, 0xaf, 0x80}},
    {0xb9c8, {0xeb, 0xaf, 0x84}},
    {0xb9c9, {0xeb, 0xaf, 0x88}},
    {0xb9ca, {0xeb, 0xaf, 0x90}},
    {0xb9cb, {0xeb, 0xaf, 0x93}},
    {0xb9cc, {0xeb, 0xaf, 0xb8}},
    {0xb9cd, {0xeb, 0xaf, 0xb9}},
    {0xb9ce, {0xeb, 0xaf, 0xbc}},
    {0xb9cf, {0xeb, 0xaf, 0xbf}},
    {0xb9d0, {0xeb, 0xb0, 0x80}},
    {0xb9d1, {0xeb, 0xb0, 0x82}},
    {0xb9d2, {0xeb, 0xb0, 0x88}},
    {0xb9d3, {0xeb, 0xb0, 0x89}},
    {0xb9d4, {0xeb, 0xb0, 0x8b}},
    {0xb9d5, {0xeb, 0xb0, 0x8c}},
    {0xb9d6, {0xeb, 0xb0, 0x8d}},
    {0xb9d7, {0xeb, 0xb0, 0x8f}},
    {0xb9d8, {0xeb, 0xb0, 0x91}},
    {0xb9d9, {0xeb, 0xb0, 0x94}},
    {0xb9da, {0xeb, 0xb0, 0x95}},
    {0xb9db, {0xeb, 0xb0, 0x96}},
    {0xb9dc, {0xeb, 0xb0, 0x97}},
    {0xb9dd, {0xeb, 0xb0, 0x98}},
    {0xb9de, {0xeb, 0xb0, 0x9b}},
    {0xb9df, {0xeb, 0xb0, 0x9c}},
    {0xb9e0, {0xeb, 0xb0, 0x9d}},
    {0xb9e1, {0xeb, 0xb0, 0x9e}},
    {0xb9e2, {0xeb, 0xb0, 0x9f}},
    {0xb9e3, {0xeb, 0xb0, 0xa4}},
    {0xb9e4, {0xeb, 0xb0, 0xa5}},
    {0xb9e5, {0xeb, 0xb0, 0xa7}},
    {0xb9e6, {0xeb, 0xb0, 0xa9}},
    {0xb9e7, {0xeb, 0xb0, 0xad}},
    {0xb9e8, {0xeb, 0xb0, 0xb0}},
    {0xb9e9, {0xeb, 0xb0, 0xb1}},
    {0xb9ea, {0xeb, 0xb0, 0xb4}},
    {0xb9eb, {0xeb, 0xb0, 0xb8}},
    {0xb9ec, {0xeb, 0xb1, 0x80}},
    {0xb9ed, {0xeb, 0xb1, 0x81}},
    {0xb9ee, {0xeb, 0xb1, 0x83}},
    {0xb9ef, {0xeb, 0xb1, 0x84}},
    {0xb9f0, {0xeb, 0xb1, 0x85}},
    {0xb9f1, {0xeb, 0xb1, 0x89}},
    {0xb9f2, {0xeb, 0xb1, 0x8c}},
    {0xb9f3, {0xeb, 0xb1, 0x8d}},
    {0xb9f4, {0xeb, 0xb1, 0x90}},
    {0xb9f5, {0xeb, 0xb1, 0x9d}},
    {0xb9f6, {0xeb, 0xb2, 0x84}},
    {0xb9f7, {0xeb, 0xb2, 0x85}},
    {0xb9f8, {0xeb, 0xb2, 0x88}},
    {0xb9f9, {0xeb, 0xb2, 0x8b}},
    {0xb9fa, {0xeb, 0xb2, 0x8c}},
    {0xb9fb, {0xeb, 0xb2, 0x8e}},
    {0xb9fc, {0xeb, 0xb2, 0x94}},
    {0xb9fd, {0xeb, 0xb2, 0x95}},
    {0xb9fe, {0xeb, 0xb2, 0x97}},
    {0xbaa1, {0xeb, 0xb2, 0x99}},
    {0xbaa2, {0xeb, 0xb2, 0x9a}},
    {0xbaa3, {0xeb, 0xb2, 0xa0}},
    {0xbaa4, {0xeb, 0xb2, 0xa1}},
    {0xbaa5, {0xeb, 0xb2, 0xa4}},
    {0xbaa6, {0xeb, 0xb2, 0xa7}},
    {0xbaa7, {0xeb, 0xb2, 0xa8}},
    {0xbaa8, {0xeb, 0xb2, 0xb0}},
    {0xbaa9, {0xeb, 0xb2, 0xb1}},
    {0xbaaa, {0xeb, 0xb2, 0xb3}},
    {0xbaab, {0xeb, 0xb2, 0xb4}},
    {0xbaac, {0xeb, 0xb2, 0xb5}},
    {0xbaad, {0xeb, 0xb2, 0xbc}},
    {0xbaae, {0xeb, 0xb2, 0xbd}},
    {0xbaaf, {0xeb, 0xb3, 0x80}},
    {0xbab0, {0xeb, 0xb3, 0x84}},
    {0xbab1, {0xeb, 0xb3, 0x8d}},
    {0xbab2, {0xeb, 0xb3, 0x8f}},
    {0xbab3, {0xeb, 0xb3, 0x90}},
    {0xbab4, {0xeb, 0xb3, 0x91}},
    {0xbab5, {0xeb, 0xb3, 0x95}},
    {0xbab6, {0xeb, 0xb3, 0x98}},
    {0xbab7, {0xeb, 0xb3, 0x9c}},
    {0xbab8, {0xeb, 0xb3, 0xb4}},
    {0xbab9, {0xeb, 0xb3, 0xb5}},
    {0xbaba, {0xeb, 0xb3, 0xb6}},
    {0xbabb, {0xeb, 0xb3, 0xb8}},
    {0xbabc, {0xeb, 0xb3, 0xbc}},
    {0xbabd, {0xeb, 0xb4, 0x84}},
    {0xbabe, {0xeb, 0xb4, 0x85}},
    {0xbabf, {0xeb, 0xb4, 0x87}},
    {0xbac0, {0xeb, 0xb4, 0x89}},
    {0xbac1, {0xeb, 0xb4, 0x90}},
    {0xbac2, {0xeb, 0xb4, 0x94}},
    {0xbac3, {0xeb, 0xb4, 0xa4}},
    {0xbac4, {0xeb, 0xb4, 0xac}},
    {0xbac5, {0xeb, 0xb5, 0x80}},
    {0xbac6, {0xeb, 0xb5, 0x88}},
    {0xbac7, {0xeb, 0xb5, 0x89}},
    {0xbac8, {0xeb, 0xb5, 0x8c}},
    {0xbac9, {0xeb, 0xb5, 0x90}},
    {0xbaca, {0xeb, 0xb5, 0x98}},
    {0xbacb, {0xeb, 0xb5, 0x99}},
    {0xbacc, {0xeb, 0xb5, 0xa4}},
    {0xbacd, {0xeb, 0xb5, 0xa8}},
    {0xbace, {0xeb, 0xb6, 0x80}},
    {0xbacf, {0xeb, 0xb6, 0x81}},
    {0xbad0, {0xeb, 0xb6, 0x84}},
    {0xbad1, {0xeb, 0xb6, 0x87}},
    {0xbad2, {0xeb, 0xb6, 0x88}},
    {0xbad3, {0xeb, 0xb6, 0x89}},
    {0xbad4, {0xeb, 0xb6, 0x8a}},
    {0xbad5, {0xeb, 0xb6, 0x90}},
    {0xbad6, {0xeb, 0xb6, 0x91}},
    {0xbad7, {0xeb, 0xb6, 0x93}},
    {0xbad8, {0xeb, 0xb6, 0x95}},
    {0xbad9, {0xeb, 0xb6, 0x99}},
    {0xbada, {0xeb, 0xb6, 0x9a}},
    {0xbadb, {0xeb, 0xb6, 0x9c}},
    {0xbadc, {0xeb, 0xb6, 0xa4}},
    {0xbadd, {0xeb, 0xb6, 0xb0}},
    {0xbade, {0xeb, 0xb6, 0xb8}},
    {0xbadf, {0xeb, 0xb7, 0x94}},
    {0xbae0, {0xeb, 0xb7, 0x95}},
    {0xbae1, {0xeb, 0xb7, 0x98}},
    {0xbae2, {0xeb, 0xb7, 0x9c}},
    {0xbae3, {0xeb, 0xb7, 0xa9}},
    {0xbae4, {0xeb, 0xb7, 0xb0}},
    {0xbae5, {0xeb, 0xb7, 0xb4}},
    {0xbae6, {0xeb, 0xb7, 0xb8}},
    {0xbae7, {0xeb, 0xb8, 0x80}},
    {0xbae8, {0xeb, 0xb8, 0x83}},
    {0xbae9, {0xeb, 0xb8, 0x85}},
    {0xbaea, {0xeb, 0xb8, 0x8c}},
    {0xbaeb, {0xeb, 0xb8, 0x8d}},
    {0xbaec, {0xeb, 0xb8, 0x90}},
    {0xbaed, {0xeb, 0xb8, 0x94}},
    {0xbaee, {0xeb, 0xb8, 0x9c}},
    {0xbaef, {0xeb, 0xb8, 0x9d}},
    {0xbaf0, {0xeb, 0xb8, 0x9f}},
    {0xbaf1, {0xeb, 0xb9, 0x84}},
    {0xbaf2, {0xeb, 0xb9, 0x85}},
    {0xbaf3, {0xeb, 0xb9, 0x88}},
    {0xbaf4, {0xeb, 0xb9, 0x8c}},
    {0xbaf5, {0xeb, 0xb9, 0x8e}},
    {0xbaf6, {0xeb, 0xb9, 0x94}},
    {0xbaf7, {0xeb, 0xb9, 0x95}},
    {0xbaf8, {0xeb, 0xb9, 0x97}},
    {0xbaf9, {0xeb, 0xb9, 0x99}},
    {0xbafa, {0xeb, 0xb9, 0x9a}},
    {0xbafb, {0xeb, 0xb9, 0x9b}},
    {0xbafc, {0xeb, 0xb9, 0xa0}},
    {0xbafd, {0xeb, 0xb9, 0xa1}},
    {0xbafe, {0xeb, 0xb9, 0xa4}},
    {0xbba1, {0xeb, 0xb9, 0xa8}},
    {0xbba2, {0xeb, 0xb9, 0xaa}},
    {0xbba3, {0xeb, 0xb9, 0xb0}},
    {0xbba4, {0xeb, 0xb9, 0xb1}},
    {0xbba5, {0xeb, 0xb9, 0xb3}},
    {0xbba6, {0xeb, 0xb9, 0xb4}},
    {0xbba7, {0xeb, 0xb9, 0xb5}},
    {0xbba8, {0xeb, 0xb9, 0xbb}},
    {0xbba9, {0xeb, 0xb9, 0xbc}},
    {0xbbaa, {0xeb, 0xb9, 0xbd}},
    {0xbbab, {0xeb, 0xba, 0x80}},
    {0xbbac, {0xeb, 0xba, 0x84}},
    {0xbbad, {0xeb, 0xba, 0x8c}},
    {0xbbae, {0xeb, 0xba, 0x8d}},
    {0xbbaf, {0xeb, 0xba, 0x8f}},
    {0xbbb0, {0xeb, 0xba, 0x90}},
    {0xbbb1, {0xeb, 0xba, 0x91}},
    {0xbbb2, {0xeb, 0xba, 0x98}},
    {0xbbb3, {0xeb, 0xba, 0x99}},
    {0xbbb4, {0xeb, 0xba, 0xa8}},
    {0xbbb5, {0xeb, 0xbb, 0x90}},
    {0xbbb6, {0xeb, 0xbb, 0x91}},
    {0xbbb7, {0xeb, 0xbb, 0x94}},
    {0xbbb8, {0xeb, 0xbb, 0x97}},
    {0xbbb9, {0xeb, 0xbb, 0x98}},
    {0xbbba, {0xeb, 0xbb, 0xa0}},
    {0xbbbb, {0xeb, 0xbb, 0xa3}},
    {0xbbbc, {0xeb, 0xbb, 0xa4}},
    {0xbbbd, {0xeb, 0xbb, 0xa5}},
    {0xbbbe, {0xeb, 0xbb, 0xac}},
    {0xbbbf, {0xeb, 0xbc, 0x81}},
    {0xbbc0, {0xeb, 0xbc, 0x88}},
    {0xbbc1, {0xeb, 0xbc, 0x89}},
    {0xbbc2, {0xeb, 0xbc, 0x98}},
    {0xbbc3, {0xeb, 0xbc, 0x99}},
    {0xbbc4, {0xeb, 0xbc, 0x9b}},
    {0xbbc5, {0xeb, 0xbc, 0x9c}},
    {0xbbc6, {0xeb, 0xbc, 0x9d}},
    {0xbbc7, {0xeb, 0xbd, 0x80}},
    {0xbbc8, {0xeb, 0xbd, 0x81}},
    {0xbbc9, {0xeb, 0xbd, 0x84}},
    {0xbbca, {0xeb, 0xbd, 0x88}},
    {0xbbcb, {0xeb, 0xbd, 0x90}},
    {0xbbcc, {0xeb, 0xbd, 0x91}},
    {0xbbcd, {0xeb, 0xbd, 0x95}},
    {0xbbce, {0xeb, 0xbe, 0x94}},
    {0xbbcf, {0xeb, 0xbe, 0xb0}},
    {0xbbd0, {0xeb, 0xbf, 0x85}},
    {0xbbd1, {0xeb, 0xbf, 0x8c}},
    {0xbbd2, {0xeb, 0xbf, 0x8d}},
    {0xbbd3, {0xeb, 0xbf, 0x90}},
    {0xbbd4, {0xeb, 0xbf, 0x94}},
    {0xbbd5, {0xeb, 0xbf, 0x9c}},
    {0xbbd6, {0xeb, 0xbf, 0x9f}},
    {0xbbd7, {0xeb, 0xbf, 0xa1}},
    {0xbbd8, {0xec, 0x80, 0xbc}},
    {0xbbd9, {0xec, 0x81, 0x91}},
    {0xbbda, {0xec, 0x81, 0x98}},
    {0xbbdb, {0xec, 0x81, 0x9c}},
    {0xbbdc, {0xec, 0x81, 0xa0}},
    {0xbbdd, {0xec, 0x81, 0xa8}},
    {0xbbde, {0xec, 0x81, 0xa9}},
    {0xbbdf, {0xec, 0x82, 0x90}},
    {0xbbe0, {0xec, 0x82, 0x91}},
    {0xbbe1, {0xec, 0x82, 0x94}},
    {0xbbe2, {0xec, 0x82, 0x98}},
    {0xbbe3, {0xec, 0x82, 0xa0}},
    {0xbbe4, {0xec, 0x82, 0xa1}},
    {0xbbe5, {0xec, 0x82, 0xa3}},
    {0xbbe6, {0xec, 0x82, 0xa5}},
    {0xbbe7, {0xec, 0x82, 0xac}},
    {0xbbe8, {0xec, 0x82, 0xad}},
    {0xbbe9, {0xec, 0x82, 0xaf}},
    {0xbbea, {0xec, 0x82, 0xb0}},
    {0xbbeb, {0xec, 0x82, 0xb3}},
    {0xbbec, {0xec, 0x82, 0xb4}},
    {0xbbed, {0xec, 0x82, 0xb5}},
    {0xbbee, {0xec, 0x82, 0xb6}},
    {0xbbef, {0xec, 0x82, 0xbc}},
    {0xbbf0, {0xec, 0x82, 0xbd}},
    {0xbbf1, {0xec, 0x82, 0xbf}},
    {0xbbf2, {0xec, 0x83, 0x80}},
    {0xbbf3, {0xec, 0x83, 0x81}},
    {0xbbf4, {0xec, 0x83, 0x85}},
    {0xbbf5, {0xec, 0x83, 0x88}},
    {0xbbf6, {0xec, 0x83, 0x89}},
    {0xbbf7, {0xec, 0x83, 0x8c}},
    {0xbbf8, {0xec, 0x83, 0x90}},
    {0xbbf9, {0xec, 0x83, 0x98}},
    {0xbbfa, {0xec, 0x83, 0x99}},
    {0xbbfb, {0xec, 0x83, 0x9b}},
    {0xbbfc, {0xec, 0x83, 0x9c}},
    {0xbbfd, {0xec, 0x83, 0x9d}},
    {0xbbfe, {0xec, 0x83, 0xa4}},
    {0xbca1, {0xec, 0x83, 0xa5}},
    {0xbca2, {0xec, 0x83, 0xa8}},
    {0xbca3, {0xec, 0x83, 0xac}},
    {0xbca4, {0xec, 0x83, 0xb4}},
    {0xbca5, {0xec, 0x83, 0xb5}},
    {0xbca6, {0xec, 0x83, 0xb7}},
    {0xbca7, {0xec, 0x83, 0xb9}},
    {0xbca8, {0xec, 0x84, 0x80}},
    {0xbca9, {0xec, 0x84, 0x84}},
    {0xbcaa, {0xec, 0x84, 0x88}},
    {0xbcab, {0xec, 0x84, 0x90}},
    {0xbcac, {0xec, 0x84, 0x95}},
    {0xbcad, {0xec, 0x84, 0x9c}},
    {0xbcae, {0xec, 0x84, 0x9d}},
    {0xbcaf, {0xec, 0x84, 0x9e}},
    {0xbcb0, {0xec, 0x84, 0x9f}},
    {0xbcb1, {0xec, 0x84, 0xa0}},
    {0xbcb2, {0xec, 0x84, 0xa3}},
    {0xbcb3, {0xec, 0x84, 0xa4}},
    {0xbcb4, {0xec, 0x84, 0xa6}},
    {0xbcb5, {0xec, 0x84, 0xa7}},
    {0xbcb6, {0xec, 0x84, 0xac}},
    {0xbcb7, {0xec, 0x84, 0xad}},
    {0xbcb8, {0xec, 0x84, 0xaf}},
    {0xbcb9, {0xec, 0x84, 0xb0}},
    {0xbcba, {0xec, 0x84, 0xb1}},
    {0xbcbb, {0xec, 0x84, 0xb6}},
    {0xbcbc, {0xec, 0x84, 0xb8}},
    {0xbcbd, {0xec, 0x84, 0xb9}},
    {0xbcbe, {0xec, 0x84, 0xbc}},
    {0xbcbf, {0xec, 0x85, 0x80}},
    {0xbcc0, {0xec, 0x85, 0x88}},
    {0xbcc1, {0xec, 0x85, 0x89}},
    {0xbcc2, {0xec, 0x85, 0x8b}},
    {0xbcc3, {0xec, 0x85, 0x8c}},
    {0xbcc4, {0xec, 0x85, 0x8d}},
    {0xbcc5, {0xec, 0x85, 0x94}},
    {0xbcc6, {0xec, 0x85, 0x95}},
    {0xbcc7, {0xec, 0x85, 0x98}},
    {0xbcc8, {0xec, 0x85, 0x9c}},
    {0xbcc9, {0xec, 0x85, 0xa4}},
    {0xbcca, {0xec, 0x85, 0xa5}},
    {0xbccb, {0xec, 0x85, 0xa7}},
    {0xbccc, {0xec, 0x85, 0xa8}},
    {0xbccd, {0xec, 0x85, 0xa9}},
    {0xbcce, {0xec, 0x85, 0xb0}},
    {0xbccf, {0xec, 0x85, 0xb4}},
    {0xbcd0, {0xec, 0x85, 0xb8}},
    {0xbcd1, {0xec, 0x86, 0x85}},
    {0xbcd2, {0xec, 0x86, 0x8c}},
    {0xbcd3, {0xec, 0x86, 0x8d}},
    {0xbcd4, {0xec, 0x86, 0x8e}},
    {0xbcd5, {0xec, 0x86, 0x90}},
    {0xbcd6, {0xec, 0x86, 0x94}},
    {0xbcd7, {0xec, 0x86, 0x96}},
    {0xbcd8, {0xec, 0x86, 0x9c}},
    {0xbcd9, {0xec, 0x86, 0x9d}},
    {0xbcda, {0xec, 0x86, 0x9f}},
    {0xbcdb, {0xec, 0x86, 0xa1}},
    {0xbcdc, {0xec, 0x86, 0xa5}},
    {0xbcdd, {0xec, 0x86, 0xa8}},
    {0xbcde, {0xec, 0x86, 0xa9}},
    {0xbcdf, {0xec, 0x86, 0xac}},
    {0xbce0, {0xec, 0x86, 0xb0}},
    {0xbce1, {0xec, 0x86, 0xbd}},
    {0xbce2, {0xec, 0x87, 0x84}},
    {0xbce3, {0xec, 0x87, 0x88}},
    {0xbce4, {0xec, 0x87, 0x8c}},
    {0xbce5, {0xec, 0x87, 0x94}},
    {0xbce6, {0xec, 0x87, 0x97}},
    {0xbce7, {0xec, 0x87, 0x98}},
    {0xbce8, {0xec, 0x87, 0xa0}},
    {0xbce9, {0xec, 0x87, 0xa4}},
    {0xbcea, {0xec, 0x87, 0xa8}},
    {0xbceb, {0xec, 0x87, 0xb0}},
    {0xbcec, {0xec, 0x87, 0xb1}},
    {0xbced, {0xec, 0x87, 0xb3}},
    {0xbcee, {0xec, 0x87, 0xbc}},
    {0xbcef, {0xec, 0x87, 0xbd}},
    {0xbcf0, {0xec, 0x88, 0x80}},
    {0xbcf1, {0xec, 0x88, 0x84}},
    {0xbcf2, {0xec, 0x88, 0x8c}},
    {0xbcf3, {0xec, 0x88, 0x8d}},
    {0xbcf4, {0xec, 0x88, 0x8f}},
    {0xbcf5, {0xec, 0x88, 0x91}},
    {0xbcf6, {0xec, 0x88, 0x98}},
    {0xbcf7, {0xec, 0x88, 0x99}},
    {0xbcf8, {0xec, 0x88, 0x9c}},
    {0xbcf9, {0xec, 0x88, 0x9f}},
    {0xbcfa, {0xec, 0x88, 0xa0}},
    {0xbcfb, {0xec, 0x88, 0xa8}},
    {0xbcfc, {0xec, 0x88, 0xa9}},
    {0xbcfd, {0xec, 0x88, 0xab}},
    {0xbcfe, {0xec, 0x88, 0xad}},
    {0xbda1, {0xec, 0x88, 0xaf}},
    {0xbda2, {0xec, 0x88, 0xb1}},
    {0xbda3, {0xec, 0x88, 0xb2}},
    {0xbda4, {0xec, 0x88, 0xb4}},
    {0xbda5, {0xec, 0x89, 0x88}},
    {0xbda6, {0xec, 0x89, 0x90}},
    {0xbda7, {0xec, 0x89, 0x91}},
    {0xbda8, {0xec, 0x89, 0x94}},
    {0xbda9, {0xec, 0x89, 0x98}},
    {0xbdaa, {0xec, 0x89, 0xa0}},
    {0xbdab, {0xec, 0x89, 0xa5}},
    {0xbdac, {0xec, 0x89, 0xac}},
    {0xbdad, {0xec, 0x89, 0xad}},
    {0xbdae, {0xec, 0x89, 0xb0}},
    {0xbdaf, {0xec, 0x89, 0xb4}},
    {0xbdb0, {0xec, 0x89, 0xbc}},
    {0xbdb1, {0xec, 0x89, 0xbd}},
    {0xbdb2, {0xec, 0x89, 0xbf}},
    {0xbdb3, {0xec, 0x8a, 0x81}},
    {0xbdb4, {0xec, 0x8a, 0x88}},
    {0xbdb5, {0xec, 0x8a, 0x89}},
    {0xbdb6, {0xec, 0x8a, 0x90}},
    {0xbdb7, {0xec, 0x8a, 0x98}},
    {0xbdb8, {0xec, 0x8a, 0x9b}},
    {0xbdb9, {0xec, 0x8a, 0x9d}},
    {0xbdba, {0xec, 0x8a, 0xa4}},
    {0xbdbb, {0xec, 0x8a, 0xa5}},
    {0xbdbc, {0xec, 0x8a, 0xa8}},
    {0xbdbd, {0xec, 0x8a, 0xac}},
    {0xbdbe, {0xec, 0x8a, 0xad}},
    {0xbdbf, {0xec, 0x8a, 0xb4}},
    {0xbdc0, {0xec, 0x8a, 0xb5}},
    {0xbdc1, {0xec, 0x8a, 0xb7}},
    {0xbdc2, {0xec, 0x8a, 0xb9}},
    {0xbdc3, {0xec, 0x8b, 0x9c}},
    {0xbdc4, {0xec, 0x8b, 0x9d}},
    {0xbdc5, {0xec, 0x8b, 0xa0}},
    {0xbdc6, {0xec, 0x8b, 0xa3}},
    {0xbdc7, {0xec, 0x8b, 0xa4}},
    {0xbdc8, {0xec, 0x8b, 0xab}},
    {0xbdc9, {0xec, 0x8b, 0xac}},
    {0xbdca, {0xec, 0x8b, 0xad}},
    {0xbdcb, {0xec, 0x8b, 0xaf}},
    {0xbdcc, {0xec, 0x8b, 0xb1}},
    {0xbdcd, {0xec, 0x8b, 0xb6}},
    {0xbdce, {0xec, 0x8b, 0xb8}},
    {0xbdcf, {0xec, 0x8b, 0xb9}},
    {0xbdd0, {0xec, 0x8b, 0xbb}},
    {0xbdd1, {0xec, 0x8b, 0xbc}},
    {0xbdd2, {0xec, 0x8c, 0x80}},
    {0xbdd3, {0xec, 0x8c, 0x88}},
    {0xbdd4, {0xec, 0x8c, 0x89}},
    {0xbdd5, {0xec, 0x8c, 0x8c}},
    {0xbdd6, {0xec, 0x8c, 0x8d}},
    {0xbdd7, {0xec, 0x8c, 0x93}},
    {0xbdd8, {0xec, 0x8c, 0x94}},
    {0xbdd9, {0xec, 0x8c, 0x95}},
    {0xbdda, {0xec, 0x8c, 0x98}},
    {0xbddb, {0xec, 0x8c, 0x9c}},
    {0xbddc, {0xec, 0x8c, 0xa4}},
    {0xbddd, {0xec, 0x8c, 0xa5}},
    {0xbdde, {0xec, 0x8c, 0xa8}},
    {0xbddf, {0xec, 0x8c, 0xa9}},
    {0xbde0, {0xec, 0x8d, 0x85}},
    {0xbde1, {0xec, 0x8d, 0xa8}},
    {0xbde2, {0xec, 0x8d, 0xa9}},
    {0xbde3, {0xec, 0x8d, 0xac}},
    {0xbde4, {0xec, 0x8d, 0xb0}},
    {0xbde5, {0xec, 0x8d, 0xb2}},
    {0xbde6, {0xec, 0x8d, 0xb8}},
    {0xbde7, {0xec, 0x8d, 0xb9}},
    {0xbde8, {0xec, 0x8d, 0xbc}},
    {0xbde9, {0xec, 0x8d, 0xbd}},
    {0xbdea, {0xec, 0x8e, 0x84}},
    {0xbdeb, {0xec, 0x8e, 0x88}},
    {0xbdec, {0xec, 0x8e, 0x8c}},
    {0xbded, {0xec, 0x8f, 0x80}},
    {0xbdee, {0xec, 0x8f, 0x98}},
    {0xbdef, {0xec, 0x8f, 0x99}},
    {0xbdf0, {0xec, 0x8f, 0x9c}},
    {0xbdf1, {0xec, 0x8f, 0x9f}},
    {0xbdf2, {0xec, 0x8f, 0xa0}},
    {0xbdf3, {0xec, 0x8f, 0xa2}},
    {0xbdf4, {0xec, 0x8f, 0xa8}},
    {0xbdf5, {0xec, 0x8f, 0xa9}},
    {0xbdf6, {0xec, 0x8f, 0xad}},
    {0xbdf7, {0xec, 0x8f, 0xb4}},
    {0xbdf8, {0xec, 0x8f, 0xb5}},
    {0xbdf9, {0xec, 0x8f, 0xb8}},
    {0xbdfa, {0xec, 0x90, 0x88}},
    {0xbdfb, {0xec, 0x90, 0x90}},
    {0xbdfc, {0xec, 0x90, 0xa4}},
    {0xbdfd, {0xec, 0x90, 0xac}},
    {0xbdfe, {0xec, 0x90, 0xb0}},
    {0xbea1, {0xec, 0x90, 0xb4}},
    {0xbea2, {0xec, 0x90, 0xbc}},
    {0xbea3, {0xec, 0x90, 0xbd}},
    {0xbea4, {0xec, 0x91, 0x88}},
    {0xbea5, {0xec, 0x91, 0xa4}},
    {0xbea6, {0xec, 0x91, 0xa5}},
    {0xbea7, {0xec, 0x91, 0xa8}},
    {0xbea8, {0xec, 0x91, 0xac}},
    {0xbea9, {0xec, 0x91, 0xb4}},
    {0xbeaa, {0xec, 0x91, 0xb5}},
    {0xbeab, {0xec, 0x91, 0xb9}},
    {0xbeac, {0xec, 0x92, 0x80}},
    {0xbead, {0xec, 0x92, 0x94}},
    {0xbeae, {0xec, 0x92, 0x9c}},
    {0xbeaf, {0xec, 0x92, 0xb8}},
    {0xbeb0, {0xec, 0x92, 0xbc}},
    {0xbeb1, {0xec, 0x93, 0xa9}},
    {0xbeb2, {0xec, 0x93, 0xb0}},
    {0xbeb3, {0xec, 0x93, 0xb1}},
    {0xbeb4, {0xec, 0x93, 0xb4}},
    {0xbeb5, {0xec, 0x93, 0xb8}},
    {0xbeb6, {0xec, 0x93, 0xba}},
    {0xbeb7, {0xec, 0x93, 0xbf}},
    {0xbeb8, {0xec, 0x94, 0x80}},
    {0xbeb9, {0xec, 0x94, 0x81}},
    {0xbeba, {0xec, 0x94, 0x8c}},
    {0xbebb, {0xec, 0x94, 0x90}},
    {0xbebc, {0xec, 0x94, 0x94}},
    {0xbebd, {0xec, 0x94, 0x9c}},
    {0xbebe, {0xec, 0x94, 0xa8}},
    {0xbebf, {0xec, 0x94, 0xa9}},
    {0xbec0, {0xec, 0x94, 0xac}},
    {0xbec1, {0xec, 0x94, 0xb0}},
    {0xbec2, {0xec, 0x94, 0xb8}},
    {0xbec3, {0xec, 0x94, 0xb9}},
    {0xbec4, {0xec, 0x94, 0xbb}},
    {0xbec5, {0xec, 0x94, 0xbd}},
    {0xbec6, {0xec, 0x95, 0x84}},
    {0xbec7, {0xec, 0x95, 0x85}},
    {0xbec8, {0xec, 0x95, 0x88}},
    {0xbec9, {0xec, 0x95, 0x89}},
    {0xbeca, {0xec, 0x95, 0x8a}},
    {0xbecb, {0xec, 0x95, 0x8c}},
    {0xbecc, {0xec, 0x95, 0x8d}},
    {0xbecd, {0xec, 0x95, 0x8e}},
    {0xbece, {0xec, 0x95, 0x93}},
    {0xbecf, {0xec, 0x95, 0x94}},
    {0xbed0, {0xec, 0x95, 0x95}},
    {0xbed1, {0xec, 0x95, 0x97}},
    {0xbed2, {0xec, 0x95, 0x98}},
    {0xbed3, {0xec, 0x95, 0x99}},
    {0xbed4, {0xec, 0x95, 0x9d}},
    {0xbed5, {0xec, 0x95, 0x9e}},
    {0xbed6, {0xec, 0x95, 0xa0}},
    {0xbed7, {0xec, 0x95, 0xa1}},
    {0xbed8, {0xec, 0x95, 0xa4}},
    {0xbed9, {0xec, 0x95, 0xa8}},
    {0xbeda, {0xec, 0x95, 0xb0}},
    {0xbedb, {0xec, 0x95, 0xb1}},
    {0xbedc, {0xec, 0x95, 0xb3}},
    {0xbedd, {0xec, 0x95, 0xb4}},
    {0xbede, {0xec, 0x95, 0xb5}},
    {0xbedf, {0xec, 0x95, 0xbc}},
    {0xbee0, {0xec, 0x95, 0xbd}},
    {0xbee1, {0xec, 0x96, 0x80}},
    {0xbee2, {0xec, 0x96, 0x84}},
    {0xbee3, {0xec, 0x96, 0x87}},
    {0xbee4, {0xec, 0x96, 0x8c}},
    {0xbee5, {0xec, 0x96, 0x8d}},
    {0xbee6, {0xec, 0x96, 0x8f}},
    {0xbee7, {0xec, 0x96, 0x91}},
    {0xbee8, {0xec, 0x96, 0x95}},
    {0xbee9, {0xec, 0x96, 0x97}},
    {0xbeea, {0xec, 0x96, 0x98}},
    {0xbeeb, {0xec, 0x96, 0x9c}},
    {0xbeec, {0xec, 0x96, 0xa0}},
    {0xbeed, {0xec, 0x96, 0xa9}},
    {0xbeee, {0xec, 0x96, 0xb4}},
    {0xbeef, {0xec, 0x96, 0xb5}},
    {0xbef0, {0xec, 0x96, 0xb8}},
    {0xbef1, {0xec, 0x96, 0xb9}},
    {0xbef2, {0xec, 0x96, 0xbb}},
    {0xbef3, {0xec, 0x96, 0xbc}},
    {0xbef4, {0xec, 0x96, 0xbd}},
    {0xbef5, {0xec, 0x96, 0xbe}},
    {0xbef6, {0xec, 0x97, 0x84}},
    {0xbef7, {0xec, 0x97, 0x85}},
    {0xbef8, {0xec, 0x97, 0x86}},
    {0xbef9, {0xec, 0x97, 0x87}},
    {0xbefa, {0xec, 0x97, 0x88}},
    {0xbefb, {0xec, 0x97, 0x89}},
    {0xbefc, {0xec, 0x97, 0x8a}},
    {0xbefd, {0xec, 0x97, 0x8c}},
    {0xbefe, {0xec, 0x97, 0x8e}},
    {0xbfa1, {0xec, 0x97, 0x90}},
    {0xbfa2, {0xec, 0x97, 0x91}},
    {0xbfa3, {0xec, 0x97, 0x94}},
    {0xbfa4, {0xec, 0x97, 0x98}},
    {0xbfa5, {0xec, 0x97, 0xa0}},
    {0xbfa6, {0xec, 0x97, 0xa1}},
    {0xbfa7, {0xec, 0x97, 0xa3}},
    {0xbfa8, {0xec, 0x97, 0xa5}},
    {0xbfa9, {0xec, 0x97, 0xac}},
    {0xbfaa, {0xec, 0x97, 0xad}},
    {0xbfab, {0xec, 0x97, 0xae}},
    {0xbfac, {0xec, 0x97, 0xb0}},
    {0xbfad, {0xec, 0x97, 0xb4}},
    {0xbfae, {0xec, 0x97, 0xb6}},
    {0xbfaf, {0xec, 0x97, 0xb7}},
    {0xbfb0, {0xec, 0x97, 0xbc}},
    {0xbfb1, {0xec, 0x97, 0xbd}},
    {0xbfb2, {0xec, 0x97, 0xbe}},
    {0xbfb3, {0xec, 0x97, 0xbf}},
    {0xbfb4, {0xec, 0x98, 0x80}},
    {0xbfb5, {0xec, 0x98, 0x81}},
    {0xbfb6, {0xec, 0x98, 0x85}},
    {0xbfb7, {0xec, 0x98, 0x86}},
    {0xbfb8, {0xec, 0x98, 0x87}},
    {0xbfb9, {0xec, 0x98, 0x88}},
    {0xbfba, {0xec, 0x98, 0x8c}},
    {0xbfbb, {0xec, 0x98, 0x90}},
    {0xbfbc, {0xec, 0x98, 0x98}},
    {0xbfbd, {0xec, 0x98, 0x99}},
    {0xbfbe, {0xec, 0x98, 0x9b}},
    {0xbfbf, {0xec, 0x98, 0x9c}},
    {0xbfc0, {0xec, 0x98, 0xa4}},
    {0xbfc1, {0xec, 0x98, 0xa5}},
    {0xbfc2, {0xec, 0x98, 0xa8}},
    {0xbfc3, {0xec, 0x98, 0xac}},
    {0xbfc4, {0xec, 0x98, 0xad}},
    {0xbfc5, {0xec, 0x98, 0xae}},
    {0xbfc6, {0xec, 0x98, 0xb0}},
    {0xbfc7, {0xec, 0x98, 0xb3}},
    {0xbfc8, {0xec, 0x98, 0xb4}},
    {0xbfc9, {0xec, 0x98, 0xb5}},
    {0xbfca, {0xec, 0x98, 0xb7}},
    {0xbfcb, {0xec, 0x98, 0xb9}},
    {0xbfcc, {0xec, 0x98, 0xbb}},
    {0xbfcd, {0xec, 0x99, 0x80}},
    {0xbfce, {0xec, 0x99, 0x81}},
    {0xbfcf, {0xec, 0x99, 0x84}},
    {0xbfd0, {0xec, 0x99, 0x88}},
    {0xbfd1, {0xec, 0x99, 0x90}},
    {0xbfd2, {0xec, 0x99, 0x91}},
    {0xbfd3, {0xec, 0x99, 0x93}},
    {0xbfd4, {0xec, 0x99, 0x94}},
    {0xbfd5, {0xec, 0x99, 0x95}},
    {0xbfd6, {0xec, 0x99, 0x9c}},
    {0xbfd7, {0xec, 0x99, 0x9d}},
    {0xbfd8, {0xec, 0x99, 0xa0}},
    {0xbfd9, {0xec, 0x99, 0xac}},
    {0xbfda, {0xec, 0x99, 0xaf}},
    {0xbfdb, {0xec, 0x99, 0xb1}},
    {0xbfdc, {0xec, 0x99, 0xb8}},
    {0xbfdd, {0xec, 0x99, 0xb9}},
    {0xbfde, {0xec, 0x99, 0xbc}},
    {0xbfdf, {0xec, 0x9a, 0x80}},
    {0xbfe0, {0xec, 0x9a, 0x88}},
    {0xbfe1, {0xec, 0x9a, 0x89}},
    {0xbfe2, {0xec, 0x9a, 0x8b}},
    {0xbfe3, {0xec, 0x9a, 0x8d}},
    {0xbfe4, {0xec, 0x9a, 0x94}},
    {0xbfe5, {0xec, 0x9a, 0x95}},
    {0xbfe6, {0xec, 0x9a, 0x98}},
    {0xbfe7, {0xec, 0x9a, 0x9c}},
    {0xbfe8, {0xec, 0x9a, 0xa4}},
    {0xbfe9, {0xec, 0x9a, 0xa5}},
    {0xbfea, {0xec, 0x9a, 0xa7}},
    {0xbfeb, {0xec, 0x9a, 0xa9}},
    {0xbfec, {0xec, 0x9a, 0xb0}},
    {0xbfed, {0xec, 0x9a, 0xb1}},
    {0xbfee, {0xec, 0x9a, 0xb4}},
    {0xbfef, {0xec, 0x9a, 0xb8}},
    {0xbff0, {0xec, 0x9a, 0xb9}},
    {0xbff1, {0xec, 0x9a, 0xba}},
    {0xbff2, {0xec, 0x9b, 0x80}},
    {0xbff3, {0xec, 0x9b, 0x81}},
    {0xbff4, {0xec, 0x9b, 0x83}},
    {0xbff5, {0xec, 0x9b, 0x85}},
    {0xbff6, {0xec, 0x9b, 0x8c}},
    {0xbff7, {0xec, 0x9b, 0x8d}},
    {0xbff8, {0xec, 0x9b, 0x90}},
    {0xbff9, {0xec, 0x9b, 0x94}},
    {0xbffa, {0xec, 0x9b, 0x9c}},
    {0xbffb, {0xec, 0x9b, 0x9d}},
    {0xbffc, {0xec, 0x9b, 0xa0}},
    {0xbffd, {0xec, 0x9b, 0xa1}},
    {0xbffe, {0xec, 0x9b, 0xa8}},
    {0xc0a1, {0xec, 0x9b, 0xa9}},
    {0xc0a2, {0xec, 0x9b, 0xac}},
    {0xc0a3, {0xec, 0x9b, 0xb0}},
    {0xc0a4, {0xec, 0x9b, 0xb8}},
    {0xc0a5, {0xec, 0x9b, 0xb9}},
    {0xc0a6, {0xec, 0x9b, 0xbd}},
    {0xc0a7, {0xec, 0x9c, 0x84}},
    {0xc0a8, {0xec, 0x9c, 0x85}},
    {0xc0a9, {0xec, 0x9c, 0x88}},
    {0xc0aa, {0xec, 0x9c, 0x8c}},
    {0xc0ab, {0xec, 0x9c, 0x94}},
    {0xc0ac, {0xec, 0x9c, 0x95}},
    {0xc0ad, {0xec, 0x9c, 0x97}},
    {0xc0ae, {0xec, 0x9c, 0x99}},
    {0xc0af, {0xec, 0x9c, 0xa0}},
    {0xc0b0, {0xec, 0x9c, 0xa1}},
    {0xc0b1, {0xec, 0x9c, 0xa4}},
    {0xc0b2, {0xec, 0x9c, 0xa8}},
    {0xc0b3, {0xec, 0x9c, 0xb0}},
    {0xc0b4, {0xec, 0x9c, 0xb1}},
    {0xc0b5, {0xec, 0x9c, 0xb3}},
    {0xc0b6, {0xec, 0x9c, 0xb5}},
    {0xc0b7, {0xec, 0x9c, 0xb7}},
    {0xc0b8, {0xec, 0x9c, 0xbc}},
    {0xc0b9, {0xec, 0x9c, 0xbd}},
    {0xc0ba, {0xec, 0x9d, 0x80}},
    {0xc0bb, {0xec, 0x9d, 0x84}},
    {0xc0bc, {0xec, 0x9d, 0x8a}},
    {0xc0bd, {0xec, 0x9d, 0x8c}},
    {0xc0be, {0xec, 0x9d, 0x8d}},
    {0xc0bf, {0xec, 0x9d, 0x8f}},
    {0xc0c0, {0xec, 0x9d, 0x91}},
    {0xc0c1, {0xec, 0x9d, 0x92}},
    {0xc0c2, {0xec, 0x9d, 0x93}},
    {0xc0c3, {0xec, 0x9d, 0x94}},
    {0xc0c4, {0xec, 0x9d, 0x95}},
    {0xc0c5, {0xec, 0x9d, 0x96}},
    {0xc0c6, {0xec, 0x9d, 0x97}},
    {0xc0c7, {0xec, 0x9d, 0x98}},
    {0xc0c8, {0xec, 0x9d, 0x9c}},
    {0xc0c9, {0xec, 0x9d, 0xa0}},
    {0xc0ca, {0xec, 0x9d, 0xa8}},
    {0xc0cb, {0xec, 0x9d, 0xab}},
    {0xc0cc, {0xec, 0x9d, 0xb4}},
    {0xc0cd, {0xec, 0x9d, 0xb5}},
    {0xc0ce, {0xec, 0x9d, 0xb8}},
    {0xc0cf, {0xec, 0x9d, 0xbc}},
    {0xc0d0, {0xec, 0x9d, 0xbd}},
    {0xc0d1, {0xec, 0x9d, 0xbe}},
    {0xc0d2, {0xec, 0x9e, 0x83}},
    {0xc0d3, {0xec, 0x9e, 0x84}},
    {0xc0d4, {0xec, 0x9e, 0x85}},
    {0xc0d5, {0xec, 0x9e, 0x87}},
    {0xc0d6, {0xec, 0x9e, 0x88}},
    {0xc0d7, {0xec, 0x9e, 0x89}},
    {0xc0d8, {0xec, 0x9e, 0x8a}},
    {0xc0d9, {0xec, 0x9e, 0x8e}},
    {0xc0da, {0xec, 0x9e, 0x90}},
    {0xc0db, {0xec, 0x9e, 0x91}},
    {0xc0dc, {0xec, 0x9e, 0x94}},
    {0xc0dd, {0xec, 0x9e, 0x96}},
    {0xc0de, {0xec, 0x9e, 0x97}},
    {0xc0df, {0xec, 0x9e, 0x98}},
    {0xc0e0, {0xec, 0x9e, 0x9a}},
    {0xc0e1, {0xec, 0x9e, 0xa0}},
    {0xc0e2, {0xec, 0x9e, 0xa1}},
    {0xc0e3, {0xec, 0x9e, 0xa3}},
    {0xc0e4, {0xec, 0x9e, 0xa4}},
    {0xc0e5, {0xec, 0x9e, 0xa5}},
    {0xc0e6, {0xec, 0x9e, 0xa6}},
    {0xc0e7, {0xec, 0x9e, 0xac}},
    {0xc0e8, {0xec, 0x9e, 0xad}},
    {0xc0e9, {0xec, 0x9e, 0xb0}},
    {0xc0ea, {0xec, 0x9e, 0xb4}},
    {0xc0eb, {0xec, 0x9e, 0xbc}},
    {0xc0ec, {0xec, 0x9e, 0xbd}},
    {0xc0ed, {0xec, 0x9e, 0xbf}},
    {0xc0ee, {0xec, 0x9f, 0x80}},
    {0xc0ef, {0xec, 0x9f, 0x81}},
    {0xc0f0, {0xec, 0x9f, 0x88}},
    {0xc0f1, {0xec, 0x9f, 0x89}},
    {0xc0f2, {0xec, 0x9f, 0x8c}},
    {0xc0f3, {0xec, 0x9f, 0x8e}},
    {0xc0f4, {0xec, 0x9f, 0x90}},
    {0xc0f5, {0xec, 0x9f, 0x98}},
    {0xc0f6, {0xec, 0x9f, 0x9d}},
    {0xc0f7, {0xec, 0x9f, 0xa4}},
    {0xc0f8, {0xec, 0x9f, 0xa8}},
    {0xc0f9, {0xec, 0x9f, 0xac}},
    {0xc0fa, {0xec, 0xa0, 0x80}},
    {0xc0fb, {0xec, 0xa0, 0x81}},
    {0xc0fc, {0xec, 0xa0, 0x84}},
    {0xc0fd, {0xec, 0xa0, 0x88}},
    {0xc0fe, {0xec, 0xa0, 0x8a}},
    {0xc1a1, {0xec, 0xa0, 0x90}},
    {0xc1a2, {0xec, 0xa0, 0x91}},
    {0xc1a3, {0xec, 0xa0, 0x93}},
    {0xc1a4, {0xec, 0xa0, 0x95}},
    {0xc1a5, {0xec, 0xa0, 0x96}},
    {0xc1a6, {0xec, 0xa0, 0x9c}},
    {0xc1a7, {0xec, 0xa0, 0x9d}},
    {0xc1a8, {0xec, 0xa0, 0xa0}},
    {0xc1a9, {0xec, 0xa0, 0xa4}},
    {0xc1aa, {0xec, 0xa0, 0xac}},
    {0xc1ab, {0xec, 0xa0, 0xad}},
    {0xc1ac, {0xec, 0xa0, 0xaf}},
    {0xc1ad, {0xec, 0xa0, 0xb1}},
    {0xc1ae, {0xec, 0xa0, 0xb8}},
    {0xc1af, {0xec, 0xa0, 0xbc}},
    {0xc1b0, {0xec, 0xa1, 0x80}},
    {0xc1b1, {0xec, 0xa1, 0x88}},
    {0xc1b2, {0xec, 0xa1, 0x89}},
    {0xc1b3, {0xec, 0xa1, 0x8c}},
    {0xc1b4, {0xec, 0xa1, 0x8d}},
    {0xc1b5, {0xec, 0xa1, 0x94}},
    {0xc1b6, {0xec, 0xa1, 0xb0}},
    {0xc1b7, {0xec, 0xa1, 0xb1}},
    {0xc1b8, {0xec, 0xa1, 0xb4}},
    {0xc1b9, {0xec, 0xa1, 0xb8}},
    {0xc1ba, {0xec, 0xa1, 0xba}},
    {0xc1bb, {0xec, 0xa2, 0x80}},
    {0xc1bc, {0xec, 0xa2, 0x81}},
    {0xc1bd, {0xec, 0xa2, 0x83}},
    {0xc1be, {0xec, 0xa2, 0x85}},
    {0xc1bf, {0xec, 0xa2, 0x86}},
    {0xc1c0, {0xec, 0xa2, 0x87}},
    {0xc1c1, {0xec, 0xa2, 0x8b}},
    {0xc1c2, {0xec, 0xa2, 0x8c}},
    {0xc1c3, {0xec, 0xa2, 0x8d}},
    {0xc1c4, {0xec, 0xa2, 0x94}},
    {0xc1c5, {0xec, 0xa2, 0x9d}},
    {0xc1c6, {0xec, 0xa2, 0x9f}},
    {0xc1c7, {0xec, 0xa2, 0xa1}},
    {0xc1c8, {0xec, 0xa2, 0xa8}},
    {0xc1c9, {0xec, 0xa2, 0xbc}},
    {0xc1ca, {0xec, 0xa2, 0xbd}},
    {0xc1cb, {0xec, 0xa3, 0x84}},
    {0xc1cc, {0xec, 0xa3, 0x88}},
    {0xc1cd, {0xec, 0xa3, 0x8c}},
    {0xc1ce, {0xec, 0xa3, 0x94}},
    {0xc1cf, {0xec, 0xa3, 0x95}},
    {0xc1d0, {0xec, 0xa3, 0x97}},
    {0xc1d1, {0xec, 0xa3, 0x99}},
    {0xc1d2, {0xec, 0xa3, 0xa0}},
    {0xc1d3, {0xec, 0xa3, 0xa1}},
    {0xc1d4, {0xec, 0xa3, 0xa4}},
    {0xc1d5, {0xec, 0xa3, 0xb5}},
    {0xc1d6, {0xec, 0xa3, 0xbc}},
    {0xc1d7, {0xec, 0xa3, 0xbd}},
    {0xc1d8, {0xec, 0xa4, 0x80}},
    {0xc1d9, {0xec, 0xa4, 0x84}},
    {0xc1da, {0xec, 0xa4, 0x85}},
    {0xc1db, {0xec, 0xa4, 0x86}},
    {0xc1dc, {0xec, 0xa4, 0x8c}},
    {0xc1dd, {0xec, 0xa4, 0x8d}},
    {0xc1de, {0xec, 0xa4, 0x8f}},
    {0xc1df, {0xec, 0xa4, 0x91}},
    {0xc1e0, {0xec, 0xa4, 0x98}},
    {0xc1e1, {0xec, 0xa4, 0xac}},
    {0xc1e2, {0xec, 0xa4, 0xb4}},
    {0xc1e3, {0xec, 0xa5, 0x90}},
    {0xc1e4, {0xec, 0xa5, 0x91}},
    {0xc1e5, {0xec, 0xa5, 0x94}},
    {0xc1e6, {0xec, 0xa5, 0x98}},
    {0xc1e7, {0xec, 0xa5, 0xa0}},
    {0xc1e8, {0xec, 0xa5, 0xa1}},
    {0xc1e9, {0xec, 0xa5, 0xa3}},
    {0xc1ea, {0xec, 0xa5, 0xac}},
    {0xc1eb, {0xec, 0xa5, 0xb0}},
    {0xc1ec, {0xec, 0xa5, 0xb4}},
    {0xc1ed, {0xec, 0xa5, 0xbc}},
    {0xc1ee, {0xec, 0xa6, 0x88}},
    {0xc1ef, {0xec, 0xa6, 0x89}},
    {0xc1f0, {0xec, 0xa6, 0x8c}},
    {0xc1f1, {0xec, 0xa6, 0x90}},
    {0xc1f2, {0xec, 0xa6, 0x98}},
    {0xc1f3, {0xec, 0xa6, 0x99}},
    {0xc1f4, {0xec, 0xa6, 0x9b}},
    {0xc1f5, {0xec, 0xa6, 0x9d}},
    {0xc1f6, {0xec, 0xa7, 0x80}},
    {0xc1f7, {0xec, 0xa7, 0x81}},
    {0xc1f8, {0xec, 0xa7, 0x84}},
    {0xc1f9, {0xec, 0xa7, 0x87}},
    {0xc1fa, {0xec, 0xa7, 0x88}},
    {0xc1fb, {0xec, 0xa7, 0x8a}},
    {0xc1fc, {0xec, 0xa7, 0x90}},
    {0xc1fd, {0xec, 0xa7, 0x91}},
    {0xc1fe, {0xec, 0xa7, 0x93}},
    {0xc2a1, {0xec, 0xa7, 0x95}},
    {0xc2a2, {0xec, 0xa7, 0x96}},
    {0xc2a3, {0xec, 0xa7, 0x99}},
    {0xc2a4, {0xec, 0xa7, 0x9a}},
    {0xc2a5, {0xec, 0xa7, 0x9c}},
    {0xc2a6, {0xec, 0xa7, 0x9d}},
    {0xc2a7, {0xec, 0xa7, 0xa0}},
    {0xc2a8, {0xec, 0xa7, 0xa2}},
    {0xc2a9, {0xec, 0xa7, 0xa4}},
    {0xc2aa, {0xec, 0xa7, 0xa7}},
    {0xc2ab, {0xec, 0xa7, 0xac}},
    {0xc2ac, {0xec, 0xa7, 0xad}},
    {0xc2ad, {0xec, 0xa7, 0xaf}},
    {0xc2ae, {0xec, 0xa7, 0xb0}},
    {0xc2af, {0xec, 0xa7, 0xb1}},
    {0xc2b0, {0xec, 0xa7, 0xb8}},
    {0xc2b1, {0xec, 0xa7, 0xb9}},
    {0xc2b2, {0xec, 0xa7, 0xbc}},
    {0xc2b3, {0xec, 0xa8, 0x80}},
    {0xc2b4, {0xec, 0xa8, 0x88}},
    {0xc2b5, {0xec, 0xa8, 0x89}},
    {0xc2b6, {0xec, 0xa8, 0x8b}},
    {0xc2b7, {0xec, 0xa8, 0x8c}},
    {0xc2b8, {0xec, 0xa8, 0x8d}},
    {0xc2b9, {0xec, 0xa8, 0x94}},
    {0xc2ba, {0xec, 0xa8, 0x98}},
    {0xc2bb, {0xec, 0xa8, 0xa9}},
    {0xc2bc, {0xec, 0xa9, 0x8c}},
    {0xc2bd, {0xec, 0xa9, 0x8d}},
    {0xc2be, {0xec, 0xa9, 0x90}},
    {0xc2bf, {0xec, 0xa9, 0x94}},
    {0xc2c0, {0xec, 0xa9, 0x9c}},
    {0xc2c1, {0xec, 0xa9, 0x9d}},
    {0xc2c2, {0xec, 0xa9, 0x9f}},
    {0xc2c3, {0xec, 0xa9, 0xa0}},
    {0xc2c4, {0xec, 0xa9, 0xa1}},
    {0xc2c5, {0xec, 0xa9, 0xa8}},
    {0xc2c6, {0xec, 0xa9, 0xbd}},
    {0xc2c7, {0xec, 0xaa, 0x84}},
    {0xc2c8, {0xec, 0xaa, 0x98}},
    {0xc2c9, {0xec, 0xaa, 0xbc}},
    {0xc2ca, {0xec, 0xaa, 0xbd}},
    {0xc2cb, {0xec, 0xab, 0x80}},
    {0xc2cc, {0xec, 0xab, 0x84}},
    {0xc2cd, {0xec, 0xab, 0x8c}},
    {0xc2ce, {0xec, 0xab, 0x8d}},
    {0xc2cf, {0xec, 0xab, 0x8f}},
    {0xc2d0, {0xec, 0xab, 0x91}},
    {0xc2d1, {0xec, 0xab, 0x93}},
    {0xc2d2, {0xec, 0xab, 0x98}},
    {0xc2d3, {0xec, 0xab, 0x99}},
    {0xc2d4, {0xec, 0xab, 0xa0}},
    {0xc2d5, {0xec, 0xab, 0xac}},
    {0xc2d6, {0xec, 0xab, 0xb4}},
    {0xc2d7, {0xec, 0xac, 0x88}},
    {0xc2d8, {0xec, 0xac, 0x90}},
    {0xc2d9, {0xec, 0xac, 0x94}},
    {0xc2da, {0xec, 0xac, 0x98}},
    {0xc2db, {0xec, 0xac, 0xa0}},
    {0xc2dc, {0xec, 0xac, 0xa1}},
    {0xc2dd, {0xec, 0xad, 0x81}},
    {0xc2de, {0xec, 0xad, 0x88}},
    {0xc2df, {0xec, 0xad, 0x89}},
    {0xc2e0, {0xec, 0xad, 0x8c}},
    {0xc2e1, {0xec, 0xad, 0x90}},
    {0xc2e2, {0xec, 0xad, 0x98}},
    {0xc2e3, {0xec, 0xad, 0x99}},
    {0xc2e4, {0xec, 0xad, 0x9d}},
    {0xc2e5, {0xec, 0xad, 0xa4}},
    {0xc2e6, {0xec, 0xad, 0xb8}},
    {0xc2e7, {0xec, 0xad, 0xb9}},
    {0xc2e8, {0xec, 0xae, 0x9c}},
    {0xc2e9, {0xec, 0xae, 0xb8}},
    {0xc2ea, {0xec, 0xaf, 0x94}},
    {0xc2eb, {0xec, 0xaf, 0xa4}},
    {0xc2ec, {0xec, 0xaf, 0xa7}},
    {0xc2ed, {0xec, 0xaf, 0xa9}},
    {0xc2ee, {0xec, 0xb0, 0x8c}},
    {0xc2ef, {0xec, 0xb0, 0x8d}},
    {0xc2f0, {0xec, 0xb0, 0x90}},
    {0xc2f1, {0xec, 0xb0, 0x94}},
    {0xc2f2, {0xec, 0xb0, 0x9c}},
    {0xc2f3, {0xec, 0xb0, 0x9d}},
    {0xc2f4, {0xec, 0xb0, 0xa1}},
    {0xc2f5, {0xec, 0xb0, 0xa2}},
    {0xc2f6, {0xec, 0xb0, 0xa7}},
    {0xc2f7, {0xec, 0xb0, 0xa8}},
    {0xc2f8, {0xec, 0xb0, 0xa9}},
    {0xc2f9, {0xec, 0xb0, 0xac}},
    {0xc2fa, {0xec, 0xb0, 0xae}},
    {0xc2fb, {0xec, 0xb0, 0xb0}},
    {0xc2fc, {0xec, 0xb0, 0xb8}},
    {0xc2fd, {0xec, 0xb0, 0xb9}},
    {0xc2fe, {0xec, 0xb0, 0xbb}},
    {0xc3a1, {0xec, 0xb0, 0xbc}},
    {0xc3a2, {0xec, 0xb0, 0xbd}},
    {0xc3a3, {0xec, 0xb0, 0xbe}},
    {0xc3a4, {0xec, 0xb1, 0x84}},
    {0xc3a5, {0xec, 0xb1, 0x85}},
    {0xc3a6, {0xec, 0xb1, 0x88}},
    {0xc3a7, {0xec, 0xb1, 0x8c}},
    {0xc3a8, {0xec, 0xb1, 0x94}},
    {0xc3a9, {0xec, 0xb1, 0x95}},
    {0xc3aa, {0xec, 0xb1, 0x97}},
    {0xc3ab, {0xec, 0xb1, 0x98}},
    {0xc3ac, {0xec, 0xb1, 0x99}},
    {0xc3ad, {0xec, 0xb1, 0xa0}},
    {0xc3ae, {0xec, 0xb1, 0xa4}},
    {0xc3af, {0xec, 0xb1, 0xa6}},
    {0xc3b0, {0xec, 0xb1, 0xa8}},
    {0xc3b1, {0xec, 0xb1, 0xb0}},
    {0xc3b2, {0xec, 0xb1, 0xb5}},
    {0xc3b3, {0xec, 0xb2, 0x98}},
    {0xc3b4, {0xec, 0xb2, 0x99}},
    {0xc3b5, {0xec, 0xb2, 0x9c}},
    {0xc3b6, {0xec, 0xb2, 0xa0}},
    {0xc3b7, {0xec, 0xb2, 0xa8}},
    {0xc3b8, {0xec, 0xb2, 0xa9}},
    {0xc3b9, {0xec, 0xb2, 0xab}},
    {0xc3ba, {0xec, 0xb2, 0xac}},
    {0xc3bb, {0xec, 0xb2, 0xad}},
    {0xc3bc, {0xec, 0xb2, 0xb4}},
    {0xc3bd, {0xec, 0xb2, 0xb5}},
    {0xc3be, {0xec, 0xb2, 0xb8}},
    {0xc3bf, {0xec, 0xb2, 0xbc}},
    {0xc3c0, {0xec, 0xb3, 0x84}},
    {0xc3c1, {0xec, 0xb3, 0x85}},
    {0xc3c2, {0xec, 0xb3, 0x87}},
    {0xc3c3, {0xec, 0xb3, 0x89}},
    {0xc3c4, {0xec, 0xb3, 0x90}},
    {0xc3c5, {0xec, 0xb3, 0x94}},
    {0xc3c6, {0xec, 0xb3, 0xa4}},
    {0xc3c7, {0xec, 0xb3, 0xac}},
    {0xc3c8, {0xec, 0xb3, 0xb0}},
    {0xc3c9, {0xec, 0xb4, 0x81}},
    {0xc3ca, {0xec, 0xb4, 0x88}},
    {0xc3cb, {0xec, 0xb4, 0x89}},
    {0xc3cc, {0xec, 0xb4, 0x8c}},
    {0xc3cd, {0xec, 0xb4, 0x90}},
    {0xc3ce, {0xec, 0xb4, 0x98}},
    {0xc3cf, {0xec, 0xb4, 0x99}},
    {0xc3d0, {0xec, 0xb4, 0x9b}},
    {0xc3d1, {0xec, 0xb4, 0x9d}},
    {0xc3d2, {0xec, 0xb4, 0xa4}},
    {0xc3d3, {0xec, 0xb4, 0xa8}},
    {0xc3d4, {0xec, 0xb4, 0xac}},
    {0xc3d5, {0xec, 0xb4, 0xb9}},
    {0xc3d6, {0xec, 0xb5, 0x9c}},
    {0xc3d7, {0xec, 0xb5, 0xa0}},
    {0xc3d8, {0xec, 0xb5, 0xa4}},
    {0xc3d9, {0xec, 0xb5, 0xac}},
    {0xc3da, {0xec, 0xb5, 0xad}},
    {0xc3db, {0xec, 0xb5, 0xaf}},
    {0xc3dc, {0xec, 0xb5, 0xb1}},
    {0xc3dd, {0xec, 0xb5, 0xb8}},
    {0xc3de, {0xec, 0xb6, 0x88}},
    {0xc3df, {0xec, 0xb6, 0x94}},
    {0xc3e0, {0xec, 0xb6, 0x95}},
    {0xc3e1, {0xec, 0xb6, 0x98}},
    {0xc3e2, {0xec, 0xb6, 0x9c}},
    {0xc3e3, {0xec, 0xb6, 0xa4}},
    {0xc3e4, {0xec, 0xb6, 0xa5}},
    {0xc3e5, {0xec, 0xb6, 0xa7}},
    {0xc3e6, {0xec, 0xb6, 0xa9}},
    {0xc3e7, {0xec, 0xb6, 0xb0}},
    {0xc3e8, {0xec, 0xb7, 0x84}},
    {0xc3e9, {0xec, 0xb7, 0x8c}},
    {0xc3ea, {0xec, 0xb7, 0x90}},
    {0xc3eb, {0xec, 0xb7, 0xa8}},
    {0xc3ec, {0xec, 0xb7, 0xac}},
    {0xc3ed, {0xec, 0xb7, 0xb0}},
    {0xc3ee, {0xec, 0xb7, 0xb8}},
    {0xc3ef, {0xec, 0xb7, 0xb9}},
    {0xc3f0, {0xec, 0xb7, 0xbb}},
    {0xc3f1, {0xec, 0xb7, 0xbd}},
    {0xc3f2, {0xec, 0xb8, 0x84}},
    {0xc3f3, {0xec, 0xb8, 0x88}},
    {0xc3f4, {0xec, 0xb8, 0x8c}},
    {0xc3f5, {0xec, 0xb8, 0x94}},
    {0xc3f6, {0xec, 0xb8, 0x99}},
    {0xc3f7, {0xec, 0xb8, 0xa0}},
    {0xc3f8, {0xec, 0xb8, 0xa1}},
    {0xc3f9, {0xec, 0xb8, 0xa4}},
    {0xc3fa, {0xec, 0xb8, 0xa8}},
    {0xc3fb, {0xec, 0xb8, 0xb0}},
    {0xc3fc, {0xec, 0xb8, 0xb1}},
    {0xc3fd, {0xec, 0xb8, 0xb3}},
    {0xc3fe, {0xec, 0xb8, 0xb5}},
    {0xc4a1, {0xec, 0xb9, 0x98}},
    {0xc4a2, {0xec, 0xb9, 0x99}},
    {0xc4a3, {0xec, 0xb9, 0x9c}},
    {0xc4a4, {0xec, 0xb9, 0x9f}},
    {0xc4a5, {0xec, 0xb9, 0xa0}},
    {0xc4a6, {0xec, 0xb9, 0xa1}},
    {0xc4a7, {0xec, 0xb9, 0xa8}},
    {0xc4a8, {0xec, 0xb9, 0xa9}},
    {0xc4a9, {0xec, 0xb9, 0xab}},
    {0xc4aa, {0xec, 0xb9, 0xad}},
    {0xc4ab, {0xec, 0xb9, 0xb4}},
    {0xc4ac, {0xec, 0xb9, 0xb5}},
    {0xc4ad, {0xec, 0xb9, 0xb8}},
    {0xc4ae, {0xec, 0xb9, 0xbc}},
    {0xc4af, {0xec, 0xba, 0x84}},
    {0xc4b0, {0xec, 0xba, 0x85}},
    {0xc4b1, {0xec, 0xba, 0x87}},
    {0xc4b2, {0xec, 0xba, 0x89}},
    {0xc4b3, {0xec, 0xba, 0x90}},
    {0xc4b4, {0xec, 0xba, 0x91}},
    {0xc4b5, {0xec, 0xba, 0x94}},
    {0xc4b6, {0xec, 0xba, 0x98}},
    {0xc4b7, {0xec, 0xba, 0xa0}},
    {0xc4b8, {0xec, 0xba, 0xa1}},
    {0xc4b9, {0xec, 0xba, 0xa3}},
    {0xc4ba, {0xec, 0xba, 0xa4}},
    {0xc4bb, {0xec, 0xba, 0xa5}},
    {0xc4bc, {0xec, 0xba, 0xac}},
    {0xc4bd, {0xec, 0xba, 0xad}},
    {0xc4be, {0xec, 0xbb, 0x81}},
    {0xc4bf, {0xec, 0xbb, 0xa4}},
    {0xc4c0, {0xec, 0xbb, 0xa5}},
    {0xc4c1, {0xec, 0xbb, 0xa8}},
    {0xc4c2, {0xec, 0xbb, 0xab}},
    {0xc4c3, {0xec, 0xbb, 0xac}},
    {0xc4c4, {0xec, 0xbb, 0xb4}},
    {0xc4c5, {0xec, 0xbb, 0xb5}},
    {0xc4c6, {0xec, 0xbb, 0xb7}},
    {0xc4c7, {0xec, 0xbb, 0xb8}},
    {0xc4c8, {0xec, 0xbb, 0xb9}},
    {0xc4c9, {0xec, 0xbc, 0x80}},
    {0xc4ca, {0xec, 0xbc, 0x81}},
    {0xc4cb, {0xec, 0xbc, 0x84}},
    {0xc4cc, {0xec, 0xbc, 0x88}},
    {0xc4cd, {0xec, 0xbc, 0x90}},
    {0xc4ce, {0xec, 0xbc, 0x91}},
    {0xc4cf, {0xec, 0xbc, 0x93}},
    {0xc4d0, {0xec, 0xbc, 0x95}},
    {0xc4d1, {0xec, 0xbc, 0x9c}},
    {0xc4d2, {0xec, 0xbc, 0xa0}},
    {0xc4d3, {0xec, 0xbc, 0xa4}},
    {0xc4d4, {0xec, 0xbc, 0xac}},
    {0xc4d5, {0xec, 0xbc, 0xad}},
    {0xc4d6, {0xec, 0xbc, 0xaf}},
    {0xc4d7, {0xec, 0xbc, 0xb0}},
    {0xc4d8, {0xec, 0xbc, 0xb1}},
    {0xc4d9, {0xec, 0xbc, 0xb8}},
    {0xc4da, {0xec, 0xbd, 0x94}},
    {0xc4db, {0xec, 0xbd, 0x95}},
    {0xc4dc, {0xec, 0xbd, 0x98}},
    {0xc4dd, {0xec, 0xbd, 0x9c}},
    {0xc4de, {0xec, 0xbd, 0xa4}},
    {0xc4df, {0xec, 0xbd, 0xa5}},
    {0xc4e0, {0xec, 0xbd, 0xa7}},
    {0xc4e1, {0xec, 0xbd, 0xa9}},
    {0xc4e2, {0xec, 0xbd, 0xb0}},
    {0xc4e3, {0xec, 0xbd, 0xb1}},
    {0xc4e4, {0xec, 0xbd, 0xb4}},
    {0xc4e5, {0xec, 0xbd, 0xb8}},
    {0xc4e6, {0xec, 0xbe, 0x80}},
    {0xc4e7, {0xec, 0xbe, 0x85}},
    {0xc4e8, {0xec, 0xbe, 0x8c}},
    {0xc4e9, {0xec, 0xbe, 0xa1}},
    {0xc4ea, {0xec, 0xbe, 0xa8}},
    {0xc4eb, {0xec, 0xbe, 0xb0}},
    {0xc4ec, {0xec, 0xbf, 0x84}},
    {0xc4ed, {0xec, 0xbf, 0xa0}},
    {0xc4ee, {0xec, 0xbf, 0xa1}},
    {0xc4ef, {0xec, 0xbf, 0xa4}},
    {0xc4f0, {0xec, 0xbf, 0xa8}},
    {0xc4f1, {0xec, 0xbf, 0xb0}},
    {0xc4f2, {0xec, 0xbf, 0xb1}},
    {0xc4f3, {0xec, 0xbf, 0xb3}},
    {0xc4f4, {0xec, 0xbf, 0xb5}},
    {0xc4f5, {0xec, 0xbf, 0xbc}},
    {0xc4f6, {0xed, 0x80, 0x80}},
    {0xc4f7, {0xed, 0x80, 0x84}},
    {0xc4f8, {0xed, 0x80, 0x91}},
    {0xc4f9, {0xed, 0x80, 0x98}},
    {0xc4fa, {0xed, 0x80, 0xad}},
    {0xc4fb, {0xed, 0x80, 0xb4}},
    {0xc4fc, {0xed, 0x80, 0xb5}},
    {0xc4fd, {0xed, 0x80, 0xb8}},
    {0xc4fe, {0xed, 0x80, 0xbc}},
    {0xc5a1, {0xed, 0x81, 0x84}},
    {0xc5a2, {0xed, 0x81, 0x85}},
    {0xc5a3, {0xed, 0x81, 0x87}},
    {0xc5a4, {0xed, 0x81, 0x89}},
    {0xc5a5, {0xed, 0x81, 0x90}},
    {0xc5a6, {0xed, 0x81, 0x94}},
    {0xc5a7, {0xed, 0x81, 0x98}},
    {0xc5a8, {0xed, 0x81, 0xa0}},
    {0xc5a9, {0xed, 0x81, 0xac}},
    {0xc5aa, {0xed, 0x81, 0xad}},
    {0xc5ab, {0xed, 0x81, 0xb0}},
    {0xc5ac, {0xed, 0x81, 0xb4}},
    {0xc5ad, {0xed, 0x81, 0xbc}},
    {0xc5ae, {0xed, 0x81, 0xbd}},
    {0xc5af, {0xed, 0x82, 0x81}},
    {0xc5b0, {0xed, 0x82, 0xa4}},
    {0xc5b1, {0xed, 0x82, 0xa5}},
    {0xc5b2, {0xed, 0x82, 0xa8}},
    {0xc5b3, {0xed, 0x82, 0xac}},
    {0xc5b4, {0xed, 0x82, 0xb4}},
    {0xc5b5, {0xed, 0x82, 0xb5}},
    {0xc5b6, {0xed, 0x82, 0xb7}},
    {0xc5b7, {0xed, 0x82, 0xb9}},
    {0xc5b8, {0xed, 0x83, 0x80}},
    {0xc5b9, {0xed, 0x83, 0x81}},
    {0xc5ba, {0xed, 0x83, 0x84}},
    {0xc5bb, {0xed, 0x83, 0x88}},
    {0xc5bc, {0xed, 0x83, 0x89}},
    {0xc5bd, {0xed, 0x83, 0x90}},
    {0xc5be, {0xed, 0x83, 0x91}},
    {0xc5bf, {0xed, 0x83, 0x93}},
    {0xc5c0, {0xed, 0x83, 0x94}},
    {0xc5c1, {0xed, 0x83, 0x95}},
    {0xc5c2, {0xed, 0x83, 0x9c}},
    {0xc5c3, {0xed, 0x83, 0x9d}},
    {0xc5c4, {0xed, 0x83, 0xa0}},
    {0xc5c5, {0xed, 0x83, 0xa4}},
    {0xc5c6, {0xed, 0x83, 0xac}},
    {0xc5c7, {0xed, 0x83, 0xad}},
    {0xc5c8, {0xed, 0x83, 0xaf}},
    {0xc5c9, {0xed, 0x83, 0xb0}},
    {0xc5ca, {0xed, 0x83, 0xb1}},
    {0xc5cb, {0xed, 0x83, 0xb8}},
    {0xc5cc, {0xed, 0x84, 0x8d}},
    {0xc5cd, {0xed, 0x84, 0xb0}},
    {0xc5ce, {0xed, 0x84, 0xb1}},
    {0xc5cf, {0xed, 0x84, 0xb4}},
    {0xc5d0, {0xed, 0x84, 0xb8}},
    {0xc5d1, {0xed, 0x84, 0xba}},
    {0xc5d2, {0xed, 0x85, 0x80}},
    {0xc5d3, {0xed, 0x85, 0x81}},
    {0xc5d4, {0xed, 0x85, 0x83}},
    {0xc5d5, {0xed, 0x85, 0x84}},
    {0xc5d6, {0xed, 0x85, 0x85}},
    {0xc5d7, {0xed, 0x85, 0x8c}},
    {0xc5d8, {0xed, 0x85, 0x8d}},
    {0xc5d9, {0xed, 0x85, 0x90}},
    {0xc5da, {0xed, 0x85, 0x94}},
    {0xc5db, {0xed, 0x85, 0x9c}},
    {0xc5dc, {0xed, 0x85, 0x9d}},
    {0xc5dd, {0xed, 0x85, 0x9f}},
    {0xc5de, {0xed, 0x85, 0xa1}},
    {0xc5df, {0xed, 0x85, 0xa8}},
    {0xc5e0, {0xed, 0x85, 0xac}},
    {0xc5e1, {0xed, 0x85, 0xbc}},
    {0xc5e2, {0xed, 0x86, 0x84}},
    {0xc5e3, {0xed, 0x86, 0x88}},
    {0xc5e4, {0xed, 0x86, 0xa0}},
    {0xc5e5, {0xed, 0x86, 0xa1}},
    {0xc5e6, {0xed, 0x86, 0xa4}},
    {0xc5e7, {0xed, 0x86, 0xa8}},
    {0xc5e8, {0xed, 0x86, 0xb0}},
    {0xc5e9, {0xed, 0x86, 0xb1}},
    {0xc5ea, {0xed, 0x86, 0xb3}},
    {0xc5eb, {0xed, 0x86, 0xb5}},
    {0xc5ec, {0xed, 0x86, 0xba}},
    {0xc5ed, {0xed, 0x86, 0xbc}},
    {0xc5ee, {0xed, 0x87, 0x80}},
    {0xc5ef, {0xed, 0x87, 0x98}},
    {0xc5f0, {0xed, 0x87, 0xb4}},
    {0xc5f1, {0xed, 0x87, 0xb8}},
    {0xc5f2, {0xed, 0x88, 0x87}},
    {0xc5f3, {0xed, 0x88, 0x89}},
    {0xc5f4, {0xed, 0x88, 0x90}},
    {0xc5f5, {0xed, 0x88, 0xac}},
    {0xc5f6, {0xed, 0x88, 0xad}},
    {0xc5f7, {0xed, 0x88, 0xb0}},
    {0xc5f8, {0xed, 0x88, 0xb4}},
    {0xc5f9, {0xed, 0x88, 0xbc}},
    {0xc5fa, {0xed, 0x88, 0xbd}},
    {0xc5fb, {0xed, 0x88, 0xbf}},
    {0xc5fc, {0xed, 0x89, 0x81}},
    {0xc5fd, {0xed, 0x89, 0x88}},
    {0xc5fe, {0xed, 0x89, 0x9c}},
    {0xc6a1, {0xed, 0x89, 0xa4}},
    {0xc6a2, {0xed, 0x8a, 0x80}},
    {0xc6a3, {0xed, 0x8a, 0x81}},
    {0xc6a4, {0xed, 0x8a, 0x84}},
    {0xc6a5, {0xed, 0x8a, 0x88}},
    {0xc6a6, {0xed, 0x8a, 0x90}},
    {0xc6a7, {0xed, 0x8a, 0x91}},
    {0xc6a8, {0xed, 0x8a, 0x95}},
    {0xc6a9, {0xed, 0x8a, 0x9c}},
    {0xc6aa, {0xed, 0x8a, 0xa0}},
    {0xc6ab, {0xed, 0x8a, 0xa4}},
    {0xc6ac, {0xed, 0x8a, 0xac}},
    {0xc6ad, {0xed, 0x8a, 0xb1}},
    {0xc6ae, {0xed, 0x8a, 0xb8}},
    {0xc6af, {0xed, 0x8a, 0xb9}},
    {0xc6b0, {0xed, 0x8a, 0xbc}},
    {0xc6b1, {0xed, 0x8a, 0xbf}},
    {0xc6b2, {0xed, 0x8b, 0x80}},
    {0xc6b3, {0xed, 0x8b, 0x82}},
    {0xc6b4, {0xed, 0x8b, 0x88}},
    {0xc6b5, {0xed, 0x8b, 0x89}},
    {0xc6b6, {0xed, 0x8b, 0x8b}},
    {0xc6b7, {0xed, 0x8b, 0x94}},
    {0xc6b8, {0xed, 0x8b, 0x98}},
    {0xc6b9, {0xed, 0x8b, 0x9c}},
    {0xc6ba, {0xed, 0x8b, 0xa4}},
    {0xc6bb, {0xed, 0x8b, 0xa5}},
    {0xc6bc, {0xed, 0x8b, 0xb0}},
    {0xc6bd, {0xed, 0x8b, 0xb1}},
    {0xc6be, {0xed, 0x8b, 0xb4}},
    {0xc6bf, {0xed, 0x8b, 0xb8}},
    {0xc6c0, {0xed, 0x8c, 0x80}},
    {0xc6c1, {0xed, 0x8c, 0x81}},
    {0xc6c2, {0xed, 0x8c, 0x83}},
    {0xc6c3, {0xed, 0x8c, 0x85}},
    {0xc6c4, {0xed, 0x8c, 0x8c}},
    {0xc6c5, {0xed, 0x8c, 0x8d}},
    {0xc6c6, {0xed, 0x8c, 0x8e}},
    {0xc6c7, {0xed, 0x8c, 0x90}},
    {0xc6c8, {0xed, 0x8c, 0x94}},
    {0xc6c9, {0xed, 0x8c, 0x96}},
    {0xc6ca, {0xed, 0x8c, 0x9c}},
    {0xc6cb, {0xed, 0x8c, 0x9d}},
    {0xc6cc, {0xed, 0x8c, 0x9f}},
    {0xc6cd, {0xed, 0x8c, 0xa0}},
    {0xc6ce, {0xed, 0x8c, 0xa1}},
    {0xc6cf, {0xed, 0x8c, 0xa5}},
    {0xc6d0, {0xed, 0x8c, 0xa8}},
    {0xc6d1, {0xed, 0x8c, 0xa9}},
    {0xc6d2, {0xed, 0x8c, 0xac}},
    {0xc6d3, {0xed, 0x8c, 0xb0}},
    {0xc6d4, {0xed, 0x8c, 0xb8}},
    {0xc6d5, {0xed, 0x8c, 0xb9}},
    {0xc6d6, {0xed, 0x8c, 0xbb}},
    {0xc6d7, {0xed, 0x8c, 0xbc}},
    {0xc6d8, {0xed, 0x8c, 0xbd}},
    {0xc6d9, {0xed, 0x8d, 0x84}},
    {0xc6da, {0xed, 0x8d, 0x85}},
    {0xc6db, {0xed, 0x8d, 0xbc}},
    {0xc6dc, {0xed, 0x8d, 0xbd}},
    {0xc6dd, {0xed, 0x8e, 0x80}},
    {0xc6de, {0xed, 0x8e, 0x84}},
    {0xc6df, {0xed, 0x8e, 0x8c}},
    {0xc6e0, {0xed, 0x8e, 0x8d}},
    {0xc6e1, {0xed, 0x8e, 0x8f}},
    {0xc6e2, {0xed, 0x8e, 0x90}},
    {0xc6e3, {0xed, 0x8e, 0x91}},
    {0xc6e4, {0xed, 0x8e, 0x98}},
    {0xc6e5, {0xed, 0x8e, 0x99}},
    {0xc6e6, {0xed, 0x8e, 0x9c}},
    {0xc6e7, {0xed, 0x8e, 0xa0}},
    {0xc6e8, {0xed, 0x8e, 0xa8}},
    {0xc6e9, {0xed, 0x8e, 0xa9}},
    {0xc6ea, {0xed, 0x8e, 0xab}},
    {0xc6eb, {0xed, 0x8e, 0xad}},
    {0xc6ec, {0xed, 0x8e, 0xb4}},
    {0xc6ed, {0xed, 0x8e, 0xb8}},
    {0xc6ee, {0xed, 0x8e, 0xbc}},
    {0xc6ef, {0xed, 0x8f, 0x84}},
    {0xc6f0, {0xed, 0x8f, 0x85}},
    {0xc6f1, {0xed, 0x8f, 0x88}},
    {0xc6f2, {0xed, 0x8f, 0x89}},
    {0xc6f3, {0xed, 0x8f, 0x90}},
    {0xc6f4, {0xed, 0x8f, 0x98}},
    {0xc6f5, {0xed, 0x8f, 0xa1}},
    {0xc6f6, {0xed, 0x8f, 0xa3}},
    {0xc6f7, {0xed, 0x8f, 0xac}},
    {0xc6f8, {0xed, 0x8f, 0xad}},
    {0xc6f9, {0xed, 0x8f, 0xb0}},
    {0xc6fa, {0xed, 0x8f, 0xb4}},
    {0xc6fb, {0xed, 0x8f, 0xbc}},
    {0xc6fc, {0xed, 0x8f, 0xbd}},
    {0xc6fd, {0xed, 0x8f, 0xbf}},
    {0xc6fe, {0xed, 0x90, 0x81}},
    {0xc7a1, {0xed, 0x90, 0x88}},
    {0xc7a2, {0xed, 0x90, 0x9d}},
    {0xc7a3, {0xed, 0x91, 0x80}},
    {0xc7a4, {0xed, 0x91, 0x84}},
    {0xc7a5, {0xed, 0x91, 0x9c}},
    {0xc7a6, {0xed, 0x91, 0xa0}},
    {0xc7a7, {0xed, 0x91, 0xa4}},
    {0xc7a8, {0xed, 0x91, 0xad}},
    {0xc7a9, {0xed, 0x91, 0xaf}},
    {0xc7aa, {0xed, 0x91, 0xb8}},
    {0xc7ab, {0xed, 0x91, 0xb9}},
    {0xc7ac, {0xed, 0x91, 0xbc}},
    {0xc7ad, {0xed, 0x91, 0xbf}},
    {0xc7ae, {0xed, 0x92, 0x80}},
    {0xc7af, {0xed, 0x92, 0x82}},
    {0xc7b0, {0xed, 0x92, 0x88}},
    {0xc7b1, {0xed, 0x92, 0x89}},
    {0xc7b2, {0xed, 0x92, 0x8b}},
    {0xc7b3, {0xed, 0x92, 0x8d}},
    {0xc7b4, {0xed, 0x92, 0x94}},
    {0xc7b5, {0xed, 0x92, 0xa9}},
    {0xc7b6, {0xed, 0x93, 0x8c}},
    {0xc7b7, {0xed, 0x93, 0x90}},
    {0xc7b8, {0xed, 0x93, 0x94}},
    {0xc7b9, {0xed, 0x93, 0x9c}},
    {0xc7ba, {0xed, 0x93, 0x9f}},
    {0xc7bb, {0xed, 0x93, 0xa8}},
    {0xc7bc, {0xed, 0x93, 0xac}},
    {0xc7bd, {0xed, 0x93, 0xb0}},
    {0xc7be, {0xed, 0x93, 0xb8}},
    {0xc7bf, {0xed, 0x93, 0xbb}},
    {0xc7c0, {0xed, 0x93, 0xbd}},
    {0xc7c1, {0xed, 0x94, 0x84}},
    {0xc7c2, {0xed, 0x94, 0x88}},
    {0xc7c3, {0xed, 0x94, 0x8c}},
    {0xc7c4, {0xed, 0x94, 0x94}},
    {0xc7c5, {0xed, 0x94, 0x95}},
    {0xc7c6, {0xed, 0x94, 0x97}},
    {0xc7c7, {0xed, 0x94, 0xbc}},
    {0xc7c8, {0xed, 0x94, 0xbd}},
    {0xc7c9, {0xed, 0x95, 0x80}},
    {0xc7ca, {0xed, 0x95, 0x84}},
    {0xc7cb, {0xed, 0x95, 0x8c}},
    {0xc7cc, {0xed, 0x95, 0x8d}},
    {0xc7cd, {0xed, 0x95, 0x8f}},
    {0xc7ce, {0xed, 0x95, 0x91}},
    {0xc7cf, {0xed, 0x95, 0x98}},
    {0xc7d0, {0xed, 0x95, 0x99}},
    {0xc7d1, {0xed, 0x95, 0x9c}},
    {0xc7d2, {0xed, 0x95, 0xa0}},
    {0xc7d3, {0xed, 0x95, 0xa5}},
    {0xc7d4, {0xed, 0x95, 0xa8}},
    {0xc7d5, {0xed, 0x95, 0xa9}},
    {0xc7d6, {0xed, 0x95, 0xab}},
    {0xc7d7, {0xed, 0x95, 0xad}},
    {0xc7d8, {0xed, 0x95, 0xb4}},
    {0xc7d9, {0xed, 0x95, 0xb5}},
    {0xc7da, {0xed, 0x95, 0xb8}},
    {0xc7db, {0xed, 0x95, 0xbc}},
    {0xc7dc, {0xed, 0x96, 0x84}},
    {0xc7dd, {0xed, 0x96, 0x85}},
    {0xc7de, {0xed, 0x96, 0x87}},
    {0xc7df, {0xed, 0x96, 0x88}},
    {0xc7e0, {0xed, 0x96, 0x89}},
    {0xc7e1, {0xed, 0x96, 0x90}},
    {0xc7e2, {0xed, 0x96, 0xa5}},
    {0xc7e3, {0xed, 0x97, 0x88}},
    {0xc7e4, {0xed, 0x97, 0x89}},
    {0xc7e5, {0xed, 0x97, 0x8c}},
    {0xc7e6, {0xed, 0x97, 0x90}},
    {0xc7e7, {0xed, 0x97, 0x92}},
    {0xc7e8, {0xed, 0x97, 0x98}},
    {0xc7e9, {0xed, 0x97, 0x99}},
    {0xc7ea, {0xed, 0x97, 0x9b}},
    {0xc7eb, {0xed, 0x97, 0x9d}},
    {0xc7ec, {0xed, 0x97, 0xa4}},
    {0xc7ed, {0xed, 0x97, 0xa5}},
    {0xc7ee, {0xed, 0x97, 0xa8}},
    {0xc7ef, {0xed, 0x97, 0xac}},
    {0xc7f0, {0xed, 0x97, 0xb4}},
    {0xc7f1, {0xed, 0x97, 0xb5}},
    {0xc7f2, {0xed, 0x97, 0xb7}},
    {0xc7f3, {0xed, 0x97, 0xb9}},
    {0xc7f4, {0xed, 0x98, 0x80}},
    {0xc7f5, {0xed, 0x98, 0x81}},
    {0xc7f6, {0xed, 0x98, 0x84}},
    {0xc7f7, {0xed, 0x98, 0x88}},
    {0xc7f8, {0xed, 0x98, 0x90}},
    {0xc7f9, {0xed, 0x98, 0x91}},
    {0xc7fa, {0xed, 0x98, 0x93}},
    {0xc7fb, {0xed, 0x98, 0x94}},
    {0xc7fc, {0xed, 0x98, 0x95}},
    {0xc7fd, {0xed, 0x98, 0x9c}},
    {0xc7fe, {0xed, 0x98, 0xa0}},
    {0xc8a1, {0xed, 0x98, 0xa4}},
    {0xc8a2, {0xed, 0x98, 0xad}},
    {0xc8a3, {0xed, 0x98, 0xb8}},
    {0xc8a4, {0xed, 0x98, 0xb9}},
    {0xc8a5, {0xed, 0x98, 0xbc}},
    {0xc8a6, {0xed, 0x99, 0x80}},
    {0xc8a7, {0xed, 0x99, 0x85}},
    {0xc8a8, {0xed, 0x99, 0x88}},
    {0xc8a9, {0xed, 0x99, 0x89}},
    {0xc8aa, {0xed, 0x99, 0x8b}},
    {0xc8ab, {0xed, 0x99, 0x8d}},
    {0xc8ac, {0xed, 0x99, 0x91}},
    {0xc8ad, {0xed, 0x99, 0x94}},
    {0xc8ae, {0xed, 0x99, 0x95}},
    {0xc8af, {0xed, 0x99, 0x98}},
    {0xc8b0, {0xed, 0x99, 0x9c}},
    {0xc8b1, {0xed, 0x99, 0xa7}},
    {0xc8b2, {0xed, 0x99, 0xa9}},
    {0xc8b3, {0xed, 0x99, 0xb0}},
    {0xc8b4, {0xed, 0x99, 0xb1}},
    {0xc8b5, {0xed, 0x99, 0xb4}},
    {0xc8b6, {0xed, 0x9a, 0x83}},
    {0xc8b7, {0xed, 0x9a, 0x85}},
    {0xc8b8, {0xed, 0x9a, 0x8c}},
    {0xc8b9, {0xed, 0x9a, 0x8d}},
    {0xc8ba, {0xed, 0x9a, 0x90}},
    {0xc8bb, {0xed, 0x9a, 0x94}},
    {0xc8bc, {0xed, 0x9a, 0x9d}},
    {0xc8bd, {0xed, 0x9a, 0x9f}},
    {0xc8be, {0xed, 0x9a, 0xa1}},
    {0xc8bf, {0xed, 0x9a, 0xa8}},
    {0xc8c0, {0xed, 0x9a, 0xac}},
    {0xc8c1, {0xed, 0x9a, 0xb0}},
    {0xc8c2, {0xed, 0x9a, 0xb9}},
    {0xc8c3, {0xed, 0x9a, 0xbb}},
    {0xc8c4, {0xed, 0x9b, 0x84}},
    {0xc8c5, {0xed, 0x9b, 0x85}},
    {0xc8c6, {0xed, 0x9b, 0x88}},
    {0xc8c7, {0xed, 0x9b, 0x8c}},
    {0xc8c8, {0xed, 0x9b, 0x91}},
    {0xc8c9, {0xed, 0x9b, 0x94}},
    {0xc8ca, {0xed, 0x9b, 0x97}},
    {0xc8cb, {0xed, 0x9b, 0x99}},
    {0xc8cc, {0xed, 0x9b, 0xa0}},
    {0xc8cd, {0xed, 0x9b, 0xa4}},
    {0xc8ce, {0xed, 0x9b, 0xa8}},
    {0xc8cf, {0xed, 0x9b, 0xb0}},
    {0xc8d0, {0xed, 0x9b, 0xb5}},
    {0xc8d1, {0xed, 0x9b, 0xbc}},
    {0xc8d2, {0xed, 0x9b, 0xbd}},
    {0xc8d3, {0xed, 0x9c, 0x80}},
    {0xc8d4, {0xed, 0x9c, 0x84}},
    {0xc8d5, {0xed, 0x9c, 0x91}},
    {0xc8d6, {0xed, 0x9c, 0x98}},
    {0xc8d7, {0xed, 0x9c, 0x99}},
    {0xc8d8, {0xed, 0x9c, 0x9c}},
    {0xc8d9, {0xed, 0x9c, 0xa0}},
    {0xc8da, {0xed, 0x9c, 0xa8}},
    {0xc8db, {0xed, 0x9c, 0xa9}},
    {0xc8dc, {0xed, 0x9c, 0xab}},
    {0xc8dd, {0xed, 0x9c, 0xad}},
    {0xc8de, {0xed, 0x9c, 0xb4}},
    {0xc8df, {0xed, 0x9c, 0xb5}},
    {0xc8e0, {0xed, 0x9c, 0xb8}},
    {0xc8e1, {0xed, 0x9c, 0xbc}},
    {0xc8e2, {0xed, 0x9d, 0x84}},
    {0xc8e3, {0xed, 0x9d, 0x87}},
    {0xc8e4, {0xed, 0x9d, 0x89}},
    {0xc8e5, {0xed, 0x9d, 0x90}},
    {0xc8e6, {0xed, 0x9d, 0x91}},
    {0xc8e7, {0xed, 0x9d, 0x94}},
    {0xc8e8, {0xed, 0x9d, 0x96}},
    {0xc8e9, {0xed, 0x9d, 0x97}},
    {0xc8ea, {0xed, 0x9d, 0x98}},
    {0xc8eb, {0xed, 0x9d, 0x99}},
    {0xc8ec, {0xed, 0x9d, 0xa0}},
    {0xc8ed, {0xed, 0x9d, 0xa1}},
    {0xc8ee, {0xed, 0x9d, 0xa3}},
    {0xc8ef, {0xed, 0x9d, 0xa5}},
    {0xc8f0, {0xed, 0x9d, 0xa9}},
    {0xc8f1, {0xed, 0x9d, 0xac}},
    {0xc8f2, {0xed, 0x9d, 0xb0}},
    {0xc8f3, {0xed, 0x9d, 0xb4}},
    {0xc8f4, {0xed, 0x9d, 0xbc}},
    {0xc8f5, {0xed, 0x9d, 0xbd}},
    {0xc8f6, {0xed, 0x9e, 0x81}},
    {0xc8f7, {0xed, 0x9e, 0x88}},
    {0xc8f8, {0xed, 0x9e, 0x89}},
    {0xc8f9, {0xed, 0x9e, 0x8c}},
    {0xc8fa, {0xed, 0x9e, 0x90}},
    {0xc8fb, {0xed, 0x9e, 0x98}},
    {0xc8fc, {0xed, 0x9e, 0x99}},
    {0xc8fd, {0xed, 0x9e, 0x9b}},
    {0xc8fe, {0xed, 0x9e, 0x9d}}
};

static korean_entry utf8_to_codepage[IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS];

static int compare_utf8(const void *a, const void *b)
{
    const uint8_t *va = ((const korean_entry*) a)->utf8;
    const uint8_t *vb = ((const korean_entry*) b)->utf8;
    for (int i = 0; i < 3; i++) {
        if (va[i] == vb[i]) {
            continue;
        }
        return va[i] < vb[i] ? -1 : 1;
    }
    return 0;
}

static int compare_codepage(const void *a, const void *b)
{
    uint16_t va = ((const korean_entry*) a)->cp949;
    uint16_t vb = ((const korean_entry*) b)->cp949;
    return va == vb ? 0 : (va < vb ? -1 : 1);
}

void encoding_korean_init(void)
{
    // codepage_to_unicode is already sorted, copy data and sort the other way around
    memcpy(utf8_to_codepage, codepage_to_utf8,
        IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS * sizeof(korean_entry));

    qsort(utf8_to_codepage, IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS, sizeof(korean_entry), compare_utf8);
}

void encoding_korean_to_utf8(const uint8_t *input, char *output, int output_length)
{
    const char *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if (*input < 0x80) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // multi-byte char
            const korean_entry key = {input[0] << 8 | input[1]};
            const korean_entry *entry = bsearch(&key, codepage_to_utf8,
                IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS, sizeof(korean_entry), compare_codepage);
            if (entry && output + 3 <= max_output) {
                for (int i = 0; i < 3; i++) {
                    *output = entry->utf8[i];
                    output++;
                }
            }
            input += 2;
        }
    }
    *output = 0;
}

void encoding_korean_from_utf8(const char *input, uint8_t *output, int output_length)
{
    const uint8_t *max_output = &output[output_length - 1];

    while (*input && output < max_output) {
        if (*input >= 0 && *input <= 0x7f) {
            *output = *input;
            ++output;
            ++input;
        } else {
            // multi-byte char: Korean characters are always 3 bytes in utf-8
            const korean_entry key = {0, {(uint8_t)input[0], (uint8_t)input[1], (uint8_t)input[2]}};
            const korean_entry *entry = bsearch(&key, utf8_to_codepage,
                IMAGE_FONT_MULTIBYTE_KOREAN_MAX_CHARS, sizeof(korean_entry), compare_utf8);
            if (entry && output + 2 <= max_output) {
                *output = (entry->cp949 >> 8) & 0xff;
                output++;
                *output = entry->cp949 & 0xff;
                output++;
            } else {
                *output = '?';
                output++;
            }
            input += 3;
        }
    }
    *output = 0;
}
