// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
	// Logo detection, tracking, and recognition.
	Feature_LOGO_RECOGNITION Feature = 12
	// Celebrity recognition.
	Feature_CELEBRITY_RECOGNITION Feature = 13
)

var Feature_name = map[int32]string{
	0:  "FEATURE_UNSPECIFIED",
	1:  "LABEL_DETECTION",
	2:  "SHOT_CHANGE_DETECTION",
	3:  "EXPLICIT_CONTENT_DETECTION",
	6:  "SPEECH_TRANSCRIPTION",
	7:  "TEXT_DETECTION",
	9:  "OBJECT_TRACKING",
	12: "LOGO_RECOGNITION",
	13: "CELEBRITY_RECOGNITION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"SPEECH_TRANSCRIPTION":       6,
	"TEXT_DETECTION":             7,
	"OBJECT_TRACKING":            9,
	"LOGO_RECOGNITION":           12,
	"CELEBRITY_RECOGNITION":      13,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{2}
}

// Streaming video annotation feature.
type StreamingFeature int32

const (
	// Unspecified.
	StreamingFeature_STREAMING_FEATURE_UNSPECIFIED StreamingFeature = 0
	// Label detection. Detect objects, such as dog or flower.
	StreamingFeature_STREAMING_LABEL_DETECTION StreamingFeature = 1
	// Shot change detection.
	StreamingFeature_STREAMING_SHOT_CHANGE_DETECTION StreamingFeature = 2
	// Explicit content detection.
	StreamingFeature_STREAMING_EXPLICIT_CONTENT_DETECTION StreamingFeature = 3
	// Object detection and tracking.
	StreamingFeature_STREAMING_OBJECT_TRACKING StreamingFeature = 4
	// Video classification based on AutoML model.
	StreamingFeature_STREAMING_AUTOML_CLASSIFICATION StreamingFeature = 21
	// Object detection and tracking based on AutoML model.
	StreamingFeature_STREAMING_AUTOML_OBJECT_TRACKING StreamingFeature = 22
)

var StreamingFeature_name = map[int32]string{
	0:  "STREAMING_FEATURE_UNSPECIFIED",
	1:  "STREAMING_LABEL_DETECTION",
	2:  "STREAMING_SHOT_CHANGE_DETECTION",
	3:  "STREAMING_EXPLICIT_CONTENT_DETECTION",
	4:  "STREAMING_OBJECT_TRACKING",
	21: "STREAMING_AUTOML_CLASSIFICATION",
	22: "STREAMING_AUTOML_OBJECT_TRACKING",
}

var StreamingFeature_value = map[string]int32{
	"STREAMING_FEATURE_UNSPECIFIED":        0,
	"STREAMING_LABEL_DETECTION":            1,
	"STREAMING_SHOT_CHANGE_DETECTION":      2,
	"STREAMING_EXPLICIT_CONTENT_DETECTION": 3,
	"STREAMING_OBJECT_TRACKING":            4,
	"STREAMING_AUTOML_CLASSIFICATION":      21,
	"STREAMING_AUTOML_OBJECT_TRACKING":     22,
}

func (x StreamingFeature) String() string {
	return proto.EnumName(StreamingFeature_name, int32(x))
}

func (StreamingFeature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{3}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p3beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	// Config for OBJECT_TRACKING.
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,13,opt,name=object_tracking_config,json=objectTrackingConfig,proto3" json:"object_tracking_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

func (m *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if m != nil {
		return m.TextDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if m != nil {
		return m.ObjectTrackingConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p3beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// frame-level detection. If not set, it is set to 0.4 by default. The valid
	// range for this threshold is [0.1, 0.9]. Any value set outside of this
	// range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	FrameConfidenceThreshold float32 `protobuf:"fixed32,4,opt,name=frame_confidence_threshold,json=frameConfidenceThreshold,proto3" json:"frame_confidence_threshold,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// video-level and shot-level detections. If not set, it is set to 0.3 by
	// default. The valid range for this threshold is [0.1, 0.9]. Any value set
	// outside of this range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	VideoConfidenceThreshold float32  `protobuf:"fixed32,5,opt,name=video_confidence_threshold,json=videoConfidenceThreshold,proto3" json:"video_confidence_threshold,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *LabelDetectionConfig) GetFrameConfidenceThreshold() float32 {
	if m != nil {
		return m.FrameConfidenceThreshold
	}
	return 0
}

func (m *LabelDetectionConfig) GetVideoConfidenceThreshold() float32 {
	if m != nil {
		return m.VideoConfidenceThreshold
	}
	return 0
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for OBJECT_TRACKING.
type ObjectTrackingConfig struct {
	// Model to use for object tracking.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectTrackingConfig) Reset()         { *m = ObjectTrackingConfig{} }
func (m *ObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingConfig) ProtoMessage()    {}
func (*ObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{4}
}

func (m *ObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingConfig.Unmarshal(m, b)
}
func (m *ObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingConfig.Merge(m, src)
}
func (m *ObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingConfig.Size(m)
}
func (m *ObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingConfig proto.InternalMessageInfo

func (m *ObjectTrackingConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{5}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Model to use for text detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextDetectionConfig) Reset()         { *m = TextDetectionConfig{} }
func (m *TextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*TextDetectionConfig) ProtoMessage()    {}
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{6}
}

func (m *TextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextDetectionConfig.Unmarshal(m, b)
}
func (m *TextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextDetectionConfig.Marshal(b, m, deterministic)
}
func (m *TextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextDetectionConfig.Merge(m, src)
}
func (m *TextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_TextDetectionConfig.Size(m)
}
func (m *TextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TextDetectionConfig proto.InternalMessageInfo

func (m *TextDetectionConfig) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *TextDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{7}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{8}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{9}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{10}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{11}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p3beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{12}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{13}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{14}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// For tracking related features.
// An object at time_offset with attributes, and located with
// normalized_bounding_box.
type TimestampedObject struct {
	// Normalized Bounding box in a frame, where the object is located.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this object.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Optional. The attributes of the object in the bounding box.
	Attributes           []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimestampedObject) Reset()         { *m = TimestampedObject{} }
func (m *TimestampedObject) String() string { return proto.CompactTextString(m) }
func (*TimestampedObject) ProtoMessage()    {}
func (*TimestampedObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{15}
}

func (m *TimestampedObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampedObject.Unmarshal(m, b)
}
func (m *TimestampedObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampedObject.Marshal(b, m, deterministic)
}
func (m *TimestampedObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampedObject.Merge(m, src)
}
func (m *TimestampedObject) XXX_Size() int {
	return xxx_messageInfo_TimestampedObject.Size(m)
}
func (m *TimestampedObject) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampedObject.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampedObject proto.InternalMessageInfo

func (m *TimestampedObject) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *TimestampedObject) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *TimestampedObject) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A track of an object instance.
type Track struct {
	// Video segment of a track.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// The object with timestamp and attributes per frame in the track.
	TimestampedObjects []*TimestampedObject `protobuf:"bytes,2,rep,name=timestamped_objects,json=timestampedObjects,proto3" json:"timestamped_objects,omitempty"`
	// Optional. Attributes in the track level.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The confidence score of the tracked object.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Track) Reset()         { *m = Track{} }
func (m *Track) String() string { return proto.CompactTextString(m) }
func (*Track) ProtoMessage()    {}
func (*Track) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{16}
}

func (m *Track) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Track.Unmarshal(m, b)
}
func (m *Track) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Track.Marshal(b, m, deterministic)
}
func (m *Track) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Track.Merge(m, src)
}
func (m *Track) XXX_Size() int {
	return xxx_messageInfo_Track.Size(m)
}
func (m *Track) XXX_DiscardUnknown() {
	xxx_messageInfo_Track.DiscardUnknown(m)
}

var xxx_messageInfo_Track proto.InternalMessageInfo

func (m *Track) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *Track) GetTimestampedObjects() []*TimestampedObject {
	if m != nil {
		return m.TimestampedObjects
	}
	return nil
}

func (m *Track) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Track) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// A generic detected attribute represented by name in string format.
type DetectedAttribute struct {
	// The name of the attribute, i.e. glasses, dark_glasses, mouth_open etc.
	// A full list of supported type names will be provided in the document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Detected attribute confidence. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Text value of the detection result. For example, the value for "HairColor"
	// can be "black", "blonde", etc.
	Value                string   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedAttribute) Reset()         { *m = DetectedAttribute{} }
func (m *DetectedAttribute) String() string { return proto.CompactTextString(m) }
func (*DetectedAttribute) ProtoMessage()    {}
func (*DetectedAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{17}
}

func (m *DetectedAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedAttribute.Unmarshal(m, b)
}
func (m *DetectedAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedAttribute.Marshal(b, m, deterministic)
}
func (m *DetectedAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedAttribute.Merge(m, src)
}
func (m *DetectedAttribute) XXX_Size() int {
	return xxx_messageInfo_DetectedAttribute.Size(m)
}
func (m *DetectedAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedAttribute proto.InternalMessageInfo

func (m *DetectedAttribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetectedAttribute) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *DetectedAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Celebrity definition.
type Celebrity struct {
	// The resource name of the celebrity. Have the format
	// `video-intelligence/kg-mid` indicates a celebrity from preloaded gallery.
	// kg-mid is the id in Google knowledge graph, which is unique for the
	// celebrity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The celebrity name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Textual description of additional information about the celebrity, if
	// applicable.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Celebrity) Reset()         { *m = Celebrity{} }
func (m *Celebrity) String() string { return proto.CompactTextString(m) }
func (*Celebrity) ProtoMessage()    {}
func (*Celebrity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{18}
}

func (m *Celebrity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Celebrity.Unmarshal(m, b)
}
func (m *Celebrity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Celebrity.Marshal(b, m, deterministic)
}
func (m *Celebrity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Celebrity.Merge(m, src)
}
func (m *Celebrity) XXX_Size() int {
	return xxx_messageInfo_Celebrity.Size(m)
}
func (m *Celebrity) XXX_DiscardUnknown() {
	xxx_messageInfo_Celebrity.DiscardUnknown(m)
}

var xxx_messageInfo_Celebrity proto.InternalMessageInfo

func (m *Celebrity) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Celebrity) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Celebrity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// The annotation result of a celebrity face track. RecognizedCelebrity field
// could be empty if the face track does not have any matched celebrities.
type CelebrityTrack struct {
	// Top N match of the celebrities for the face in this track.
	Celebrities []*CelebrityTrack_RecognizedCelebrity `protobuf:"bytes,1,rep,name=celebrities,proto3" json:"celebrities,omitempty"`
	// A track of a person's face.
	FaceTrack            *Track   `protobuf:"bytes,3,opt,name=face_track,json=faceTrack,proto3" json:"face_track,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CelebrityTrack) Reset()         { *m = CelebrityTrack{} }
func (m *CelebrityTrack) String() string { return proto.CompactTextString(m) }
func (*CelebrityTrack) ProtoMessage()    {}
func (*CelebrityTrack) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{19}
}

func (m *CelebrityTrack) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityTrack.Unmarshal(m, b)
}
func (m *CelebrityTrack) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityTrack.Marshal(b, m, deterministic)
}
func (m *CelebrityTrack) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityTrack.Merge(m, src)
}
func (m *CelebrityTrack) XXX_Size() int {
	return xxx_messageInfo_CelebrityTrack.Size(m)
}
func (m *CelebrityTrack) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityTrack.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityTrack proto.InternalMessageInfo

func (m *CelebrityTrack) GetCelebrities() []*CelebrityTrack_RecognizedCelebrity {
	if m != nil {
		return m.Celebrities
	}
	return nil
}

func (m *CelebrityTrack) GetFaceTrack() *Track {
	if m != nil {
		return m.FaceTrack
	}
	return nil
}

// The recognized celebrity with confidence score.
type CelebrityTrack_RecognizedCelebrity struct {
	// The recognized celebrity.
	Celebrity *Celebrity `protobuf:"bytes,1,opt,name=celebrity,proto3" json:"celebrity,omitempty"`
	// Recognition confidence. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CelebrityTrack_RecognizedCelebrity) Reset()         { *m = CelebrityTrack_RecognizedCelebrity{} }
func (m *CelebrityTrack_RecognizedCelebrity) String() string { return proto.CompactTextString(m) }
func (*CelebrityTrack_RecognizedCelebrity) ProtoMessage()    {}
func (*CelebrityTrack_RecognizedCelebrity) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{19, 0}
}

func (m *CelebrityTrack_RecognizedCelebrity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Unmarshal(m, b)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Marshal(b, m, deterministic)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Merge(m, src)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_Size() int {
	return xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.Size(m)
}
func (m *CelebrityTrack_RecognizedCelebrity) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityTrack_RecognizedCelebrity.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityTrack_RecognizedCelebrity proto.InternalMessageInfo

func (m *CelebrityTrack_RecognizedCelebrity) GetCelebrity() *Celebrity {
	if m != nil {
		return m.Celebrity
	}
	return nil
}

func (m *CelebrityTrack_RecognizedCelebrity) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Celebrity recognition annotation per video.
type CelebrityRecognitionAnnotation struct {
	// The tracks detected from the input video, including recognized celebrities
	// and other detected faces in the video.
	CelebrityTracks      []*CelebrityTrack `protobuf:"bytes,1,rep,name=celebrity_tracks,json=celebrityTracks,proto3" json:"celebrity_tracks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CelebrityRecognitionAnnotation) Reset()         { *m = CelebrityRecognitionAnnotation{} }
func (m *CelebrityRecognitionAnnotation) String() string { return proto.CompactTextString(m) }
func (*CelebrityRecognitionAnnotation) ProtoMessage()    {}
func (*CelebrityRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{20}
}

func (m *CelebrityRecognitionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Unmarshal(m, b)
}
func (m *CelebrityRecognitionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Marshal(b, m, deterministic)
}
func (m *CelebrityRecognitionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CelebrityRecognitionAnnotation.Merge(m, src)
}
func (m *CelebrityRecognitionAnnotation) XXX_Size() int {
	return xxx_messageInfo_CelebrityRecognitionAnnotation.Size(m)
}
func (m *CelebrityRecognitionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_CelebrityRecognitionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_CelebrityRecognitionAnnotation proto.InternalMessageInfo

func (m *CelebrityRecognitionAnnotation) GetCelebrityTracks() []*CelebrityTrack {
	if m != nil {
		return m.CelebrityTracks
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Video segment on which the annotation is run.
	Segment *VideoSegment `protobuf:"bytes,10,opt,name=segment,proto3" json:"segment,omitempty"`
	// Topical label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Presence label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label. Compared to the
	// existing topical `segment_label_annotations`, this field presents more
	// fine-grained, segment-level labels detected in video content and is made
	// available only when the client sets `LabelDetectionConfig.model` to
	// "builtin/latest" in the request.
	SegmentPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,23,rep,name=segment_presence_label_annotations,json=segmentPresenceLabelAnnotations,proto3" json:"segment_presence_label_annotations,omitempty"`
	// Topical label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Presence label annotations on shot level. There is exactly one element for
	// each unique label. Compared to the existing topical
	// `shot_label_annotations`, this field presents more fine-grained, shot-level
	// labels detected in video content and is made available only when the client
	// sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
	ShotPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,24,rep,name=shot_presence_label_annotations,json=shotPresenceLabelAnnotations,proto3" json:"shot_presence_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// Annotations for list of logos detected, tracked and recognized in video.
	LogoRecognitionAnnotations []*LogoRecognitionAnnotation `protobuf:"bytes,19,rep,name=logo_recognition_annotations,json=logoRecognitionAnnotations,proto3" json:"logo_recognition_annotations,omitempty"`
	// Celebrity recognition annotations.
	CelebrityRecognitionAnnotations *CelebrityRecognitionAnnotation `protobuf:"bytes,21,opt,name=celebrity_recognition_annotations,json=celebrityRecognitionAnnotations,proto3" json:"celebrity_recognition_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{21}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetLogoRecognitionAnnotations() []*LogoRecognitionAnnotation {
	if m != nil {
		return m.LogoRecognitionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetCelebrityRecognitionAnnotations() *CelebrityRecognitionAnnotation {
	if m != nil {
		return m.CelebrityRecognitionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{22}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Specifies which feature is being tracked if the request contains more than
	// one features.
	Feature Feature `protobuf:"varint,5,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1p3beta1.Feature" json:"feature,omitempty"`
	// Specifies which segment is being tracked if the request contains more than
	// one segments.
	Segment              *VideoSegment `protobuf:"bytes,6,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{23}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetFeature() Feature {
	if m != nil {
		return m.Feature
	}
	return Feature_FEATURE_UNSPECIFIED
}

func (m *VideoAnnotationProgress) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{24}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// Required. *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// Optional. If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// Optional. A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Optional. If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// Optional. For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	// Optional. If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_tag provided
	// in the WordInfo.
	// Note: When this is true, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	EnableSpeakerDiarization bool `protobuf:"varint,7,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// Optional. If set, specifies the estimated number of speakers in the
	// conversation. If not set, defaults to '2'. Ignored unless
	// enable_speaker_diarization is set to true.
	DiarizationSpeakerCount int32 `protobuf:"varint,8,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// Optional. If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool     `protobuf:"varint,9,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{25}
}

func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (m *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(m, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableSpeakerDiarization() bool {
	if m != nil {
		return m.EnableSpeakerDiarization
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetDiarizationSpeakerCount() int32 {
	if m != nil {
		return m.DiarizationSpeakerCount
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetEnableWordConfidence() bool {
	if m != nil {
		return m.EnableWordConfidence
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// Optional. A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{26}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{27}
}

func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (m *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(m, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *SpeechTranscription) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	// Note: When `enable_speaker_diarization` is true, you will see all the words
	// from the beginning of the audio.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{28}
}

func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(m, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from 1 up to diarization_speaker_count,
	// and is only set if speaker diarization is enabled.
	SpeakerTag           int32    `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{29}
}

func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (m *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(m, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func (m *WordInfo) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *WordInfo) GetSpeakerTag() int32 {
	if m != nil {
		return m.SpeakerTag
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{30}
}

func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (m *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(m, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	// Normalized vertices of the bounding polygon.
	Vertices             []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{31}
}

func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(m, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames               []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *TextSegment) Reset()         { *m = TextSegment{} }
func (m *TextSegment) String() string { return proto.CompactTextString(m) }
func (*TextSegment) ProtoMessage()    {}
func (*TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{32}
}

func (m *TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSegment.Unmarshal(m, b)
}
func (m *TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSegment.Marshal(b, m, deterministic)
}
func (m *TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSegment.Merge(m, src)
}
func (m *TextSegment) XXX_Size() int {
	return xxx_messageInfo_TextSegment.Size(m)
}
func (m *TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TextSegment proto.InternalMessageInfo

func (m *TextSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *TextSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *TextSegment) GetFrames() []*TextFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextFrame) Reset()         { *m = TextFrame{} }
func (m *TextFrame) String() string { return proto.CompactTextString(m) }
func (*TextFrame) ProtoMessage()    {}
func (*TextFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{33}
}

func (m *TextFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextFrame.Unmarshal(m, b)
}
func (m *TextFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextFrame.Marshal(b, m, deterministic)
}
func (m *TextFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextFrame.Merge(m, src)
}
func (m *TextFrame) XXX_Size() int {
	return xxx_messageInfo_TextFrame.Size(m)
}
func (m *TextFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_TextFrame.DiscardUnknown(m)
}

var xxx_messageInfo_TextFrame proto.InternalMessageInfo

func (m *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if m != nil {
		return m.RotatedBoundingBox
	}
	return nil
}

func (m *TextFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments             []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TextAnnotation) Reset()         { *m = TextAnnotation{} }
func (m *TextAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextAnnotation) ProtoMessage()    {}
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{34}
}

func (m *TextAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAnnotation.Unmarshal(m, b)
}
func (m *TextAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAnnotation.Marshal(b, m, deterministic)
}
func (m *TextAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAnnotation.Merge(m, src)
}
func (m *TextAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextAnnotation.Size(m)
}
func (m *TextAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextAnnotation proto.InternalMessageInfo

func (m *TextAnnotation) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextAnnotation) GetSegments() []*TextSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{35}
}

func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(m, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

func (m *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	// Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
	// messages in frames.
	// Streaming mode: it can only be one ObjectTrackingFrame message in frames.
	Frames []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
	// Different representation of tracking info in non-streaming batch
	// and streaming modes.
	//
	// Types that are valid to be assigned to TrackInfo:
	//	*ObjectTrackingAnnotation_Segment
	//	*ObjectTrackingAnnotation_TrackId
	TrackInfo            isObjectTrackingAnnotation_TrackInfo `protobuf_oneof:"track_info"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ObjectTrackingAnnotation) Reset()         { *m = ObjectTrackingAnnotation{} }
func (m *ObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingAnnotation) ProtoMessage()    {}
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{36}
}

func (m *ObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *ObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingAnnotation.Merge(m, src)
}
func (m *ObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingAnnotation.Size(m)
}
func (m *ObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingAnnotation proto.InternalMessageInfo

func (m *ObjectTrackingAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

type isObjectTrackingAnnotation_TrackInfo interface {
	isObjectTrackingAnnotation_TrackInfo()
}

type ObjectTrackingAnnotation_Segment struct {
	Segment *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3,oneof"`
}

type ObjectTrackingAnnotation_TrackId struct {
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3,oneof"`
}

func (*ObjectTrackingAnnotation_Segment) isObjectTrackingAnnotation_TrackInfo() {}

func (*ObjectTrackingAnnotation_TrackId) isObjectTrackingAnnotation_TrackInfo() {}

func (m *ObjectTrackingAnnotation) GetTrackInfo() isObjectTrackingAnnotation_TrackInfo {
	if m != nil {
		return m.TrackInfo
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_Segment); ok {
		return x.Segment
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetTrackId() int64 {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_TrackId); ok {
		return x.TrackId
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ObjectTrackingAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ObjectTrackingAnnotation_Segment)(nil),
		(*ObjectTrackingAnnotation_TrackId)(nil),
	}
}

// Annotation corresponding to one detected, tracked and recognized logo class.
type LogoRecognitionAnnotation struct {
	// Entity category information to specify the logo class that all the logo
	// tracks within this LogoRecognitionAnnotation are recognized as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// All logo tracks where the recognized logo appears. Each track corresponds
	// to one logo instance appearing in consecutive frames.
	Tracks []*Track `protobuf:"bytes,2,rep,name=tracks,proto3" json:"tracks,omitempty"`
	// All video segments where the recognized logo appears. There might be
	// multiple instances of the same logo class appearing in one VideoSegment.
	Segments             []*VideoSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *LogoRecognitionAnnotation) Reset()         { *m = LogoRecognitionAnnotation{} }
func (m *LogoRecognitionAnnotation) String() string { return proto.CompactTextString(m) }
func (*LogoRecognitionAnnotation) ProtoMessage()    {}
func (*LogoRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{37}
}

func (m *LogoRecognitionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogoRecognitionAnnotation.Unmarshal(m, b)
}
func (m *LogoRecognitionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogoRecognitionAnnotation.Marshal(b, m, deterministic)
}
func (m *LogoRecognitionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogoRecognitionAnnotation.Merge(m, src)
}
func (m *LogoRecognitionAnnotation) XXX_Size() int {
	return xxx_messageInfo_LogoRecognitionAnnotation.Size(m)
}
func (m *LogoRecognitionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LogoRecognitionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LogoRecognitionAnnotation proto.InternalMessageInfo

func (m *LogoRecognitionAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetTracks() []*Track {
	if m != nil {
		return m.Tracks
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// The top-level message sent by the client for the `StreamingAnnotateVideo`
// method. Multiple `StreamingAnnotateVideoRequest` messages are sent.
// The first message must only contain a `StreamingVideoConfig` message.
// All subsequent messages must only contain `input_content` data.
type StreamingAnnotateVideoRequest struct {
	// *Required* The streaming request, which is either a streaming config or
	// video content.
	//
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingAnnotateVideoRequest_VideoConfig
	//	*StreamingAnnotateVideoRequest_InputContent
	StreamingRequest     isStreamingAnnotateVideoRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *StreamingAnnotateVideoRequest) Reset()         { *m = StreamingAnnotateVideoRequest{} }
func (m *StreamingAnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoRequest) ProtoMessage()    {}
func (*StreamingAnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{38}
}

func (m *StreamingAnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *StreamingAnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoRequest.Merge(m, src)
}
func (m *StreamingAnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Size(m)
}
func (m *StreamingAnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoRequest proto.InternalMessageInfo

type isStreamingAnnotateVideoRequest_StreamingRequest interface {
	isStreamingAnnotateVideoRequest_StreamingRequest()
}

type StreamingAnnotateVideoRequest_VideoConfig struct {
	VideoConfig *StreamingVideoConfig `protobuf:"bytes,1,opt,name=video_config,json=videoConfig,proto3,oneof"`
}

type StreamingAnnotateVideoRequest_InputContent struct {
	InputContent []byte `protobuf:"bytes,2,opt,name=input_content,json=inputContent,proto3,oneof"`
}

func (*StreamingAnnotateVideoRequest_VideoConfig) isStreamingAnnotateVideoRequest_StreamingRequest() {}

func (*StreamingAnnotateVideoRequest_InputContent) isStreamingAnnotateVideoRequest_StreamingRequest() {
}

func (m *StreamingAnnotateVideoRequest) GetStreamingRequest() isStreamingAnnotateVideoRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetVideoConfig() *StreamingVideoConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_VideoConfig); ok {
		return x.VideoConfig
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetInputContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_InputContent); ok {
		return x.InputContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamingAnnotateVideoRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamingAnnotateVideoRequest_VideoConfig)(nil),
		(*StreamingAnnotateVideoRequest_InputContent)(nil),
	}
}

// `StreamingAnnotateVideoResponse` is the only message returned to the client
// by `StreamingAnnotateVideo`. A series of zero or more
// `StreamingAnnotateVideoResponse` messages are streamed back to the client.
type StreamingAnnotateVideoResponse struct {
	// If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Streaming annotation results.
	AnnotationResults *StreamingVideoAnnotationResults `protobuf:"bytes,2,opt,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	// GCS URI that stores annotation results of one streaming session.
	// It is a directory that can hold multiple files in JSON format.
	// Example uri format:
	// gs://bucket_id/object_id/cloud_project_name-session_id
	AnnotationResultsUri string   `protobuf:"bytes,3,opt,name=annotation_results_uri,json=annotationResultsUri,proto3" json:"annotation_results_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAnnotateVideoResponse) Reset()         { *m = StreamingAnnotateVideoResponse{} }
func (m *StreamingAnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoResponse) ProtoMessage()    {}
func (*StreamingAnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{39}
}

func (m *StreamingAnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *StreamingAnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoResponse.Merge(m, src)
}
func (m *StreamingAnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Size(m)
}
func (m *StreamingAnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoResponse proto.InternalMessageInfo

func (m *StreamingAnnotateVideoResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResults() *StreamingVideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResultsUri() string {
	if m != nil {
		return m.AnnotationResultsUri
	}
	return ""
}

// Config for STREAMING_AUTOML_CLASSIFICATION.
type StreamingAutomlClassificationConfig struct {
	// Resource name of AutoML model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	ModelName            string   `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAutomlClassificationConfig) Reset()         { *m = StreamingAutomlClassificationConfig{} }
func (m *StreamingAutomlClassificationConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingAutomlClassificationConfig) ProtoMessage()    {}
func (*StreamingAutomlClassificationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{40}
}

func (m *StreamingAutomlClassificationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Unmarshal(m, b)
}
func (m *StreamingAutomlClassificationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Marshal(b, m, deterministic)
}
func (m *StreamingAutomlClassificationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAutomlClassificationConfig.Merge(m, src)
}
func (m *StreamingAutomlClassificationConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingAutomlClassificationConfig.Size(m)
}
func (m *StreamingAutomlClassificationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAutomlClassificationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAutomlClassificationConfig proto.InternalMessageInfo

func (m *StreamingAutomlClassificationConfig) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

// Config for STREAMING_AUTOML_OBJECT_TRACKING.
type StreamingAutomlObjectTrackingConfig struct {
	// Resource name of AutoML model.
	// Format: `projects/{project_id}/locations/{location_id}/models/{model_id}`
	ModelName            string   `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAutomlObjectTrackingConfig) Reset()         { *m = StreamingAutomlObjectTrackingConfig{} }
func (m *StreamingAutomlObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingAutomlObjectTrackingConfig) ProtoMessage()    {}
func (*StreamingAutomlObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{41}
}

func (m *StreamingAutomlObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Unmarshal(m, b)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Merge(m, src)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingAutomlObjectTrackingConfig.Size(m)
}
func (m *StreamingAutomlObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAutomlObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAutomlObjectTrackingConfig proto.InternalMessageInfo

func (m *StreamingAutomlObjectTrackingConfig) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

// Config for STREAMING_EXPLICIT_CONTENT_DETECTION.
type StreamingExplicitContentDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingExplicitContentDetectionConfig) Reset() {
	*m = StreamingExplicitContentDetectionConfig{}
}
func (m *StreamingExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingExplicitContentDetectionConfig) ProtoMessage()    {}
func (*StreamingExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{42}
}

func (m *StreamingExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.Merge(m, src)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Size(m)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingExplicitContentDetectionConfig proto.InternalMessageInfo

// Config for STREAMING_LABEL_DETECTION.
type StreamingLabelDetectionConfig struct {
	// Whether the video has been captured from a stationary (i.e. non-moving)
	// camera. When set to true, might improve detection accuracy for moving
	// objects. Default: false.
	StationaryCamera     bool     `protobuf:"varint,1,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingLabelDetectionConfig) Reset()         { *m = StreamingLabelDetectionConfig{} }
func (m *StreamingLabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingLabelDetectionConfig) ProtoMessage()    {}
func (*StreamingLabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{43}
}

func (m *StreamingLabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingLabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingLabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingLabelDetectionConfig.Merge(m, src)
}
func (m *StreamingLabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Size(m)
}
func (m *StreamingLabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingLabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingLabelDetectionConfig proto.InternalMessageInfo

func (m *StreamingLabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

// Config for STREAMING_OBJECT_TRACKING.
type StreamingObjectTrackingConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingObjectTrackingConfig) Reset()         { *m = StreamingObjectTrackingConfig{} }
func (m *StreamingObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingObjectTrackingConfig) ProtoMessage()    {}
func (*StreamingObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{44}
}

func (m *StreamingObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Unmarshal(m, b)
}
func (m *StreamingObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *StreamingObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingObjectTrackingConfig.Merge(m, src)
}
func (m *StreamingObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Size(m)
}
func (m *StreamingObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingObjectTrackingConfig proto.InternalMessageInfo

// Config for STREAMING_SHOT_CHANGE_DETECTION.
type StreamingShotChangeDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingShotChangeDetectionConfig) Reset()         { *m = StreamingShotChangeDetectionConfig{} }
func (m *StreamingShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingShotChangeDetectionConfig) ProtoMessage()    {}
func (*StreamingShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{45}
}

func (m *StreamingShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.Merge(m, src)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Size(m)
}
func (m *StreamingShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingShotChangeDetectionConfig proto.InternalMessageInfo

// Config for streaming storage option.
type StreamingStorageConfig struct {
	// Enable streaming storage. Default: false.
	EnableStorageAnnotationResult bool `protobuf:"varint,1,opt,name=enable_storage_annotation_result,json=enableStorageAnnotationResult,proto3" json:"enable_storage_annotation_result,omitempty"`
	// GCS URI to store all annotation results for one client. Client should
	// specify this field as the top-level storage directory. Annotation results
	// of different sessions will be put into different sub-directories denoted
	// by project_name and session_id. All sub-directories will be auto generated
	// by program and will be made accessible to client in response proto.
	// URIs must be specified in the following format: `gs://bucket-id/object-id`
	// `bucket-id` should be a valid GCS bucket created by client and bucket
	// permission shall also be configured properly. `object-id` can be arbitrary
	// string that make sense to client. Other URI formats will return error and
	// cause GCS write failure.
	AnnotationResultStorageDirectory string   `protobuf:"bytes,3,opt,name=annotation_result_storage_directory,json=annotationResultStorageDirectory,proto3" json:"annotation_result_storage_directory,omitempty"`
	XXX_NoUnkeyedLiteral             struct{} `json:"-"`
	XXX_unrecognized                 []byte   `json:"-"`
	XXX_sizecache                    int32    `json:"-"`
}

func (m *StreamingStorageConfig) Reset()         { *m = StreamingStorageConfig{} }
func (m *StreamingStorageConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingStorageConfig) ProtoMessage()    {}
func (*StreamingStorageConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{46}
}

func (m *StreamingStorageConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingStorageConfig.Unmarshal(m, b)
}
func (m *StreamingStorageConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingStorageConfig.Marshal(b, m, deterministic)
}
func (m *StreamingStorageConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingStorageConfig.Merge(m, src)
}
func (m *StreamingStorageConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingStorageConfig.Size(m)
}
func (m *StreamingStorageConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingStorageConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingStorageConfig proto.InternalMessageInfo

func (m *StreamingStorageConfig) GetEnableStorageAnnotationResult() bool {
	if m != nil {
		return m.EnableStorageAnnotationResult
	}
	return false
}

func (m *StreamingStorageConfig) GetAnnotationResultStorageDirectory() string {
	if m != nil {
		return m.AnnotationResultStorageDirectory
	}
	return ""
}

// Streaming annotation results corresponding to a portion of the video
// that is currently being processed.
type StreamingVideoAnnotationResults struct {
	// Shot annotation results. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,1,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Label annotation results.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// Explicit content annotation results.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,3,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Object tracking results.
	ObjectAnnotations    []*ObjectTrackingAnnotation `protobuf:"bytes,4,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *StreamingVideoAnnotationResults) Reset()         { *m = StreamingVideoAnnotationResults{} }
func (m *StreamingVideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoAnnotationResults) ProtoMessage()    {}
func (*StreamingVideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{47}
}

func (m *StreamingVideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Unmarshal(m, b)
}
func (m *StreamingVideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *StreamingVideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoAnnotationResults.Merge(m, src)
}
func (m *StreamingVideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Size(m)
}
func (m *StreamingVideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoAnnotationResults proto.InternalMessageInfo

func (m *StreamingVideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

// Provides information to the annotator that specifies how to process the
// request.
type StreamingVideoConfig struct {
	// Requested annotation feature.
	Feature StreamingFeature `protobuf:"varint,1,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1p3beta1.StreamingFeature" json:"feature,omitempty"`
	// Config for requested annotation feature.
	//
	// Types that are valid to be assigned to StreamingConfig:
	//	*StreamingVideoConfig_ShotChangeDetectionConfig
	//	*StreamingVideoConfig_LabelDetectionConfig
	//	*StreamingVideoConfig_ExplicitContentDetectionConfig
	//	*StreamingVideoConfig_ObjectTrackingConfig
	//	*StreamingVideoConfig_AutomlClassificationConfig
	//	*StreamingVideoConfig_AutomlObjectTrackingConfig
	StreamingConfig isStreamingVideoConfig_StreamingConfig `protobuf_oneof:"streaming_config"`
	// Streaming storage option. By default: storage is disabled.
	StorageConfig        *StreamingStorageConfig `protobuf:"bytes,30,opt,name=storage_config,json=storageConfig,proto3" json:"storage_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StreamingVideoConfig) Reset()         { *m = StreamingVideoConfig{} }
func (m *StreamingVideoConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoConfig) ProtoMessage()    {}
func (*StreamingVideoConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06234ac6e4dad78c, []int{48}
}

func (m *StreamingVideoConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoConfig.Unmarshal(m, b)
}
func (m *StreamingVideoConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoConfig.Marshal(b, m, deterministic)
}
func (m *StreamingVideoConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoConfig.Merge(m, src)
}
func (m *StreamingVideoConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoConfig.Size(m)
}
func (m *StreamingVideoConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoConfig proto.InternalMessageInfo

func (m *StreamingVideoConfig) GetFeature() StreamingFeature {
	if m != nil {
		return m.Feature
	}
	return StreamingFeature_STREAMING_FEATURE_UNSPECIFIED
}

type isStreamingVideoConfig_StreamingConfig interface {
	isStreamingVideoConfig_StreamingConfig()
}

type StreamingVideoConfig_ShotChangeDetectionConfig struct {
	ShotChangeDetectionConfig *StreamingShotChangeDetectionConfig `protobuf:"bytes,2,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_LabelDetectionConfig struct {
	LabelDetectionConfig *StreamingLabelDetectionConfig `protobuf:"bytes,3,opt,name=label_detection_config,json=labelDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ExplicitContentDetectionConfig struct {
	ExplicitContentDetectionConfig *StreamingExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ObjectTrackingConfig struct {
	ObjectTrackingConfig *StreamingObjectTrackingConfig `protobuf:"bytes,5,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type StreamingVideoConfig_AutomlClassificationConfig struct {
	AutomlClassificationConfig *StreamingAutomlClassificationConfig `protobuf:"bytes,21,opt,name=automl_classification_config,json=automlClassificationConfig,proto3,oneof"`
}

type StreamingVideoConfig_AutomlObjectTrackingConfig struct {
	AutomlObjectTrackingConfig *StreamingAutomlObjectTrackingConfig `protobuf:"bytes,22,opt,name=automl_object_tracking_config,json=automlObjectTrackingConfig,proto3,oneof"`
}

func (*StreamingVideoConfig_ShotChangeDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_LabelDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ExplicitContentDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ObjectTrackingConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_AutomlClassificationConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_AutomlObjectTrackingConfig) isStreamingVideoConfig_StreamingConfig() {}

func (m *StreamingVideoConfig) GetStreamingConfig() isStreamingVideoConfig_StreamingConfig {
	if m != nil {
		return m.StreamingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetShotChangeDetectionConfig() *StreamingShotChangeDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ShotChangeDetectionConfig); ok {
		return x.ShotChangeDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetLabelDetectionConfig() *StreamingLabelDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_LabelDetectionConfig); ok {
		return x.LabelDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetExplicitContentDetectionConfig() *StreamingExplicitContentDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ExplicitContentDetectionConfig); ok {
		return x.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetObjectTrackingConfig() *StreamingObjectTrackingConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetAutomlClassificationConfig() *StreamingAutomlClassificationConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_AutomlClassificationConfig); ok {
		return x.AutomlClassificationConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetAutomlObjectTrackingConfig() *StreamingAutomlObjectTrackingConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_AutomlObjectTrackingConfig); ok {
		return x.AutomlObjectTrackingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetStorageConfig() *StreamingStorageConfig {
	if m != nil {
		return m.StorageConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamingVideoConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamingVideoConfig_ShotChangeDetectionConfig)(nil),
		(*StreamingVideoConfig_LabelDetectionConfig)(nil),
		(*StreamingVideoConfig_ExplicitContentDetectionConfig)(nil),
		(*StreamingVideoConfig_ObjectTrackingConfig)(nil),
		(*StreamingVideoConfig_AutomlClassificationConfig)(nil),
		(*StreamingVideoConfig_AutomlObjectTrackingConfig)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.StreamingFeature", StreamingFeature_name, StreamingFeature_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p3beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*TextDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.TextDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p3beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p3beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p3beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p3beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox")
	proto.RegisterType((*TimestampedObject)(nil), "google.cloud.videointelligence.v1p3beta1.TimestampedObject")
	proto.RegisterType((*Track)(nil), "google.cloud.videointelligence.v1p3beta1.Track")
	proto.RegisterType((*DetectedAttribute)(nil), "google.cloud.videointelligence.v1p3beta1.DetectedAttribute")
	proto.RegisterType((*Celebrity)(nil), "google.cloud.videointelligence.v1p3beta1.Celebrity")
	proto.RegisterType((*CelebrityTrack)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityTrack")
	proto.RegisterType((*CelebrityTrack_RecognizedCelebrity)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity")
	proto.RegisterType((*CelebrityRecognitionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.CelebrityRecognitionAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1p3beta1.WordInfo")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedVertex")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingPoly")
	proto.RegisterType((*TextSegment)(nil), "google.cloud.videointelligence.v1p3beta1.TextSegment")
	proto.RegisterType((*TextFrame)(nil), "google.cloud.videointelligence.v1p3beta1.TextFrame")
	proto.RegisterType((*TextAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.TextAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame")
	proto.RegisterType((*ObjectTrackingAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation")
	proto.RegisterType((*LogoRecognitionAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.LogoRecognitionAnnotation")
	proto.RegisterType((*StreamingAnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoRequest")
	proto.RegisterType((*StreamingAnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoResponse")
	proto.RegisterType((*StreamingAutomlClassificationConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAutomlClassificationConfig")
	proto.RegisterType((*StreamingAutomlObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAutomlObjectTrackingConfig")
	proto.RegisterType((*StreamingExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingExplicitContentDetectionConfig")
	proto.RegisterType((*StreamingLabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingLabelDetectionConfig")
	proto.RegisterType((*StreamingObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingObjectTrackingConfig")
	proto.RegisterType((*StreamingShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingShotChangeDetectionConfig")
	proto.RegisterType((*StreamingStorageConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingStorageConfig")
	proto.RegisterType((*StreamingVideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults")
	proto.RegisterType((*StreamingVideoConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoConfig")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p3beta1/video_intelligence.proto", fileDescriptor_06234ac6e4dad78c)
}

var fileDescriptor_06234ac6e4dad78c = []byte{
	// 3539 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5b, 0xcd, 0x73, 0x23, 0x47,
	0x54, 0xf7, 0x8c, 0x6c, 0xaf, 0xfd, 0x2c, 0xdb, 0x72, 0xfb, 0x4b, 0x76, 0xd6, 0x1f, 0x3b, 0xbb,
	0x01, 0x67, 0x09, 0x72, 0x76, 0x37, 0x84, 0x64, 0xf3, 0x29, 0xcb, 0x5a, 0x5b, 0xac, 0xfc, 0x91,
	0xb1, 0xd6, 0x64, 0x21, 0xa9, 0x61, 0x3c, 0x6a, 0xc9, 0x93, 0x1d, 0x4d, 0x2b, 0x33, 0x23, 0xaf,
	0x9d, 0x4b, 0x52, 0x81, 0x50, 0xa9, 0xa2, 0x28, 0x0a, 0xc2, 0x81, 0x13, 0x7f, 0x40, 0x28, 0xaa,
	0x80, 0x23, 0x1c, 0xe0, 0x42, 0x51, 0xb5, 0x45, 0xe5, 0x40, 0x8a, 0x03, 0x49, 0x0e, 0x1c, 0x52,
	0xfc, 0x0d, 0x14, 0x27, 0xaa, 0x3f, 0xe6, 0x43, 0x9a, 0x91, 0x6d, 0xc9, 0xbb, 0x45, 0x71, 0xd3,
	0xbc, 0x7e, 0xfd, 0x7b, 0xaf, 0x5f, 0xbf, 0x7e, 0xaf, 0xfb, 0x75, 0x0b, 0xf2, 0x75, 0x42, 0xea,
	0x16, 0x5e, 0x37, 0x2c, 0xd2, 0xaa, 0xae, 0x9f, 0x98, 0x55, 0x4c, 0x4c, 0xdb, 0xc3, 0x96, 0x65,
	0xd6, 0xb1, 0x6d, 0xe0, 0xf5, 0x93, 0x3b, 0xcd, 0x7b, 0x47, 0xd8, 0xd3, 0xef, 0xf0, 0x36, 0x2d,
	0xda, 0x98, 0x6b, 0x3a, 0xc4, 0x23, 0x68, 0x8d, 0x43, 0xe4, 0x18, 0x44, 0x2e, 0x06, 0x91, 0x0b,
	0x20, 0x16, 0xaf, 0x0b, 0x61, 0x7a, 0xd3, 0x5c, 0xd7, 0x6d, 0x9b, 0x78, 0xba, 0x67, 0x12, 0xdb,
	0xe5, 0x38, 0x8b, 0xf3, 0x91, 0x56, 0xc3, 0x32, 0xb1, 0xed, 0x89, 0x86, 0x95, 0x48, 0x43, 0xcd,
	0xc4, 0x56, 0x55, 0x3b, 0xc2, 0xc7, 0xfa, 0x89, 0x49, 0x1c, 0xc1, 0x70, 0x53, 0x30, 0x58, 0xc4,
	0xae, 0x3b, 0x2d, 0xdb, 0x36, 0xed, 0xfa, 0x3a, 0x69, 0x62, 0xa7, 0x0d, 0x7e, 0x59, 0x30, 0xb1,
	0xaf, 0xa3, 0x56, 0x6d, 0xbd, 0xda, 0xe2, 0x0c, 0x1d, 0x52, 0x82, 0x76, 0xcf, 0x6c, 0x60, 0xd7,
	0xd3, 0x1b, 0xcd, 0x0e, 0xfd, 0x9c, 0xa6, 0xb1, 0xee, 0x7a, 0xba, 0xd7, 0x12, 0xc8, 0xca, 0x0f,
	0x32, 0xcc, 0xe4, 0xf9, 0x70, 0xf0, 0x21, 0x1d, 0xbe, 0x8a, 0x3f, 0x6b, 0x61, 0xd7, 0x43, 0x2f,
	0xc1, 0xa8, 0x69, 0x37, 0x5b, 0x9e, 0xd6, 0x72, 0xcc, 0xac, 0xb4, 0x2a, 0xad, 0x8d, 0xaa, 0x23,
	0x8c, 0xf0, 0xc8, 0x31, 0xd1, 0x4d, 0x18, 0xe7, 0x8d, 0x06, 0xb1, 0x3d, 0x6c, 0x7b, 0xd9, 0xe1,
	0x55, 0x69, 0x2d, 0xad, 0xa6, 0x19, 0xb1, 0xc0, 0x69, 0x48, 0x85, 0x91, 0x1a, 0xd6, 0xbd, 0x96,
	0x83, 0xdd, 0xac, 0xbc, 0x9a, 0x5a, 0x9b, 0xb8, 0x7b, 0x27, 0x77, 0x59, 0x73, 0xe7, 0x1e, 0xf0,
	0x9e, 0x1b, 0xa9, 0xff, 0xcc, 0xcb, 0x6a, 0x80, 0x83, 0x7e, 0x17, 0xc6, 0xf9, 0x5c, 0x32, 0xc1,
	0xa7, 0x5e, 0x36, 0xb5, 0x2a, 0xad, 0x8d, 0xdd, 0x7d, 0xe3, 0xf2, 0xc0, 0x6c, 0x90, 0x05, 0xde,
	0x5b, 0x4d, 0x9f, 0x44, 0xbe, 0x90, 0x02, 0x40, 0x5a, 0x9e, 0x3f, 0xe6, 0x41, 0x3a, 0x66, 0x2a,
	0x5f, 0x52, 0x47, 0x39, 0x99, 0x8e, 0xfc, 0x16, 0x8c, 0x59, 0xc4, 0x60, 0xb6, 0xd7, 0xcc, 0x6a,
	0x76, 0x28, 0x64, 0x02, 0x9f, 0x5e, 0xaa, 0x2a, 0xbf, 0x0c, 0x43, 0x3a, 0x2a, 0x88, 0xda, 0xc2,
	0xc5, 0xf5, 0x06, 0xb6, 0x3d, 0x37, 0x2b, 0xad, 0xa6, 0xfa, 0x50, 0xf9, 0x80, 0x77, 0x57, 0x03,
	0x1c, 0xe4, 0xc1, 0x9c, 0xa5, 0x1f, 0x61, 0x4b, 0xab, 0x62, 0x0f, 0x1b, 0x4c, 0x23, 0x83, 0xd8,
	0x35, 0xb3, 0x9e, 0x95, 0x99, 0x51, 0xde, 0xbb, 0xbc, 0x84, 0x32, 0xc5, 0xd9, 0xf4, 0x61, 0x0a,
	0x0c, 0x45, 0x9d, 0xb1, 0x12, 0xa8, 0xe8, 0x0f, 0x24, 0xb8, 0xee, 0x1e, 0x13, 0x4f, 0x33, 0x8e,
	0x75, 0xbb, 0x8e, 0xe3, 0xc2, 0xf9, 0x8c, 0x14, 0x2e, 0x2f, 0xfc, 0xe0, 0x98, 0x78, 0x05, 0x06,
	0xd6, 0xa9, 0xc1, 0x82, 0xdb, 0xad, 0x09, 0x7d, 0x2b, 0xc1, 0x0d, 0x7c, 0xda, 0xb4, 0x4c, 0xc3,
	0x0c, 0xbc, 0x30, 0xae, 0xcb, 0x20, 0xd3, 0x65, 0xfb, 0xf2, 0xba, 0x14, 0x05, 0xa4, 0xf0, 0xe1,
	0x4e, 0x85, 0x96, 0xf1, 0xb9, 0xed, 0xe8, 0xf7, 0x25, 0x78, 0xc9, 0x6d, 0x62, 0x6c, 0x1c, 0x6b,
	0x9e, 0xa3, 0xdb, 0xae, 0xe1, 0x98, 0xcd, 0xa8, 0x3e, 0xc3, 0x3d, 0xdb, 0x86, 0x81, 0x55, 0xa2,
	0x58, 0x81, 0x6d, 0xba, 0x35, 0xa1, 0xcf, 0x60, 0x96, 0x3a, 0x5d, 0xdc, 0x1c, 0x23, 0x4c, 0xfc,
	0xbb, 0x97, 0x17, 0x5f, 0xc1, 0xa7, 0x31, 0x1b, 0x4c, 0x7b, 0x71, 0x22, 0xf5, 0x45, 0x72, 0xf4,
	0x29, 0x36, 0x3c, 0x3a, 0x6e, 0xe3, 0x89, 0x69, 0xd7, 0x7d, 0x99, 0xe3, 0xbd, 0xfa, 0xe2, 0x1e,
	0xc3, 0xa9, 0x08, 0x18, 0xdf, 0x17, 0x49, 0x02, 0x55, 0xf9, 0x67, 0x19, 0x66, 0x92, 0x5c, 0x17,
	0xd9, 0x30, 0xd3, 0xb9, 0x34, 0x1a, 0xa4, 0x8a, 0x59, 0x1c, 0x9b, 0xb8, 0xfb, 0x4e, 0xbf, 0x0b,
	0x63, 0x87, 0x54, 0xb1, 0x8a, 0xac, 0x18, 0x0d, 0xfd, 0x1a, 0x4c, 0xb9, 0x3c, 0x21, 0xe8, 0xce,
	0x99, 0x66, 0xe8, 0x0d, 0xec, 0xe8, 0x6c, 0x15, 0x8e, 0xa8, 0x99, 0xb0, 0xa1, 0xc0, 0xe8, 0x68,
	0x06, 0x86, 0xa8, 0x32, 0x16, 0x5b, 0x29, 0xa3, 0x2a, 0xff, 0x40, 0xef, 0xc0, 0x62, 0xcd, 0xd1,
	0x1b, 0x98, 0xdb, 0xad, 0x4a, 0xf5, 0xd0, 0xbc, 0x63, 0x07, 0xbb, 0xc7, 0xc4, 0xaa, 0x32, 0x47,
	0x96, 0xd5, 0x2c, 0xe3, 0x28, 0x04, 0x0c, 0x15, 0xbf, 0x9d, 0xf6, 0x0e, 0xe2, 0x62, 0xbc, 0xf7,
	0x10, 0xef, 0xed, 0x07, 0xbb, 0xce, 0xde, 0xca, 0x1d, 0x58, 0xe8, 0xba, 0x08, 0x43, 0x75, 0xa5,
	0x88, 0xba, 0xca, 0xab, 0x30, 0x93, 0x34, 0x51, 0x5d, 0xb8, 0xdf, 0x80, 0xe5, 0xf3, 0x57, 0x56,
	0x97, 0x7e, 0x2a, 0x4c, 0x27, 0xb8, 0x20, 0x7a, 0x19, 0x26, 0x2c, 0xdd, 0xae, 0xb7, 0xf4, 0x3a,
	0xd6, 0x8e, 0x4d, 0x3f, 0xa6, 0x8e, 0xaa, 0xe3, 0x3e, 0x75, 0x9b, 0x12, 0x43, 0x4c, 0x39, 0x8a,
	0xf9, 0x17, 0x92, 0x88, 0xcd, 0x22, 0xa2, 0xa2, 0x22, 0x9b, 0x3c, 0xc7, 0xd3, 0x68, 0xd2, 0xd4,
	0x48, 0xad, 0xe6, 0x62, 0x8f, 0xa9, 0x31, 0x76, 0x77, 0xc1, 0xf7, 0x14, 0x3f, 0xb1, 0xe6, 0x36,
	0x45, 0xe2, 0x55, 0x27, 0x59, 0x9f, 0x8a, 0xd9, 0xc0, 0x7b, 0xac, 0x07, 0xca, 0xc3, 0x24, 0xb6,
	0xab, 0x6d, 0x20, 0xf2, 0x45, 0x20, 0xe3, 0xd8, 0xae, 0x86, 0x10, 0xca, 0x97, 0x12, 0xa4, 0x99,
	0xc7, 0xf9, 0xaa, 0xed, 0xc3, 0x35, 0x11, 0xee, 0x85, 0x42, 0xfd, 0x66, 0x0d, 0x1f, 0x06, 0x2d,
	0x03, 0x84, 0x2e, 0xc2, 0x14, 0x94, 0xd5, 0x08, 0x45, 0x39, 0x06, 0x60, 0x1a, 0x3c, 0xa0, 0x9e,
	0x86, 0xee, 0xc3, 0x58, 0x4f, 0x46, 0x01, 0x2f, 0xb4, 0xc7, 0x45, 0x92, 0x2c, 0x18, 0x2e, 0xda,
	0x9e, 0xe9, 0x9d, 0xd1, 0xad, 0x06, 0x66, 0xbf, 0x68, 0x46, 0x15, 0x5b, 0x0d, 0x4e, 0x28, 0x55,
	0xd1, 0x2a, 0x8c, 0x55, 0x71, 0x10, 0xe1, 0xc4, 0x54, 0x46, 0x49, 0x74, 0x33, 0x12, 0x78, 0x83,
	0x41, 0x57, 0x39, 0x5f, 0x57, 0x69, 0x9f, 0x58, 0x20, 0x55, 0xac, 0xfc, 0x2c, 0xc3, 0x24, 0x1b,
	0x58, 0x3e, 0xd8, 0xbb, 0xa1, 0x6d, 0x18, 0xe6, 0x62, 0xc4, 0xc0, 0x5e, 0xeb, 0x21, 0x4f, 0xb0,
	0x7e, 0xaa, 0xe8, 0x8f, 0x3e, 0x81, 0x29, 0x43, 0xf7, 0x70, 0x9d, 0x38, 0x67, 0x1a, 0x23, 0x99,
	0x62, 0xcf, 0xd3, 0x0f, 0x68, 0xc6, 0x87, 0x2a, 0x0a, 0xa4, 0xb6, 0xdd, 0x43, 0xaa, 0xd7, 0xdd,
	0x43, 0xd4, 0xa1, 0x22, 0xbb, 0x87, 0x32, 0x0c, 0xb3, 0x68, 0xe2, 0x66, 0x07, 0x19, 0xe2, 0xeb,
	0x3d, 0x22, 0x32, 0x07, 0x51, 0x05, 0x86, 0xf2, 0x8f, 0x12, 0xcc, 0x74, 0xac, 0xf0, 0xab, 0x7b,
	0xd0, 0x13, 0x98, 0x6b, 0x12, 0xc7, 0x26, 0x75, 0x47, 0x6f, 0x1e, 0x9f, 0x69, 0x96, 0xf9, 0x04,
	0x5b, 0xe6, 0x31, 0x21, 0x55, 0xe6, 0x05, 0x13, 0x3d, 0xa9, 0x1c, 0xf4, 0x55, 0x67, 0x23, 0x98,
	0x21, 0x59, 0x71, 0x61, 0xa1, 0x63, 0x00, 0x11, 0x4f, 0x39, 0x0c, 0x8c, 0xc5, 0x37, 0x6f, 0xef,
	0xf5, 0xbd, 0xa3, 0x68, 0x37, 0xdb, 0x13, 0x98, 0xdd, 0x25, 0x4e, 0x43, 0xb7, 0xcc, 0xcf, 0x71,
	0x75, 0x83, 0xb4, 0xec, 0xaa, 0x69, 0xd7, 0x37, 0xc8, 0x29, 0x42, 0x30, 0x68, 0xe1, 0x1a, 0xb7,
	0x97, 0xac, 0xb2, 0xdf, 0x28, 0x03, 0x29, 0x8f, 0x34, 0xc5, 0x4a, 0xa2, 0x3f, 0x69, 0x80, 0x73,
	0xcc, 0xfa, 0x31, 0xdf, 0x05, 0xcb, 0x2a, 0xff, 0x40, 0x73, 0x30, 0x7c, 0x44, 0x3c, 0x8f, 0x34,
	0x44, 0xd6, 0x10, 0x5f, 0xca, 0x77, 0x32, 0x4c, 0x55, 0xfc, 0x73, 0x01, 0xae, 0xf2, 0xf0, 0x8d,
	0x9e, 0xc2, 0xbc, 0x1d, 0xa8, 0xa0, 0x1d, 0x09, 0x1d, 0xb4, 0x23, 0x72, 0x2a, 0x26, 0xeb, 0xfd,
	0xcb, 0x8f, 0x35, 0x71, 0x2c, 0xea, 0xac, 0x9d, 0x38, 0xc4, 0x0e, 0xcf, 0x90, 0x7b, 0xf1, 0x8c,
	0xdf, 0x03, 0xd0, 0x3d, 0xcf, 0x31, 0x8f, 0x5a, 0x1e, 0xf6, 0x97, 0xc4, 0xdb, 0x97, 0xd7, 0x93,
	0xe7, 0x13, 0x5c, 0xcd, 0xfb, 0x18, 0x62, 0x07, 0x1f, 0x62, 0x2a, 0xdf, 0xcb, 0x30, 0xc4, 0x52,
	0xdb, 0x0b, 0x88, 0xc1, 0x16, 0x4c, 0x7b, 0xe1, 0x3c, 0x68, 0x7c, 0x6b, 0xe3, 0xc7, 0x8b, 0x1e,
	0x86, 0x11, 0x9b, 0x4c, 0x15, 0x79, 0x9d, 0x24, 0xf7, 0xc5, 0xdb, 0x0a, 0xdd, 0x6c, 0x8b, 0xf4,
	0xcc, 0xe9, 0x04, 0x53, 0x24, 0xdc, 0x7f, 0x02, 0x53, 0x31, 0x28, 0xea, 0xe6, 0xb6, 0xde, 0xc0,
	0x22, 0xe8, 0xb3, 0xdf, 0x17, 0xe5, 0x0d, 0xea, 0xf4, 0x27, 0xba, 0xd5, 0xf2, 0xc3, 0x3c, 0xff,
	0x50, 0xaa, 0x30, 0x5a, 0xc0, 0x16, 0x3e, 0x72, 0x68, 0x38, 0x4e, 0x82, 0xbd, 0x01, 0xe9, 0xaa,
	0xe9, 0x36, 0x2d, 0xfd, 0x4c, 0x63, 0x6d, 0x7e, 0x22, 0xe1, 0xb4, 0x5d, 0xca, 0xd2, 0x91, 0x6a,
	0x52, 0xb1, 0x54, 0xa3, 0xfc, 0x24, 0xc3, 0x44, 0x20, 0x86, 0xbb, 0x87, 0x0d, 0x63, 0x86, 0xa0,
	0x98, 0x41, 0x7c, 0x28, 0x5f, 0xde, 0xbe, 0xed, 0x70, 0x39, 0x15, 0x1b, 0xa4, 0x6e, 0xd3, 0xb5,
	0x12, 0x34, 0xa8, 0x51, 0x01, 0x68, 0x17, 0xa0, 0xa6, 0xd3, 0xdd, 0x1d, 0x65, 0x17, 0x87, 0xad,
	0xf5, 0x1e, 0x7c, 0x86, 0x76, 0x53, 0x47, 0x29, 0x04, 0xfb, 0xb9, 0xf8, 0x8d, 0x04, 0xd3, 0x09,
	0x42, 0xd1, 0x87, 0x30, 0xea, 0x8b, 0xf5, 0xf3, 0xe3, 0xbd, 0x3e, 0x46, 0xa5, 0x86, 0x28, 0x17,
	0xee, 0x08, 0xbe, 0x96, 0x60, 0x39, 0xec, 0xc8, 0x75, 0xa2, 0x66, 0x8f, 0x04, 0x62, 0x03, 0x32,
	0x01, 0x1e, 0x37, 0x81, 0x6f, 0xf2, 0x37, 0xfb, 0x35, 0xb9, 0x3a, 0x69, 0xb4, 0x7d, 0xbb, 0xca,
	0xcf, 0x69, 0x98, 0x63, 0x2b, 0x37, 0x14, 0xac, 0x62, 0xb7, 0x65, 0x79, 0xee, 0xf9, 0x55, 0x91,
	0x48, 0xa4, 0x80, 0xe7, 0x13, 0x29, 0x5a, 0xb0, 0x20, 0x7e, 0x6a, 0xfc, 0x3c, 0x13, 0xa9, 0x3c,
	0x89, 0x78, 0xf1, 0x56, 0x8f, 0x79, 0x3b, 0x32, 0xa6, 0x79, 0x81, 0xdd, 0x41, 0x77, 0xd1, 0x1f,
	0x4a, 0xa0, 0xf8, 0x72, 0x9b, 0x0e, 0x76, 0xd9, 0x71, 0x22, 0xae, 0xc0, 0xfc, 0x55, 0x15, 0x58,
	0x11, 0x42, 0xf6, 0x85, 0x8c, 0x98, 0x22, 0x04, 0xe6, 0x58, 0xad, 0x21, 0x2e, 0x3b, 0x75, 0x55,
	0xd9, 0x33, 0x14, 0x38, 0x26, 0xf0, 0x4b, 0x09, 0x56, 0x98, 0xc4, 0x73, 0x86, 0x9d, 0xbd, 0xaa,
	0x68, 0x56, 0x3f, 0xe9, 0x3a, 0xe6, 0xcf, 0x60, 0x9e, 0x1f, 0x04, 0xe3, 0x92, 0x07, 0xaf, 0x2a,
	0x79, 0x96, 0x21, 0xc7, 0x44, 0xea, 0x90, 0x61, 0x83, 0x8e, 0xca, 0x1a, 0xbe, 0x52, 0x95, 0x6a,
	0x92, 0xe2, 0x45, 0x45, 0x78, 0x30, 0x1d, 0x94, 0x6b, 0x42, 0x31, 0xd9, 0x6b, 0xbd, 0x16, 0x44,
	0xba, 0xee, 0xd1, 0x54, 0xe4, 0xe3, 0x47, 0xc2, 0x85, 0x03, 0xb3, 0x49, 0xe5, 0x18, 0x37, 0x3b,
	0xc6, 0x46, 0xf7, 0xee, 0x95, 0x0a, 0x31, 0xea, 0x4c, 0x42, 0x09, 0xc6, 0xa5, 0x21, 0x8a, 0x55,
	0x5f, 0xa2, 0xc6, 0x4c, 0xf7, 0x1a, 0xa2, 0xe8, 0xa9, 0x37, 0x32, 0xb6, 0x49, 0xaf, 0xed, 0x9b,
	0x3a, 0x09, 0x12, 0xf5, 0x96, 0xa8, 0x98, 0x09, 0x26, 0x66, 0xa3, 0xdf, 0x5a, 0x4b, 0x44, 0xe0,
	0x14, 0x47, 0x8f, 0x8a, 0xfc, 0x5a, 0x82, 0xeb, 0x16, 0xa9, 0x13, 0xcd, 0x09, 0x23, 0x73, 0x9b,
	0xf4, 0x69, 0x26, 0xbd, 0x87, 0xb9, 0x2c, 0x93, 0x3a, 0x49, 0x0c, 0xf3, 0xea, 0xa2, 0xd5, 0xad,
	0xc9, 0x45, 0x7f, 0x2e, 0xc1, 0x8d, 0x30, 0x07, 0x74, 0x53, 0x66, 0xb6, 0xd7, 0xca, 0xdf, 0xf9,
	0x89, 0x47, 0x5d, 0x31, 0xce, 0x6d, 0x77, 0xd1, 0x1a, 0x0c, 0x61, 0xc7, 0x21, 0x4e, 0x76, 0x94,
	0x49, 0x46, 0xbe, 0x64, 0xa7, 0x69, 0xe4, 0x0e, 0x58, 0xc5, 0x5d, 0xe5, 0x0c, 0xca, 0x37, 0x12,
	0xcc, 0x76, 0x94, 0xdc, 0xdd, 0x26, 0xb1, 0x5d, 0x8c, 0x08, 0xa0, 0x70, 0x0c, 0x9a, 0xc3, 0x73,
	0x8e, 0xc8, 0x6f, 0x1f, 0xf4, 0xb8, 0x12, 0x63, 0xb9, 0x4b, 0x9d, 0xd2, 0x3b, 0x49, 0xca, 0x7f,
	0xcb, 0x30, 0xdf, 0xc1, 0xbd, 0xef, 0x90, 0xba, 0x83, 0xdd, 0x0b, 0x52, 0xdd, 0x2b, 0x90, 0x69,
	0x0a, 0x46, 0xad, 0x89, 0x1d, 0x83, 0xe6, 0x3c, 0x9a, 0xd0, 0x87, 0xd4, 0x49, 0x9f, 0xbe, 0xcf,
	0xc9, 0xe8, 0x2d, 0x80, 0xb0, 0xbc, 0x22, 0x36, 0x2c, 0x8b, 0xb1, 0x6d, 0x7e, 0xb0, 0x97, 0x55,
	0x47, 0x83, 0xc2, 0x0a, 0x7a, 0x1b, 0xc6, 0x5a, 0xcd, 0xaa, 0xee, 0x61, 0xde, 0x77, 0xf0, 0xc2,
	0xbe, 0xc0, 0xd9, 0x59, 0xe7, 0x87, 0x70, 0x4d, 0x5c, 0x1b, 0xb0, 0xfa, 0x57, 0x3f, 0xb7, 0x0f,
	0xaa, 0x8f, 0x10, 0x4d, 0xed, 0xc3, 0xcf, 0x25, 0xb5, 0x2b, 0x7f, 0xd4, 0xe9, 0x05, 0x81, 0xe1,
	0x1d, 0x98, 0x8e, 0x78, 0x81, 0x6f, 0x4e, 0xe1, 0x06, 0xf9, 0xbe, 0xdd, 0xc0, 0xc7, 0x57, 0x23,
	0x3e, 0xe6, 0xd3, 0x94, 0xbf, 0x1f, 0x84, 0x85, 0xae, 0xb5, 0x66, 0xb4, 0xd6, 0x59, 0x61, 0x91,
	0xfc, 0x6b, 0x0f, 0xb9, 0xbd, 0xcc, 0x82, 0x72, 0x90, 0x69, 0xe8, 0xa7, 0x9a, 0x6e, 0x79, 0xd8,
	0xb1, 0x75, 0xcf, 0x3c, 0x61, 0x75, 0x10, 0x69, 0x6d, 0x88, 0x1f, 0x08, 0x26, 0x1b, 0xfa, 0x69,
	0x3e, 0xd2, 0x46, 0xf9, 0x6b, 0x26, 0x25, 0xd0, 0x71, 0xd6, 0x74, 0x9b, 0x6e, 0x36, 0xa9, 0x8b,
	0x8c, 0x08, 0x7e, 0xde, 0xb8, 0xef, 0xb7, 0x21, 0x0c, 0x93, 0x22, 0xa0, 0x8b, 0x0b, 0x20, 0x3f,
	0x29, 0xfe, 0x66, 0xaf, 0xa1, 0x5c, 0xdc, 0xcc, 0x70, 0x39, 0x13, 0x6e, 0x94, 0xe6, 0xa2, 0x22,
	0x5c, 0xc7, 0xb6, 0x7e, 0x64, 0x61, 0x4d, 0x6f, 0x79, 0xa4, 0xa1, 0x7b, 0xa6, 0xa1, 0x35, 0x5b,
	0xb6, 0xe1, 0xb5, 0x78, 0xda, 0x1a, 0x0a, 0x55, 0x5c, 0xe4, 0x8c, 0x79, 0x9f, 0x6f, 0x3f, 0x64,
	0x43, 0xbf, 0x02, 0x69, 0xbd, 0x55, 0x35, 0x89, 0xbf, 0x53, 0xa5, 0x39, 0x55, 0x58, 0x62, 0x8c,
	0x35, 0xf0, 0x0d, 0x27, 0xca, 0x83, 0x40, 0xd1, 0xdc, 0x26, 0xd6, 0x9f, 0x60, 0x47, 0xab, 0x9a,
	0xba, 0x63, 0x7e, 0x1e, 0xe6, 0x48, 0x21, 0x2c, 0xcb, 0xd9, 0x0e, 0x38, 0xd7, 0x66, 0xc8, 0x84,
	0xde, 0x87, 0x85, 0x48, 0x9f, 0x00, 0xc7, 0x20, 0x2d, 0xdb, 0x63, 0x75, 0x7f, 0x21, 0x77, 0x3e,
	0xc2, 0x25, 0x60, 0x0a, 0x94, 0x07, 0xbd, 0x05, 0x73, 0x42, 0x87, 0xa7, 0xc4, 0xa9, 0x46, 0xea,
	0xc8, 0x2c, 0xa0, 0x09, 0xf9, 0x33, 0x9c, 0xe5, 0xb7, 0x89, 0x53, 0x0d, 0xeb, 0xc8, 0x4a, 0x0e,
	0xc6, 0xdb, 0x6c, 0x8a, 0x96, 0xe0, 0x5a, 0xf3, 0xd8, 0xd1, 0x5d, 0x71, 0x1e, 0x12, 0x17, 0x64,
	0x3e, 0x4d, 0xf9, 0x2b, 0x09, 0xa6, 0x13, 0x9c, 0x0d, 0x7d, 0x0a, 0xe9, 0x36, 0xc7, 0xe1, 0x1e,
	0xff, 0xa0, 0xd7, 0x99, 0x8d, 0x06, 0xe8, 0x10, 0x4e, 0x6d, 0xc3, 0x8e, 0xbb, 0xb4, 0xec, 0xbb,
	0x74, 0xaa, 0xa3, 0x72, 0xf8, 0x77, 0x12, 0x5c, 0x3f, 0x0f, 0x98, 0x1e, 0x6b, 0xc2, 0xdd, 0x85,
	0x88, 0x94, 0x11, 0x4a, 0xc7, 0xf1, 0x58, 0xf6, 0x8f, 0xc7, 0xa9, 0xb6, 0x53, 0xed, 0x0e, 0x0c,
	0x51, 0xbb, 0xfb, 0x1b, 0xdb, 0xbb, 0x97, 0x1f, 0x34, 0x9d, 0x8c, 0x92, 0x5d, 0x23, 0x1c, 0x93,
	0xa3, 0x28, 0xff, 0x21, 0xc1, 0x88, 0xdf, 0x80, 0xde, 0x6c, 0x8b, 0xc0, 0x17, 0x96, 0xe0, 0x22,
	0x01, 0xf8, 0x75, 0x18, 0xf1, 0x6b, 0xda, 0x17, 0x17, 0x68, 0xae, 0x89, 0x62, 0x36, 0x3d, 0x7e,
	0x53, 0x2d, 0xc4, 0x01, 0x9a, 0xfd, 0xee, 0x56, 0x23, 0x68, 0x37, 0xc2, 0x2d, 0x18, 0xf3, 0x1d,
	0xd7, 0xd3, 0xeb, 0x6c, 0x95, 0x0d, 0x09, 0x2e, 0x41, 0xaf, 0xe8, 0x75, 0x25, 0x07, 0x99, 0xb0,
	0xd0, 0x74, 0x88, 0x1d, 0x0f, 0x9f, 0xa2, 0x34, 0x48, 0xa7, 0xa2, 0x58, 0x26, 0xb1, 0xaf, 0x33,
	0x71, 0xbe, 0x94, 0xce, 0x94, 0x26, 0xcc, 0xc5, 0x0b, 0x53, 0xfb, 0xc4, 0x3a, 0x43, 0x87, 0x30,
	0x72, 0x82, 0x1d, 0xcf, 0x34, 0x02, 0x67, 0xbb, 0xdf, 0x4f, 0xb1, 0x8b, 0xeb, 0xa0, 0x06, 0x58,
	0xca, 0xbf, 0x4a, 0x30, 0x46, 0x77, 0x70, 0xff, 0x67, 0x65, 0x7c, 0xf4, 0x30, 0x28, 0x58, 0x72,
	0x7f, 0xba, 0xd7, 0xdb, 0xd6, 0xb3, 0xbd, 0x4a, 0xf9, 0x0f, 0x12, 0x8c, 0x06, 0x54, 0xe4, 0xc0,
	0x8c, 0xc3, 0xb2, 0x56, 0x62, 0xb5, 0xf0, 0x83, 0xab, 0x54, 0x0b, 0xe9, 0xa4, 0xa8, 0x48, 0xa0,
	0x3f, 0xa7, 0x5a, 0xa1, 0xf2, 0x14, 0x26, 0xda, 0x77, 0xd3, 0xd4, 0x3f, 0xd9, 0xdb, 0x01, 0x51,
	0x1e, 0x62, 0x21, 0xeb, 0xc3, 0x48, 0x89, 0x9d, 0x1f, 0xac, 0x7f, 0xa3, 0x37, 0x93, 0xc5, 0x2a,
	0xec, 0xca, 0x33, 0x09, 0xa6, 0xdb, 0x37, 0xd8, 0xdc, 0x80, 0xff, 0x1f, 0x2b, 0xae, 0xca, 0x8f,
	0x32, 0x64, 0xbb, 0x9d, 0x16, 0x9e, 0xe3, 0x45, 0xca, 0x72, 0x3c, 0x4c, 0xb4, 0xf9, 0xf5, 0xa3,
	0xc0, 0xaf, 0xe5, 0x5e, 0x4f, 0x70, 0x09, 0x53, 0xe1, 0x7b, 0x38, 0x52, 0xc3, 0x05, 0x9a, 0xba,
	0xca, 0x02, 0xdd, 0x1e, 0x08, 0x97, 0xe8, 0x4b, 0x30, 0xc2, 0xd2, 0xbe, 0xff, 0x4c, 0x24, 0x45,
	0x1b, 0x19, 0xa5, 0x54, 0xdd, 0x48, 0xb3, 0x9c, 0x41, 0x1b, 0xed, 0x1a, 0x51, 0xbe, 0x92, 0x61,
	0xa1, 0xeb, 0x61, 0xe8, 0x39, 0x5a, 0x77, 0x0b, 0x86, 0xc5, 0x4e, 0x84, 0x5b, 0xaf, 0xe7, 0xba,
	0xa1, 0xe8, 0x7e, 0xb5, 0x0b, 0xa9, 0xe4, 0xe7, 0x2c, 0xca, 0x3f, 0x49, 0xb0, 0x74, 0xe0, 0x39,
	0x58, 0x6f, 0x84, 0xce, 0xd5, 0xfe, 0x24, 0xc9, 0x80, 0x74, 0xe4, 0x92, 0xbb, 0x2e, 0xcc, 0xd1,
	0xc3, 0x5d, 0x4c, 0x00, 0x7f, 0x18, 0xdc, 0x84, 0xd7, 0xb7, 0x07, 0xd4, 0xb1, 0xf0, 0x62, 0xbc,
	0x8e, 0x5e, 0xee, 0x7c, 0xda, 0x44, 0x97, 0x49, 0x7a, 0x7b, 0xa0, 0xfd, 0x71, 0xd3, 0xc6, 0x34,
	0x4c, 0xb9, 0x3e, 0x9a, 0xe6, 0x70, 0x05, 0x95, 0xff, 0x91, 0x60, 0xb9, 0xdb, 0x10, 0xc4, 0x11,
	0x2f, 0x38, 0x26, 0x4a, 0x17, 0x1c, 0x13, 0xd1, 0x69, 0xe2, 0x61, 0x90, 0x2f, 0xda, 0x52, 0xbf,
	0x63, 0xbe, 0xcc, 0xa9, 0x10, 0xbd, 0x0e, 0x73, 0x71, 0xc9, 0xec, 0x18, 0xc8, 0x33, 0xfa, 0x4c,
	0xac, 0xcb, 0x23, 0xc7, 0x54, 0x36, 0xe1, 0x66, 0x38, 0x76, 0xba, 0x1b, 0xb6, 0x0a, 0x96, 0xee,
	0xba, 0x66, 0xcd, 0xe4, 0xcf, 0xa2, 0x84, 0x7d, 0x97, 0x00, 0xd8, 0x3d, 0xbc, 0x16, 0xa9, 0xd0,
	0x8f, 0x32, 0xca, 0xae, 0xde, 0xc0, 0x09, 0x28, 0x89, 0xcf, 0x0c, 0x2e, 0x40, 0x79, 0x05, 0x7e,
	0x35, 0x40, 0x39, 0xff, 0xe1, 0x81, 0x52, 0x8e, 0x78, 0x5d, 0xe2, 0x5b, 0x92, 0xc4, 0xb7, 0x1d,
	0x52, 0xf2, 0xdb, 0x0e, 0x65, 0x25, 0x82, 0x96, 0xa4, 0xb8, 0x72, 0x0b, 0x94, 0x80, 0xa1, 0xeb,
	0x9b, 0x0b, 0xe5, 0x6f, 0x24, 0x98, 0x0b, 0xd9, 0x3c, 0xe2, 0xb0, 0xcd, 0x28, 0x53, 0x67, 0x0b,
	0x56, 0xfd, 0xb3, 0x02, 0xa7, 0x6b, 0xb1, 0xb9, 0x12, 0xda, 0x2d, 0x89, 0xc3, 0x02, 0x67, 0xeb,
	0x9c, 0x79, 0xb4, 0x03, 0x37, 0x63, 0x3d, 0x03, 0xcc, 0xaa, 0xe9, 0x60, 0xc3, 0x23, 0xce, 0x99,
	0x98, 0xf2, 0xd5, 0xce, 0x29, 0x17, 0xa8, 0x9b, 0x3e, 0x9f, 0xf2, 0xef, 0x29, 0x58, 0xb9, 0xc0,
	0xd7, 0x12, 0xeb, 0x8c, 0xd2, 0xf3, 0xad, 0x33, 0xd6, 0x60, 0xea, 0x05, 0x54, 0xca, 0x33, 0x56,
	0x67, 0xc9, 0xb4, 0x4b, 0x3d, 0x33, 0xf5, 0x62, 0xeb, 0x99, 0xc9, 0x65, 0xbf, 0xc1, 0x17, 0x58,
	0xf6, 0x53, 0xfe, 0x65, 0x04, 0x66, 0x92, 0xe2, 0x26, 0xaa, 0x84, 0xf5, 0x15, 0xfe, 0xac, 0xea,
	0x7e, 0x1f, 0x41, 0x29, 0x56, 0x68, 0xf9, 0x93, 0x8b, 0x9e, 0x17, 0xf2, 0x00, 0x58, 0xee, 0x43,
	0x56, 0xd7, 0xe5, 0xb6, 0x3d, 0x70, 0xde, 0x4b, 0xc3, 0x2f, 0xba, 0x3e, 0xb3, 0xe4, 0x93, 0xbd,
	0xd5, 0x87, 0x2a, 0x49, 0x81, 0x66, 0x7b, 0xa0, 0xcb, 0x8b, 0xcb, 0xbf, 0xec, 0xe1, 0xa9, 0xe3,
	0x87, 0x7d, 0x28, 0x73, 0x7e, 0x80, 0xdc, 0x1e, 0xb8, 0xf0, 0xd5, 0xe3, 0x17, 0x5d, 0x1f, 0xff,
	0x0d, 0xf5, 0x6d, 0xa1, 0xa4, 0xe0, 0x49, 0x2d, 0x94, 0xf4, 0x0e, 0x10, 0xfd, 0xa9, 0x04, 0xd7,
	0x59, 0xa1, 0xc6, 0xd2, 0x8c, 0xb6, 0x9c, 0xe3, 0xeb, 0xc1, 0xab, 0xc1, 0x3b, 0x7d, 0xe8, 0xd1,
	0x3d, 0x93, 0x6d, 0x0f, 0xa8, 0x8b, 0x7a, 0xf7, 0x3c, 0xf7, 0x67, 0x12, 0x2c, 0x09, 0x9d, 0xba,
	0x18, 0x67, 0xee, 0x8a, 0x4a, 0x75, 0x31, 0x91, 0x50, 0x2a, 0x31, 0x6d, 0xd6, 0x61, 0xc2, 0x8f,
	0xf0, 0x42, 0x89, 0xe5, 0x5e, 0x4f, 0x6d, 0xc9, 0x69, 0x49, 0x1d, 0x77, 0xa3, 0x9f, 0x1b, 0x08,
	0x32, 0xe1, 0xf6, 0x88, 0x8b, 0xba, 0xfd, 0x5f, 0x12, 0x5c, 0x13, 0xeb, 0x1d, 0xcd, 0xc3, 0xf4,
	0x83, 0x62, 0xbe, 0xf2, 0x48, 0x2d, 0x6a, 0x8f, 0x76, 0x0f, 0xf6, 0x8b, 0x85, 0xd2, 0x83, 0x52,
	0x71, 0x33, 0x33, 0x80, 0xa6, 0x61, 0xb2, 0x9c, 0xdf, 0x28, 0x96, 0xb5, 0xcd, 0x62, 0xa5, 0x58,
	0xa8, 0x94, 0xf6, 0x76, 0x33, 0x12, 0x5a, 0x80, 0xd9, 0x83, 0xed, 0xbd, 0x8a, 0x56, 0xd8, 0xce,
	0xef, 0x6e, 0x15, 0x23, 0x4d, 0x32, 0x5a, 0x86, 0xc5, 0xe2, 0x47, 0xfb, 0xe5, 0x52, 0xa1, 0x54,
	0xd1, 0x0a, 0x7b, 0xbb, 0x95, 0xe2, 0x6e, 0x25, 0xd2, 0x9e, 0x42, 0x59, 0x98, 0x39, 0xd8, 0x2f,
	0x16, 0x0b, 0xdb, 0x5a, 0x45, 0xcd, 0xef, 0x1e, 0x14, 0xd4, 0xd2, 0x3e, 0x6b, 0x19, 0x46, 0x08,
	0x26, 0x2a, 0xc5, 0x8f, 0xa2, 0xdc, 0xd7, 0xa8, 0xf4, 0xbd, 0x8d, 0xdf, 0x2a, 0x16, 0x2a, 0x94,
	0xbb, 0xf0, 0xb0, 0xb4, 0xbb, 0x95, 0x19, 0x45, 0x33, 0x90, 0x29, 0xef, 0x6d, 0xed, 0x69, 0x6a,
	0xb1, 0xb0, 0xb7, 0xb5, 0x5b, 0x62, 0xac, 0x69, 0xaa, 0x53, 0xa1, 0x58, 0x2e, 0x6e, 0xa8, 0xa5,
	0xca, 0xe3, 0xb6, 0xa6, 0xf1, 0xdb, 0x0e, 0xa0, 0xf8, 0xbb, 0x51, 0x74, 0x0b, 0x56, 0x3b, 0x46,
	0xa6, 0xed, 0xec, 0x6d, 0x76, 0x8e, 0x7f, 0x1c, 0x46, 0xd9, 0x50, 0x69, 0x53, 0x46, 0x42, 0x13,
	0x00, 0x0f, 0xd4, 0xfc, 0x4e, 0x91, 0x7f, 0xcb, 0xd4, 0x6e, 0xac, 0x39, 0xbf, 0xbb, 0xa9, 0x45,
	0x1a, 0x52, 0xb7, 0x3d, 0x80, 0xf0, 0x31, 0x13, 0x5a, 0x84, 0xb9, 0x72, 0xe9, 0x61, 0xb1, 0x5c,
	0xda, 0xde, 0xdb, 0xdb, 0xec, 0x90, 0x30, 0x05, 0xe3, 0x87, 0x45, 0xf5, 0xb1, 0xf6, 0x68, 0x97,
	0xb1, 0x3c, 0xce, 0x48, 0x28, 0x0d, 0x23, 0xc1, 0x97, 0x4c, 0xbf, 0xf6, 0xf7, 0x0e, 0x0e, 0x4a,
	0x1b, 0xe5, 0x62, 0x26, 0x85, 0x00, 0x86, 0x45, 0xcb, 0x20, 0x9a, 0x84, 0x31, 0xd6, 0x55, 0x10,
	0x86, 0x6e, 0xff, 0xb1, 0x0c, 0x99, 0xce, 0x58, 0x8e, 0x6e, 0xc0, 0xd2, 0x41, 0x45, 0x2d, 0xe6,
	0x77, 0x4a, 0xbb, 0x5b, 0x5a, 0xf2, 0x2c, 0x2f, 0xc1, 0x42, 0xc8, 0x12, 0x9f, 0xef, 0x9b, 0xb0,
	0x12, 0x36, 0x77, 0x9b, 0xf9, 0x35, 0xb8, 0x15, 0x32, 0x9d, 0xeb, 0x03, 0x6d, 0xd2, 0x3a, 0xe7,
	0x77, 0xb0, 0x5d, 0x5a, 0xfe, 0x51, 0x65, 0x6f, 0xa7, 0xac, 0x15, 0xca, 0xf9, 0x83, 0x83, 0xd2,
	0x83, 0x52, 0x21, 0xcf, 0x30, 0x66, 0xe9, 0xec, 0xc5, 0x98, 0x3a, 0xa1, 0xe6, 0xee, 0x7e, 0x2f,
	0x43, 0x96, 0xe5, 0xc8, 0x52, 0x64, 0xf1, 0x1c, 0x60, 0xe7, 0xc4, 0x34, 0x30, 0xfa, 0x49, 0x82,
	0xf1, 0xb6, 0x43, 0x01, 0xea, 0xe1, 0xe8, 0x92, 0x74, 0x20, 0x5a, 0x5c, 0xf2, 0xfb, 0x47, 0xfe,
	0x3c, 0x92, 0xdb, 0xf3, 0xff, 0x3c, 0xa2, 0x3c, 0x79, 0x96, 0xcf, 0x75, 0xbb, 0x6a, 0x4a, 0xbe,
	0x7b, 0xf8, 0x31, 0x8f, 0x82, 0x3b, 0x9f, 0x57, 0xfd, 0x3f, 0x5d, 0x7c, 0xf5, 0xc3, 0x2f, 0xdf,
	0xca, 0x2b, 0xca, 0x62, 0xe7, 0xff, 0x69, 0xdc, 0xfb, 0x62, 0x13, 0x82, 0xef, 0x4b, 0xb7, 0x17,
	0x2b, 0xcf, 0xf2, 0xab, 0xf1, 0x01, 0x70, 0xfd, 0xf4, 0xa6, 0xe9, 0xe6, 0x0c, 0xd2, 0xf8, 0xb7,
	0x7c, 0xee, 0xd8, 0xf3, 0x9a, 0xee, 0xfd, 0xf5, 0xf5, 0xa7, 0x4f, 0x9f, 0x76, 0x34, 0xae, 0xeb,
	0x2d, 0xef, 0x98, 0xff, 0x97, 0xe7, 0xd7, 0x9b, 0x96, 0xee, 0xd5, 0x88, 0xd3, 0xb8, 0xfb, 0xd7,
	0x32, 0xdc, 0x68, 0xdf, 0x7d, 0x24, 0x59, 0xf6, 0x6f, 0xa3, 0xdb, 0xe5, 0x76, 0x13, 0xf7, 0x93,
	0x7b, 0x12, 0x6d, 0xbd, 0x7d, 0x75, 0x20, 0x6e, 0x7a, 0x65, 0x60, 0x4d, 0x7a, 0x4d, 0x7a, 0x31,
	0xf6, 0xda, 0xf8, 0x52, 0x86, 0x57, 0x0d, 0xd2, 0xb8, 0xb4, 0xae, 0x1b, 0x4b, 0xdd, 0x8c, 0xba,
	0xef, 0x10, 0x8f, 0xec, 0x4b, 0xbf, 0xf3, 0x58, 0x40, 0xd5, 0x89, 0xa5, 0xdb, 0xf5, 0x1c, 0x71,
	0xea, 0xeb, 0x75, 0x6c, 0xb3, 0x62, 0xd1, 0x7a, 0xa8, 0xd0, 0xc5, 0xff, 0xc1, 0x7a, 0x3b, 0xd6,
	0xf6, 0x9d, 0xbc, 0xb6, 0xc5, 0xb1, 0x0b, 0x4c, 0xcd, 0x98, 0x26, 0xb9, 0xc3, 0x3b, 0xfb, 0xf7,
	0x36, 0x68, 0xe7, 0x67, 0x3e, 0xeb, 0xc7, 0x8c, 0xf5, 0xe3, 0x18, 0xeb, 0xc7, 0x87, 0xbe, 0x9c,
	0xa3, 0x61, 0xa6, 0xdb, 0xbd, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x92, 0x90, 0x2e, 0x99, 0x1e,
	0x36, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}

// StreamingVideoIntelligenceServiceClient is the client API for StreamingVideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingVideoIntelligenceServiceClient interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error)
}

type streamingVideoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingVideoIntelligenceServiceClient(cc *grpc.ClientConn) StreamingVideoIntelligenceServiceClient {
	return &streamingVideoIntelligenceServiceClient{cc}
}

func (c *streamingVideoIntelligenceServiceClient) StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingVideoIntelligenceService_serviceDesc.Streams[0], "/google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService/StreamingAnnotateVideo", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVideoIntelligenceServiceStreamingAnnotateVideoClient{stream}
	return x, nil
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoClient interface {
	Send(*StreamingAnnotateVideoRequest) error
	Recv() (*StreamingAnnotateVideoResponse, error)
	grpc.ClientStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoClient struct {
	grpc.ClientStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Send(m *StreamingAnnotateVideoRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Recv() (*StreamingAnnotateVideoResponse, error) {
	m := new(StreamingAnnotateVideoResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingVideoIntelligenceServiceServer is the server API for StreamingVideoIntelligenceService service.
type StreamingVideoIntelligenceServiceServer interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(StreamingVideoIntelligenceService_StreamingAnnotateVideoServer) error
}

// UnimplementedStreamingVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingVideoIntelligenceServiceServer struct {
}

func (*UnimplementedStreamingVideoIntelligenceServiceServer) StreamingAnnotateVideo(srv StreamingVideoIntelligenceService_StreamingAnnotateVideoServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingAnnotateVideo not implemented")
}

func RegisterStreamingVideoIntelligenceServiceServer(s *grpc.Server, srv StreamingVideoIntelligenceServiceServer) {
	s.RegisterService(&_StreamingVideoIntelligenceService_serviceDesc, srv)
}

func _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingVideoIntelligenceServiceServer).StreamingAnnotateVideo(&streamingVideoIntelligenceServiceStreamingAnnotateVideoServer{stream})
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoServer interface {
	Send(*StreamingAnnotateVideoResponse) error
	Recv() (*StreamingAnnotateVideoRequest, error)
	grpc.ServerStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoServer struct {
	grpc.ServerStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Send(m *StreamingAnnotateVideoResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Recv() (*StreamingAnnotateVideoRequest, error) {
	m := new(StreamingAnnotateVideoRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _StreamingVideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService",
	HandlerType: (*StreamingVideoIntelligenceServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingAnnotateVideo",
			Handler:       _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}
