package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAccessKey invokes the ram.CreateAccessKey API synchronously
// api document: https://help.aliyun.com/api/ram/createaccesskey.html
func (client *Client) CreateAccessKey(request *CreateAccessKeyRequest) (response *CreateAccessKeyResponse, err error) {
	response = CreateCreateAccessKeyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAccessKeyWithChan invokes the ram.CreateAccessKey API asynchronously
// api document: https://help.aliyun.com/api/ram/createaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAccessKeyWithChan(request *CreateAccessKeyRequest) (<-chan *CreateAccessKeyResponse, <-chan error) {
	responseChan := make(chan *CreateAccessKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAccessKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAccessKeyWithCallback invokes the ram.CreateAccessKey API asynchronously
// api document: https://help.aliyun.com/api/ram/createaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAccessKeyWithCallback(request *CreateAccessKeyRequest, callback func(response *CreateAccessKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAccessKeyResponse
		var err error
		defer close(result)
		response, err = client.CreateAccessKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAccessKeyRequest is the request struct for api CreateAccessKey
type CreateAccessKeyRequest struct {
	*requests.RpcRequest
	UserName string `position:"Query" name:"UserName"`
}

// CreateAccessKeyResponse is the response struct for api CreateAccessKey
type CreateAccessKeyResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	AccessKey AccessKey `json:"AccessKey" xml:"AccessKey"`
}

// CreateCreateAccessKeyRequest creates a request to invoke CreateAccessKey API
func CreateCreateAccessKeyRequest() (request *CreateAccessKeyRequest) {
	request = &CreateAccessKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "CreateAccessKey", "", "")
	return
}

// CreateCreateAccessKeyResponse creates a response to parse from CreateAccessKey response
func CreateCreateAccessKeyResponse() (response *CreateAccessKeyResponse) {
	response = &CreateAccessKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
