# Fennel Code of Conduct

## When Something Happens

If you see a Code of Conduct violation, follow these steps:

1. Let the person know that what they did is not appropriate and ask them to stop and/or edit their message(s).
2. That person should immediately stop the behavior and correct the issue.
3. If this doesn’t happen, or if you're uncomfortable speaking up, [contact admins](#contacting-admins).
4. As soon as available, an admin will join, identify themselves, and take [further action (see below)](#further-enforcement), starting with a warning, then temporary deactivation, then long-term deactivation.

When reporting, please include any relevant details, links, screenshots, context, or other information that may be used to better understand and resolve the situation.

**The Admin team will prioritize the well-being and comfort of the recipients of the violation over the comfort of the violator.** See [some examples below](#enforcement-examples).

## Our Pledge

In the interest of fostering an open and welcoming environment, we as members of the Fennel community pledge to making participation in our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, technical preferences, nationality, personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

  * Using welcoming and inclusive language.
  * Being respectful of differing viewpoints and experiences.
  * Gracefully accepting constructive feedback.
  * Focusing on what is best for the community.
  * Showing empathy and kindness towards other community members.

Examples of unacceptable behavior by participants include:

  * The use of sexualized language or imagery and unwelcome sexual attention or advances, including when simulated online. The only exception to sexual topics is channels/spaces specifically for topics of sexual identity.
  * Trolling, insulting/derogatory comments, and personal or political attacks.
  * Casual mention of slavery or indentured servitude and/or false comparisons of one's occupation or situation to slavery. Please consider using or asking about alternate terminology when referring to such metaphors in technology.
  * Making light of/making mocking comments about trigger warnings and content warnings.
  * Public or private harassment, deliberate intimidation, or threats.
  * Publishing others' private information, such as a physical or electronic address, without explicit permission. This includes any sort of "outing" of any aspect of someone's identity without their consent.
  * Publishing screenshots or quotes, especially from identity channels, without all quoted users' *explicit* consent.
  * Publishing or telling others that a member belongs to a particular identity channel without asking their consent first.
  * Publishing of non-harassing private communication.
  * Any of the above even when [presented as "ironic" or "joking"](https://en.wikipedia.org/wiki/Hipster_racism).
  * Any attempt to present "reverse-ism" versions of the above as violations. Examples of reverse-isms are "reverse racism", "reverse sexism", "heterophobia", and "cisphobia".
  * Unsolicited explanations under the assumption that someone doesn't already know it. Ask before you teach! Don't assume what people's knowledge gaps are.
  * [Feigning or exaggerating surprise](https://www.recurse.com/manual#no-feigned-surprise) when someone admits to not knowing something.
  * "[Well-actuallies](https://www.recurse.com/manual#no-well-actuallys)"
  * Other conduct which could reasonably be considered inappropriate in a professional or community setting.

## Scope

This Code of Conduct applies both within community spaces and in other spaces involving the community. This includes the Fennel Email list, #fennel IRC channel on FreeNode, private email communications in the context of the community, and any events where members of the community are participating, as well as adjacent communities and venues affecting the community's members.

Depending on the violation, the admins may decide that violations of this code of conduct that have happened outside of the scope of the community may deem an individual unwelcome, and take appropriate action to maintain the comfort and safety of its members.

This Code of Conduct is detailed for the purpose of removing ambiguity, not for the sake of strictness. It is the sincere hope of admins that it helps foster mutual understanding, and the creation of a space where everyone can participate in a way relevant to the project itself, without things going horribly due to accidental/well-intentioned toe stepping. Please be kind to one another!

## Admin Enforcement Process

Once the admins get involved, they will follow a documented series of steps and do their best to preserve the well-being of community members. This section covers actual concrete steps.

### Contacting Admins

You may get in touch with the Fennel admin team through any of the following methods:

  * Contact anyone on the #fennel IRC channel or Email list
  * Directly message any admin in private (through either IRC PM, Fediverse, or email, as available) if it is a preferred or more comfortable avenue.
  * More methods coming eventually

### Further Enforcement

If you've already followed the [initial enforcement steps](#enforcement), these are the steps admins will take for further enforcement, as needed:

  1. Repeat the request to stop.
  2. If the person doubles down, they will be removed from the channel and given an official warning.
  3. If the behavior continues or is repeated later, the person will be deactivated for 24 hours.
  4. If the behavior continues or is repeated after the temporary deactivation, a long-term (6-12mo) deactivation will be used.

On top of this, admins may remove any offending messages, images, contributions, etc, as they deem necessary.

Admins reserve full rights to skip any of these steps, at their discretion, if the violation is considered to be a serious and/or immediate threat to the health and well-being of members of the community. These include any threats, serious physical or verbal attacks, and other such behavior that would be completely unacceptable in any social setting that puts our members at risk.

Members expelled from events or venues with any sort of paid attendance will not be refunded.

### Who Watches the Watchers?

Admins and other leaders who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the community's leadership. These may include anything from removal from the admin team to a permanent ban from the community.

### Enforcement Examples

#### The Best Case

The vast majority of situations work out like this, in our experience. This interaction is common, and generally positive.

> Alex: "Yeah I used X and it was really crazy!"

> Patt: "Hey, could you not use that word? What about 'ridiculous' instead?"

> Alex: "oh sorry, sure." -> edits old message to say "it was really confusing!"

#### The Admin Case

Sometimes, though, you need to get admins involved. Admins will do their best to resolve conflicts, but people who were harmed by something **will take priority**.

> Patt: "Honestly, sometimes I just really hate using $language and anyone who uses it probably sucks at their job."

> Alex: "Whoa there, could you dial it back a bit? There's a CoC thing about attacking folks' tech use like that."

> Patt: "I'm not attacking anyone, are you deaf?"

> Alex: *DMs admin* "hey uh. Can someone look at #fennel? Patt is getting a bit aggro. I tried to nudge them about it, but nope."

> MxAdmin1: <joins #fennel> "Hey Patt, admin here. Could you tone it down? This sort of attack is really not okay in this space."

> Patt: "Leave me alone I haven't said anything bad wtf is wrong with you."

> MxAdmin1: *removes patt* *DMs patt* "I mean it. Please refer to the CoC in the repository if you have questions, but you can consider this an actual warning. I'd appreciate it if you reworded your messages in #fennel, since they made folks there uncomfortable. Let's try and be kind, yeah?"

> Patt: *Replies to DM* "@mxadmin1 Okay sorry. I'm just frustrated and I'm kinda burnt out and I guess I got carried away. I'll DM Alex a note apologizing and edit my messages. Sorry for the trouble."

> MxAdmin1: *Replies to DM* "@patt Thanks for that. I hear you on the stress. Burnout sucks :/.  Have a good one!"

#### The Nope Case

> PepeTheFrog🐸: "Hi, I am a literal actual nazi and I think white supremacists are quite fashionable."

> Patt: "NOOOOPE. OH NOPE NOPE."

> Alex: "JFC NO. NOPE. /msg MxAdmin1 Nope nope nope"

> MxAdmin1: "/kick PepeTheFrog"

> PepeTheFrog🐸 has been kicked.

## Attribution

This Code of Conduct is adapted from the [Package Community Code of Conduct](http://package.community/code-of-conduct), which was adapted from the [WeAllJS Code of Conduct](https://wealljs.org/code-of-conduct),
itself adapted from [Contributor Covenant](https://contributor-covenant.org) version 1.4 (available at
[contributor-covenant.org/version/1/4](https://contributor-covenant.org/version/1/4)) and the LGBTQ in
Technology Slack [Code of Conduct](https://lgbtq.technology/coc.html).
