# This file was automatically generated by running:
#
#   scripts/generate_grapheme_break_spec.cr
#
# See https://www.unicode.org/license.html for the Unicode license agreement.
# DO NOT EDIT

require "./spec_helper"

describe "String#each_grapheme" do
  it_iterates_graphemes "  ", [' ', ' ']                                                                                         #   ÷ [0.2] SPACE (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes " \u0308 ", [" \u0308", ' ']                                                                             #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes " \r", [' ', '\r']                                                                                       #   ÷ [0.2] SPACE (Other) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes " \u0308\r", [" \u0308", '\r']                                                                           #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes " \n", [' ', '\n']                                                                                       #   ÷ [0.2] SPACE (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes " \u0308\n", [" \u0308", '\n']                                                                           #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes " \u0001", [' ', '\u0001']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0001", [" \u0308", '\u0001']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes " \u034F", [" \u034F"]                                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes " \u0308\u034F", [" \u0308\u034F"]                                                                       #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes " \u{1F1E6}", [' ', '\u{1F1E6}']                                                                         #   ÷ [0.2] SPACE (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes " \u0308\u{1F1E6}", [" \u0308", '\u{1F1E6}']                                                             #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes " \u0600", [' ', '\u0600']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0600", [" \u0308", '\u0600']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes " \u0903", [" \u0903"]                                                                                   #   ÷ [0.2] SPACE (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0903", [" \u0308\u0903"]                                                                       #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes " \u1100", [' ', '\u1100']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes " \u0308\u1100", [" \u0308", '\u1100']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes " \u1160", [' ', '\u1160']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes " \u0308\u1160", [" \u0308", '\u1160']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes " \u11A8", [' ', '\u11A8']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes " \u0308\u11A8", [" \u0308", '\u11A8']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes " \uAC00", [' ', '\uAC00']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes " \u0308\uAC00", [" \u0308", '\uAC00']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes " \uAC01", [' ', '\uAC01']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes " \u0308\uAC01", [" \u0308", '\uAC01']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes " \u231A", [' ', '\u231A']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0308\u231A", [" \u0308", '\u231A']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes " \u0300", [" \u0300"]                                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0300", [" \u0308\u0300"]                                                                       #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes " \u200D", [" \u200D"]                                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes " \u0308\u200D", [" \u0308\u200D"]                                                                       #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes " \u0378", [' ', '\u0378']                                                                               #   ÷ [0.2] SPACE (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes " \u0308\u0378", [" \u0308", '\u0378']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\r ", ['\r', ' ']                                                                                       #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\r\u0308 ", ['\r', '\u0308', ' ']                                                                       #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\r\r", ['\r', '\r']                                                                                     #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\r", ['\r', '\u0308', '\r']                                                                     #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\r\n", ["\r\n"]                                                                                         #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\n", ['\r', '\u0308', '\n']                                                                     #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\r\u0001", ['\r', '\u0001']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0001", ['\r', '\u0308', '\u0001']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\r\u034F", ['\r', '\u034F']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u034F", ['\r', "\u0308\u034F"]                                                                 #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\r\u{1F1E6}", ['\r', '\u{1F1E6}']                                                                       #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u{1F1E6}", ['\r', '\u0308', '\u{1F1E6}']                                                       #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\r\u0600", ['\r', '\u0600']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0600", ['\r', '\u0308', '\u0600']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\r\u0903", ['\r', '\u0903']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0903", ['\r', "\u0308\u0903"]                                                                 #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\r\u1100", ['\r', '\u1100']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u1100", ['\r', '\u0308', '\u1100']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\r\u1160", ['\r', '\u1160']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u1160", ['\r', '\u0308', '\u1160']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\r\u11A8", ['\r', '\u11A8']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u11A8", ['\r', '\u0308', '\u11A8']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\r\uAC00", ['\r', '\uAC00']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\uAC00", ['\r', '\u0308', '\uAC00']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\r\uAC01", ['\r', '\uAC01']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\uAC01", ['\r', '\u0308', '\uAC01']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\r\u231A", ['\r', '\u231A']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u231A", ['\r', '\u0308', '\u231A']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\r\u0300", ['\r', '\u0300']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0300", ['\r', "\u0308\u0300"]                                                                 #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\r\u200D", ['\r', '\u200D']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u200D", ['\r', "\u0308\u200D"]                                                                 #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\r\u0378", ['\r', '\u0378']                                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\r\u0308\u0378", ['\r', '\u0308', '\u0378']                                                             #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\n ", ['\n', ' ']                                                                                       #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\n\u0308 ", ['\n', '\u0308', ' ']                                                                       #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\n\r", ['\n', '\r']                                                                                     #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\r", ['\n', '\u0308', '\r']                                                                     #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\n\n", ['\n', '\n']                                                                                     #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\n", ['\n', '\u0308', '\n']                                                                     #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\n\u0001", ['\n', '\u0001']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0001", ['\n', '\u0308', '\u0001']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\n\u034F", ['\n', '\u034F']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u034F", ['\n', "\u0308\u034F"]                                                                 #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\n\u{1F1E6}", ['\n', '\u{1F1E6}']                                                                       #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u{1F1E6}", ['\n', '\u0308', '\u{1F1E6}']                                                       #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\n\u0600", ['\n', '\u0600']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0600", ['\n', '\u0308', '\u0600']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\n\u0903", ['\n', '\u0903']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0903", ['\n', "\u0308\u0903"]                                                                 #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\n\u1100", ['\n', '\u1100']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u1100", ['\n', '\u0308', '\u1100']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\n\u1160", ['\n', '\u1160']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u1160", ['\n', '\u0308', '\u1160']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\n\u11A8", ['\n', '\u11A8']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u11A8", ['\n', '\u0308', '\u11A8']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\n\uAC00", ['\n', '\uAC00']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\uAC00", ['\n', '\u0308', '\uAC00']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\n\uAC01", ['\n', '\uAC01']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\uAC01", ['\n', '\u0308', '\uAC01']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\n\u231A", ['\n', '\u231A']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u231A", ['\n', '\u0308', '\u231A']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\n\u0300", ['\n', '\u0300']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0300", ['\n', "\u0308\u0300"]                                                                 #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\n\u200D", ['\n', '\u200D']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u200D", ['\n', "\u0308\u200D"]                                                                 #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\n\u0378", ['\n', '\u0378']                                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\n\u0308\u0378", ['\n', '\u0308', '\u0378']                                                             #   ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0001 ", ['\u0001', ' ']                                                                               #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308 ", ['\u0001', '\u0308', ' ']                                                               #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0001\r", ['\u0001', '\r']                                                                             #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\r", ['\u0001', '\u0308', '\r']                                                             #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0001\n", ['\u0001', '\n']                                                                             #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\n", ['\u0001', '\u0308', '\n']                                                             #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0001", ['\u0001', '\u0001']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u0001", ['\u0001', '\u0308', '\u0001']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0001\u034F", ['\u0001', '\u034F']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u034F", ['\u0001', "\u0308\u034F"]                                                         #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0001\u{1F1E6}", ['\u0001', '\u{1F1E6}']                                                               #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u{1F1E6}", ['\u0001', '\u0308', '\u{1F1E6}']                                               #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0600", ['\u0001', '\u0600']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u0600", ['\u0001', '\u0308', '\u0600']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0903", ['\u0001', '\u0903']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u0903", ['\u0001', "\u0308\u0903"]                                                         #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0001\u1100", ['\u0001', '\u1100']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u1100", ['\u0001', '\u0308', '\u1100']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0001\u1160", ['\u0001', '\u1160']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u1160", ['\u0001', '\u0308', '\u1160']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0001\u11A8", ['\u0001', '\u11A8']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u11A8", ['\u0001', '\u0308', '\u11A8']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0001\uAC00", ['\u0001', '\uAC00']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\uAC00", ['\u0001', '\u0308', '\uAC00']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0001\uAC01", ['\u0001', '\uAC01']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\uAC01", ['\u0001', '\u0308', '\uAC01']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0001\u231A", ['\u0001', '\u231A']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u231A", ['\u0001', '\u0308', '\u231A']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0300", ['\u0001', '\u0300']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u0300", ['\u0001', "\u0308\u0300"]                                                         #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0001\u200D", ['\u0001', '\u200D']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u200D", ['\u0001', "\u0308\u200D"]                                                         #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0378", ['\u0001', '\u0378']                                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0001\u0308\u0378", ['\u0001', '\u0308', '\u0378']                                                     #   ÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u034F ", ['\u034F', ' ']                                                                               #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308 ", ["\u034F\u0308", ' ']                                                                   #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u034F\r", ['\u034F', '\r']                                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\r", ["\u034F\u0308", '\r']                                                                 #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u034F\n", ['\u034F', '\n']                                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\n", ["\u034F\u0308", '\n']                                                                 #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0001", ['\u034F', '\u0001']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u0001", ["\u034F\u0308", '\u0001']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u034F\u034F", ["\u034F\u034F"]                                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u034F", ["\u034F\u0308\u034F"]                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u034F\u{1F1E6}", ['\u034F', '\u{1F1E6}']                                                               #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u{1F1E6}", ["\u034F\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0600", ['\u034F', '\u0600']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u0600", ["\u034F\u0308", '\u0600']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0903", ["\u034F\u0903"]                                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u0903", ["\u034F\u0308\u0903"]                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u034F\u1100", ['\u034F', '\u1100']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u1100", ["\u034F\u0308", '\u1100']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u034F\u1160", ['\u034F', '\u1160']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u1160", ["\u034F\u0308", '\u1160']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u034F\u11A8", ['\u034F', '\u11A8']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u11A8", ["\u034F\u0308", '\u11A8']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u034F\uAC00", ['\u034F', '\uAC00']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\uAC00", ["\u034F\u0308", '\uAC00']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u034F\uAC01", ['\u034F', '\uAC01']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\uAC01", ["\u034F\u0308", '\uAC01']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u034F\u231A", ['\u034F', '\u231A']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u231A", ["\u034F\u0308", '\u231A']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0300", ["\u034F\u0300"]                                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u0300", ["\u034F\u0308\u0300"]                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u034F\u200D", ["\u034F\u200D"]                                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u200D", ["\u034F\u0308\u200D"]                                                             #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0378", ['\u034F', '\u0378']                                                                     #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u034F\u0308\u0378", ["\u034F\u0308", '\u0378']                                                         #   ÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6} ", ['\u{1F1E6}', ' ']                                                                         #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308 ", ["\u{1F1E6}\u0308", ' ']                                                             #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\r", ['\u{1F1E6}', '\r']                                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\r", ["\u{1F1E6}\u0308", '\r']                                                           #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\n", ['\u{1F1E6}', '\n']                                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\n", ["\u{1F1E6}\u0308", '\n']                                                           #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0001", ['\u{1F1E6}', '\u0001']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0001", ["\u{1F1E6}\u0308", '\u0001']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u034F", ["\u{1F1E6}\u034F"]                                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u034F", ["\u{1F1E6}\u0308\u034F"]                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u{1F1E6}", ["\u{1F1E6}\u{1F1E6}"]                                                             #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u{1F1E6}", ["\u{1F1E6}\u0308", '\u{1F1E6}']                                             #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0600", ['\u{1F1E6}', '\u0600']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0600", ["\u{1F1E6}\u0308", '\u0600']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0903", ["\u{1F1E6}\u0903"]                                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0903", ["\u{1F1E6}\u0308\u0903"]                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u1100", ['\u{1F1E6}', '\u1100']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u1100", ["\u{1F1E6}\u0308", '\u1100']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u1160", ['\u{1F1E6}', '\u1160']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u1160", ["\u{1F1E6}\u0308", '\u1160']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u11A8", ['\u{1F1E6}', '\u11A8']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u11A8", ["\u{1F1E6}\u0308", '\u11A8']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\uAC00", ['\u{1F1E6}', '\uAC00']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\uAC00", ["\u{1F1E6}\u0308", '\uAC00']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\uAC01", ['\u{1F1E6}', '\uAC01']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\uAC01", ["\u{1F1E6}\u0308", '\uAC01']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u231A", ['\u{1F1E6}', '\u231A']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u231A", ["\u{1F1E6}\u0308", '\u231A']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0300", ["\u{1F1E6}\u0300"]                                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0300", ["\u{1F1E6}\u0308\u0300"]                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u200D", ["\u{1F1E6}\u200D"]                                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u200D", ["\u{1F1E6}\u0308\u200D"]                                                       #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0378", ['\u{1F1E6}', '\u0378']                                                               #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u0308\u0378", ["\u{1F1E6}\u0308", '\u0378']                                                   #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0600 ", ["\u0600 "]                                                                                   #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308 ", ["\u0600\u0308", ' ']                                                                   #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0600\r", ['\u0600', '\r']                                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\r", ["\u0600\u0308", '\r']                                                                 #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0600\n", ['\u0600', '\n']                                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\n", ["\u0600\u0308", '\n']                                                                 #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0001", ['\u0600', '\u0001']                                                                     #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u0001", ["\u0600\u0308", '\u0001']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0600\u034F", ["\u0600\u034F"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u034F", ["\u0600\u0308\u034F"]                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0600\u{1F1E6}", ["\u0600\u{1F1E6}"]                                                                   #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u{1F1E6}", ["\u0600\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0600", ["\u0600\u0600"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u0600", ["\u0600\u0308", '\u0600']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0903", ["\u0600\u0903"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u0903", ["\u0600\u0308\u0903"]                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0600\u1100", ["\u0600\u1100"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u1100", ["\u0600\u0308", '\u1100']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0600\u1160", ["\u0600\u1160"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u1160", ["\u0600\u0308", '\u1160']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0600\u11A8", ["\u0600\u11A8"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u11A8", ["\u0600\u0308", '\u11A8']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0600\uAC00", ["\u0600\uAC00"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\uAC00", ["\u0600\u0308", '\uAC00']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0600\uAC01", ["\u0600\uAC01"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\uAC01", ["\u0600\u0308", '\uAC01']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0600\u231A", ["\u0600\u231A"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u231A", ["\u0600\u0308", '\u231A']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0300", ["\u0600\u0300"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u0300", ["\u0600\u0308\u0300"]                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0600\u200D", ["\u0600\u200D"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u200D", ["\u0600\u0308\u200D"]                                                             #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0378", ["\u0600\u0378"]                                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0600\u0308\u0378", ["\u0600\u0308", '\u0378']                                                         #   ÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0903 ", ['\u0903', ' ']                                                                               #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308 ", ["\u0903\u0308", ' ']                                                                   #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0903\r", ['\u0903', '\r']                                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\r", ["\u0903\u0308", '\r']                                                                 #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0903\n", ['\u0903', '\n']                                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\n", ["\u0903\u0308", '\n']                                                                 #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0001", ['\u0903', '\u0001']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0001", ["\u0903\u0308", '\u0001']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0903\u034F", ["\u0903\u034F"]                                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u034F", ["\u0903\u0308\u034F"]                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u{1F1E6}", ['\u0903', '\u{1F1E6}']                                                               #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u{1F1E6}", ["\u0903\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0600", ['\u0903', '\u0600']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0600", ["\u0903\u0308", '\u0600']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0903", ["\u0903\u0903"]                                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0903", ["\u0903\u0308\u0903"]                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0903\u1100", ['\u0903', '\u1100']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u1100", ["\u0903\u0308", '\u1100']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0903\u1160", ['\u0903', '\u1160']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u1160", ["\u0903\u0308", '\u1160']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0903\u11A8", ['\u0903', '\u11A8']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u11A8", ["\u0903\u0308", '\u11A8']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0903\uAC00", ['\u0903', '\uAC00']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\uAC00", ["\u0903\u0308", '\uAC00']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0903\uAC01", ['\u0903', '\uAC01']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\uAC01", ["\u0903\u0308", '\uAC01']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0903\u231A", ['\u0903', '\u231A']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u231A", ["\u0903\u0308", '\u231A']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0300", ["\u0903\u0300"]                                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0300", ["\u0903\u0308\u0300"]                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0903\u200D", ["\u0903\u200D"]                                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u200D", ["\u0903\u0308\u200D"]                                                             #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0378", ['\u0903', '\u0378']                                                                     #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0903\u0308\u0378", ["\u0903\u0308", '\u0378']                                                         #   ÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u1100 ", ['\u1100', ' ']                                                                               #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308 ", ["\u1100\u0308", ' ']                                                                   #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u1100\r", ['\u1100', '\r']                                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\r", ["\u1100\u0308", '\r']                                                                 #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u1100\n", ['\u1100', '\n']                                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\n", ["\u1100\u0308", '\n']                                                                 #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0001", ['\u1100', '\u0001']                                                                     #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0001", ["\u1100\u0308", '\u0001']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1100\u034F", ["\u1100\u034F"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u034F", ["\u1100\u0308\u034F"]                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u{1F1E6}", ['\u1100', '\u{1F1E6}']                                                               #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u{1F1E6}", ["\u1100\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0600", ['\u1100', '\u0600']                                                                     #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0600", ["\u1100\u0308", '\u0600']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0903", ["\u1100\u0903"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0903", ["\u1100\u0308\u0903"]                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1100", ["\u1100\u1100"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u1100", ["\u1100\u0308", '\u1100']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1160", ["\u1100\u1160"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u1160", ["\u1100\u0308", '\u1160']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1100\u11A8", ['\u1100', '\u11A8']                                                                     #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u11A8", ["\u1100\u0308", '\u11A8']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1100\uAC00", ["\u1100\uAC00"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\uAC00", ["\u1100\u0308", '\uAC00']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1100\uAC01", ["\u1100\uAC01"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\uAC01", ["\u1100\u0308", '\uAC01']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1100\u231A", ['\u1100', '\u231A']                                                                     #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u231A", ["\u1100\u0308", '\u231A']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0300", ["\u1100\u0300"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0300", ["\u1100\u0308\u0300"]                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1100\u200D", ["\u1100\u200D"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u200D", ["\u1100\u0308\u200D"]                                                             #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0378", ['\u1100', '\u0378']                                                                     #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u1100\u0308\u0378", ["\u1100\u0308", '\u0378']                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u1160 ", ['\u1160', ' ']                                                                               #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308 ", ["\u1160\u0308", ' ']                                                                   #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u1160\r", ['\u1160', '\r']                                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\r", ["\u1160\u0308", '\r']                                                                 #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u1160\n", ['\u1160', '\n']                                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\n", ["\u1160\u0308", '\n']                                                                 #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0001", ['\u1160', '\u0001']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0001", ["\u1160\u0308", '\u0001']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u1160\u034F", ["\u1160\u034F"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u034F", ["\u1160\u0308\u034F"]                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u{1F1E6}", ['\u1160', '\u{1F1E6}']                                                               #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u{1F1E6}", ["\u1160\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0600", ['\u1160', '\u0600']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0600", ["\u1160\u0308", '\u0600']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0903", ["\u1160\u0903"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0903", ["\u1160\u0308\u0903"]                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u1160\u1100", ['\u1160', '\u1100']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u1100", ["\u1160\u0308", '\u1100']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u1160\u1160", ["\u1160\u1160"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u1160", ["\u1160\u0308", '\u1160']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u1160\u11A8", ["\u1160\u11A8"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u11A8", ["\u1160\u0308", '\u11A8']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u1160\uAC00", ['\u1160', '\uAC00']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\uAC00", ["\u1160\u0308", '\uAC00']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u1160\uAC01", ['\u1160', '\uAC01']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\uAC01", ["\u1160\u0308", '\uAC01']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u1160\u231A", ['\u1160', '\u231A']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u231A", ["\u1160\u0308", '\u231A']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0300", ["\u1160\u0300"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0300", ["\u1160\u0308\u0300"]                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1160\u200D", ["\u1160\u200D"]                                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u200D", ["\u1160\u0308\u200D"]                                                             #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0378", ['\u1160', '\u0378']                                                                     #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u1160\u0308\u0378", ["\u1160\u0308", '\u0378']                                                         #   ÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u11A8 ", ['\u11A8', ' ']                                                                               #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308 ", ["\u11A8\u0308", ' ']                                                                   #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u11A8\r", ['\u11A8', '\r']                                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\r", ["\u11A8\u0308", '\r']                                                                 #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u11A8\n", ['\u11A8', '\n']                                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\n", ["\u11A8\u0308", '\n']                                                                 #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0001", ['\u11A8', '\u0001']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0001", ["\u11A8\u0308", '\u0001']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u034F", ["\u11A8\u034F"]                                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u034F", ["\u11A8\u0308\u034F"]                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u{1F1E6}", ['\u11A8', '\u{1F1E6}']                                                               #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u{1F1E6}", ["\u11A8\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0600", ['\u11A8', '\u0600']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0600", ["\u11A8\u0308", '\u0600']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0903", ["\u11A8\u0903"]                                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0903", ["\u11A8\u0308\u0903"]                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u1100", ['\u11A8', '\u1100']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u1100", ["\u11A8\u0308", '\u1100']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u1160", ['\u11A8', '\u1160']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u1160", ["\u11A8\u0308", '\u1160']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u11A8", ["\u11A8\u11A8"]                                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u11A8", ["\u11A8\u0308", '\u11A8']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u11A8\uAC00", ['\u11A8', '\uAC00']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\uAC00", ["\u11A8\u0308", '\uAC00']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u11A8\uAC01", ['\u11A8', '\uAC01']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\uAC01", ["\u11A8\u0308", '\uAC01']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u231A", ['\u11A8', '\u231A']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u231A", ["\u11A8\u0308", '\u231A']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0300", ["\u11A8\u0300"]                                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0300", ["\u11A8\u0308\u0300"]                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u200D", ["\u11A8\u200D"]                                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u200D", ["\u11A8\u0308\u200D"]                                                             #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0378", ['\u11A8', '\u0378']                                                                     #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u11A8\u0308\u0378", ["\u11A8\u0308", '\u0378']                                                         #   ÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC00 ", ['\uAC00', ' ']                                                                               #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308 ", ["\uAC00\u0308", ' ']                                                                   #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC00\r", ['\uAC00', '\r']                                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\r", ["\uAC00\u0308", '\r']                                                                 #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\uAC00\n", ['\uAC00', '\n']                                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\n", ["\uAC00\u0308", '\n']                                                                 #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0001", ['\uAC00', '\u0001']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0001", ["\uAC00\u0308", '\u0001']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u034F", ["\uAC00\u034F"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u034F", ["\uAC00\u0308\u034F"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u{1F1E6}", ['\uAC00', '\u{1F1E6}']                                                               #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u{1F1E6}", ["\uAC00\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0600", ['\uAC00', '\u0600']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0600", ["\uAC00\u0308", '\u0600']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0903", ["\uAC00\u0903"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0903", ["\uAC00\u0308\u0903"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u1100", ['\uAC00', '\u1100']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u1100", ["\uAC00\u0308", '\u1100']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u1160", ["\uAC00\u1160"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u1160", ["\uAC00\u0308", '\u1160']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u11A8", ["\uAC00\u11A8"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u11A8", ["\uAC00\u0308", '\u11A8']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC00\uAC00", ['\uAC00', '\uAC00']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\uAC00", ["\uAC00\u0308", '\uAC00']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC00\uAC01", ['\uAC00', '\uAC01']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\uAC01", ["\uAC00\u0308", '\uAC01']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u231A", ['\uAC00', '\u231A']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u231A", ["\uAC00\u0308", '\u231A']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0300", ["\uAC00\u0300"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0300", ["\uAC00\u0308\u0300"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u200D", ["\uAC00\u200D"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u200D", ["\uAC00\u0308\u200D"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0378", ['\uAC00', '\u0378']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u0308\u0378", ["\uAC00\u0308", '\u0378']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC01 ", ['\uAC01', ' ']                                                                               #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308 ", ["\uAC01\u0308", ' ']                                                                   #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC01\r", ['\uAC01', '\r']                                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\r", ["\uAC01\u0308", '\r']                                                                 #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\uAC01\n", ['\uAC01', '\n']                                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\n", ["\uAC01\u0308", '\n']                                                                 #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0001", ['\uAC01', '\u0001']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0001", ["\uAC01\u0308", '\u0001']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u034F", ["\uAC01\u034F"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u034F", ["\uAC01\u0308\u034F"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u{1F1E6}", ['\uAC01', '\u{1F1E6}']                                                               #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u{1F1E6}", ["\uAC01\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0600", ['\uAC01', '\u0600']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0600", ["\uAC01\u0308", '\u0600']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0903", ["\uAC01\u0903"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0903", ["\uAC01\u0308\u0903"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u1100", ['\uAC01', '\u1100']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u1100", ["\uAC01\u0308", '\u1100']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u1160", ['\uAC01', '\u1160']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u1160", ["\uAC01\u0308", '\u1160']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u11A8", ["\uAC01\u11A8"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u11A8", ["\uAC01\u0308", '\u11A8']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\uAC01\uAC00", ['\uAC01', '\uAC00']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\uAC00", ["\uAC01\u0308", '\uAC00']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\uAC01\uAC01", ['\uAC01', '\uAC01']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\uAC01", ["\uAC01\u0308", '\uAC01']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u231A", ['\uAC01', '\u231A']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u231A", ["\uAC01\u0308", '\u231A']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0300", ["\uAC01\u0300"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0300", ["\uAC01\u0308\u0300"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u200D", ["\uAC01\u200D"]                                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u200D", ["\uAC01\u0308\u200D"]                                                             #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0378", ['\uAC01', '\u0378']                                                                     #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u0308\u0378", ["\uAC01\u0308", '\u0378']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u231A ", ['\u231A', ' ']                                                                               #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308 ", ["\u231A\u0308", ' ']                                                                   #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u231A\r", ['\u231A', '\r']                                                                             #   ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\r", ["\u231A\u0308", '\r']                                                                 #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u231A\n", ['\u231A', '\n']                                                                             #   ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\n", ["\u231A\u0308", '\n']                                                                 #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0001", ['\u231A', '\u0001']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u0001", ["\u231A\u0308", '\u0001']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u231A\u034F", ["\u231A\u034F"]                                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u034F", ["\u231A\u0308\u034F"]                                                             #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u231A\u{1F1E6}", ['\u231A', '\u{1F1E6}']                                                               #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u{1F1E6}", ["\u231A\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0600", ['\u231A', '\u0600']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u0600", ["\u231A\u0308", '\u0600']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0903", ["\u231A\u0903"]                                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u0903", ["\u231A\u0308\u0903"]                                                             #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u231A\u1100", ['\u231A', '\u1100']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u1100", ["\u231A\u0308", '\u1100']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u231A\u1160", ['\u231A', '\u1160']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u1160", ["\u231A\u0308", '\u1160']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u231A\u11A8", ['\u231A', '\u11A8']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u11A8", ["\u231A\u0308", '\u11A8']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u231A\uAC00", ['\u231A', '\uAC00']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\uAC00", ["\u231A\u0308", '\uAC00']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u231A\uAC01", ['\u231A', '\uAC01']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\uAC01", ["\u231A\u0308", '\uAC01']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u231A\u231A", ['\u231A', '\u231A']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u231A", ["\u231A\u0308", '\u231A']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0300", ["\u231A\u0300"]                                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u0300", ["\u231A\u0308\u0300"]                                                             #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u231A\u200D", ["\u231A\u200D"]                                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u200D", ["\u231A\u0308\u200D"]                                                             #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0378", ['\u231A', '\u0378']                                                                     #   ÷ [0.2] WATCH (ExtPict) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u231A\u0308\u0378", ["\u231A\u0308", '\u0378']                                                         #   ÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0300 ", ['\u0300', ' ']                                                                               #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308 ", ["\u0300\u0308", ' ']                                                                   #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0300\r", ['\u0300', '\r']                                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\r", ["\u0300\u0308", '\r']                                                                 #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0300\n", ['\u0300', '\n']                                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\n", ["\u0300\u0308", '\n']                                                                 #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0001", ['\u0300', '\u0001']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0001", ["\u0300\u0308", '\u0001']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0300\u034F", ["\u0300\u034F"]                                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u034F", ["\u0300\u0308\u034F"]                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u{1F1E6}", ['\u0300', '\u{1F1E6}']                                                               #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u{1F1E6}", ["\u0300\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0600", ['\u0300', '\u0600']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0600", ["\u0300\u0308", '\u0600']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0903", ["\u0300\u0903"]                                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0903", ["\u0300\u0308\u0903"]                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0300\u1100", ['\u0300', '\u1100']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u1100", ["\u0300\u0308", '\u1100']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0300\u1160", ['\u0300', '\u1160']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u1160", ["\u0300\u0308", '\u1160']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0300\u11A8", ['\u0300', '\u11A8']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u11A8", ["\u0300\u0308", '\u11A8']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0300\uAC00", ['\u0300', '\uAC00']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\uAC00", ["\u0300\u0308", '\uAC00']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0300\uAC01", ['\u0300', '\uAC01']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\uAC01", ["\u0300\u0308", '\uAC01']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0300\u231A", ['\u0300', '\u231A']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u231A", ["\u0300\u0308", '\u231A']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0300", ["\u0300\u0300"]                                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0300", ["\u0300\u0308\u0300"]                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0300\u200D", ["\u0300\u200D"]                                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u200D", ["\u0300\u0308\u200D"]                                                             #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0378", ['\u0300', '\u0378']                                                                     #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0300\u0308\u0378", ["\u0300\u0308", '\u0378']                                                         #   ÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u200D ", ['\u200D', ' ']                                                                               #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308 ", ["\u200D\u0308", ' ']                                                                   #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u200D\r", ['\u200D', '\r']                                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\r", ["\u200D\u0308", '\r']                                                                 #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u200D\n", ['\u200D', '\n']                                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\n", ["\u200D\u0308", '\n']                                                                 #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0001", ['\u200D', '\u0001']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0001", ["\u200D\u0308", '\u0001']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u200D\u034F", ["\u200D\u034F"]                                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u034F", ["\u200D\u0308\u034F"]                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u{1F1E6}", ['\u200D', '\u{1F1E6}']                                                               #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u{1F1E6}", ["\u200D\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0600", ['\u200D', '\u0600']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0600", ["\u200D\u0308", '\u0600']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0903", ["\u200D\u0903"]                                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0903", ["\u200D\u0308\u0903"]                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u200D\u1100", ['\u200D', '\u1100']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u1100", ["\u200D\u0308", '\u1100']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u200D\u1160", ['\u200D', '\u1160']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u1160", ["\u200D\u0308", '\u1160']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u200D\u11A8", ['\u200D', '\u11A8']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u11A8", ["\u200D\u0308", '\u11A8']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u200D\uAC00", ['\u200D', '\uAC00']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\uAC00", ["\u200D\u0308", '\uAC00']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u200D\uAC01", ['\u200D', '\uAC01']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\uAC01", ["\u200D\u0308", '\uAC01']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u200D\u231A", ['\u200D', '\u231A']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u231A", ["\u200D\u0308", '\u231A']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0300", ["\u200D\u0300"]                                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0300", ["\u200D\u0308\u0300"]                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u200D\u200D", ["\u200D\u200D"]                                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u200D", ["\u200D\u0308\u200D"]                                                             #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0378", ['\u200D', '\u0378']                                                                     #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u200D\u0308\u0378", ["\u200D\u0308", '\u0378']                                                         #   ÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0378 ", ['\u0378', ' ']                                                                               #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308 ", ["\u0378\u0308", ' ']                                                                   #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u0378\r", ['\u0378', '\r']                                                                             #   ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\r", ["\u0378\u0308", '\r']                                                                 #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) ÷ [0.3]
  it_iterates_graphemes "\u0378\n", ['\u0378', '\n']                                                                             #   ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\n", ["\u0378\u0308", '\n']                                                                 #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0001", ['\u0378', '\u0001']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0001", ["\u0378\u0308", '\u0001']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]
  it_iterates_graphemes "\u0378\u034F", ["\u0378\u034F"]                                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u034F", ["\u0378\u0308\u034F"]                                                             #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u{1F1E6}", ['\u0378', '\u{1F1E6}']                                                               #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u{1F1E6}", ["\u0378\u0308", '\u{1F1E6}']                                                   #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0600", ['\u0378', '\u0600']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0600", ["\u0378\u0308", '\u0600']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0903", ["\u0378\u0903"]                                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0903", ["\u0378\u0308\u0903"]                                                             #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]
  it_iterates_graphemes "\u0378\u1100", ['\u0378', '\u1100']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u1100", ["\u0378\u0308", '\u1100']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u0378\u1160", ['\u0378', '\u1160']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u1160", ["\u0378\u0308", '\u1160']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]
  it_iterates_graphemes "\u0378\u11A8", ['\u0378', '\u11A8']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u11A8", ["\u0378\u0308", '\u11A8']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]
  it_iterates_graphemes "\u0378\uAC00", ['\u0378', '\uAC00']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\uAC00", ["\u0378\u0308", '\uAC00']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]
  it_iterates_graphemes "\u0378\uAC01", ['\u0378', '\uAC01']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\uAC01", ["\u0378\u0308", '\uAC01']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]
  it_iterates_graphemes "\u0378\u231A", ['\u0378', '\u231A']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u231A", ["\u0378\u0308", '\u231A']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0300", ["\u0378\u0300"]                                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0300", ["\u0378\u0308\u0300"]                                                             #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0378\u200D", ["\u0378\u200D"]                                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u200D", ["\u0378\u0308\u200D"]                                                             #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0378", ['\u0378', '\u0378']                                                                     #   ÷ [0.2] <reserved-0378> (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\u0378\u0308\u0378", ["\u0378\u0308", '\u0378']                                                         #   ÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]
  it_iterates_graphemes "\r\na\n\u0308", ["\r\n", 'a', '\n', '\u0308']                                                           #   ÷ [0.2] <CARRIAGE RETURN (CRYSTAL)> (CRYSTAL) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "a\u0308", ["a\u0308"]                                                                                   #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes " \u200D\u0646", [" \u200D", '\u0646']                                                                   #   ÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC LETTER NOON (Other) ÷ [0.3]
  it_iterates_graphemes "\u0646\u200D ", ["\u0646\u200D", ' ']                                                                   #   ÷ [0.2] ARABIC LETTER NOON (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]
  it_iterates_graphemes "\u1100\u1100", ["\u1100\u1100"]                                                                         #   ÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC00\u11A8\u1100", ["\uAC00\u11A8", '\u1100']                                                         #   ÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\uAC01\u11A8\u1100", ["\uAC01\u11A8", '\u1100']                                                         #   ÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]
  it_iterates_graphemes "\u{1F1E6}\u{1F1E7}\u{1F1E8}b", ["\u{1F1E6}\u{1F1E7}", '\u{1F1E8}', 'b']                                 #   ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u{1F1E8}b", ['a', "\u{1F1E6}\u{1F1E7}", '\u{1F1E8}', 'b']                           #   ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u200D\u{1F1E8}b", ['a', "\u{1F1E6}\u{1F1E7}\u200D", '\u{1F1E8}', 'b']               #   ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u200D\u{1F1E7}\u{1F1E8}b", ['a', "\u{1F1E6}\u200D", "\u{1F1E7}\u{1F1E8}", 'b']               #   ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u{1F1E6}\u{1F1E7}\u{1F1E8}\u{1F1E9}b", ['a', "\u{1F1E6}\u{1F1E7}", "\u{1F1E8}\u{1F1E9}", 'b']         #   ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u200D", ["a\u200D"]                                                                                   #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]
  it_iterates_graphemes "a\u0308b", ["a\u0308", 'b']                                                                             #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u0903b", ["a\u0903", 'b']                                                                             #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "a\u0600b", ['a', "\u0600b"]                                                                             #   ÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) × [9.2] LATIN SMALL LETTER B (Other) ÷ [0.3]
  it_iterates_graphemes "\u{1F476}\u{1F3FF}\u{1F476}", ["\u{1F476}\u{1F3FF}", '\u{1F476}']                                       #   ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F3FF}\u{1F476}", ["a\u{1F3FF}", '\u{1F476}']                                                       #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u{1F3FF}\u{1F476}\u200D\u{1F6D1}", ["a\u{1F3FF}", "\u{1F476}\u200D\u{1F6D1}"]                         #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u{1F476}\u{1F3FF}\u0308\u200D\u{1F476}\u{1F3FF}", ["\u{1F476}\u{1F3FF}\u0308\u200D\u{1F476}\u{1F3FF}"] #   ÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]
  it_iterates_graphemes "\u{1F6D1}\u200D\u{1F6D1}", ["\u{1F6D1}\u200D\u{1F6D1}"]                                                 #   ÷ [0.2] OCTAGONAL SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "a\u200D\u{1F6D1}", ["a\u200D", '\u{1F6D1}']                                                             #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
  it_iterates_graphemes "\u2701\u200D\u2701", ["\u2701\u200D\u2701"]                                                             #   ÷ [0.2] UPPER BLADE SCISSORS (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]
  it_iterates_graphemes "a\u200D\u2701", ["a\u200D", '\u2701']                                                                   #   ÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]
end
