# SPDX-License-Identifier: GPL-2.0-or-later

"""
Pose Library based on the Asset Browser.
"""

bl_info = {
    "name": "Pose Library",
    "description": "Pose Library based on the Asset Browser.",
    "author": "Sybren A. Stüvel",
    "version": (2, 0),
    "blender": (3, 0, 0),
    "warning": "In heavily development, things may change",
    "location": "Asset Browser -> Animations, and 3D Viewport -> Animation panel",
    # "doc_url": "{BLENDER_MANUAL_URL}/addons/animation/pose_library.html",
    "support": "OFFICIAL",
    "category": "Animation",
}

from typing import List, Tuple

_need_reload = "operators" in locals()
from . import gui, keymaps, operators, conversion

if _need_reload:
    import importlib

    gui = importlib.reload(gui)
    keymaps = importlib.reload(keymaps)
    operators = importlib.reload(operators)
    conversion = importlib.reload(conversion)

import bpy

addon_keymaps: List[Tuple[bpy.types.KeyMap, bpy.types.KeyMapItem]] = []


def register() -> None:
    bpy.types.WindowManager.poselib_flipped = bpy.props.BoolProperty(
        name="Flip Pose",
        default=False,
    )
    bpy.types.WindowManager.poselib_previous_action = bpy.props.PointerProperty(type=bpy.types.Action)

    operators.register()
    keymaps.register()
    gui.register()


def unregister() -> None:
    gui.unregister()
    keymaps.unregister()
    operators.unregister()

    try:
        del bpy.types.WindowManager.poselib_flipped
    except AttributeError:
        pass
    try:
        del bpy.types.WindowManager.poselib_previous_action
    except AttributeError:
        pass
