#!/usr/bin/env bash
################################################################################

PYMODULE=pexpect
PIPMODULE=pexpect
PACKAGE=python-pexpect
# debian7 wheezy python-pexpect                  2.4-1
# debian8 jessie python-pexpect              3.2-1
# ubuntu12 precise python-pexpect                   2.3-1ubuntu2
# ubuntu14 trusty python-pexpect                   3.1-1ubuntu0.1
# ubuntu16 xenial python-pexpect              4.0.1-1


################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

python <<EOF
try:
	import ${PYMODULE}
	import sys
	sys.exit(0)
except Exception as e:
	import sys
	sys.exit(1)
EOF
has_pymodule=$?

if [ $has_pymodule -eq 0 ]; then
	exit 0
fi

if [ -f /etc/os-release ]; then
	. /etc/os-release
fi

distro_id=${ID,,}
distro_version=${VERSION_ID}

case "$distro_id:$distro_version" in
	* )
		echo Installing ${PACKAGE}
		apt-get install -y ${PACKAGE}
		;;
esac
