#!/usr/bin/env bash

################################################################################

PYMODULE=pyOpenSSL

PIP_PACKAGE=pip-9.0.1.tar.gz

################################################################################

command_exists () {
    type "$1" &> /dev/null ;
}

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

assumeyes=$1

package_installer="apt-get"
if $assumeyes ; then
	package_installer="apt-get -y"
fi

if ! command_exists pip ; then
	if ! $assumeyes ; then
		echo "Installing following packages:"
		echo "1) System Packages: python-pip, python-dev, python-setuptools"
		read -p "Is this ok [y/N]: " input

		if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
			exit 0
		fi
	fi

	echo Installing python-dev
	${package_installer} install python-dev

	echo Installing python-setuptools
	${package_installer} install python-setuptools

	DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

	echo Installing pip
	easy_install ${DIR}/${PIP_PACKAGE}

	if ! command_exists pip ; then
		echo "Error while installing pip. Please install pip and run this installation again."
		exit 1
	fi
fi

if ! $assumeyes ; then
	echo "Installing following package:"
	echo "1) Python Package: pyOpenSSL"
	read -p "Is this ok [y/N]: " input

	if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
		exit 0
	fi
fi

echo "Installing ${PYMODULE}>=16.0.0"
pip install "${PYMODULE}>=16.0.0"
