###############################################################################
#
# Tests for XlsxWriter.
#
# Copyright (c), 2013-2021, John McNamara, jmcnamara@cpan.org
#

from ..excel_comparison_test import ExcelComparisonTest
from ...workbook import Workbook


class TestCompareXLSXFiles(ExcelComparisonTest):
    """
    Test file created by XlsxWriter against a file created by Excel.

    """

    def setUp(self):

        self.set_filename('table22.xlsx')

    def test_create_file(self):
        """Test the creation of a simple XlsxWriter file with tables."""

        workbook = Workbook(self.got_filename)

        worksheet = workbook.add_worksheet()

        data = [
            ['apple', 'pie'],
            ['pine', 'tree'],
        ]

        worksheet.set_column('B:C', 10.288)

        worksheet.add_table('B2:C3', {'data': data, 'header_row': False})

        workbook.close()

        self.assertExcelEqual()
