/* LibExploit
 *
 * FILENAME : network.c
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Network functions file.
 *
*/

#include "../include/LibExploit.h"

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : int LibExploit_Connect
 * PARAMS   : char *host, int port
 * ABSTRACT : Connect to given host on port. 
*/
int LibExploit_Connect(char *host, int port) {
	int Sock, Con;
	struct sockaddr_in Victim;
	struct hostent *he;

	he = gethostbyname(host);
	if(he == NULL) {
		return -1;
	}
	
	Sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(Sock == -1) {
		return -1;
	}

	memcpy(&Victim.sin_addr, he->h_addr, he->h_length);
	Victim.sin_family = AF_INET;
	Victim.sin_port = htons(port);
	
	Con = connect(Sock, (struct sockaddr *) &Victim, sizeof(Victim));
	if(Con == -1) {
		return -1;
	}

return Sock;
}

/*
 * FUNCTION : void LibExploit_Write
 * PARAMS   : int Sock, char *msg
 * ABSTRACT : Write data to a socket.
*/
void LibExploit_Write(int Sock, char *msg) {
	write(Sock, msg, strlen(msg));
}

/*
 * FUNCTION : unsigned long LibExploit_Resolve
 * PARAMS   : char *host
 * ABSTRACT : Resolve host.
*/
unsigned long LibExploit_Resolve(char *host) {
	struct hostent *he;
	unsigned long ip;

	if((ip = inet_addr(host)) == -1)  {
		if((he = gethostbyname(host)) == NULL) {
			return -1;
		}
		memcpy(&ip, he->h_addr,4);
	}
	
return ip;
}

/*
 * FUNCTION : void LibExploit_Loginftp
 * PARAMS   : int Sock, char *user, char *pass
 * ABSTRACT : Do the ftp login procress.
*/
void LibExploit_Loginftp(int Sock, char *user, char *pass) {
	char snd[MAX1024], rcv[MAX1024];
	int n;

	memset(snd, '\0', MAX1024);
	sprintf(snd, "USER %s\r\n", user);
	LibExploit_Write(Sock, snd);	

	while((n=read(Sock, rcv, sizeof(rcv))) > 0) {
		rcv[n] = 0;
		if(strchr(rcv, '\n') != NULL)
			break;
	}

	memset(snd, '\0', MAX1024);
	sprintf(snd, "PASS %s\r\n", pass);
	LibExploit_Write(Sock, snd);	

	while((n=read(Sock, rcv, sizeof(rcv))) > 0) {
		rcv[n] = 0;
		if(strchr(rcv, '\n') != NULL)
			break;
	}

return;
}

/*
 * FUNCTION : int LibExploit_Send
 * PARAMS   : int Sock, const char *msg
 * ABSTRACT : Send data via socket.
*/
int LibExploit_Send(int Sock, const char *msg) {
	int ret;

	ret = send(Sock, msg, sizeof(msg), 0);

return ret;
}

/*
 * FUNCTION : int LibExploit_Close
 * PARAMS   : int Sock
 * ABSTRACT : Close a socket.
*/
int LibExploit_Close(int Sock) {
	int ret;	

	ret = close(Sock);

return ret;
}

/*
 * FUNCTION : int LibExploit_Read
 * PARAMS   : int Sock, char data[MAX1024]
 * ABSTRACT : Read data from socket.
*/
int LibExploit_Read(int Sock, char dt[MAX1024]) {
	int ret;

	ret = read(Sock, dt, sizeof(dt));

return(ret);
}

/*
 * FUNCTION : int LibExploit_CheckBanner
 * PARAMS   : int Sock, char *str
 * ABSTRACT : Check a banner port.
*/
int LibExploit_CheckBanner(int Sock, char str[MAX1024]) {
	char buf[MAX1024];
	int ret=0;

	bzero(buf, sizeof(buf));
	read(Sock, buf, sizeof(buf));
	if(strstr(buf, str) != NULL) {
		ret = 1;
	} else {
		ret = -1;
	}

return(ret);	
}

/* SRF E0F */
