#!perl -Tw
use Test::More tests=>5;
BEGIN {
    use_ok( 'HTML::TreeBuilder' );
}
use strict;

print "#Using HTML::TreeBuilder version v$HTML::TreeBuilder::VERSION\n";
print "#Using HTML::Element version v$HTML::Element::VERSION\n";
print "#Using HTML::Parser version v", $HTML::Parser::VERSION || "?", "\n";
print "#Using HTML::Entities version v", $HTML::Entities::VERSION || "?", "\n";
print "#Using HTML::Tagset version v", $HTML::Tagset::VERSION || "?", "\n";
print "# Running under perl version $] for $^O",
  (chr(65) eq 'A') ? "\n" : " in a non-ASCII world\n";
print "# Win32::BuildNumber ", &Win32::BuildNumber(), "\n"
  if defined(&Win32::BuildNumber) and defined &Win32::BuildNumber();
print "# MacPerl verison $MacPerl::Version\n"
  if defined $MacPerl::Version;
printf 
  "# Current time local: %s\n# Current time GMT:   %s\n",
  scalar(localtime($^T)), scalar(gmtime($^T));


my $tempfile = "lwp-test-$$";

open(F, ">$tempfile") or die "Can't open $tempfile: $!";

print F <<EOT;
<!-- This is a test file generated by $0 -->
<title>Libwww-perl test</title>
<isindex>

<body>

This is some text and this is a simple <a
href="http://www.sn.no/libwww-perl/">link</a> back to the
<b>libwww-perl</b> site.

<!-- This tag isn't quoted properly, but should be when rendered -->
<img src=sean-burke-naked-as-a-jaybird.jpg>

<foo a=b

EOT
close(F);

my $h = HTML::TreeBuilder->new;
$h->parse_file($tempfile);
unlink($tempfile);

{
my $x = $_ = $h->as_HTML;
$x =~ s/^/# /mg;
print "# As HTML: $x#\n";
}

# Just make a few samples to check that we got what we expected
like($_, qr/<head>/i, "Matches Head");
like($_, qr/<isindex \/>/i, "Matches isindex");
like($_, qr/<img src="sean-burke-naked-as-a-jaybird.jpg" \/>/, "Found the img tag");
like($_, qr/this is a simple/, "Matches simple text");

# /foo\s*a=b/ || $bad++; # too version-dependent
