/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.List;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.StaticError;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryCompiler {
    private Processor processor;
    private StaticQueryContext env;
    private ItemType requiredContextItemType;
    private String encoding;

    protected XQueryCompiler(Processor processor) {
        this.processor = processor;
        this.env = processor.getUnderlyingConfiguration().newStaticQueryContext();
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setBaseURI(URI baseURI) {
        if (baseURI == null) {
            this.env.setBaseURI(null);
        } else {
            if (!baseURI.isAbsolute()) {
                throw new IllegalArgumentException("Base URI must be an absolute URI: " + baseURI);
            }
            this.env.setBaseURI(baseURI.toString());
        }
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void setErrorListener(ErrorListener listener) {
        this.env.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.env.getErrorListener();
    }

    public void setCompileWithTracing(boolean option) {
        this.env.setCompileWithTracing(option);
    }

    public boolean isCompileWithTracing() {
        return this.env.isCompileWithTracing();
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.env.setModuleURIResolver(resolver);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.env.getModuleURIResolver();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUpdatingEnabled(boolean updating) {
        if (updating && !this.env.getConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("XQuery Update is not supported in this Saxon Configuration");
        }
        this.env.setUpdatingEnabled(updating);
    }

    public boolean isUpdatingEnabled() {
        return this.env.isUpdatingEnabled();
    }

    public void setSchemaAware(boolean schemaAware) {
        if (schemaAware && !this.processor.getUnderlyingConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("Schema-awareness requires a Saxon-EE license");
        }
        this.env.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.env.isSchemaAware();
    }

    public void setStreaming(boolean option) {
        this.env.setStreaming(option);
        if (option && !this.processor.getUnderlyingConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("Streaming requires a Saxon-EE license");
        }
    }

    public boolean isStreaming() {
        return this.env.isStreaming();
    }

    public void setLanguageVersion(String version) {
        DecimalValue v;
        try {
            v = (DecimalValue)DecimalValue.makeDecimalValue(version, true).asAtomic();
        }
        catch (ValidationException ve) {
            throw new IllegalArgumentException(ve);
        }
        if (v.equals(DecimalValue.THREE_POINT_ONE)) {
            v = DecimalValue.THREE;
        }
        if (!DecimalValue.ONE.equals(v) && !DecimalValue.THREE.equals(v)) {
            throw new IllegalArgumentException("LanguageVersion " + v);
        }
        this.env.setLanguageVersion(v);
    }

    public String getLanguageVersion() {
        return this.env.getLanguageVersion().toString();
    }

    public void declareNamespace(String prefix, String uri) {
        this.env.declareNamespace(prefix, uri);
    }

    public void declareCollation(String uri, Collator collation) {
        this.getProcessor().declareCollation(uri, collation);
    }

    public void declareDefaultCollation(String uri) {
        StringCollator c;
        try {
            c = this.getProcessor().getUnderlyingConfiguration().getCollation(uri);
        }
        catch (XPathException e) {
            c = null;
        }
        if (c == null) {
            throw new IllegalStateException("Unknown collation " + uri);
        }
        this.env.declareDefaultCollation(uri);
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
        this.env.setRequiredContextItemType(type.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void compileLibrary(String query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void compileLibrary(File query) throws SaxonApiException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(query);
            String savedBaseUri = this.env.getBaseURI();
            this.env.setBaseURI(query.toURI().toString());
            this.env.compileLibrary(stream, this.encoding);
            this.env.setBaseURI(savedBaseUri);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void compileLibrary(Reader query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public void compileLibrary(InputStream query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query, this.encoding);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(String query) throws SaxonApiException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(File query) throws SaxonApiException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(query);
            String savedBaseUri = this.env.getBaseURI();
            this.env.setBaseURI(query.toURI().toString());
            XQueryExecutable exec = new XQueryExecutable(this.processor, this.env.compileQuery(stream, this.encoding));
            this.env.setBaseURI(savedBaseUri);
            XQueryExecutable xQueryExecutable = exec;
            return xQueryExecutable;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public XQueryExecutable compile(InputStream query) throws SaxonApiException, IOException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query, this.encoding));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(Reader query) throws SaxonApiException, IOException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StaticQueryContext getUnderlyingStaticContext() {
        return this.env;
    }

    public void setErrorList(List<StaticError> errorList) {
        this.env.setErrorListener(new ErrorGatherer(errorList));
    }
}

