/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

public final class EExplicit
extends AExpression {
    private final String type;
    private AExpression child;

    public EExplicit(Location location, String type, AExpression child) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.child = Objects.requireNonNull(child);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.child.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.actual = locals.getPainlessLookup().canonicalTypeNameToType(this.type);
        if (this.actual == null) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        this.child.expected = this.actual;
        this.child.explicit = true;
        this.child.analyze(locals);
        this.child = this.child.cast(locals);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    AExpression cast(Locals locals) {
        this.child.expected = this.expected;
        this.child.explicit = this.explicit;
        this.child.internal = this.internal;
        return this.child.cast(locals);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type, this.child);
    }
}

