/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;

public final class ForEachProcessor
extends AbstractProcessor {
    public static final String TYPE = "foreach";
    private final String field;
    private final Processor processor;
    private final boolean ignoreMissing;

    ForEachProcessor(String tag, String field, Processor processor, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.processor = processor;
        this.ignoreMissing = ignoreMissing;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        List values = (List)ingestDocument.getFieldValue(this.field, List.class, this.ignoreMissing);
        if (values == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot loop over its elements.");
        }
        ArrayList newValues = new ArrayList(values.size());
        IngestDocument document = ingestDocument;
        for (Object value : values) {
            Object previousValue = ingestDocument.getIngestMetadata().put("_value", value);
            try {
                if ((document = this.processor.execute(document)) != null) continue;
                IngestDocument ingestDocument2 = null;
                return ingestDocument2;
            }
            finally {
                newValues.add(ingestDocument.getIngestMetadata().put("_value", previousValue));
            }
        }
        document.setFieldValue(this.field, newValues);
        return document;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    Processor getProcessor() {
        return this.processor;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public ForEachProcessor create(Map<String, Processor.Factory> factories, String tag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            Map processorConfig = ConfigurationUtils.readMap((String)ForEachProcessor.TYPE, (String)tag, config, (String)"processor");
            Set entries = processorConfig.entrySet();
            if (entries.size() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)ForEachProcessor.TYPE, (String)tag, (String)"processor", (String)"Must specify exactly one processor type");
            }
            Map.Entry entry = entries.iterator().next();
            Processor processor = ConfigurationUtils.readProcessor(factories, (ScriptService)this.scriptService, (String)((String)entry.getKey()), (Map)((Map)entry.getValue()));
            return new ForEachProcessor(tag, field, processor, ignoreMissing);
        }
    }
}

