#ifndef SPELLCHECKER_H
#define SPELLCHECKER_H

#include <qobject.h>
#include <qstringlist.h>
#include <qsyntaxhighlighter.h>
#include <qmap.h>

class QTimer;
class AspellSpeller;
class AspellConfig;
class HtmlDocument;
class ConfigFile;
class UinsList;
class QPopupMenu;
class Chat;
class CustomInput;
class QListBoxItem;

class SpellChecker : public QObject
{
    Q_OBJECT

    private:
        typedef QMap<QString, AspellSpeller*> Checkers;
        QTimer* myWakeupTimer;
        Checkers checkers; 
        AspellConfig* spellConfig;
        ConfigFile* config;
        QString beginMark;

        bool isTagMyOwn( HtmlDocument&, int );
        void updateChat( CustomInput* edit, QString text );

    public:
        SpellChecker();
        ~SpellChecker();
        QStringList notCheckedLanguages();
        QStringList checkedLanguages();
        bool addCheckedLang( QString& name ); 
        void removeCheckedLang( QString& name ); 
        void changeMarkColor( const QColor& );
        void buildMarkTag();
        bool buildCheckers();

    public slots:
        void chatCreated( const UinsList& );
        void cleanMessage( Chat* );
        void onCreateConfig();
        void onUpdateConfig();
        void onDestroyConfig();
        void configForward();
        void configBackward();
        void configForward2(QListBoxItem*);
        void configBackward2(QListBoxItem*);

    private slots:
        void executeChecking ();
};

extern SpellChecker* spellcheck;

#endif
