/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.util.List;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.session.Payload;

public class Results {
    private final TotalHits totalHits;
    private final List<?> results;
    private final boolean timedOut;
    private final TimeValue tookTime;
    private final Type type;

    public static Results fromPayload(Payload payload) {
        List values = payload.values();
        return new Results(new TotalHits((long)values.size(), TotalHits.Relation.EQUAL_TO), payload.timeTook(), false, values, payload.resultType());
    }

    Results(TotalHits totalHits, TimeValue tookTime, boolean timedOut, List<?> results, Type type) {
        this.totalHits = totalHits;
        this.tookTime = tookTime;
        this.timedOut = timedOut;
        this.results = results;
        this.type = type;
    }

    public TotalHits totalHits() {
        return this.totalHits;
    }

    public List<SearchHit> searchHits() {
        return this.type == Type.SEARCH_HIT ? this.results : null;
    }

    public List<EqlSearchResponse.Sequence> sequences() {
        return this.type == Type.SEQUENCE ? this.results : null;
    }

    public List<EqlSearchResponse.Count> counts() {
        return this.type == Type.COUNT ? this.results : null;
    }

    public TimeValue tookTime() {
        return this.tookTime;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public static enum Type {
        SEARCH_HIT,
        SEQUENCE,
        COUNT;

    }
}

