/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.eql.analysis.Analyzer;
import org.elasticsearch.xpack.eql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.eql.analysis.Verifier;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.optimizer.Optimizer;
import org.elasticsearch.xpack.eql.parser.EqlParser;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.planner.Planner;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.Results;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class EqlSession {
    private final Client client;
    private final EqlConfiguration configuration;
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final Analyzer analyzer;
    private final Optimizer optimizer;
    private final Planner planner;

    public EqlSession(Client client, EqlConfiguration cfg, IndexResolver indexResolver, PreAnalyzer preAnalyzer, FunctionRegistry functionRegistry, Verifier verifier, Optimizer optimizer, Planner planner, PlanExecutor planExecutor) {
        this.client = new ParentTaskAssigningClient(client, cfg.getTaskId());
        this.configuration = cfg;
        this.indexResolver = indexResolver;
        this.preAnalyzer = preAnalyzer;
        this.analyzer = new Analyzer(cfg, functionRegistry, verifier);
        this.optimizer = optimizer;
        this.planner = planner;
    }

    public Client client() {
        return this.client;
    }

    public Optimizer optimizer() {
        return this.optimizer;
    }

    public EqlConfiguration configuration() {
        return this.configuration;
    }

    public void eql(String eql, ParserParams params, ActionListener<Results> listener) {
        this.eqlExecutable(eql, params, (ActionListener<PhysicalPlan>)ActionListener.wrap(e -> e.execute(this, ActionListeners.map((ActionListener)listener, Results::fromPayload)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void eqlExecutable(String eql, ParserParams params, ActionListener<PhysicalPlan> listener) {
        try {
            this.physicalPlan(this.doParse(eql, params), listener);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public void physicalPlan(LogicalPlan optimized, ActionListener<PhysicalPlan> listener) {
        this.optimizedPlan(optimized, (ActionListener<LogicalPlan>)ActionListeners.map(listener, this.planner::plan));
    }

    public void optimizedPlan(LogicalPlan verified, ActionListener<LogicalPlan> listener) {
        this.analyzedPlan(verified, (ActionListener<LogicalPlan>)ActionListeners.map(listener, this.optimizer::optimize));
    }

    public void analyzedPlan(LogicalPlan parsed, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, (ActionListener<LogicalPlan>)ActionListeners.map(listener, p -> this.analyzer.analyze((LogicalPlan)p)));
    }

    private <T> void preAnalyze(LogicalPlan parsed, ActionListener<LogicalPlan> listener) {
        String indexWildcard = this.configuration.indexAsWildcard();
        if (this.configuration.isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("cancelled"));
            return;
        }
        this.indexResolver.resolveAsMergedMapping(indexWildcard, null, this.configuration.includeFrozen(), this.configuration.filter(), ActionListeners.map(listener, r -> this.preAnalyzer.preAnalyze(parsed, (IndexResolution)r)));
    }

    private LogicalPlan doParse(String eql, ParserParams params) {
        return new EqlParser().createStatement(eql, params);
    }
}

