/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.session;

import java.time.ZoneId;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.ql.session.Configuration;

public class EqlConfiguration
extends Configuration {
    private final String[] indices;
    private final TimeValue requestTimeout;
    private final String clientId;
    private final boolean includeFrozenIndices;
    private final TaskId taskId;
    private final EqlSearchTask task;
    private final boolean isCaseSensitive;
    @Nullable
    private final QueryBuilder filter;

    public EqlConfiguration(String[] indices, ZoneId zi, String username, String clusterName, QueryBuilder filter, TimeValue requestTimeout, boolean includeFrozen, boolean isCaseSensitive, String clientId, TaskId taskId, EqlSearchTask task) {
        super(zi, username, clusterName);
        this.indices = indices;
        this.filter = filter;
        this.requestTimeout = requestTimeout;
        this.clientId = clientId;
        this.includeFrozenIndices = includeFrozen;
        this.isCaseSensitive = isCaseSensitive;
        this.taskId = taskId;
        this.task = task;
    }

    public String[] indices() {
        return this.indices;
    }

    public String indexAsWildcard() {
        return Strings.arrayToCommaDelimitedString((Object[])this.indices);
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public String clientId() {
        return this.clientId;
    }

    public boolean includeFrozen() {
        return this.includeFrozenIndices;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public TaskId getTaskId() {
        return this.taskId;
    }
}

