/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncResultsService;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.eql.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.eql.async.StoredAsyncResponse;

public class TransportEqlAsyncGetResultAction
extends HandledTransportAction<GetAsyncResultRequest, EqlSearchResponse> {
    private final AsyncResultsService<EqlSearchTask, StoredAsyncResponse<EqlSearchResponse>> resultsService;
    private final TransportService transportService;

    @Inject
    public TransportEqlAsyncGetResultAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool) {
        super("indices:data/read/eql/async/get", transportService, actionFilters, GetAsyncResultRequest::new);
        this.transportService = transportService;
        this.resultsService = TransportEqlAsyncGetResultAction.createResultsService(transportService, clusterService, registry, client, threadPool);
    }

    static AsyncResultsService<EqlSearchTask, StoredAsyncResponse<EqlSearchResponse>> createResultsService(TransportService transportService, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool) {
        Writeable.Reader reader = in -> new StoredAsyncResponse(EqlSearchResponse::new, in);
        AsyncTaskIndexService store = new AsyncTaskIndexService(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", reader, registry);
        return new AsyncResultsService(store, true, EqlSearchTask.class, (task, listener, timeout) -> AsyncTaskManagementService.addCompletionListener(threadPool, task, listener, timeout), transportService.getTaskManager(), clusterService);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doExecute(Task task, GetAsyncResultRequest request, ActionListener<EqlSearchResponse> listener) {
        DiscoveryNode node = this.resultsService.getNode(request.getId());
        if (node != null && !this.resultsService.isLocalNode(node)) {
            TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
            this.transportService.sendRequest(node, "indices:data/read/eql/async/get", (TransportRequest)request, builder.build(), (TransportResponseHandler)new ActionListenerResponseHandler(listener, EqlSearchResponse::new, "same"));
            return;
        }
        this.resultsService.retrieveResult(request, ActionListener.wrap(r -> {
            if (r.getException() != null) {
                listener.onFailure(r.getException());
            } else {
                listener.onResponse((Object)((EqlSearchResponse)((Object)((Object)r.getResponse()))));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

