/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.action.EqlSearchRequest;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;

public class RestEqlSearchAction
extends BaseRestHandler {
    private static final String SEARCH_PATH = "/{index}/_eql/search";

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, SEARCH_PATH), new RestHandler.Route(RestRequest.Method.POST, SEARCH_PATH)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        EqlSearchRequest eqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            eqlRequest = EqlSearchRequest.fromXContent(parser);
            eqlRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
            eqlRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)eqlRequest.indicesOptions()));
            if (request.hasParam("wait_for_completion_timeout")) {
                eqlRequest.waitForCompletionTimeout(request.paramAsTime("wait_for_completion_timeout", eqlRequest.waitForCompletionTimeout()));
            }
            if (request.hasParam("keep_alive")) {
                eqlRequest.keepAlive(request.paramAsTime("keep_alive", eqlRequest.keepAlive()));
            }
            eqlRequest.keepOnCompletion(request.paramAsBoolean("keep_on_completion", eqlRequest.keepOnCompletion()));
        }
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)EqlSearchAction.INSTANCE, (ActionRequest)eqlRequest, (ActionListener)new RestResponseListener<EqlSearchResponse>(channel){

                public RestResponse buildResponse(EqlSearchResponse response) throws Exception {
                    XContentBuilder builder = this.channel.newBuilder(request.getXContentType(), XContentType.JSON, true);
                    response.toXContent(builder, (ToXContent.Params)request);
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
        };
    }

    public String getName() {
        return "eql_search";
    }
}

