/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.eql.EqlFeatureSet;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.plugin.EqlAsyncGetResultAction;
import org.elasticsearch.xpack.eql.plugin.EqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlDeleteAsyncResultAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlGetAsyncResultAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlSearchAction;
import org.elasticsearch.xpack.eql.plugin.RestEqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlAsyncGetResultAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlSearchAction;
import org.elasticsearch.xpack.eql.plugin.TransportEqlStatsAction;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.type.DefaultDataTypeRegistry;

public class EqlPlugin
extends Plugin
implements ActionPlugin {
    private final boolean enabled;
    public static final Setting<Boolean> EQL_ENABLED_SETTING = Setting.boolSetting((String)"xpack.eql.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public EqlPlugin(Settings settings) {
        this.enabled = (Boolean)EQL_ENABLED_SETTING.get(settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return this.createComponents(client, clusterService.getClusterName().value(), namedWriteableRegistry);
    }

    private Collection<Object> createComponents(Client client, String clusterName, NamedWriteableRegistry namedWriteableRegistry) {
        IndexResolver indexResolver = new IndexResolver(client, clusterName, DefaultDataTypeRegistry.INSTANCE);
        PlanExecutor planExecutor = new PlanExecutor(client, indexResolver, namedWriteableRegistry);
        return Arrays.asList(planExecutor);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, EqlFeatureSet.class));
        return modules;
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(EQL_ENABLED_SETTING);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (this.enabled) {
            return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)EqlSearchAction.INSTANCE, TransportEqlSearchAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EqlStatsAction.INSTANCE, TransportEqlStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EqlAsyncGetResultAction.INSTANCE, TransportEqlAsyncGetResultAction.class, new Class[0]));
        }
        return Collections.emptyList();
    }

    boolean isSnapshot() {
        return Build.CURRENT.isSnapshot();
    }

    public static boolean isEnabled(Settings settings) {
        return (Boolean)EQL_ENABLED_SETTING.get(settings);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (this.enabled) {
            return Arrays.asList(new RestHandler[]{new RestEqlSearchAction(), new RestEqlStatsAction(), new RestEqlGetAsyncResultAction(), new RestEqlDeleteAsyncResultAction()});
        }
        return Collections.emptyList();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }
}

