/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.eql.parser.EqlBaseBaseVisitor;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;

abstract class AbstractBuilder
extends EqlBaseBaseVisitor<Object> {
    private static final Pattern slashPattern = Pattern.compile("\\\\.");

    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        Object result = super.visit(tree);
        Check.notNull((Object)result, (String)"Don't know how to handle context [{}] with value [{}]", (Object[])new Object[]{tree.getClass(), tree.getText()});
        return result;
    }

    protected <T> T typedParsing(ParseTree ctx, Class<T> type) {
        Object result = ctx.accept((ParseTreeVisitor)this);
        if (type.isInstance(result)) {
            return (T)result;
        }
        throw new ParsingException(AbstractBuilder.source(ctx), "Invalid query '{}'[{}] given; expected {} but found {}", ctx.getText(), ctx.getClass().getSimpleName(), type.getSimpleName(), result != null ? result.getClass().getSimpleName() : "null");
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return this.typedParsing(ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return this.visitList(ctxs, LogicalPlan.class);
    }

    protected <T> List<T> visitList(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>(contexts.size());
        for (ParserRuleContext parserRuleContext : contexts) {
            results.add(clazz.cast(this.visit((ParseTree)parserRuleContext)));
        }
        return results;
    }

    static Source source(ParseTree ctx) {
        if (ctx instanceof ParserRuleContext) {
            return AbstractBuilder.source((ParserRuleContext)ctx);
        }
        return Source.EMPTY;
    }

    static Source source(TerminalNode terminalNode) {
        Check.notNull((Object)terminalNode, (String)"terminalNode is null");
        return AbstractBuilder.source(terminalNode.getSymbol());
    }

    static Source source(ParserRuleContext parserRuleContext) {
        Check.notNull((Object)parserRuleContext, (String)"parserRuleContext is null");
        Token start = parserRuleContext.start;
        Token stop = parserRuleContext.stop != null ? parserRuleContext.stop : start;
        Interval interval = new Interval(start.getStartIndex(), stop.getStopIndex());
        String text = start.getInputStream().getText(interval);
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static Source source(Token token) {
        Check.notNull((Object)token, (String)"token is null");
        String text = token.getInputStream().getText(new Interval(token.getStartIndex(), token.getStopIndex()));
        return new Source(new Location(token.getLine(), token.getCharPositionInLine()), text);
    }

    Source source(ParserRuleContext begin, ParserRuleContext end) {
        Check.notNull((Object)begin, (String)"begin is null");
        Check.notNull((Object)end, (String)"end is null");
        Token start = begin.start;
        Token stop = end.stop != null ? end.stop : begin.stop;
        Interval interval = new Interval(start.getStartIndex(), stop.getStopIndex());
        String text = start.getInputStream().getText(interval);
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static Source source(TerminalNode begin, ParserRuleContext end) {
        Check.notNull((Object)begin, (String)"begin is null");
        Check.notNull((Object)end, (String)"end is null");
        Token start = begin.getSymbol();
        Token stop = end.stop != null ? end.stop : start;
        String text = start.getInputStream().getText(new Interval(start.getStartIndex(), stop.getStopIndex()));
        return new Source(new Location(start.getLine(), start.getCharPositionInLine()), text);
    }

    static String text(ParseTree node) {
        return node == null ? null : node.getText();
    }

    public static String unquoteString(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("?")) {
            return text.substring(2, text.length() - 1);
        }
        text = text.substring(1, text.length() - 1);
        StringBuffer resultString = new StringBuffer();
        Matcher regexMatcher = slashPattern.matcher(text);
        while (regexMatcher.find()) {
            String replacement;
            String source;
            switch (source = regexMatcher.group()) {
                case "\\t": {
                    replacement = "\t";
                    break;
                }
                case "\\b": {
                    replacement = "\b";
                    break;
                }
                case "\\f": {
                    replacement = "\f";
                    break;
                }
                case "\\n": {
                    replacement = "\n";
                    break;
                }
                case "\\r": {
                    replacement = "\r";
                    break;
                }
                case "\\\"": {
                    replacement = "\"";
                    break;
                }
                case "\\'": {
                    replacement = "'";
                    break;
                }
                case "\\\\": {
                    replacement = "\\\\";
                    break;
                }
                default: {
                    replacement = source;
                }
            }
            regexMatcher.appendReplacement(resultString, replacement);
        }
        regexMatcher.appendTail(resultString);
        return resultString.toString();
    }

    public Object visitTerminal(TerminalNode node) {
        Source source = AbstractBuilder.source(node);
        throw new ParsingException(source, "Does not know how to handle {}", source.text());
    }
}

