/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.plan.logical.Join;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.eql.plan.logical.LimitWithOffset;
import org.elasticsearch.xpack.eql.plan.physical.LocalRelation;
import org.elasticsearch.xpack.eql.session.Results;
import org.elasticsearch.xpack.eql.util.MathUtils;
import org.elasticsearch.xpack.eql.util.StringUtils;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Optimizer
extends RuleExecutor<LogicalPlan> {
    public LogicalPlan optimize(LogicalPlan verified) {
        return verified.optimized() ? verified : (LogicalPlan)this.execute((Node)verified);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch substitutions = new RuleExecutor.Batch((RuleExecutor)this, "Operator Replacement", RuleExecutor.Limiter.ONCE, new Rule[]{new OptimizerRules.ReplaceSurrogateFunction()});
        RuleExecutor.Batch operators = new RuleExecutor.Batch((RuleExecutor)this, "Operator Optimization", new Rule[]{new OptimizerRules.ConstantFolding(), new OptimizerRules.BooleanSimplification(), new OptimizerRules.BooleanLiteralsOnTheRight(), new OptimizerRules.BooleanEqualsSimplification(), new ReplaceWildcards(), new ReplaceNullChecks(), new OptimizerRules.PropagateEquals(), new OptimizerRules.CombineBinaryComparisons(), new PruneFilters(), new OptimizerRules.PruneLiteralsInOrderBy(), new CombineLimits()});
        RuleExecutor.Batch ordering = new RuleExecutor.Batch((RuleExecutor)this, "Implicit Order", new Rule[]{new SortByLimit(), new PushDownOrderBy()});
        RuleExecutor.Batch local = new RuleExecutor.Batch((RuleExecutor)this, "Skip Elasticsearch", new Rule[]{new SkipEmptyFilter(), new SkipEmptyJoin(), new SkipQueryOnLimitZero()});
        RuleExecutor.Batch label = new RuleExecutor.Batch((RuleExecutor)this, "Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{new OptimizerRules.SetAsOptimized()});
        return Arrays.asList(substitutions, operators, ordering, local, label);
    }

    private static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), plan.output());
    }

    private static class ReplaceWildcards
    extends OptimizerRules.OptimizerRule<Filter> {
        private ReplaceWildcards() {
        }

        private static boolean isWildcard(Expression expr) {
            if (expr.foldable()) {
                Object value = expr.fold();
                return value instanceof String && value.toString().contains("*");
            }
            return false;
        }

        protected LogicalPlan rule(Filter filter) {
            return (LogicalPlan)filter.transformExpressionsUp(e -> {
                BinaryComparison cmp;
                if ((e instanceof Equals || e instanceof NotEquals) && ReplaceWildcards.isWildcard((cmp = (BinaryComparison)e).right())) {
                    String wcString = cmp.right().fold().toString();
                    Like like = new Like(e.source(), cmp.left(), StringUtils.toLikePattern(wcString));
                    if (e instanceof NotEquals) {
                        like = new Not(e.source(), (Expression)like);
                    }
                    e = like;
                }
                return e;
            });
        }
    }

    private static class ReplaceNullChecks
    extends OptimizerRules.OptimizerRule<Filter> {
        private ReplaceNullChecks() {
        }

        protected LogicalPlan rule(Filter filter) {
            return (LogicalPlan)filter.transformExpressionsUp(e -> {
                BinaryComparison cmp;
                if ((e instanceof Equals || e instanceof NotEquals) && (cmp = (BinaryComparison)e).right().foldable() && cmp.right().fold() == null) {
                    e = e instanceof Equals ? new IsNull(e.source(), cmp.left()) : new IsNotNull(e.source(), cmp.left());
                }
                return e;
            });
        }
    }

    static class PruneFilters
    extends OptimizerRules.PruneFilters {
        PruneFilters() {
        }

        protected LogicalPlan skipPlan(Filter filter) {
            return Optimizer.skipPlan((UnaryPlan)filter);
        }
    }

    static final class CombineLimits
    extends OptimizerRules.OptimizerRule<LimitWithOffset> {
        CombineLimits() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(LimitWithOffset limit) {
            if (!(limit.child() instanceof LimitWithOffset)) {
                return limit;
            }
            LimitWithOffset primary = (LimitWithOffset)limit.child();
            int primaryLimit = (Integer)primary.limit().fold();
            int primaryOffset = primary.offset();
            int sign = Integer.signum(primaryLimit);
            int secondaryLimit = (Integer)limit.limit().fold();
            if (limit.offset() != 0) {
                throw new EqlIllegalArgumentException("Limits with different offset not implemented yet");
            }
            if (primaryLimit > 0 && secondaryLimit > 0) {
                primaryLimit = Math.min(primaryLimit, secondaryLimit);
            } else if (primaryLimit < 0 && secondaryLimit < 0) {
                primaryLimit = Math.max(primaryLimit, secondaryLimit);
            } else if (MathUtils.abs(secondaryLimit) < MathUtils.abs(primaryLimit)) {
                primaryOffset += MathUtils.abs(primaryLimit + secondaryLimit);
                primaryLimit = MathUtils.abs(secondaryLimit) * sign;
            }
            Literal literal = new Literal(primary.limit().source(), (Object)primaryLimit, DataTypes.INTEGER);
            return new LimitWithOffset(primary.source(), (Expression)literal, primaryOffset, primary.child());
        }
    }

    static final class SortByLimit
    extends OptimizerRules.OptimizerRule<LimitWithOffset> {
        SortByLimit() {
        }

        protected LogicalPlan rule(LimitWithOffset limit) {
            OrderBy ob;
            LogicalPlan child;
            if (limit.limit().foldable() && (child = limit.child()) instanceof OrderBy && PushDownOrderBy.isDefaultOrderBy(ob = (OrderBy)child)) {
                int l = (Integer)limit.limit().fold();
                Order.OrderDirection direction = Integer.signum(l) > 0 ? Order.OrderDirection.ASC : Order.OrderDirection.DESC;
                ob = new OrderBy(ob.source(), ob.child(), PushDownOrderBy.changeOrderDirection(ob.order(), direction));
                limit = new LimitWithOffset(limit.source(), limit.limit(), limit.offset(), (LogicalPlan)ob);
            }
            return limit;
        }
    }

    static final class PushDownOrderBy
    extends OptimizerRules.OptimizerRule<OrderBy> {
        PushDownOrderBy() {
        }

        protected LogicalPlan rule(OrderBy orderBy) {
            LogicalPlan child;
            Object plan = orderBy;
            if (PushDownOrderBy.isDefaultOrderBy(orderBy) && (child = orderBy.child()) instanceof Join) {
                Join join = (Join)child;
                List<KeyedFilter> queries = join.queries();
                List ascendingOrders = PushDownOrderBy.changeOrderDirection(orderBy.order(), Order.OrderDirection.ASC);
                ArrayList<KeyedFilter> orderedQueries = new ArrayList<KeyedFilter>(queries.size());
                boolean baseFilter = true;
                for (KeyedFilter filter : queries) {
                    List pushedOrder = baseFilter ? orderBy.order() : ascendingOrders;
                    OrderBy order = new OrderBy(filter.source(), filter.child(), pushedOrder);
                    orderedQueries.add((KeyedFilter)filter.replaceChildren(Collections.singletonList(order)));
                    baseFilter = false;
                }
                KeyedFilter until = join.until();
                OrderBy order = new OrderBy(until.source(), until.child(), ascendingOrders);
                until = (KeyedFilter)until.replaceChildren(Collections.singletonList(order));
                Order.OrderDirection direction = ((Order)orderBy.order().get(0)).direction();
                plan = join.with(orderedQueries, until, direction);
            }
            return plan;
        }

        private static boolean isDefaultOrderBy(OrderBy orderBy) {
            LogicalPlan child = orderBy.child();
            return child instanceof Project || child instanceof Join;
        }

        private static List<Order> changeOrderDirection(List<Order> orders, Order.OrderDirection direction) {
            ArrayList<Order> changed = new ArrayList<Order>(orders.size());
            boolean hasChanged = false;
            for (Order order : orders) {
                if (order.direction() != direction) {
                    order = new Order(order.source(), order.child(), direction, direction == Order.OrderDirection.ASC ? Order.NullsPosition.FIRST : Order.NullsPosition.LAST);
                    hasChanged = true;
                }
                changed.add(order);
            }
            return hasChanged ? changed : orders;
        }
    }

    static class SkipEmptyFilter
    extends OptimizerRules.OptimizerRule<UnaryPlan> {
        SkipEmptyFilter() {
            super(OptimizerRules.TransformDirection.UP);
        }

        protected LogicalPlan rule(UnaryPlan plan) {
            if (!(plan instanceof KeyedFilter) && plan.child() instanceof LocalRelation) {
                return new LocalRelation(plan.source(), plan.output(), Results.Type.SEARCH_HIT);
            }
            return plan;
        }
    }

    static class SkipEmptyJoin
    extends OptimizerRules.OptimizerRule<Join> {
        SkipEmptyJoin() {
        }

        protected LogicalPlan rule(Join plan) {
            for (KeyedFilter filter : plan.queries()) {
                if (!filter.anyMatch(LocalRelation.class::isInstance)) continue;
                return new LocalRelation(plan.source(), plan.output(), Results.Type.SEQUENCE);
            }
            return plan;
        }
    }

    static class SkipQueryOnLimitZero
    extends OptimizerRules.SkipQueryOnLimitZero {
        SkipQueryOnLimitZero() {
        }

        protected LogicalPlan skipPlan(Limit limit) {
            return Optimizer.skipPlan((UnaryPlan)limit);
        }
    }
}

