/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ToStringFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.ToStringFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToString
extends ScalarFunction {
    private final Expression value;

    public ToString(Source source, Expression src) {
        super(source, Collections.singletonList(src));
        this.value = src;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isExact((Expression)this.value, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.DEFAULT);
    }

    protected Pipe makePipe() {
        return new ToStringFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.value));
    }

    public boolean foldable() {
        return this.value.foldable();
    }

    public Object fold() {
        return ToStringFunctionProcessor.doProcess(this.value.fold());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToString::new, (Object)this.value);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate sourceScript = this.asScript(this.value);
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s)"), "string", sourceScript.template()), ParamsBuilder.paramsBuilder().script(sourceScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] children but received [" + newChildren.size() + "]");
        }
        return new ToString(this.source(), newChildren.get(0));
    }
}

