/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringContainsFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringContainsFunctionProcessor;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseSensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class StringContains
extends CaseSensitiveScalarFunction {
    private final Expression string;
    private final Expression substring;

    public StringContains(Source source, Expression string, Expression substring, Configuration configuration) {
        super(source, Arrays.asList(string, substring), configuration);
        this.string = string;
        this.substring = substring;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.string, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isStringAndExact((Expression)this.substring, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
    }

    public Expression string() {
        return this.string;
    }

    public Expression substring() {
        return this.substring;
    }

    protected Pipe makePipe() {
        return new StringContainsFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.string), Expressions.pipe((Expression)this.substring), this.isCaseSensitive());
    }

    public boolean foldable() {
        return this.string.foldable() && this.substring.foldable();
    }

    public Object fold() {
        return StringContainsFunctionProcessor.doProcess(this.string.fold(), this.substring.fold(), this.isCaseSensitive());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StringContains::new, (Object)this.string, (Object)this.substring, (Object)((Object)this.eqlConfiguration()));
    }

    public ScriptTemplate asScript() {
        return this.asScriptFrom(this.asScript(this.string), this.asScript(this.substring));
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate stringScript, ScriptTemplate substringScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s,%s)"), "stringContains", stringScript.template(), substringScript.template(), "{}"), ParamsBuilder.paramsBuilder().script(stringScript.params()).script(substringScript.params()).variable((Object)this.isCaseSensitive()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new StringContains(this.source(), newChildren.get(0), newChildren.get(1), this.eqlConfiguration());
    }

    public EqlConfiguration eqlConfiguration() {
        return (EqlConfiguration)this.configuration();
    }

    public boolean isCaseSensitive() {
        return this.eqlConfiguration().isCaseSensitive();
    }
}

