/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.IndexOfFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.IndexOfFunctionProcessor;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.string.CaseSensitiveScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class IndexOf
extends CaseSensitiveScalarFunction
implements OptionalArgument {
    private final Expression input;
    private final Expression substring;
    private final Expression start;

    public IndexOf(Source source, Expression input, Expression substring, Expression start, Configuration configuration) {
        super(source, Arrays.asList(input, substring, start != null ? start : new Literal(source, null, DataTypes.NULL)), configuration);
        this.input = input;
        this.substring = substring;
        this.start = (Expression)this.arguments().get(2);
    }

    public boolean isCaseSensitive() {
        return ((EqlConfiguration)this.configuration()).isCaseSensitive();
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isStringAndExact((Expression)this.substring, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isInteger((Expression)this.start, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.THIRD);
    }

    protected Pipe makePipe() {
        return new IndexOfFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.substring), Expressions.pipe((Expression)this.start), this.isCaseSensitive());
    }

    public boolean foldable() {
        return this.input.foldable() && this.substring.foldable() && this.start.foldable();
    }

    public Object fold() {
        return IndexOfFunctionProcessor.doProcess(this.input.fold(), this.substring.fold(), this.start.fold(), this.isCaseSensitive());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, IndexOf::new, (Object)this.input, (Object)this.substring, (Object)this.start, (Object)this.configuration());
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate substringScript = this.asScript(this.substring);
        ScriptTemplate startScript = this.asScript(this.start);
        return this.asScriptFrom(inputScript, substringScript, startScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate substringScript, ScriptTemplate startScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s,%s,%s)"), "indexOf", inputScript.template(), substringScript.template(), startScript.template(), "{}"), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(substringScript.params()).script(startScript.params()).variable((Object)this.isCaseSensitive()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.INTEGER;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new IndexOf(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), this.configuration());
    }
}

