/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class ToNumberFunctionProcessor
implements Processor {
    public static final String NAME = "num";
    private final Processor value;
    private final Processor base;

    public ToNumberFunctionProcessor(Processor value, Processor base) {
        this.value = value;
        this.base = base;
    }

    public ToNumberFunctionProcessor(StreamInput in) throws IOException {
        this.value = (Processor)in.readNamedWriteable(Processor.class);
        this.base = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.value);
        out.writeNamedWriteable((NamedWriteable)this.base);
    }

    public Object process(Object input) {
        return ToNumberFunctionProcessor.doProcess(this.value.process(input), this.base.process(input));
    }

    private static Number parseDecimal(String source) {
        try {
            return Long.valueOf(source);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(source);
        }
    }

    public static Object doProcess(Object value, Object base) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String) && !(value instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", value);
        }
        boolean detectedHexPrefix = value.toString().startsWith("0x");
        if (base == null) {
            base = detectedHexPrefix ? 16 : 10;
        } else if (!(base instanceof Integer)) {
            throw new EqlIllegalArgumentException("An integer base is required; received [{}]", base);
        }
        int radix = (Integer)base;
        if (detectedHexPrefix && radix == 16) {
            value = value.toString().substring(2);
        }
        try {
            if (radix == 10) {
                return ToNumberFunctionProcessor.parseDecimal(value.toString());
            }
            return Long.parseLong(value.toString(), radix);
        }
        catch (NumberFormatException e) {
            throw new EqlIllegalArgumentException("Unable to convert [{}] to number of base [{}]", value, radix);
        }
    }

    protected Processor value() {
        return this.value;
    }

    protected Processor base() {
        return this.base;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ToNumberFunctionProcessor other = (ToNumberFunctionProcessor)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.base(), other.base());
    }

    public int hashCode() {
        return Objects.hash(this.value, this.base);
    }

    public String getWriteableName() {
        return NAME;
    }
}

