/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.math.ToNumberFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class ToNumberFunctionPipe
extends Pipe {
    private final Pipe value;
    private final Pipe base;

    public ToNumberFunctionPipe(Source source, Expression expression, Pipe value, Pipe base) {
        super(source, expression, Arrays.asList(value, base));
        this.value = value;
        this.base = base;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newValue = this.value.resolveAttributes(resolver);
        Pipe newBase = this.base.resolveAttributes(resolver);
        if (newValue == this.value && newBase == this.base) {
            return this;
        }
        return this.replaceChildren(newValue, newBase);
    }

    public boolean supportedByAggsOnlyQuery() {
        return this.value.supportedByAggsOnlyQuery() && this.base.supportedByAggsOnlyQuery();
    }

    public boolean resolved() {
        return this.value.resolved() && this.base.resolved();
    }

    protected ToNumberFunctionPipe replaceChildren(Pipe newValue, Pipe newBase) {
        return new ToNumberFunctionPipe(this.source(), this.expression(), newValue, newBase);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.value.collectFields(sourceBuilder);
        this.base.collectFields(sourceBuilder);
    }

    protected NodeInfo<ToNumberFunctionPipe> info() {
        return NodeInfo.create((Node)this, ToNumberFunctionPipe::new, (Object)this.expression(), (Object)this.value, (Object)this.base);
    }

    public ToNumberFunctionProcessor asProcessor() {
        return new ToNumberFunctionProcessor(this.value.asProcessor(), this.base.asProcessor());
    }

    public Pipe value() {
        return this.value;
    }

    public Pipe base() {
        return this.base;
    }

    public int hashCode() {
        return Objects.hash(this.value(), this.base());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ToNumberFunctionPipe other = (ToNumberFunctionPipe)((Object)obj);
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.base(), other.base());
    }
}

