/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.execution.payload.AbstractPayload;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.session.Results;

class SequencePayload
extends AbstractPayload {
    private final List<EqlSearchResponse.Sequence> values;

    SequencePayload(List<Sequence> sequences, List<List<SearchHit>> searchHits, boolean timedOut, TimeValue timeTook) {
        super(timedOut, timeTook);
        this.values = new ArrayList<EqlSearchResponse.Sequence>(sequences.size());
        for (int i = 0; i < sequences.size(); ++i) {
            Sequence s = sequences.get(i);
            List<SearchHit> hits = searchHits.get(i);
            this.values.add(new EqlSearchResponse.Sequence(s.key().asList(), hits));
        }
    }

    @Override
    public Results.Type resultType() {
        return Results.Type.SEQUENCE;
    }

    @Override
    public <V> List<V> values() {
        return this.values;
    }
}

