/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyToSequences;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceGroup;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.StageToKeys;
import org.elasticsearch.xpack.eql.execution.sequence.UntilGroup;

public class SequenceMatcher {
    private final Logger log = LogManager.getLogger(SequenceMatcher.class);
    private final KeyToSequences keyToSequences;
    private final StageToKeys stageToKeys;
    private final int numberOfStages;
    private final int completionStage;
    private final List<Sequence> completed;
    private int completedInsertPosition = 0;
    private final long maxSpanInMillis;
    private final boolean descending;
    private Limit limit;
    private boolean headLimit = false;
    private final Stats stats = new Stats();

    public SequenceMatcher(int stages, boolean descending, TimeValue maxSpan, Limit limit) {
        this.numberOfStages = stages;
        this.completionStage = stages - 1;
        this.descending = descending;
        this.stageToKeys = new StageToKeys(this.completionStage);
        this.keyToSequences = new KeyToSequences(this.completionStage);
        this.completed = new LinkedList<Sequence>();
        this.maxSpanInMillis = maxSpan.millis();
        this.limit = limit;
    }

    private void trackSequence(Sequence sequence) {
        SequenceKey key = sequence.key();
        this.stageToKeys.add(0, key);
        this.keyToSequences.add(0, sequence);
        ++this.stats.seen;
    }

    boolean match(int stage, Iterable<Tuple<KeyAndOrdinal, HitReference>> hits) {
        for (Tuple<KeyAndOrdinal, HitReference> tuple : hits) {
            KeyAndOrdinal ko = (KeyAndOrdinal)tuple.v1();
            HitReference hit = (HitReference)tuple.v2();
            if (stage == 0) {
                Sequence seq = new Sequence(ko.key, this.numberOfStages, ko.ordinal, hit);
                this.trackSequence(seq);
                continue;
            }
            this.match(stage, ko.key, ko.ordinal, hit);
            if (!this.headLimit) continue;
            this.log.trace("(Head) Limit reached {}", (Object)this.stats);
            return false;
        }
        if (this.tailLimitReached()) {
            this.log.trace("(Tail) Limit reached {}", (Object)this.stats);
            return false;
        }
        this.log.trace("{}", (Object)this.stats);
        return true;
    }

    private boolean tailLimitReached() {
        return this.limit != null && this.limit.limit() < 0 && this.limit.absLimit() <= this.completed.size();
    }

    private void match(int stage, SequenceKey key, Ordinal ordinal, HitReference hit) {
        KeyAndOrdinal nearestUntil;
        ++this.stats.seen;
        int previousStage = stage - 1;
        SequenceGroup group = this.keyToSequences.groupIfPresent(previousStage, key);
        if (group == null || group.isEmpty()) {
            ++this.stats.ignored;
            return;
        }
        Sequence sequence = (Sequence)group.trimBefore(ordinal);
        if (sequence == null) {
            ++this.stats.ignored;
            return;
        }
        if (group.isEmpty()) {
            this.keyToSequences.remove(previousStage, group);
            this.stageToKeys.remove(previousStage, key);
        }
        if (this.maxSpanInMillis > 0L && ordinal.timestamp() - sequence.startOrdinal().timestamp() > this.maxSpanInMillis) {
            ++this.stats.rejectionMaxspan;
            return;
        }
        UntilGroup until = this.keyToSequences.untilIfPresent(key);
        if (until != null && (nearestUntil = (KeyAndOrdinal)until.before(ordinal)) != null && nearestUntil.ordinal().between(sequence.ordinal(), ordinal)) {
            ++this.stats.rejectionUntil;
            return;
        }
        sequence.putMatch(stage, ordinal, hit);
        if (stage == this.completionStage) {
            if (this.descending) {
                for (Sequence seen : this.completed) {
                    if (!seen.key().equals(key) || !seen.ordinal().equals(ordinal)) continue;
                    return;
                }
            }
            this.completed.add(this.completedInsertPosition++, sequence);
            this.headLimit = this.limit != null && this.limit.limit() > 0 && this.completed.size() == this.limit.totalLimit();
        } else {
            if (this.descending && (group = this.keyToSequences.groupIfPresent(stage, key)) != null) {
                for (Ordinal previous : group) {
                    if (!previous.equals(ordinal)) continue;
                    return;
                }
            }
            this.stageToKeys.add(stage, key);
            this.keyToSequences.add(stage, sequence);
        }
    }

    boolean hasCandidates(int stage) {
        for (int i = stage; i < this.completionStage; ++i) {
            if (this.stageToKeys.isEmpty(i)) continue;
            return true;
        }
        return false;
    }

    List<Sequence> completed() {
        return this.limit != null ? this.limit.view(this.completed) : this.completed;
    }

    void dropUntil() {
        this.keyToSequences.dropUntil();
    }

    void until(Iterable<KeyAndOrdinal> markers) {
        this.keyToSequences.until(markers);
    }

    void resetInsertPosition() {
        if (this.descending) {
            this.keyToSequences.resetGroupInsertPosition();
            this.keyToSequences.resetUntilInsertPosition();
            this.completedInsertPosition = 0;
        }
    }

    public Stats stats() {
        return this.stats;
    }

    public void clear() {
        this.stats.clear();
        this.keyToSequences.clear();
        this.stageToKeys.clear();
        this.completed.clear();
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"Tracking [{}] keys with [{}] completed and in-flight {}", (Object[])new Object[]{this.keyToSequences, this.completed.size(), this.stageToKeys});
    }

    static class Stats {
        long seen = 0L;
        long ignored = 0L;
        long until = 0L;
        long rejectionMaxspan = 0L;
        long rejectionUntil = 0L;

        Stats() {
        }

        public String toString() {
            return LoggerMessageFormat.format(null, (String)"Stats: Seen [{}]/Ignored [{}]/Until [{}]/Rejected {Maxspan [{}]/Until [{}]}", (Object[])new Object[]{this.seen, this.ignored, this.until, this.rejectionMaxspan, this.rejectionUntil});
        }

        public void clear() {
            this.seen = 0L;
            this.ignored = 0L;
            this.until = 0L;
            this.rejectionMaxspan = 0L;
            this.rejectionUntil = 0L;
        }
    }
}

