/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.Match;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.ql.util.Check;

public class Sequence {
    private final SequenceKey key;
    private final int stages;
    private final Match[] matches;
    private int currentStage = 0;

    public Sequence(SequenceKey key, int stages, Ordinal ordinal, HitReference firstHit) {
        Check.isTrue((stages >= 2 ? 1 : 0) != 0, (String)"A sequence requires at least 2 criteria, given [{}]", (Object[])new Object[]{stages});
        this.key = key;
        this.stages = stages;
        this.matches = new Match[stages];
        this.matches[0] = new Match(ordinal, firstHit);
    }

    public int putMatch(int stage, Ordinal ordinal, HitReference hit) {
        if (stage == this.currentStage + 1) {
            int previousStage = this.currentStage;
            this.currentStage = stage;
            this.matches[this.currentStage] = new Match(ordinal, hit);
            return previousStage;
        }
        throw new EqlIllegalArgumentException("Incorrect stage [{}] specified for Sequence[key={}, stage={}]", stage, this.key, this.currentStage);
    }

    public SequenceKey key() {
        return this.key;
    }

    public Ordinal ordinal() {
        return this.matches[this.currentStage].ordinal();
    }

    public Ordinal startOrdinal() {
        return this.matches[0].ordinal();
    }

    public List<HitReference> hits() {
        ArrayList<HitReference> hits = new ArrayList<HitReference>(this.matches.length);
        for (Match m : this.matches) {
            hits.add(m.hit());
        }
        return hits;
    }

    public int hashCode() {
        return Objects.hash(this.currentStage, this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return Objects.equals(this.currentStage, other.currentStage) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        int numberOfDigits = this.stages > 100 ? 3 : (this.stages > 10 ? 2 : 1);
        NumberFormat nf = NumberFormat.getIntegerInstance(Locale.ROOT);
        nf.setMinimumIntegerDigits(numberOfDigits);
        StringBuilder sb = new StringBuilder();
        sb.append(LoggerMessageFormat.format(null, (String)"[Seq<{}>[{}/{}]]", (Object[])new Object[]{this.key, nf.format(this.currentStage), nf.format(this.stages - 1)}));
        for (int i = 0; i < this.matches.length; ++i) {
            sb.append(LoggerMessageFormat.format(null, (String)"\n [{}]={{}}", (Object[])new Object[]{nf.format(i), this.matches[i]}));
        }
        return sb.toString();
    }
}

