/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;

abstract class OrdinalGroup<E>
implements Iterable<Ordinal> {
    private final SequenceKey key;
    private final Function<E, Ordinal> extractor;
    private final List<E> elements = new LinkedList();
    private int insertPosition = 0;
    private int hashCode = 0;
    private Ordinal start;
    private Ordinal stop;

    protected OrdinalGroup(SequenceKey key, Function<E, Ordinal> extractor) {
        this.key = key;
        this.hashCode = key.hashCode();
        this.extractor = extractor;
    }

    SequenceKey key() {
        return this.key;
    }

    void add(E element) {
        this.hashCode = 31 * this.hashCode + Objects.hashCode(element);
        Ordinal ordinal = this.extractor.apply(element);
        if (this.start == null) {
            this.start = ordinal;
        } else if (this.stop == null) {
            this.stop = ordinal;
        } else {
            if (this.start.compareTo(ordinal) > 0) {
                this.start = ordinal;
            }
            if (this.stop.compareTo(ordinal) < 0) {
                this.stop = ordinal;
            }
        }
        this.elements.add(this.insertPosition++, element);
    }

    void resetInsertPosition() {
        this.insertPosition = 0;
    }

    E trimBefore(Ordinal ordinal) {
        Tuple<E, Integer> match = this.findBefore(ordinal);
        if (match != null) {
            int pos = (Integer)match.v2() + 1;
            this.elements.subList(0, pos).clear();
            this.insertPosition -= pos;
            if (this.insertPosition < 0) {
                this.insertPosition = 0;
            }
            if (!this.elements.isEmpty()) {
                this.start = this.extractor.apply(this.elements.get(0));
            } else {
                this.start = null;
                this.stop = null;
            }
        }
        return (E)(match != null ? match.v1() : null);
    }

    E before(Ordinal ordinal) {
        Tuple<E, Integer> match = this.findBefore(ordinal);
        return (E)(match != null ? match.v1() : null);
    }

    private Tuple<E, Integer> findBefore(Ordinal ordinal) {
        Object match = null;
        int matchPos = -1;
        int position = -1;
        for (E element : this.elements) {
            ++position;
            Ordinal o = this.extractor.apply(element);
            if (o.compareTo(ordinal) >= 0) break;
            match = element;
            matchPos = position;
        }
        return match != null ? new Tuple(match, (Object)matchPos) : null;
    }

    boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<Ordinal> iterator() {
        return new Iterator<Ordinal>(){
            final Iterator<E> iter;
            {
                this.iter = OrdinalGroup.this.elements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Ordinal next() {
                return (Ordinal)OrdinalGroup.this.extractor.apply(this.iter.next());
            }
        };
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrdinalGroup other = (OrdinalGroup)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.hashCode, other.hashCode);
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"[{}][{}-{}]({} seqs)", (Object[])new Object[]{this.key, this.start, this.stop, this.elements.size()});
    }
}

