/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.eql.execution.search.BasicListener;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class BasicQueryClient
implements QueryClient {
    private static final Logger log = RuntimeUtils.QUERY_LOG;
    private final EqlConfiguration cfg;
    private final Client client;
    private final String indices;

    public BasicQueryClient(EqlSession eqlSession) {
        this.cfg = eqlSession.configuration();
        this.client = eqlSession.client();
        this.indices = this.cfg.indexAsWildcard();
    }

    @Override
    public void query(QueryRequest request, ActionListener<Payload> listener) {
        SearchSourceBuilder searchSource = request.searchSource();
        searchSource.timeout(this.cfg.requestTimeout());
        if (log.isTraceEnabled()) {
            log.trace("About to execute query {} on {}", (Object)StringUtils.toString((SearchSourceBuilder)searchSource), (Object)this.indices);
        }
        if (this.cfg.isCancelled()) {
            throw new TaskCancelledException("cancelled");
        }
        SearchRequest search = RuntimeUtils.prepareRequest(this.client, searchSource, false, this.indices);
        this.client.search(search, (ActionListener)new BasicListener(listener));
    }

    @Override
    public void get(Iterable<List<HitReference>> refs, ActionListener<List<List<SearchHit>>> listener) {
        MultiGetRequestBuilder requestBuilder = this.client.prepareMultiGet();
        requestBuilder.setRealtime(false).setRefresh(false);
        int sz = 0;
        for (List<HitReference> list : refs) {
            sz = list.size();
            for (HitReference ref : list) {
                MultiGetRequest.Item item = new MultiGetRequest.Item(ref.index(), ref.id());
                item.fetchSourceContext(FetchSourceContext.FETCH_SOURCE);
                requestBuilder.add(item);
            }
        }
        int listSize = sz;
        this.client.multiGet((MultiGetRequest)requestBuilder.request(), ActionListener.wrap(r -> {
            ArrayList hits = new ArrayList(r.getResponses().length / listSize);
            ArrayList<SearchHit> sequence = new ArrayList<SearchHit>(listSize);
            int counter = 0;
            Text type = new Text("_doc");
            for (MultiGetItemResponse mgr : r.getResponses()) {
                if (mgr.isFailed()) {
                    listener.onFailure(mgr.getFailure().getFailure());
                    return;
                }
                GetResponse response = mgr.getResponse();
                SearchHit hit = new SearchHit(-1, response.getId(), type, null, null);
                hit.sourceRef(response.getSourceInternal());
                hit.shard(new SearchShardTarget(null, new ShardId(response.getIndex(), "", -1), null, null));
                hit.setSeqNo(response.getSeqNo());
                hit.setPrimaryTerm(response.getPrimaryTerm());
                hit.version(response.getVersion());
                sequence.add(hit);
                if (++counter != listSize) continue;
                counter = 0;
                hits.add(sequence);
                sequence = new ArrayList(listSize);
            }
            listener.onResponse(hits);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

