/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.payload.SearchResponsePayload;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.session.Payload;

public class BasicListener
implements ActionListener<SearchResponse> {
    private static final Logger log = RuntimeUtils.QUERY_LOG;
    private final ActionListener<Payload> listener;

    public BasicListener(ActionListener<Payload> listener) {
        this.listener = listener;
    }

    public void onResponse(SearchResponse response) {
        try {
            Object[] failures = response.getShardFailures();
            if (!CollectionUtils.isEmpty((Object[])failures)) {
                this.listener.onFailure((Exception)((Object)new EqlIllegalArgumentException(failures[0].reason(), failures[0].getCause())));
            } else {
                if (log.isTraceEnabled()) {
                    RuntimeUtils.logSearchResponse(response, log);
                }
                this.listener.onResponse((Object)new SearchResponsePayload(response));
            }
        }
        catch (Exception ex) {
            this.onFailure(ex);
        }
    }

    public void onFailure(Exception ex) {
        this.listener.onFailure(ex);
    }
}

