/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.payload;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.xpack.eql.execution.payload.AbstractPayload;
import org.elasticsearch.xpack.eql.session.Results;

public class SearchResponsePayload
extends AbstractPayload {
    private final List<SearchHit> hits;

    public SearchResponsePayload(SearchResponse response) {
        super(response.isTimedOut(), response.getTook());
        this.hits = Arrays.asList(response.getHits().getHits());
        SearchSortValues sortValues = new SearchSortValues(new Object[0], new DocValueFormat[0]);
        for (SearchHit hit : this.hits) {
            hit.sortValues(sortValues);
        }
    }

    @Override
    public Results.Type resultType() {
        return Results.Type.SEARCH_HIT;
    }

    @Override
    public <V> List<V> values() {
        return this.hits;
    }
}

