/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;

public class BoxedQueryRequest
implements QueryRequest {
    private final RangeQueryBuilder timestampRange;
    private final SearchSourceBuilder searchSource;
    private Ordinal from;
    private Ordinal to;
    private Ordinal after;

    public BoxedQueryRequest(QueryRequest original, String timestamp) {
        this.searchSource = original.searchSource();
        this.timestampRange = QueryBuilders.rangeQuery((String)timestamp).timeZone("UTC").format("epoch_millis");
        RuntimeUtils.addFilter((QueryBuilder)this.timestampRange, this.searchSource);
    }

    @Override
    public SearchSourceBuilder searchSource() {
        return this.searchSource;
    }

    @Override
    public void nextAfter(Ordinal ordinal) {
        this.after = ordinal;
        this.searchSource.searchAfter(ordinal.toArray());
    }

    public BoxedQueryRequest from(Ordinal begin) {
        this.from = begin;
        this.timestampRange.gte(begin != null ? Long.valueOf(begin.timestamp()) : null);
        return this;
    }

    public Ordinal after() {
        return this.after;
    }

    public Ordinal from() {
        return this.from;
    }

    public BoxedQueryRequest to(Ordinal end) {
        this.to = end;
        this.timestampRange.lte(end != null ? Long.valueOf(end.timestamp()) : null);
        return this;
    }

    public String toString() {
        return "( " + BoxedQueryRequest.string(this.from) + " >-" + BoxedQueryRequest.string(this.after) + "-> " + BoxedQueryRequest.string(this.to) + "]";
    }

    private static String string(Ordinal o) {
        return o != null ? o.toString() : "<none>";
    }
}

