/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.InstantiatingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;

public class EqlSearchResponse
extends ActionResponse
implements ToXContentObject {
    private final Hits hits;
    private final long tookInMillis;
    private final boolean isTimeout;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isPartial;
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField HITS = new ParseField("hits", new String[0]);
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField IS_RUNNING = new ParseField("is_running", new String[0]);
    private static final ParseField IS_PARTIAL = new ParseField("is_partial", new String[0]);
    private static final InstantiatingObjectParser<EqlSearchResponse, Void> PARSER;

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout) {
        this(hits, tookInMillis, isTimeout, null, false, false);
    }

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout, String asyncExecutionId, boolean isRunning, boolean isPartial) {
        this.hits = hits == null ? Hits.EMPTY : hits;
        this.tookInMillis = tookInMillis;
        this.isTimeout = isTimeout;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
    }

    public EqlSearchResponse(StreamInput in) throws IOException {
        super(in);
        this.tookInMillis = in.readVLong();
        this.isTimeout = in.readBoolean();
        this.hits = new Hits(in);
        this.asyncExecutionId = in.readOptionalString();
        this.isPartial = in.readBoolean();
        this.isRunning = in.readBoolean();
    }

    public static EqlSearchResponse fromXContent(XContentParser parser) {
        return (EqlSearchResponse)((Object)PARSER.apply(parser, null));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.isTimeout);
        this.hits.writeTo(out);
        out.writeOptionalString(this.asyncExecutionId);
        out.writeBoolean(this.isPartial);
        out.writeBoolean(this.isRunning);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    private XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.asyncExecutionId != null) {
            builder.field(ID.getPreferredName(), this.asyncExecutionId);
        }
        builder.field(IS_PARTIAL.getPreferredName(), this.isPartial);
        builder.field(IS_RUNNING.getPreferredName(), this.isRunning);
        builder.field(TOOK.getPreferredName(), this.tookInMillis);
        builder.field(TIMED_OUT.getPreferredName(), this.isTimeout);
        this.hits.toXContent(builder, params);
        return builder;
    }

    public long took() {
        return this.tookInMillis;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public Hits hits() {
        return this.hits;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EqlSearchResponse that = (EqlSearchResponse)((Object)o);
        return Objects.equals(this.hits, that.hits) && Objects.equals(this.tookInMillis, that.tookInMillis) && Objects.equals(this.isTimeout, that.isTimeout) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId);
    }

    public int hashCode() {
        return Objects.hash(this.hits, this.tookInMillis, this.isTimeout, this.asyncExecutionId);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"eql/search_response", (boolean)true, EqlSearchResponse.class);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hits.fromXContent(p), HITS);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TOOK);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), TIMED_OUT);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), ID);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_RUNNING);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_PARTIAL);
        PARSER = parser.build();
    }

    public static class Hits
    implements Writeable,
    ToXContentFragment {
        public static final Hits EMPTY = new Hits(null, null, null, null);
        private final List<SearchHit> events;
        private final List<Sequence> sequences;
        private final List<Count> counts;
        private final TotalHits totalHits;
        private static final ConstructingObjectParser<Hits, Void> PARSER = new ConstructingObjectParser("eql/search_response_count", true, args -> {
            int i = 0;
            List searchHits = (List)args[i++];
            List sequences = (List)args[i++];
            List counts = (List)args[i++];
            TotalHits totalHits = (TotalHits)args[i];
            return new Hits(searchHits, sequences, counts, totalHits);
        });

        public Hits(@Nullable List<SearchHit> events, @Nullable List<Sequence> sequences, @Nullable List<Count> counts, @Nullable TotalHits totalHits) {
            this.events = events;
            this.sequences = sequences;
            this.counts = counts;
            this.totalHits = totalHits;
        }

        public Hits(StreamInput in) throws IOException {
            this.totalHits = in.readBoolean() ? Lucene.readTotalHits((StreamInput)in) : null;
            this.events = in.readBoolean() ? in.readList(SearchHit::new) : null;
            this.sequences = in.readBoolean() ? in.readList(Sequence::new) : null;
            this.counts = in.readBoolean() ? in.readList(Count::new) : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            boolean hasTotalHits = this.totalHits != null;
            out.writeBoolean(hasTotalHits);
            if (hasTotalHits) {
                Lucene.writeTotalHits((StreamOutput)out, (TotalHits)this.totalHits);
            }
            if (this.events != null) {
                out.writeBoolean(true);
                out.writeList(this.events);
            } else {
                out.writeBoolean(false);
            }
            if (this.sequences != null) {
                out.writeBoolean(true);
                out.writeList(this.sequences);
            } else {
                out.writeBoolean(false);
            }
            if (this.counts != null) {
                out.writeBoolean(true);
                out.writeList(this.counts);
            } else {
                out.writeBoolean(false);
            }
        }

        public static Hits fromXContent(XContentParser parser) throws IOException {
            return (Hits)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("hits");
            if (this.totalHits != null) {
                builder.startObject("total");
                builder.field("value", this.totalHits.value);
                builder.field("relation", this.totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte");
                builder.endObject();
            }
            if (this.events != null) {
                builder.startArray("events");
                for (SearchHit event : this.events) {
                    event.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.sequences != null) {
                builder.field("sequences", this.sequences);
            }
            if (this.counts != null) {
                builder.field("counts", this.counts);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hits that = (Hits)o;
            return Objects.equals(this.events, that.events) && Objects.equals(this.sequences, that.sequences) && Objects.equals(this.counts, that.counts) && Objects.equals(this.totalHits, that.totalHits);
        }

        public int hashCode() {
            return Objects.hash(this.events, this.sequences, this.counts, this.totalHits);
        }

        public List<SearchHit> events() {
            return this.events;
        }

        public List<Sequence> sequences() {
            return this.sequences;
        }

        public List<Count> counts() {
            return this.counts;
        }

        public TotalHits totalHits() {
            return this.totalHits;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHit.fromXContent((XContentParser)p), new ParseField("events", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Sequence.PARSER, new ParseField("sequences", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Count.PARSER, new ParseField("counts", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHits.parseTotalHitsFragment((XContentParser)p), new ParseField("total", new String[0]));
        }

        private static final class Fields {
            static final String HITS = "hits";
            static final String TOTAL = "total";
            static final String EVENTS = "events";
            static final String SEQUENCES = "sequences";
            static final String COUNTS = "counts";

            private Fields() {
            }
        }
    }

    private static final class Fields {
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String HITS = "hits";
        static final String ID = "id";
        static final String IS_RUNNING = "is_running";
        static final String IS_PARTIAL = "is_partial";

        private Fields() {
        }
    }

    public static class Count
    implements ToXContentObject,
    Writeable {
        private final int count;
        private final List<Object> keys;
        private final float percent;
        private static final ParseField COUNT = new ParseField("_count", new String[0]);
        private static final ParseField KEYS = new ParseField("_keys", new String[0]);
        private static final ParseField PERCENT = new ParseField("_percent", new String[0]);
        private static final ConstructingObjectParser<Count, Void> PARSER = new ConstructingObjectParser("eql/search_response_count", true, args -> {
            int i = 0;
            int count = (Integer)args[i++];
            List joinKeys = (List)args[i++];
            float percent = ((Float)args[i]).floatValue();
            return new Count(count, joinKeys, percent);
        });

        public Count(int count, List<Object> keys, float percent) {
            this.count = count;
            this.keys = keys == null ? Collections.emptyList() : keys;
            this.percent = percent;
        }

        public Count(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.keys = (List)in.readGenericValue();
            this.percent = in.readFloat();
        }

        public static Count fromXContent(XContentParser parser) {
            return (Count)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeGenericValue(this.keys);
            out.writeFloat(this.percent);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("_count", this.count);
            builder.field("_keys", this.keys);
            builder.field("_percent", this.percent);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Count that = (Count)o;
            return Objects.equals(this.count, that.count) && Objects.equals(this.keys, that.keys) && Objects.equals(Float.valueOf(this.percent), Float.valueOf(that.percent));
        }

        public int hashCode() {
            return Objects.hash(this.count, this.keys, Float.valueOf(this.percent));
        }

        public int count() {
            return this.count;
        }

        public List<Object> keys() {
            return this.keys;
        }

        public float percent() {
            return this.percent;
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), COUNT);
            PARSER.declareFieldArray(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), PERCENT);
        }

        private static final class Fields {
            static final String COUNT = "_count";
            static final String KEYS = "_keys";
            static final String PERCENT = "_percent";

            private Fields() {
            }
        }
    }

    public static class Sequence
    implements Writeable,
    ToXContentObject {
        private static final ParseField JOIN_KEYS = new ParseField("join_keys", new String[0]);
        private static final ParseField EVENTS = new ParseField("events", new String[0]);
        private static final ConstructingObjectParser<Sequence, Void> PARSER = new ConstructingObjectParser("eql/search_response_sequence", true, args -> {
            int i = 0;
            List joinKeys = (List)args[i++];
            List events = (List)args[i];
            return new Sequence(joinKeys, events);
        });
        private final List<Object> joinKeys;
        private final List<SearchHit> events;

        public Sequence(List<Object> joinKeys, List<SearchHit> events) {
            this.joinKeys = joinKeys == null ? Collections.emptyList() : joinKeys;
            this.events = events == null ? Collections.emptyList() : events;
        }

        public Sequence(StreamInput in) throws IOException {
            this.joinKeys = (List)in.readGenericValue();
            this.events = in.readList(SearchHit::new);
        }

        public static Sequence fromXContent(XContentParser parser) {
            return (Sequence)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.joinKeys);
            out.writeList(this.events);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (!this.joinKeys.isEmpty()) {
                builder.field("join_keys", this.joinKeys);
            }
            if (!this.events.isEmpty()) {
                builder.startArray(EVENTS.getPreferredName());
                for (SearchHit event : this.events) {
                    event.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sequence that = (Sequence)o;
            return Objects.equals(this.joinKeys, that.joinKeys) && Objects.equals(this.events, that.events);
        }

        public int hashCode() {
            return Objects.hash(this.joinKeys, this.events);
        }

        public List<Object> joinKeys() {
            return this.joinKeys;
        }

        public List<SearchHit> events() {
            return this.events;
        }

        static {
            PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), JOIN_KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHit.fromXContent((XContentParser)p), EVENTS);
        }

        private static final class Fields {
            static final String JOIN_KEYS = "join_keys";
            static final String EVENTS = "events";

            private Fields() {
            }
        }
    }
}

