/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.transform.utils.OutputFieldNameConverter;

public final class TransformAggregations {
    private static final String DYNAMIC = "_dynamic";
    private static final String SOURCE = "_source";
    public static final String FLOAT = "float";
    public static final String FLATTENED = "flattened";
    public static final String SCALED_FLOAT = "scaled_float";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String GEO_SHAPE = "geo_shape";
    public static final String GEO_POINT = "geo_point";
    private static final List<String> UNSUPPORTED_AGGS = Arrays.asList("adjacency_matrix", "auto_date_histogram", "boxplot", "composite", "date_histogram", "date_range", "diversified_sampler", "extended_stats", "filters", "geo_distance", "geohash_grid", "geotile_grid", "global", "histogram", "ip_range", "matrix_stats", "median_absolute_deviation", "missing", "nested", "percentile_ranks", "range", "reverse_nested", "sampler", "significant_terms", "significant_text", "stats", "string_stats", "top_hits", "top_metrics", "t_test", "variable_width_histogram");
    private static Set<String> aggregationSupported = Stream.of(AggregationType.values()).map(Enum::name).collect(Collectors.toSet());
    private static Set<String> aggregationsNotSupported = UNSUPPORTED_AGGS.stream().map(agg -> agg.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());

    private TransformAggregations() {
    }

    public static boolean isSupportedByTransform(String aggregationType) {
        return aggregationSupported.contains(aggregationType.toUpperCase(Locale.ROOT));
    }

    static boolean isUnSupportedByTransform(String aggregationType) {
        return aggregationsNotSupported.contains(aggregationType.toUpperCase(Locale.ROOT));
    }

    public static boolean isDynamicMapping(String targetMapping) {
        return DYNAMIC.equals(targetMapping);
    }

    public static String resolveTargetMapping(String aggregationType, String sourceType) {
        AggregationType agg = AggregationType.valueOf(aggregationType.toUpperCase(Locale.ROOT));
        if (agg.getTargetMapping().equals(SOURCE)) {
            if (sourceType == null) {
                return null;
            }
            if (sourceType.equals(SCALED_FLOAT)) {
                return FLOAT;
            }
            return sourceType;
        }
        return agg.getTargetMapping();
    }

    public static Tuple<Map<String, String>, Map<String, String>> getAggregationInputAndOutputTypes(AggregationBuilder agg) {
        if (agg instanceof PercentilesAggregationBuilder) {
            PercentilesAggregationBuilder percentilesAgg = (PercentilesAggregationBuilder)agg;
            return new Tuple(Collections.emptyMap(), Arrays.stream(percentilesAgg.percentiles()).mapToObj(OutputFieldNameConverter::fromDouble).collect(Collectors.toMap(p -> agg.getName() + "." + p, p -> agg.getType(), (p1, p2) -> p1)));
        }
        if (agg instanceof ValuesSourceAggregationBuilder) {
            ValuesSourceAggregationBuilder valueSourceAggregation = (ValuesSourceAggregationBuilder)agg;
            return new Tuple(Collections.singletonMap(valueSourceAggregation.getName(), valueSourceAggregation.field()), Collections.singletonMap(agg.getName(), agg.getType()));
        }
        if (agg.getSubAggregations().size() > 0) {
            HashMap<String, String> outputTypes = new HashMap<String, String>();
            HashMap<String, String> inputTypes = new HashMap<String, String>();
            for (AggregationBuilder subAgg : agg.getSubAggregations()) {
                Tuple<Map<String, String>, Map<String, String>> subAggregationTypes = TransformAggregations.getAggregationInputAndOutputTypes(subAgg);
                for (Map.Entry subAggOutputType : ((Map)subAggregationTypes.v2()).entrySet()) {
                    outputTypes.put(String.join((CharSequence)".", agg.getName(), (CharSequence)subAggOutputType.getKey()), (String)subAggOutputType.getValue());
                }
                for (Map.Entry subAggInputType : ((Map)subAggregationTypes.v1()).entrySet()) {
                    inputTypes.put(String.join((CharSequence)".", agg.getName(), (CharSequence)subAggInputType.getKey()), (String)subAggInputType.getValue());
                }
            }
            return new Tuple(inputTypes, outputTypes);
        }
        return new Tuple(Collections.emptyMap(), Collections.singletonMap(agg.getName(), agg.getType()));
    }

    static enum AggregationType {
        AVG("avg", "double"),
        CARDINALITY("cardinality", "long"),
        VALUE_COUNT("value_count", "long"),
        MAX("max", "_source"),
        MIN("min", "_source"),
        SUM("sum", "double"),
        GEO_CENTROID("geo_centroid", "geo_point"),
        GEO_BOUNDS("geo_bounds", "geo_shape"),
        SCRIPTED_METRIC("scripted_metric", "_dynamic"),
        WEIGHTED_AVG("weighted_avg", "_dynamic"),
        BUCKET_SELECTOR("bucket_selector", "_dynamic"),
        BUCKET_SCRIPT("bucket_script", "_dynamic"),
        PERCENTILES("percentiles", "double"),
        FILTER("filter", "long"),
        TERMS("terms", "flattened"),
        RARE_TERMS("rare_terms", "flattened");

        private final String aggregationType;
        private final String targetMapping;

        private AggregationType(String name, String targetMapping) {
            this.aggregationType = name;
            this.targetMapping = targetMapping;
        }

        public String getName() {
            return this.aggregationType;
        }

        public String getTargetMapping() {
            return this.targetMapping;
        }
    }
}

