/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.transform.transforms.pivot.TransformAggregations;

public final class SchemaUtil {
    private static final Logger logger = LogManager.getLogger(SchemaUtil.class);
    private static final Set<String> NUMERIC_FIELD_MAPPER_TYPES;

    private SchemaUtil() {
    }

    public static boolean isNumericType(String type) {
        return type != null && NUMERIC_FIELD_MAPPER_TYPES.contains(type);
    }

    public static void deduceMappings(Client client, PivotConfig config, String[] source, ActionListener<Map<String, String>> listener) {
        HashMap aggregationSourceFieldNames = new HashMap();
        HashMap<String, String> aggregationTypes = new HashMap<String, String>();
        HashMap fieldNamesForGrouping = new HashMap();
        HashMap fieldTypesForGrouping = new HashMap();
        config.getGroupConfig().getGroups().forEach((destinationFieldName, group) -> {
            if (group.getScriptConfig() != null) {
                return;
            }
            fieldNamesForGrouping.put(destinationFieldName, group.getField());
            if (group.getMappingType() != null) {
                fieldTypesForGrouping.put(destinationFieldName, group.getMappingType());
            }
        });
        for (AggregationBuilder agg : config.getAggregationConfig().getAggregatorFactories()) {
            Tuple<Map<String, String>, Map<String, String>> inputAndOutputTypes = TransformAggregations.getAggregationInputAndOutputTypes(agg);
            aggregationSourceFieldNames.putAll((Map)inputAndOutputTypes.v1());
            aggregationTypes.putAll((Map)inputAndOutputTypes.v2());
        }
        for (AggregationBuilder agg : config.getAggregationConfig().getPipelineAggregatorFactories()) {
            aggregationTypes.put(agg.getName(), agg.getType());
        }
        HashMap allFieldNames = new HashMap();
        allFieldNames.putAll(aggregationSourceFieldNames);
        allFieldNames.putAll(fieldNamesForGrouping);
        SchemaUtil.getSourceFieldMappings(client, source, (String[])allFieldNames.values().stream().filter(Objects::nonNull).toArray(String[]::new), (ActionListener<Map<String, String>>)ActionListener.wrap(sourceMappings -> listener.onResponse(SchemaUtil.resolveMappings(aggregationSourceFieldNames, aggregationTypes, fieldNamesForGrouping, fieldTypesForGrouping, sourceMappings)), arg_0 -> listener.onFailure(arg_0)));
    }

    public static void getDestinationFieldMappings(Client client, String index, ActionListener<Map<String, String>> listener) {
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest().indices(new String[]{index}).fields(new String[]{"*"}).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"transform", (ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse(SchemaUtil.extractFieldMappings(r)), arg_0 -> listener.onFailure(arg_0)));
    }

    private static Map<String, String> resolveMappings(Map<String, String> aggregationSourceFieldNames, Map<String, String> aggregationTypes, Map<String, String> fieldNamesForGrouping, Map<String, String> fieldTypesForGrouping, Map<String, String> sourceMappings) {
        HashMap<String, String> targetMapping = new HashMap<String, String>();
        aggregationTypes.forEach((targetFieldName, aggregationName) -> {
            String sourceFieldName = (String)aggregationSourceFieldNames.get(targetFieldName);
            String sourceMapping = sourceFieldName == null ? null : (String)sourceMappings.get(sourceFieldName);
            String destinationMapping = TransformAggregations.resolveTargetMapping(aggregationName, sourceMapping);
            logger.debug(() -> new ParameterizedMessage("Deduced mapping for: [{}], agg type [{}] to [{}]", new Object[]{targetFieldName, aggregationName, destinationMapping}));
            if (TransformAggregations.isDynamicMapping(destinationMapping)) {
                logger.debug(() -> new ParameterizedMessage("Dynamic target mapping set for field [{}] and aggregation [{}]", targetFieldName, aggregationName));
            } else if (destinationMapping != null) {
                targetMapping.put((String)targetFieldName, destinationMapping);
            } else {
                logger.warn("Failed to deduce mapping for [{}], fall back to dynamic mapping. Create the destination index with complete mappings first to avoid deducing the mappings", targetFieldName);
            }
        });
        fieldNamesForGrouping.forEach((targetFieldName, sourceFieldName) -> {
            String destinationMapping = fieldTypesForGrouping.computeIfAbsent((String)targetFieldName, s -> (String)sourceMappings.get(sourceFieldName));
            logger.debug(() -> new ParameterizedMessage("Deduced mapping for: [{}] to [{}]", targetFieldName, (Object)destinationMapping));
            if (destinationMapping != null) {
                targetMapping.put((String)targetFieldName, destinationMapping);
            } else {
                logger.warn("Failed to deduce mapping for [{}], fall back to keyword. Create the destination index with complete mappings first to avoid deducing the mappings", targetFieldName);
                targetMapping.put((String)targetFieldName, "keyword");
            }
        });
        SchemaUtil.insertNestedObjectMappings(targetMapping);
        return targetMapping;
    }

    private static void getSourceFieldMappings(Client client, String[] index, String[] fields, ActionListener<Map<String, String>> listener) {
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest().indices(index).fields(fields).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        client.execute((ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, ActionListener.wrap(response -> listener.onResponse(SchemaUtil.extractFieldMappings(response)), arg_0 -> listener.onFailure(arg_0)));
    }

    private static Map<String, String> extractFieldMappings(FieldCapabilitiesResponse response) {
        HashMap<String, String> extractedTypes = new HashMap<String, String>();
        response.get().forEach((fieldName, capabilitiesMap) -> capabilitiesMap.forEach((name, capability) -> {
            logger.trace(() -> new ParameterizedMessage("Extracted type for [{}] : [{}]", fieldName, (Object)capability.getType()));
            extractedTypes.put((String)fieldName, capability.getType());
        }));
        return extractedTypes;
    }

    static void insertNestedObjectMappings(Map<String, String> fieldMappings) {
        HashMap<String, String> additionalMappings = new HashMap<String, String>();
        fieldMappings.keySet().stream().filter(key -> key.contains(".")).forEach(key -> {
            int pos;
            String objectKey = key;
            while ((pos = objectKey.lastIndexOf(".")) > 0) {
                objectKey = objectKey.substring(0, pos);
                additionalMappings.putIfAbsent(objectKey, "object");
            }
        });
        additionalMappings.forEach(fieldMappings::putIfAbsent);
    }

    static {
        Set types = Stream.of(NumberFieldMapper.NumberType.values()).map(NumberFieldMapper.NumberType::typeName).collect(Collectors.toSet());
        types.add("scaled_float");
        NUMERIC_FIELD_MAPPER_TYPES = types;
    }
}

